/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.service.rabbitmq;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import kd.bos.log.service.rabbitmq.Connection;
import kd.bos.log.service.rabbitmq.PublisherCallbackChannel;
import kd.bos.log.service.rabbitmq.RabbitmqUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.rabbitmq.RabbitmqFactory;
import kd.bos.threads.ThreadPools;

@Deprecated
public class CachingConnectionFactory {
    private static final Log logger = LogFactory.getLog(CachingConnectionFactory.class);
    private final LinkedList<PublisherCallbackChannel> cachedChannels = new LinkedList();
    private final Object connectionMonitor = new Object();
    private volatile ExecutorService channelsExecutor;
    private int channelCacheSize = 10;
    private static final CachingConnectionFactory instance = new CachingConnectionFactory();

    private CachingConnectionFactory() {
    }

    public static CachingConnectionFactory getInstance() {
        return instance;
    }

    public Connection createConnection() {
        return new ChannelCachingConnection(RabbitmqFactory.getConnection((String)this.getRegionServerKey("base")));
    }

    private String getRegionServerKey(String region) {
        String serverKey = "mq.server." + region;
        String server = System.getProperty(serverKey);
        if (server != null) {
            return serverKey;
        }
        return "mq.server";
    }

    public PublisherCallbackChannel getChannel(ChannelCachingConnection connection) throws IOException {
        PublisherCallbackChannel channel = null;
        if (connection.isOpen()) {
            channel = this.findOpenChannel(this.cachedChannels);
            logger.info(Thread.currentThread().getName() + ":\u83b7\u53d6\u7f13\u5b58\u4e2d\u7684channel");
        }
        if (channel == null) {
            channel = new PublisherCallbackChannel(connection.getDelegate().createChannel(), this.getChannelsExecutor());
            this.cachedChannels.addLast(channel);
            logger.info(Thread.currentThread().getName() + ":\u521b\u5efa\u65b0\u7684channel");
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecutorService getChannelsExecutor() {
        if (this.channelsExecutor == null) {
            Object object = this.connectionMonitor;
            synchronized (object) {
                if (this.channelsExecutor == null) {
                    this.channelsExecutor = ThreadPools.newCachedExecutorService((String)"mq-log-pool");
                }
            }
        }
        return this.channelsExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublisherCallbackChannel findOpenChannel(LinkedList<PublisherCallbackChannel> channelList) {
        PublisherCallbackChannel channel = null;
        LinkedList<PublisherCallbackChannel> linkedList = channelList;
        synchronized (linkedList) {
            while (!channelList.isEmpty() && !(channel = channelList.removeFirst()).isOpen()) {
                this.cleanUpClosedChannel(channel);
                channel = null;
            }
            return channel;
        }
    }

    private void cleanUpClosedChannel(PublisherCallbackChannel channel) {
        try {
            Channel target = channel.getTargetChannel();
            if (target != null) {
                target.close();
            }
        }
        catch (Exception e) {
            logger.error("\u5173\u95edMQ\u901a\u9053\u5f02\u5e38", (Throwable)e);
        }
    }

    public void closeChannel(PublisherCallbackChannel channel) throws IOException, TimeoutException {
        if (!RabbitmqUtils.isPhysicalCloseRequired()) {
            this.logicalClose(channel);
        } else {
            this.physicalClose(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logicalClose(PublisherCallbackChannel channel) throws IOException, TimeoutException {
        if (channel != null) {
            if (channel.getTargetChannel() != null && !channel.getTargetChannel().isOpen()) {
                Object object = channel.getTargetMonitor();
                synchronized (object) {
                    channel.getTargetChannel().close();
                    if (this.cachedChannels.contains(channel)) {
                        this.cachedChannels.remove(channel);
                    }
                }
            }
            this.returnToCache(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnToCache(PublisherCallbackChannel channel) {
        if (channel != null) {
            LinkedList<PublisherCallbackChannel> linkedList = this.cachedChannels;
            synchronized (linkedList) {
                boolean alreadyCached = this.cachedChannels.contains(channel);
                if (this.cachedChannels.size() >= this.channelCacheSize && !alreadyCached) {
                    this.physicalClose(channel);
                } else if (!alreadyCached) {
                    this.cachedChannels.addLast(channel);
                }
            }
        }
    }

    private void physicalClose(PublisherCallbackChannel channel) {
        if (channel != null && channel.getTargetChannel() != null) {
            try {
                channel.getTargetChannel().close();
            }
            catch (IOException | TimeoutException e) {
                logger.error("\u7269\u7406\u5173\u95edMQ\u901a\u9053\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private class ChannelCachingConnection
    implements Connection {
        private volatile com.rabbitmq.client.Connection target;

        public ChannelCachingConnection(com.rabbitmq.client.Connection target) {
            this.target = target;
        }

        @Override
        public PublisherCallbackChannel createChannel() throws IOException {
            return CachingConnectionFactory.this.getChannel(this);
        }

        @Override
        public void close() {
            if (this.target != null) {
                try {
                    this.target.close();
                }
                catch (IOException e) {
                    logger.error("\u7269\u7406\u5173\u95edMQ\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
                }
            }
        }

        @Override
        public boolean isOpen() {
            return this.target != null && this.target.isOpen();
        }

        @Override
        public com.rabbitmq.client.Connection getDelegate() {
            return this.target;
        }
    }
}

