/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.service.util;

import java.util.ArrayList;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class UserFormatCache {
    private static Log logger = LogFactory.getLog(UserFormatCache.class);
    private static LocalMemoryCache localCache = null;

    private UserFormatCache() {
    }

    private static LocalMemoryCache getLocalMemoryCache() {
        CacheConfigInfo localConfig = new CacheConfigInfo();
        localConfig.setMaxItemSize(5000);
        localConfig.setTimeout(600);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("log_user_format_region", "basedata", localConfig);
    }

    public static void modifyUserFormat(String format) {
        UserFormatCache.modifyUserFormat(format, null);
    }

    public static String getUserFormat() {
        return UserFormatCache.getUserFormat("9");
    }

    private static String getOpUserFormat() {
        return UserFormatCache.getOpUserFormat(null);
    }

    public static void modifyUserFormat(String format, String userType) {
        StringBuilder key = new StringBuilder();
        key.append(RequestContext.get().getAccountId()).append("_format");
        if (!ObjectUtils.isEmpty((Object)userType)) {
            key.append(userType);
        }
        if (localCache == null) {
            localCache = UserFormatCache.getLocalMemoryCache();
        }
        localCache.put(key.toString(), (Object)format);
        localCache.remove(new String[]{key.toString()});
    }

    public static String getUserFormat(String userType) {
        Object value;
        StringBuilder key = new StringBuilder();
        key.append(RequestContext.get().getAccountId()).append("_format");
        if (!ObjectUtils.isEmpty((Object)userType)) {
            key.append(userType);
        }
        if (localCache == null) {
            localCache = UserFormatCache.getLocalMemoryCache();
        }
        if (StringUtils.isNotBlank((Object)(value = localCache.get(key.toString())))) {
            return value.toString();
        }
        String actualValue = UserFormatCache.getOpUserFormat(userType);
        localCache.put(key.toString(), (Object)actualValue);
        return actualValue;
    }

    private static String getOpUserFormat(String userType) {
        String select = "name";
        try {
            Object opuserformat;
            Object[] data = null;
            ArrayList<QFilter> list = new ArrayList<QFilter>(8);
            String entityName = "bos_log_appsetting";
            if (!ObjectUtils.isEmpty((Object)userType)) {
                list.add(new QFilter("usertype", "=", (Object)userType));
                entityName = "bos_log_settings";
            }
            if (!ObjectUtils.isEmpty((Object[])(data = BusinessDataServiceHelper.load((String)entityName, (String)"opuserformat", (QFilter[])list.toArray(new QFilter[list.size()])))) && !ObjectUtils.isEmpty((Object)(opuserformat = data[0].get("opuserformat")))) {
                select = opuserformat.toString();
            }
        }
        catch (Exception e) {
            logger.info(e.toString());
        }
        return select;
    }
}

