/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.data.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.param.BillParam;
import kd.bos.entity.param.FuzzySearch;
import kd.bos.entity.param.ParamConvert;
import kd.bos.entity.param.ParamKey;
import kd.bos.entity.param.ParamRow;
import kd.bos.entity.param.ShowColumn;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParamDcBinder;
import kd.bos.param.ParameterLog;
import kd.bos.param.ParameterOrgUtils;
import kd.bos.param.ParameterReader;
import kd.bos.param.ParameterUtils;
import kd.bos.param.ParameterWriter;
import kd.bos.param.facade.ISysParamServiceFacade;
import kd.bos.param.facade.SysParamServiceFactory;
import kd.bos.param.service.IParameterHelperService;

public class ParameterHelperServiceImpl
implements IParameterHelperService {
    private static final String ENTITYID_ORG_STRUCTURE = "bos_org_structure";
    private static final String PARENT = "parent";
    private static final String ORGID = "orgId";
    private static final String LOCKFIELDS = "lockfields";
    private static final String PARAMCONFIG = "paramconfig";

    public long getParamRootOrgId() {
        return ParameterOrgUtils.getParamRootOrgId();
    }

    public boolean isYzjEnable() {
        long rootOrgId = this.getParamRootOrgId();
        Map paramMap = ParameterReader.loadSystemParameterFromCache(null, (String)"83bfebc8000037ac", (String)"15", (long)rootOrgId, (long)0L);
        if (paramMap == null) {
            return false;
        }
        Object syncMode = paramMap.get("syncmode");
        int mode = 1;
        if (StringUtils.isNotBlank(syncMode)) {
            mode = Integer.parseInt(syncMode.toString());
        }
        return mode != 1;
    }

    public boolean isNeedOpenYzjClient() {
        long rootOrgId = this.getParamRootOrgId();
        Map paramMap = ParameterReader.loadSystemParameterFromCache(null, (String)"83bfebc8000037ac", (String)"15", (long)rootOrgId, (long)0L);
        if (paramMap == null) {
            return false;
        }
        Object openyzjcObj = paramMap.get("openyzjc");
        boolean openyzjc = false;
        if (StringUtils.isNotBlank(openyzjcObj)) {
            openyzjc = Boolean.parseBoolean(openyzjcObj.toString());
        }
        return openyzjc;
    }

    public BillParam getBillParam(String formId) {
        return ParameterReader.loadBillParameterFormCache((String)formId);
    }

    public void addItem(FuzzySearch setting, String id, String caption, float width) {
        this.addItem(setting, id, caption, width, true);
    }

    public void addItem(FuzzySearch setting, String id, String caption, float width, int searchIndex, int comboListIndex) {
        this.addItem(setting, id, caption, width, searchIndex, comboListIndex, true);
    }

    public void addItem(FuzzySearch setting, String id, String caption, float width, boolean visible) {
        boolean existShowColumn = false;
        for (ShowColumn item : setting.getComboListFields()) {
            if (!StringUtils.equals((CharSequence)item.getId(), (CharSequence)id)) continue;
            existShowColumn = true;
            break;
        }
        if (!existShowColumn) {
            ShowColumn item = new ShowColumn(id, caption, width, visible);
            setting.getComboListFields().add(item);
        }
        if (!setting.getSearchFields().contains(id)) {
            setting.getSearchFields().add(id);
        }
    }

    public void addItem(FuzzySearch setting, String id, String caption, float width, int searchIndex, int comboListIndex, boolean visible) {
        if (comboListIndex != -1) {
            boolean existShowColumn = false;
            for (ShowColumn item : setting.getComboListFields()) {
                if (!StringUtils.equals((CharSequence)item.getId(), (CharSequence)id)) continue;
                existShowColumn = true;
                break;
            }
            if (!existShowColumn) {
                ShowColumn item = new ShowColumn(id, caption, width, visible);
                setting.getComboListFields().add(comboListIndex, item);
            }
        }
        if (searchIndex != -1 && !setting.getSearchFields().contains(id)) {
            setting.getSearchFields().add(searchIndex, id);
        }
    }

    @Deprecated
    public Object getParameter(String formId, String viewType, long orgId, long acctBookId, String paramId, String key, List<String> gcFields) {
        AppParam appParam = new AppParam(null, null, viewType, Long.valueOf(orgId), Long.valueOf(acctBookId), Long.valueOf(0L));
        appParam.setFormId(formId);
        appParam.setParamId(paramId);
        appParam.setGcFields(gcFields);
        return this.getParameter(appParam, key);
    }

    public Object getParameter(AppParam appParam, String key) {
        if (null == appParam) {
            ParameterLog.info("ParameterHelperService.getParameter(AppParam appParam, String key),AppParam=null");
            return null;
        }
        DynamicObject obj = this.getParameters(appParam);
        if (obj != null) {
            return obj.get(key);
        }
        return null;
    }

    @Deprecated
    public Object getParameter(String viewType, long orgId, long acctBookId, String subSystem, String key) {
        return null;
    }

    public DynamicObject getParameters(String formId, String viewType, long orgId, long acctBookId, String subSystem, List<String> gcFields) {
        AppParam appParam = new AppParam(null, null, viewType, Long.valueOf(orgId), Long.valueOf(acctBookId), Long.valueOf(0L));
        appParam.setFormId(formId);
        appParam.setParamId(subSystem);
        appParam.setGcFields(gcFields);
        return this.getParameters(appParam);
    }

    public DynamicObject getParameters(AppParam appParam) {
        if (null == appParam) {
            ParameterLog.info("ParameterHelperService.getParameters(),AppParam=null");
            return null;
        }
        List<Long> orgIds = this.getSuperiorOrgIds(appParam.getOrgId(), appParam.getViewType());
        List<Map<String, Object>> orgs = this.getAllSuperiorOrg(orgIds, appParam.getViewType());
        AppParam queryParam = new AppParam(null, null, appParam.getViewType(), orgIds, appParam.getActBookId(), appParam.getAcctingBookId());
        queryParam.setParamId(appParam.getParamId());
        queryParam.setFormId(appParam.getFormId());
        queryParam.setGcFields(appParam.getGcFields());
        List<Map<String, Object>> orgParams = this.getParamFromDBBySortOrg(queryParam);
        List paramItems = ParamConvert.getParamItems((String)appParam.getFormId());
        Map rows = ParamConvert.getParamRows(orgParams, (List)paramItems);
        Map<String, Object> paramData = this.handleParameter(rows, paramItems, appParam.getOrgId(), orgs);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)appParam.getFormId());
        DynamicObject dataEntity = (DynamicObject)entityType.createInstance();
        for (Map.Entry<String, Object> entry : paramData.entrySet()) {
            dataEntity.set(entry.getKey(), entry.getValue());
        }
        return dataEntity;
    }

    @Deprecated
    public DynamicObject getParameters(String viewType, long orgId, long acctBookId, String subSystem) {
        return null;
    }

    @Deprecated
    public DynamicObject getParameterEntity(Object entityTypeObj, long orgId, Map<ParamKey, ParamRow> rows, List<String> paramItems, List<Map<String, Object>> orgs) {
        MainEntityType entityType = (MainEntityType)entityTypeObj;
        Map<String, Object> paramData = this.handleParameter(rows, paramItems, orgId, orgs);
        DynamicObject dataEntity = (DynamicObject)entityType.createInstance();
        for (Map.Entry<String, Object> entry : paramData.entrySet()) {
            dataEntity.set(entry.getKey(), entry.getValue());
        }
        return dataEntity;
    }

    public DynamicObject getParameterEntityPlus(Object entityTypeObj, long orgId, Map<ParamKey, ParamRow> rows, List<String> paramItems, List<Map<String, Object>> orgs) {
        MainEntityType entityType = (MainEntityType)entityTypeObj;
        ISysParamServiceFacade facade = SysParamServiceFactory.getFacade();
        if (null == facade || facade.getNoOrgFlag().booleanValue()) {
            return this.getParameterEntityPlusOrder(entityType, orgId, rows, paramItems, Stream.of(Long.valueOf(0L)).collect(Collectors.toList()));
        }
        return this.getParameterEntityPlusOrder(entityType, orgId, rows, paramItems, ParameterHelperServiceImpl.getParentOrgIds(orgId, orgs));
    }

    private static List<Long> getParentOrgIds(long orgId, List<Map<String, Object>> orgs) {
        ArrayList<Long> orgList = new ArrayList<Long>(10);
        long currentOrgId = orgId;
        while (currentOrgId != 0L) {
            orgList.add(currentOrgId);
            currentOrgId = ParameterHelperServiceImpl.getParentOrgId(currentOrgId, orgs);
        }
        return orgList;
    }

    public DynamicObject getParameterEntityPlusOrder(Object entityTypeObj, long orgId, Map<ParamKey, ParamRow> rows, List<String> paramItems, List<Long> orgList) {
        MainEntityType entityType = (MainEntityType)entityTypeObj;
        DynamicObject dataEntity = (DynamicObject)entityType.createInstance();
        if (rows.isEmpty()) {
            return dataEntity;
        }
        for (String param : paramItems) {
            Tuple paramValue = ParamConvert.getParamValuePlus(rows, (long)orgId, (String)param, orgList);
            if (paramValue == null) continue;
            dataEntity.set((String)paramValue.item1, paramValue.item2);
        }
        return dataEntity;
    }

    private static long getParentOrgId(long orgId, List<Map<String, Object>> orgs) {
        for (Map<String, Object> org : orgs) {
            if (Long.parseLong(org.get("id").toString()) != orgId || org.get("id").equals(org.get("parentid"))) continue;
            return Long.parseLong(org.get("parentid").toString());
        }
        return 0L;
    }

    public List<String> getLockedParameter(String viewType, long orgId, long acctBookId, String subsystem, String formId, List<String> gcFields) {
        AppParam appParam = new AppParam(null, null, viewType, Long.valueOf(orgId), Long.valueOf(acctBookId), Long.valueOf(0L));
        appParam.setParamId(subsystem);
        appParam.setFormId(formId);
        appParam.setGcFields(gcFields);
        return this.getLockedParameter(appParam);
    }

    public List<String> getLockedParameter(AppParam appParam) {
        if (null == appParam) {
            ParameterLog.info("ParameterHelperService.getLockedParameter(AppParam appParam),AppParam=null");
            return null;
        }
        List orgIds = ParameterHelper.getSuperiorOrgIds((long)appParam.getOrgId(), (String)appParam.getViewType());
        List<Map<String, Object>> orgParams = new ParameterHelperServiceImpl().getParamFromDBBySortOrg(appParam);
        List paramItems = ParamConvert.getParamItems((String)appParam.getFormId());
        Map rows = ParamConvert.getParamRows(orgParams, (List)paramItems);
        ArrayList reverOrgIds = new ArrayList(orgIds);
        Collections.reverse(reverOrgIds);
        List lockFields = ParameterHelper.getLockedParameterPlus((Map)rows, (List)paramItems, reverOrgIds);
        return lockFields;
    }

    @Deprecated
    public List<String> getLockedParameter(long orgId, Map<ParamKey, ParamRow> rows, List<String> paramItems, List<Map<String, Object>> orgs) {
        List lockFields = ParameterHelper.getLockedParameterPlus(rows, paramItems, ParameterHelperServiceImpl.getParentOrgIds(orgId, orgs));
        return lockFields;
    }

    public List<String> getLockedParameterPlus(Map<ParamKey, ParamRow> rows, List<String> paramItems, List<Long> orgList) {
        if (rows.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> lockFields = new ArrayList<String>(10);
        for (String param : paramItems) {
            ParamKey key;
            ParamRow row;
            int i;
            long currentId = 0L;
            for (i = orgList.size() - 1; !(i < 0 || (row = rows.get(key = new ParamKey(param, currentId = orgList.get(i).longValue()))) != null && row.isLock()); --i) {
            }
            if (i <= 0) continue;
            lockFields.add(param);
        }
        return lockFields;
    }

    public DynamicObject getUserOption(long userId, String formId) {
        return ParameterReader.getUserOptionParameter((Long)userId, (String)formId, (String)"");
    }

    public Object getUserOption(long userId, String formId, String extend, String key) {
        DynamicObject userParamObj = ParameterReader.getUserOptionParameter((Long)userId, (String)formId, (String)extend);
        if (userParamObj != null && userParamObj.getDataEntityType().getProperties().containsKey((Object)key)) {
            return userParamObj.get(key);
        }
        return null;
    }

    public Map<String, Object> getListOptions(long userId, String formId, String listOption, String extend) {
        HashMap<String, Object> options = new HashMap<String, Object>(16);
        DynamicObject json = ParameterReader.getListOptionParameter((long)userId, (String)formId, (String)listOption, (String)extend);
        if (json != null) {
            DataEntityPropertyCollection properties = json.getDynamicObjectType().getProperties();
            for (IDataEntityProperty property : properties) {
                options.put(property.getName(), json.get(property.getName()));
            }
        }
        return options;
    }

    public Object getListOption(long userId, String formId, String listOption, String extend, String key) {
        DynamicObject json = ParameterReader.getListOptionParameter((long)userId, (String)formId, (String)listOption, (String)extend);
        if (json != null) {
            return json.get(key);
        }
        return null;
    }

    public Map<String, Object> getListOption(long userId, String formId, String listOption, String extend, String[] keys) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        DynamicObject json = ParameterReader.getListOptionParameter((long)userId, (String)formId, (String)listOption, (String)extend);
        if (json != null) {
            for (String key : keys) {
                options.put(key, json.get(key));
            }
        }
        return options;
    }

    public String getUserCustParameter(long userId, String formId, String paramKey) {
        return ParameterReader.getUserCustParameter((Long)userId, (String)formId, (String)paramKey);
    }

    public void saveUserOption(long userId, String formId, String extend, String jsonData) {
        ParameterWriter.saveUserOptionParameter((long)userId, (String)formId, (String)extend, (String)jsonData, (boolean)false);
    }

    public void saveListOption(Long userId, String formId, String extend, String jsonData) {
        ParameterWriter.saveUserOptionParameter((long)userId, (String)formId, (String)extend, (String)jsonData, (boolean)true);
    }

    public void saveUserCustParameter(long userId, String formId, String paramKey, String paramValue) {
        ParameterWriter.saveUserCustParameter((long)userId, (String)formId, (String)paramKey, (String)paramValue);
    }

    public void deleteUserCustParameter(String filter, SqlParameter[] params) {
        ParameterWriter.deleteUserCustParameter((String)filter, (SqlParameter[])params);
    }

    public List<Long> getSuperiorOrgIds(long orgId, String viewType) {
        return this.getAllSuperiorOrgs(viewType, orgId);
    }

    public List<Long> getAllSuperiorOrgs(String orgFunction, long orgId) {
        return ParameterOrgUtils.getAllSuperiorOrgs(orgFunction, orgId, true);
    }

    public Set<Long> getSuperiorOrgIds(String orgFunction, List<Long> orgIds) {
        Set<Long> lstOrgs = new HashSet<Long>(16);
        Map<Long, List<Long>> allSuperiorOrgs = ParameterOrgUtils.getAllSuperiorOrgs(orgFunction, orgIds, false);
        if (allSuperiorOrgs != null) {
            lstOrgs = allSuperiorOrgs.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        }
        lstOrgs.addAll(orgIds);
        return lstOrgs;
    }

    public List<Long> getSuperiorOrgs(String orgFunction, long orgId) {
        ArrayList<Long> lstOrgs = new ArrayList<Long>(10);
        if (orgId == 0L) {
            return lstOrgs;
        }
        QFilter f2 = new QFilter("view.number", "=", (Object)orgFunction);
        QFilter f3 = new QFilter("org", "=", (Object)orgId);
        ORM ormOV = ORM.create();
        try (DataSet ds = ormOV.queryDataSet(ParameterHelper.class.getName(), ENTITYID_ORG_STRUCTURE, PARENT, new QFilter[]{f2, f3});){
            for (Row row : ds) {
                lstOrgs.add(row.getLong(PARENT) != null ? row.getLong(PARENT) : 0L);
            }
        }
        return lstOrgs;
    }

    @Deprecated
    public Map<String, Object> handleParameter(Map<ParamKey, ParamRow> rows, List<String> paramItems, long orgId, List<Map<String, Object>> orgs) {
        HashMap<String, Object> paramData = new HashMap<String, Object>();
        List<Long> orgList = ParameterHelperServiceImpl.getOrgList(orgId, orgs);
        if (!rows.isEmpty()) {
            for (String param : paramItems) {
                Tuple paramValue = ParamConvert.getParamValuePlus(rows, (long)orgId, (String)param, orgList);
                if (paramValue == null) continue;
                paramData.put((String)paramValue.item1, paramValue.item2);
            }
        }
        return paramData;
    }

    private static List<Long> getOrgList(long orgId, List<Map<String, Object>> orgs) {
        ArrayList<Long> orgList = new ArrayList<Long>(10);
        long currentOrgId = orgId;
        while (currentOrgId != 0L) {
            orgList.add(currentOrgId);
            currentOrgId = ParameterHelperServiceImpl.getParentOrgId(currentOrgId, orgs);
        }
        return orgList;
    }

    public Map<String, Object> handleParameterPlus(Map<ParamKey, ParamRow> rows, List<String> paramItems, long orgId, List<Long> parentOrgIds) {
        if (rows.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> paramData = new HashMap<String, Object>(paramItems.size());
        for (String param : paramItems) {
            Tuple paramValue = ParamConvert.getParamValuePlus(rows, (long)orgId, (String)param, parentOrgIds);
            if (paramValue == null) continue;
            paramData.put((String)paramValue.item1, paramValue.item2);
        }
        return paramData;
    }

    public List<Map<String, Object>> getOrgsFormatParams(DynamicObjectCollection existData, String formId) {
        ArrayList<Map<String, Object>> orgParams = new ArrayList<Map<String, Object>>(10);
        if (StringUtils.isBlank((CharSequence)formId) || CollectionUtils.isEmpty((Collection)existData)) {
            return orgParams;
        }
        SimpleDateFormat shortTimeFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat longTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
        HashMap<String, Object> map = null;
        for (DynamicObject object : existData) {
            Object fdata = object.get("FDATA");
            if (null == fdata || StringUtils.isEmpty((CharSequence)fdata.toString())) continue;
            DynamicObject dataEntity = (DynamicObject)entityType.createInstance();
            ParameterUtils.createDefaultEntity(entityType, dataEntity);
            map = new HashMap<String, Object>();
            map.put(ORGID, object.get("FORGID"));
            map.put(LOCKFIELDS, object.get("FLOCKFIELDS"));
            map.put(PARAMCONFIG, object.get("FPARAMCONFIG"));
            String jsonStr = object.getString("FDATA");
            if (StringUtils.isBlank((CharSequence)jsonStr)) {
                jsonStr = "{}";
            }
            ParamDcBinder binder = new ParamDcBinder((DynamicObjectType)entityType);
            DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
            object = (DynamicObject)jser.deserializeFromString(jsonStr, (Object)dataEntity);
            Map<String, Object> dataMap = ParameterUtils.formatDynamicObjectToDataMap(shortTimeFormat, longTimeFormat, entityType, object);
            map.put("data", dataMap);
            orgParams.add(map);
        }
        return orgParams;
    }

    public static String formatTime(Integer time) {
        return ParameterUtils.formatTime(time);
    }

    public List<Map<String, Object>> getAllSuperiorOrg(List<Long> orgIds, String viewType) {
        QFilter filter = new QFilter("org", "in", orgIds);
        QFilter filter2 = new QFilter("view.number", "=", (Object)viewType);
        QFilter[] qFilters = new QFilter[]{filter, filter2};
        List<Map<String, Object>> orgMapList = this.getOrgStructureByFilter(qFilters);
        if (!ParameterOrgUtils.isTreeOrg()) {
            for (Map<String, Object> orgMap : orgMapList) {
                orgMap.put("parentid", String.valueOf(ParameterOrgUtils.getVirtualRootOrg().getOrgId()));
                orgMap.put("isleaf", "1");
            }
            HashMap<String, String> rootOrgMap = new HashMap<String, String>();
            String rootOrgId = String.valueOf(ParameterOrgUtils.getVirtualRootOrg().getOrgId());
            rootOrgMap.put("id", rootOrgId);
            rootOrgMap.put("name", ParameterOrgUtils.getVirtualRootOrg().getName());
            rootOrgMap.put("number", rootOrgId);
            rootOrgMap.put("parentid", "0");
            rootOrgMap.put("isleaf", "0");
            rootOrgMap.put("longNumber", rootOrgId);
            orgMapList.add(0, rootOrgMap);
        }
        return orgMapList;
    }

    public List<Map<String, Object>> getOrgStructureByFilter(QFilter[] filters) {
        ArrayList<Map<String, Object>> rootNodeList = new ArrayList<Map<String, Object>>(10);
        String selectFields = "id,org.number number,org.name name,org,parent,isleaf,longnumber";
        DynamicObjectCollection orgCol = null;
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet(ParameterHelper.class.getName(), ENTITYID_ORG_STRUCTURE, selectFields, filters, "sortcode");){
            orgCol = orm.toPlainDynamicObjectCollection(ds);
        }
        if (orgCol == null || orgCol.size() == 0) {
            return rootNodeList;
        }
        for (DynamicObject org : orgCol) {
            HashMap<String, String> mtree = new HashMap<String, String>();
            mtree.put("id", org.getString("org"));
            mtree.put("name", org.getString("name"));
            mtree.put("number", org.getString("number"));
            mtree.put("parentid", org.getString(PARENT));
            mtree.put("isleaf", org.getBoolean("isleaf") ? "1" : "0");
            mtree.put("longNumber", org.getString("longnumber"));
            rootNodeList.add(mtree);
        }
        return rootNodeList;
    }

    public DynamicObjectCollection queryAllOrgParams(List<Long> orgs, String viewType, String paramId) {
        if (orgs.isEmpty()) {
            return null;
        }
        DynamicObjectType dt = new DynamicObjectType("tempObject");
        dt.registerSimpleProperty(new DynamicSimpleProperty("FORGID", Long.class, (Object)""));
        dt.registerSimpleProperty(new DynamicSimpleProperty("FDATA", String.class, (Object)""));
        dt.registerSimpleProperty(new DynamicSimpleProperty("FLOCKFIELDS", String.class, (Object)""));
        DynamicObject tempObject = null;
        ORM orm = ORM.create();
        QFilter f1 = new QFilter("FVIEWTYPEID", "=", (Object)viewType);
        QFilter f2 = new QFilter("FPARAMID", "=", (Object)paramId);
        QFilter f3 = new QFilter("FORGID", "in", orgs);
        QFilter[] qf = new QFilter[]{f1, f2, f3};
        DynamicObjectCollection dynamicObjectCollection = orm.query("bos_svc_sysparameter", "id,FORGID,FDATA,FLOCKFIELDS", qf);
        DynamicObjectCollection newDoc = new DynamicObjectCollection(dt, null);
        for (DynamicObject d : dynamicObjectCollection) {
            tempObject = new DynamicObject(dt);
            tempObject.set("FORGID", d.get("FORGID"));
            tempObject.set("FDATA", d.get("FDATA"));
            tempObject.set("FLOCKFIELDS", d.get("FLOCKFIELDS"));
            newDoc.add((Object)tempObject);
        }
        return newDoc;
    }

    @Deprecated
    public List<Map<String, Object>> getOrgParamFromDB(String formId, List<Long> orgIds, String viewType, String paramId, long acc) {
        DynamicObjectCollection collection = ParameterHelperServiceImpl.queryAllOrgParams(orgIds, viewType, paramId, acc, 0L);
        collection.removeIf(d -> StringUtils.isBlank((Object)d.get("FDATA")));
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Object> map = null;
        for (DynamicObject object : collection) {
            map = new HashMap<String, Object>();
            map.put(ORGID, object.get(0));
            map.put("data", ParameterUtils.serializeToDataEntity(object.get(1).toString(), formId));
            map.put(LOCKFIELDS, object.get(2));
            list.add(map);
        }
        return list;
    }

    private static void fillFormDefValue(DynamicObjectCollection doc, Long orgId, String formId) {
        ParamDcBinder binder = new ParamDcBinder(doc.getDynamicObjectType());
        binder.setOnlyDbProperty(false);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setSerializeComplexProperty(false);
        DynamicObject o = new DynamicObject(doc.getDynamicObjectType());
        DynamicObject dynamicObject = ParameterUtils.serializeToDataEntity(doc, formId);
        String jsonString = "";
        if (dynamicObject != null) {
            jsonString = jser.serializeToString((Object)dynamicObject, null);
        }
        o.set("FORGID", (Object)orgId);
        o.set("FDATA", (Object)jsonString);
        o.set("FLOCKFIELDS", null);
        doc.add((Object)o);
    }

    public List<Map<String, Object>> getOrgParamFromDB(String formId, List<Long> orgIds, String viewType, String paramId, long acc, List<String> groupControlFields) {
        AppParam appParam = new AppParam(null, null, viewType, orgIds, Long.valueOf(acc), Long.valueOf(0L));
        appParam.setParamId(paramId);
        appParam.setFormId(formId);
        appParam.setGcFields(groupControlFields);
        return this.getOrgParamFromDB(appParam);
    }

    public List<Map<String, Object>> getOrgParamFromDB(AppParam appParam) {
        if (null == appParam) {
            ParameterLog.info("ParameterHelperServiceImpl.getOrgParamFromDB(),AppParam=null");
            return new ArrayList<Map<String, Object>>(0);
        }
        List orgIds = appParam.getOrgIds();
        if (orgIds == null || orgIds.isEmpty()) {
            return new ArrayList<Map<String, Object>>(0);
        }
        DynamicObjectCollection collection = ParameterHelperServiceImpl.queryAllOrgParams(orgIds, appParam.getViewType(), appParam.getParamId(), appParam.getActBookId(), appParam.getAcctingBookId());
        collection.removeIf(d -> StringUtils.isBlank((Object)d.get("FDATA")));
        if (collection.isEmpty()) {
            ParameterHelperServiceImpl.fillFormDefValue(collection, (Long)orgIds.get(0), appParam.getFormId());
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Object> dataMap = null;
        DynamicObject object = null;
        for (int i = 0; i < collection.size(); ++i) {
            object = (DynamicObject)collection.get(i);
            dataMap = new HashMap<String, Object>();
            dataMap.put(ORGID, object.get(0));
            dataMap.put("data", ParameterUtils.serializeToDataEntity(object.get(1) == null ? "" : object.get(1).toString(), appParam.getFormId()));
            if (appParam.getGcFields() != null) {
                HashMap<String, Boolean> map = StringUtils.isBlank((CharSequence)object.getString(2)) ? new HashMap<String, Boolean>() : (Map)SerializationUtils.fromJsonString((String)object.getString(2), Map.class);
                for (String field : appParam.getGcFields()) {
                    map.put(field, Boolean.TRUE);
                }
                dataMap.put(LOCKFIELDS, SerializationUtils.toJsonString(map));
            } else {
                dataMap.put(LOCKFIELDS, object.get(2));
            }
            list.add(dataMap);
        }
        return list;
    }

    public List<Map<String, Object>> getParamFromDBBySortOrg(AppParam appParam) {
        String jsonString;
        if (null == appParam) {
            ParameterLog.info("ParameterHelperServiceImpl.getOrgParamFromDB(),AppParam=null");
            return new ArrayList<Map<String, Object>>(0);
        }
        List orgIds = appParam.getOrgIds();
        if (orgIds == null || orgIds.isEmpty()) {
            return new ArrayList<Map<String, Object>>(0);
        }
        DynamicObjectCollection collection = ParameterHelperServiceImpl.queryAllOrgParams(orgIds, appParam.getViewType(), appParam.getParamId(), appParam.getActBookId(), appParam.getAcctingBookId());
        this.sortCollectionByOrgIds(orgIds, collection);
        if (collection.isEmpty()) {
            jsonString = this.getDefaultJson(appParam, collection);
            DynamicObject o = new DynamicObject(collection.getDynamicObjectType());
            o.set("FORGID", orgIds.get(0));
            o.set("FDATA", (Object)jsonString);
            o.set("FLOCKFIELDS", null);
            collection.add((Object)o);
        } else if (StringUtils.isBlank((CharSequence)((DynamicObject)collection.get(0)).getString("FDATA"))) {
            jsonString = this.getDefaultJson(appParam, collection);
            ((DynamicObject)collection.get(0)).set("FDATA", (Object)jsonString);
        }
        Long crrOrgId = (Long)orgIds.get(orgIds.size() - 1);
        this.mergeLockFieldConfigAndRemoveEmptyData(crrOrgId, collection);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Object> dataMap = null;
        DynamicObject object = null;
        for (int i = 0; i < collection.size(); ++i) {
            object = (DynamicObject)collection.get(i);
            dataMap = new HashMap<String, Object>();
            dataMap.put(ORGID, object.get(0));
            dataMap.put("data", ParameterUtils.serializeToDataEntity(object.get(1) == null ? "" : object.get(1).toString(), appParam.getFormId()));
            if (appParam.getGcFields() != null) {
                HashMap<String, Boolean> map = StringUtils.isBlank((CharSequence)object.getString(2)) ? new HashMap<String, Boolean>() : (Map)SerializationUtils.fromJsonString((String)object.getString(2), Map.class);
                for (String field : appParam.getGcFields()) {
                    map.put(field, Boolean.TRUE);
                }
                dataMap.put(LOCKFIELDS, SerializationUtils.toJsonString(map));
            } else {
                dataMap.put(LOCKFIELDS, object.get(2));
            }
            list.add(dataMap);
        }
        return list;
    }

    private String getDefaultJson(AppParam appParam, DynamicObjectCollection collection) {
        ParamDcBinder binder = new ParamDcBinder(collection.getDynamicObjectType());
        binder.setOnlyDbProperty(false);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setSerializeComplexProperty(false);
        DynamicObject dynamicObject = ParameterUtils.serializeToDataEntity(collection, appParam.getFormId());
        String jsonString = "";
        if (dynamicObject != null) {
            jsonString = jser.serializeToString((Object)dynamicObject, null);
        }
        return jsonString;
    }

    private void sortCollectionByOrgIds(List<Long> orgIds, DynamicObjectCollection collection) {
        HashMap<Long, Integer> indexMap = new HashMap<Long, Integer>(orgIds.size());
        for (int index = 0; index < orgIds.size(); ++index) {
            indexMap.put(orgIds.get(index), index);
        }
        collection.sort((o1, o2) -> {
            Integer sort1 = indexMap.getOrDefault(o1.getLong("FORGID"), -999);
            Integer sort2 = indexMap.getOrDefault(o2.getLong("FORGID"), -999);
            return sort1 - sort2;
        });
    }

    private void mergeLockFieldConfigAndRemoveEmptyData(Long crrOrgId, DynamicObjectCollection collection) {
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return;
        }
        DynamicObject lastObj = (DynamicObject)collection.get(collection.size() - 1);
        Object lastOrg = lastObj.get("FORGID");
        int startIndex = collection.size() - 1;
        if (crrOrgId.equals(lastOrg)) {
            startIndex = collection.size() - 2;
        }
        for (int index = startIndex; index >= 0; --index) {
            int preIndex;
            DynamicObject dynamicObject = (DynamicObject)collection.get(index);
            Object fdata = dynamicObject.get("FDATA");
            if (StringUtils.isNotBlank((Object)fdata) || (preIndex = index - 1) < 0) continue;
            String flockfields = "FLOCKFIELDS";
            Map<String, Boolean> lockFieldMap = this.getLockFieldMap(dynamicObject.getString(flockfields));
            DynamicObject preDynamicObject = (DynamicObject)collection.get(preIndex);
            Map<String, Boolean> lockFieldMap1 = this.getLockFieldMap(preDynamicObject.getString(flockfields));
            for (Map.Entry<String, Boolean> entry : lockFieldMap.entrySet()) {
                Boolean lock = entry.getValue();
                if (!lock.booleanValue()) continue;
                lockFieldMap1.put(entry.getKey(), Boolean.TRUE);
            }
            preDynamicObject.set(flockfields, (Object)SerializationUtils.toJsonString(lockFieldMap1));
        }
        collection.removeIf(d -> StringUtils.isBlank((Object)d.get("FDATA")));
    }

    public Map<String, Boolean> getLockFieldMap(String flockFieldsJson) {
        Map<String, Boolean> lockFieldMap = new HashMap<String, Boolean>(16);
        if (StringUtils.isBlank((CharSequence)flockFieldsJson)) {
            return lockFieldMap;
        }
        lockFieldMap = (Map)SerializationUtils.fromJsonString((String)flockFieldsJson, Map.class);
        return lockFieldMap;
    }

    public void saveSysParameterFieldsByFormId(String paramFormId, String fields) {
        String sql = "update T_BAS_SYSPARACONSOLE set FSELECTEDFIELDS=? where FENABLED='1' and FFORMID=?";
        ArrayList<SqlParameter> param = new ArrayList<SqlParameter>(10);
        param.add(new SqlParameter(12, (Object)fields));
        param.add(new SqlParameter(12, (Object)paramFormId));
        try (TXHandle h = TX.requiresNew();){
            DB.update((DBRoute)DBRoute.basedata, (String)sql, (Object[])param.toArray(new SqlParameter[param.size()]));
        }
    }

    private static DynamicObjectCollection queryAllOrgParams(List<Long> orgs, String viewType, String paramId, long acc, long acctingBookId) {
        DynamicObjectType dt = new DynamicObjectType("tempObject");
        dt.registerSimpleProperty(new DynamicSimpleProperty("FORGID", Long.class, (Object)""));
        dt.registerSimpleProperty(new DynamicSimpleProperty("FDATA", String.class, (Object)""));
        dt.registerSimpleProperty(new DynamicSimpleProperty("FLOCKFIELDS", String.class, (Object)""));
        DynamicObjectCollection newDoc = new DynamicObjectCollection(dt, null);
        if (orgs == null || orgs.isEmpty()) {
            return newDoc;
        }
        DynamicObject tempObject = null;
        ORM orm = ORM.create();
        QFilter f1 = new QFilter("FVIEWTYPEID", "is not null", (Object)"");
        if (viewType != null) {
            f1 = new QFilter("FVIEWTYPEID", "=", (Object)viewType);
        }
        QFilter f2 = new QFilter("FPARAMID", "is not null", (Object)"");
        if (paramId != null) {
            f2 = new QFilter("FPARAMID", "=", (Object)paramId);
        }
        QFilter f3 = new QFilter("FORGID", "in", orgs);
        QFilter f4 = new QFilter("FACCTBOOKID", "=", (Object)acc);
        QFilter f5 = new QFilter("FACCTINGBOOKID", "=", (Object)acctingBookId);
        QFilter[] qf = new QFilter[]{f1, f2, f3, f4, f5};
        DynamicObjectCollection dynamicObjectCollection = orm.query("bos_svc_sysparameter", "id,FORGID,FDATA,FLOCKFIELDS", qf);
        for (DynamicObject d : dynamicObjectCollection) {
            tempObject = new DynamicObject(dt);
            tempObject.set("FORGID", d.get("FORGID"));
            tempObject.set("FDATA", d.get("FDATA"));
            tempObject.set("FLOCKFIELDS", d.get("FLOCKFIELDS"));
            newDoc.add((Object)tempObject);
        }
        return newDoc;
    }
}

