/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.dataentity.SingleORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.svc.util.TreeNodeFilter;

public class ParaPublishConsolePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String PUBLIC_PARAMETER = "public_parameter";
    private static final String TREE_ROOT_PREFIX = "/parameter-root";
    private static final String TREE_KEY = "paratree";
    private static final String ENTRY_KEY = "entryentity";
    private static final String VISIBLE = "visible";
    private static final String DEPLOY_STATUS = "deploystatus";
    private static final String SQL_CLOUDID = ":FCLOUDID";
    private static final String SQL_APPID = ":FAPPID";
    private static final String SQL_FID = ":FID";
    private static final String SQL_PARAM_FORMID = ":FFORMID";
    private static final String SQL_FENABLED = ":FENABLED";
    private static final String SQL_FACCTBOOKENABLED = ":FACCTBOOKENABLED";
    private static final String SETTINGS_CACHE = "SettingsCache";
    private static final String ACCT_BOOK_ENABLED = "acctbookenabled";
    private static final String PUBLIC = "public";
    private static final String BOS_PARAMETER = "bos-parameter";

    public void initialize() {
        this.addItemClickListeners(new String[]{"toolbarap"});
        TreeView tree = (TreeView)this.getControl(TREE_KEY);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String level = "unit";
        String visible = "all";
        String deploystatus = "all";
        this.getPageCache().put("level", level);
        this.getPageCache().put(VISIBLE, visible);
        this.getPageCache().put(DEPLOY_STATUS, deploystatus);
        TreeNode root = this.buildRootNode();
        if (root != null) {
            this.getPageCache().put("treenodecache", SerializationUtils.toJsonString((Object)root));
            this.lockFuctionButton(true);
            TreeView tree = (TreeView)this.getView().getControl(TREE_KEY);
            tree.addNode(root);
            this.clickFirstCloudNode(root);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        String parentId = (String)evt.getParentNodeId();
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("treenodecache"), TreeNode.class);
        TreeNode node = root.getTreeNode(nodeId, 16);
        if (!root.getId().equals(nodeId)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"editpanel"});
            FieldEdit acctbookenabled = (FieldEdit)this.getControl(ACCT_BOOK_ENABLED);
            acctbookenabled.setEntryKey(ENTRY_KEY);
            acctbookenabled.setVisible(ACCT_BOOK_ENABLED, !PUBLIC_PARAMETER.equals(nodeId));
            IDataModel model = this.getModel();
            this.queryBindParameter(model, node, parentId);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"editpanel"});
        }
    }

    private void queryBindParameter(IDataModel model, TreeNode node, String pNodeId) {
        StringBuilder sql = new StringBuilder(" SELECT FCLOUDID, FAPPID,FFORMID, FACCTBOOKENABLED,FENABLED FROM T_BAS_SYSPARACONSOLE WHERE ");
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        Object data = node.getData();
        String type = "";
        if (data != null) {
            type = StringUtils.upperCase((String)((String)data));
        }
        switch (type) {
            case "APP": {
                this.lockFuctionButton(false);
                String masterId = (String)node.getData();
                if (StringUtils.isBlank((CharSequence)masterId)) {
                    sql.append("FCLOUDID= ' ' AND FAPPID = ?");
                    params.add(new SqlParameter(SQL_APPID, 12, (Object)node.getId()));
                } else {
                    sql.append("FCLOUDID= ' ' AND FAPPID IN ('").append(node.getId()).append("','").append(node.getData()).append("')");
                }
                model.setValue("modeltype", (Object)"application");
                break;
            }
            case "CLOUD": {
                this.lockFuctionButton(true);
                this.getModel().deleteEntryData(ENTRY_KEY);
                return;
            }
            case "PUBLIC": {
                this.lockFuctionButton(false);
                sql.append("FCLOUDID= ' ' AND FAPPID = ' '");
                model.setValue("modeltype", (Object)PUBLIC);
                break;
            }
        }
        DynamicObjectCollection collection = SingleORM.query(null, (String)sql.toString(), (Object[])params.toArray(new SqlParameter[params.size()]));
        this.buildParameterEntry(collection, node);
    }

    private void buildParameterEntry(DynamicObjectCollection collection, TreeNode treeNode) {
        this.getModel().deleteEntryData(ENTRY_KEY);
        HashMap<String, List<Object>> settings = new HashMap<String, List<Object>>();
        if (collection != null && !collection.isEmpty()) {
            int[] rows;
            for (int row : rows = this.getModel().batchCreateNewEntryRow(ENTRY_KEY, collection.size())) {
                DynamicObject object = (DynamicObject)collection.get(row);
                String formId = object.getString("FFORMID");
                Object actEnable = object.get("FACCTBOOKENABLED");
                Object enable = object.get("FENABLED");
                String appId = object.getString("FAPPID");
                this.getModel().setValue("formid", (Object)formId, row);
                this.getModel().setValue(ACCT_BOOK_ENABLED, actEnable, row);
                this.getModel().setValue("enabled", enable, row);
                settings.put(formId, Arrays.asList(actEnable, enable, appId));
            }
        }
        this.getPageCache().put(SETTINGS_CACHE, SerializationUtils.toJsonString(settings));
    }

    public void itemClick(ItemClickEvent evt) {
        if ("save".equals(evt.getItemKey())) {
            this.saveAll();
        }
    }

    private void saveAll() {
        HashMap settingsDelete;
        HashMap<String, List> settingsUpdate;
        HashMap<String, List<Object>> settings;
        boolean isPublicNode;
        String appId;
        String cloudId;
        block36: {
            TreeView treeView = (TreeView)this.getControl(TREE_KEY);
            Map focusNode = treeView.getTreeState().getFocusNode();
            cloudId = "";
            appId = "";
            String treeNodeId = focusNode.get("id").toString();
            isPublicNode = PUBLIC_PARAMETER.equals(treeNodeId);
            if (Boolean.TRUE.equals(focusNode.get("isParent"))) {
                cloudId = treeNodeId;
            } else {
                appId = treeNodeId;
            }
            if (isPublicNode) {
                cloudId = "";
                appId = "";
            }
            IDataModel model = this.getModel();
            int rowCount = model.getEntryRowCount(ENTRY_KEY);
            settings = new HashMap<String, List<Object>>(16);
            boolean hasEnabledRow = false;
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject obj = (DynamicObject)model.getValue("formid", i);
                if (obj == null) continue;
                String formId = obj.get(0).toString();
                if (settings.containsKey(formId)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c \u4e1a\u52a1\u5bf9\u8c61\u91cd\u590d\u3002", (String)"ParaPublishConsolePlugin_0", (String)BOS_PARAMETER, (Object[])new Object[0]), i + 1));
                    return;
                }
                boolean enabled = (Boolean)model.getValue("ENABLED", i);
                if (!isPublicNode && hasEnabledRow && enabled) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c \u53ea\u5141\u8bb8\u540c\u65f6\u542f\u7528\u4e00\u6761\u53c2\u6570\u3002", (String)"ParaPublishConsolePlugin_1", (String)BOS_PARAMETER, (Object[])new Object[0]), i + 1));
                    return;
                }
                hasEnabledRow = hasEnabledRow || enabled;
                settings.put(formId, Arrays.asList(model.getValue("ACCTBOOKENABLED", i), enabled));
            }
            HashMap settingsInsert = new HashMap(settings);
            settingsUpdate = new HashMap<String, List>(16);
            settingsDelete = new HashMap(16);
            Map cachedSettings = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(SETTINGS_CACHE), Map.class);
            Iterator iterator = cachedSettings.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String key = (String)entry.getKey();
                if (settingsInsert.containsKey(key)) {
                    List vBooleans = (List)settingsInsert.remove(key);
                    List vCacheBooleans = (List)entry.getValue();
                    if (vBooleans.get(0) != vCacheBooleans.get(0) || vBooleans.get(1) != vCacheBooleans.get(1)) {
                        settingsUpdate.put(key, vBooleans);
                    }
                } else {
                    settingsDelete.put(key, entry.getValue());
                }
                iterator.remove();
            }
            StringBuilder sql = new StringBuilder("DELETE FROM T_BAS_SYSPARACONSOLE WHERE FCLOUDID=? AND FAPPID=? AND FFORMID=?");
            ArrayList<SqlParameter[]> sqlParameters = new ArrayList<SqlParameter[]>();
            try (TXHandle h = TX.required();){
                if (!settingsDelete.isEmpty()) {
                    for (Map.Entry kv : settingsDelete.entrySet()) {
                        sqlParameters.add(new SqlParameter[]{new SqlParameter(SQL_CLOUDID, 12, (Object)cloudId), new SqlParameter(SQL_APPID, 12, (Object)appId), new SqlParameter(SQL_PARAM_FORMID, 12, kv.getKey())});
                    }
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql.toString(), sqlParameters);
                }
                if (!settingsUpdate.isEmpty()) {
                    sql.replace(0, sql.length(), "UPDATE T_BAS_SYSPARACONSOLE SET FACCTBOOKENABLED=?,FENABLED=? WHERE FCLOUDID=? AND FAPPID=? AND FFORMID=?");
                    sqlParameters.clear();
                    for (Map.Entry kv : settingsUpdate.entrySet()) {
                        sqlParameters.add(new SqlParameter[]{new SqlParameter(SQL_FACCTBOOKENABLED, 12, ((List)kv.getValue()).get(0)), new SqlParameter(SQL_FENABLED, 12, ((List)kv.getValue()).get(1)), new SqlParameter(SQL_CLOUDID, 12, (Object)cloudId), new SqlParameter(SQL_APPID, 12, (Object)appId), new SqlParameter(SQL_PARAM_FORMID, 12, kv.getKey())});
                    }
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql.toString(), sqlParameters);
                }
                if (settingsInsert.isEmpty()) break block36;
                sqlParameters.clear();
                if (StringUtils.isBlank((CharSequence)cloudId) && StringUtils.isBlank((CharSequence)appId)) {
                    sql.replace(0, sql.length(), "INSERT INTO T_BAS_SYSPARACONSOLE (FID,FFORMID,FACCTBOOKENABLED,FENABLED) VALUES(?,?,?,?)");
                    for (Map.Entry kv : settingsInsert.entrySet()) {
                        sqlParameters.add(new SqlParameter[]{new SqlParameter(SQL_FID, 12, (Object)Uuid16.create().toString()), new SqlParameter(SQL_PARAM_FORMID, 12, kv.getKey()), new SqlParameter(SQL_FACCTBOOKENABLED, 12, ((List)kv.getValue()).get(0)), new SqlParameter(SQL_FENABLED, 12, ((List)kv.getValue()).get(1))});
                    }
                } else if (StringUtils.isNotBlank((CharSequence)cloudId)) {
                    sql.replace(0, sql.length(), "INSERT INTO T_BAS_SYSPARACONSOLE (FID,FCLOUDID,FFORMID,FACCTBOOKENABLED,FENABLED) VALUES(?,?,?,?,?)");
                    for (Map.Entry kv : settingsInsert.entrySet()) {
                        sqlParameters.add(new SqlParameter[]{new SqlParameter(SQL_FID, 12, (Object)Uuid16.create().toString()), new SqlParameter(SQL_CLOUDID, 12, (Object)cloudId), new SqlParameter(SQL_PARAM_FORMID, 12, kv.getKey()), new SqlParameter(SQL_FACCTBOOKENABLED, 12, ((List)kv.getValue()).get(0)), new SqlParameter(SQL_FENABLED, 12, ((List)kv.getValue()).get(1))});
                    }
                } else {
                    sql.replace(0, sql.length(), "INSERT INTO T_BAS_SYSPARACONSOLE (FID,FAPPID,FFORMID,FACCTBOOKENABLED,FENABLED) VALUES(?,?,?,?,?)");
                    for (Map.Entry kv : settingsInsert.entrySet()) {
                        sqlParameters.add(new SqlParameter[]{new SqlParameter(SQL_FID, 12, (Object)Uuid16.create().toString()), new SqlParameter(SQL_APPID, 12, (Object)appId), new SqlParameter(SQL_PARAM_FORMID, 12, kv.getKey()), new SqlParameter(SQL_FACCTBOOKENABLED, 12, ((List)kv.getValue()).get(0)), new SqlParameter(SQL_FENABLED, 12, ((List)kv.getValue()).get(1))});
                    }
                }
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql.toString(), sqlParameters);
            }
        }
        ParameterCache.removeParamPublishObject(cloudId, appId);
        if (isPublicNode) {
            if (!settingsUpdate.isEmpty()) {
                settingsUpdate.keySet().forEach(ParameterCache::removePublicParam);
            }
            if (!settingsDelete.isEmpty()) {
                settingsDelete.keySet().forEach(ParameterCache::removePublicParam);
            }
        }
        this.getPageCache().put(SETTINGS_CACHE, SerializationUtils.toJsonString(settings));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ParaPublishConsolePlugin_2", (String)BOS_PARAMETER, (Object[])new Object[0]));
    }

    private TreeNode buildRootNode() {
        TreeNode root = this.getCloudAndAppTree();
        if (root != null) {
            root.setId(TREE_ROOT_PREFIX);
            root.setText(ResManager.loadKDString((String)"\u5206\u7c7b", (String)"ParaPublishConsolePlugin_3", (String)BOS_PARAMETER, (Object[])new Object[0]));
            root.setParentid("");
            root.setIsOpened(true);
        }
        return root;
    }

    private void clickFirstCloudNode(TreeNode root) {
        String paramType = (String)this.getView().getFormShowParameter().getCustomParam("paramType");
        if (paramType == null) {
            return;
        }
        List nodes = root.getChildren();
        TreeNode firstNode = (TreeNode)nodes.get(0);
        if (!PUBLIC.equals(paramType)) {
            QFilter appFilter = new QFilter("id", "=", (Object)paramType);
            QFilter[] appFilters = new QFilter[]{appFilter};
            DynamicObject appInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizapp", (String)"masterid", (QFilter[])appFilters);
            String masterAppId = appInfo.getString("masterid");
            if (StringUtils.isBlank((CharSequence)masterAppId)) {
                masterAppId = paramType;
            }
            firstNode = root.getTreeNode(masterAppId, 16);
        }
        if (firstNode == null) {
            return;
        }
        TreeView tree = (TreeView)this.getView().getControl(TREE_KEY);
        tree.focusNode(firstNode);
        tree.expand(firstNode.getParentid());
        tree.treeNodeClick(root.getId(), firstNode.getId());
    }

    private void lockFuctionButton(boolean lock) {
        this.getView().setEnable(Boolean.valueOf(!lock), new String[]{"addnew"});
        this.getView().setEnable(Boolean.valueOf(!lock), new String[]{"delete"});
        this.getView().setEnable(Boolean.valueOf(!lock), new String[]{"save"});
    }

    private TreeNode getCloudAndAppTree() {
        TreeNode treeRoot = (TreeNode)BizAppServiceHelp.getSubsysTree(null, null, null, (String)"app", (boolean)true, (boolean)true, (boolean)true);
        this.filterCloudAndAppNodes(treeRoot);
        TreeNode commonNode = new TreeNode();
        commonNode.setId(PUBLIC_PARAMETER);
        commonNode.setText(ResManager.loadKDString((String)"\u516c\u5171\u53c2\u6570", (String)"ParaPublishConsolePlugin_4", (String)BOS_PARAMETER, (Object[])new Object[0]));
        commonNode.setParentid("/biz");
        commonNode.setIsOpened(true);
        commonNode.setData((Object)PUBLIC);
        if (treeRoot != null) {
            treeRoot.addChild(0, commonNode);
        }
        return treeRoot;
    }

    private void filterCloudAndAppNodes(TreeNode root) {
        List cloudNodes = root.getChildren();
        TreeNodeFilter treeNodeFilter = new TreeNodeFilter();
        cloudNodes = treeNodeFilter.filterCloudTreeNode(cloudNodes);
        root.setChildren(cloudNodes);
        for (TreeNode cloudNode : cloudNodes) {
            List appNodes = cloudNode.getChildren();
            if (CollectionUtils.isEmpty((Collection)appNodes)) continue;
            appNodes = treeNodeFilter.filterAppTreeNode(appNodes);
            cloudNode.setChildren(appNodes);
        }
        this.removeEmptyCloudNode(cloudNodes);
    }

    private void removeEmptyCloudNode(List<TreeNode> cloudNodes) {
        if (CollectionUtils.isEmpty(cloudNodes)) {
            return;
        }
        Iterator<TreeNode> cloudIterator = cloudNodes.iterator();
        while (cloudIterator.hasNext()) {
            TreeNode cloud = cloudIterator.next();
            List appNodes = cloud.getChildren();
            if (!CollectionUtils.isEmpty((Collection)appNodes)) continue;
            cloudIterator.remove();
        }
    }
}

