/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IParameterModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.param.AppCustomParam;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.param.ParamPublishObject;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.SingleOrgContextHelper;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.param.AbstractParamConsolePlugin;
import kd.bos.form.plugin.param.ParameterUtils;
import kd.bos.form.plugin.param.TabStatus;
import kd.bos.form.plugin.param.groupcontrol.SelectParamConfig;
import kd.bos.form.plugin.utils.LocalCacheUtils;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.dataentity.SingleORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParamOpLogUtils;
import kd.bos.param.ParameterCache;
import kd.bos.param.ParameterLog;
import kd.bos.param.ParameterOrgUtils;
import kd.bos.param.ParameterReader;
import kd.bos.parameter.ParameterShowParameter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.model.AdminType;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.svc.util.TreeNodeFilter;

public class AppParamConsolePlugin
extends AbstractParamConsolePlugin
implements TreeNodeClickListener,
BeforeF7SelectListener,
SearchEnterListener {
    private static final String HEADPANEL = "headpanel";
    private static final String SPLITCONTAINER = "splitcontainerap";
    private static final String BTNSAVE = "save";
    private static final String FIELD_VIEWTYPE = "viewtype";
    protected static final String FIELD_ACTBOOK = "acctbook";
    protected static final String FIELD_ACCTINGBOOK = "acctingbook";
    private static final String SELECTED_ACCT_BOOK = "selectedAcctBook";
    private static final String SELECTED_ACCTING_BOOK = "selectedAcctingBook";
    private static final String DEFAULTVIEWTYPE = "15";
    private static final String CACHEKEY_VIEWTYPE = "orgF7SelViewTreeType";
    private static final String HASVIEWTYPE = "hasViewType";
    private static final String PUBLICPARAMETERID = "public_parameter";
    private static final String FULL_CONFIG_APP = "18XR3MJ0W0ET";
    protected static final String VISIBLE = "visible";
    protected static final String DEPLOYSTATUS = "deploystatus";
    protected static final String TREENODECACHE = "treenodecache";
    private static final String COMMON_PARAMETERS = "_commonparameters";
    private static final String CLOUD = "CLOUD";
    private static final String CLOUD_L_CASE = "cloud";
    private static final String TAB_CUSTOM_PAGE_ID = "TAB_CUSTOM_PAGE_ID";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String BOS_PARAMETER = "bos-parameter";
    private static final String ORGFIELD_ID = "orgField_id";
    private static final String CLOUDID = "cloudId";
    private static final String APPID = "appId";
    private static final String APP_U_CASE = "APP";
    private static final String APP_L_CASE = "app";
    private static final String SUCCESS = "success";
    private static final String HAS_FORM_PERM = "hasFormPerm";
    private static final String FNAME = "FNAME";
    private static final String FNUMBER = "FNUMBER";
    protected static final String PARAM_FORM_ID = "paramFormId";
    protected static final String PERM_ORG_IDS = "permOrgIds";
    private static final String ID = "id";
    private static final String TREEVIEW_CONSOLE = "apptreeviewap";
    protected String TARGET_PANEL_KEY = "appcontenpanel";
    private static final String BT_GROUP_CTRL = "groupcontrol";
    private static final String BT_SYNC_PARAMS = "syncparams";
    private static final String BOS_PARAM_GC_CONSOLE = "bos_param_gc_console";
    private static final String OPEN_GC_PAGEID = "openGcPageid";

    @Override
    public void initialize() {
        TreeView tree = (TreeView)this.getControl(this.APP_TREEKEY);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{FIELD_ACTBOOK});
        this.addClickListeners(new String[]{FIELD_ACCTINGBOOK});
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        IPageCache pageCache = this.getPageCache();
        String isViewType = pageCache.get(HASVIEWTYPE);
        String viewType = pageCache.get(CACHEKEY_VIEWTYPE) == null ? DEFAULTVIEWTYPE : pageCache.get(CACHEKEY_VIEWTYPE);
        String viewTypeId = pageCache.get("viewTypeId");
        OrgEdit edit = (OrgEdit)this.getControl(this.getShowOrgKey());
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        edit.setViewTypeCache(viewTypeId);
        if (StringUtils.isNotBlank((CharSequence)isViewType)) {
            if (!viewType.equals(DEFAULTVIEWTYPE)) {
                edit.setOrgFunc(viewType);
            }
        } else {
            edit.setOrgFunc(null);
        }
    }

    public void registerListener(EventObject e) {
        Tab tab = (Tab)this.getView().getControl("apptabap");
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (BTNSAVE.equals(itemKey) && !this.checkIsAppNode()) {
            return;
        }
        super.itemClick(evt);
    }

    boolean checkIsAppNode() {
        TreeView treeView = this.getTreeView();
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        String rootJson = this.getPageCache().get(TREENODECACHE);
        if (StringUtils.isBlank((CharSequence)rootJson)) {
            return false;
        }
        TreeNode cloudAndAppTree = (TreeNode)SerializationUtils.fromJsonString((String)rootJson, TreeNode.class);
        TreeNode treeNode = cloudAndAppTree.getTreeNode(focusNodeId);
        if (treeNode == null) {
            return false;
        }
        return APP_L_CASE.equals(treeNode.getType());
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        FormShowParameter showParameter = arg0.getFormShowParameter();
        if (showParameter instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)showParameter;
            String cachedId = this.getPageCache().get(PARAM_FORM_ID);
            if (cachedId == null) {
                return;
            }
            String ids = this.getPageCache().get(PERM_ORG_IDS);
            List orgIds = null;
            if (StringUtils.isNotBlank((CharSequence)ids)) {
                orgIds = SerializationUtils.fromJsonStringToList((String)ids, Long.class);
            }
            QFilter f = new QFilter(ID, "in", (Object)orgIds);
            listShowParameter.getListFilterParameter().setFilter(f);
        }
    }

    @Override
    protected TreeView getTreeView() {
        TreeView tree = (TreeView)this.getView().getControl(this.APP_TREEKEY);
        return tree;
    }

    @Override
    protected void save() {
        String msg = "";
        TabStatus tabStatus = this.getStatus();
        String appParamPageId = tabStatus.getAppParamPageId();
        String customPageId = tabStatus.getCustomPageId();
        IFormView parameterView = this.getAppView(appParamPageId);
        IFormView customView = this.getAppView(customPageId);
        if (appParamPageId == null || parameterView == null) {
            msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a\u8bf7\u68c0\u67e5\u662f\u5426\u6253\u5f00\u53c2\u6570\u8868\u5355\u6216\u68c0\u67e5\u64cd\u4f5c\u6743\u9650\u3002", (String)"ParameterConsolePlugin_3", (String)BOS_PARAMETER, (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        IDataModel dataModel = (IDataModel)parameterView.getService(IDataModel.class);
        DynamicObject dataEntity = dataModel.getDataEntity();
        if (!this.validate(parameterView, dataEntity, dataModel)) {
            return;
        }
        if (!this.checkCustomParams(customView)) {
            return;
        }
        IDataModel customModel = (IDataModel)customView.getService(IDataModel.class);
        this.saveAppParam(dataModel);
        this.saveCustomParams(customModel);
        msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ParameterConsolePlugin_2", (String)BOS_PARAMETER, (Object[])new Object[0]);
        this.getView().showSuccessNotification(msg);
    }

    private void saveCustomParams(IDataModel dataModel) {
        DynamicObjectCollection entryentity = dataModel.getEntryEntity("entryentity");
        TreeView tree = (TreeView)this.getView().getControl(this.APP_TREEKEY);
        String focusNodeId = tree.getTreeState().getFocusNodeId();
        Map<String, String> preCusTomMap = parameterReaderService.loadAppCustomParameterFromCache(new AppCustomParam(focusNodeId));
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bos_customparam_app");
        ArrayList<DynamicObject> saveObjs = new ArrayList<DynamicObject>(10);
        for (int index = 0; index < entryentity.size(); ++index) {
            DynamicObject dyObj = (DynamicObject)entryentity.get(index);
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType);
            dynamicObject.set("key", dyObj.get("key"));
            dynamicObject.set("number", (Object)kd.bos.id.ID.genStringId());
            dynamicObject.set("name", dyObj.get("name"));
            dynamicObject.set("value", dyObj.get("value"));
            dynamicObject.set("appid", (Object)focusNodeId);
            dynamicObject.set("sort", (Object)index);
            dynamicObject.set("status", (Object)"C");
            dynamicObject.set("enable", (Object)"1");
            saveObjs.add(dynamicObject);
        }
        DeleteServiceHelper.delete((String)"bos_customparam_app", (QFilter[])new QFilter[]{new QFilter("appid", "=", (Object)focusNodeId)});
        SaveServiceHelper.save((DynamicObject[])saveObjs.toArray(new DynamicObject[0]));
        ThreadCache.remove((Object)("parameterCustom." + focusNodeId));
        Map<String, String> nextCusTomMap = parameterReaderService.loadAppCustomParameterFromCache(new AppCustomParam(focusNodeId));
        this.addCustomLog(preCusTomMap, nextCusTomMap);
    }

    @Override
    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if ("tabpageapp".equals(tabKey)) {
            this.changeToAppTob();
            this.switchToAppTree();
            return;
        }
        if ("baseparamtab".equals(tabKey)) {
            this.changeToBaseTob();
        }
        if ("customparamtab".equals(tabKey)) {
            this.changeToCustomTob();
        }
    }

    private void showCustomPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("customparamfpanel");
        showParameter.setFormId("bos_customparam_view");
        TreeView tree = (TreeView)this.getView().getControl(this.APP_TREEKEY);
        String focusNodeId = tree.getTreeState().getFocusNodeId();
        showParameter.setCustomParam(APPID, (Object)focusNodeId);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        if (PermissionServiceHelper.isAdminUser((long)userId, (AdminType)AdminType.Administrator)) {
            showParameter.setHasRight(true);
        }
        this.getView().showForm(showParameter);
        this.setCustomPageId(showParameter);
    }

    private void switchToAppTree() {
        Map focusNode;
        String treeNodeCache = this.getPageCache().get(TREENODECACHE);
        this.getView().setVisible(Boolean.TRUE, new String[]{"appleftpanel", "apprightpanel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"sysleftpanel", "sysrightpanel"});
        if (StringUtils.isBlank((CharSequence)treeNodeCache)) {
            String level = "unit";
            String visible = "all";
            String deploystatus = "all";
            IPageCache pageCache = this.getPageCache();
            pageCache.put("level", level);
            pageCache.put(VISIBLE, visible);
            pageCache.put(DEPLOYSTATUS, deploystatus);
            TreeNode treeNode = this.buildRootNode();
            List children = treeNode.getChildren();
            if (CollectionUtils.isEmpty((Collection)children)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6388\u6743\u542b\u53c2\u6570\u7684\u5e94\u7528\uff0c\u8bf7\u6388\u6743\u540e\u91cd\u65b0\u6253\u5f00\u3002", (String)"AppParamConsolePlugin_5", (String)BOS_PARAMETER, (Object[])new Object[0]));
            }
            this.getPageCache().put(TREENODECACHE, SerializationUtils.toJsonString((Object)treeNode));
            pageCache.put("isInit", "true");
            TreeView tree = (TreeView)this.getView().getControl(this.APP_TREEKEY);
            tree.addNode(treeNode);
            tree.addTreeNodeClickListener((TreeNodeClickListener)this);
            this.clickFirstCloudNode(treeNode);
            this.setSingleOrgView(false);
            return;
        }
        TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)treeNodeCache, TreeNode.class);
        List children = treeNode.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6388\u6743\u542b\u53c2\u6570\u7684\u5e94\u7528\uff0c\u8bf7\u6388\u6743\u540e\u91cd\u65b0\u6253\u5f00\u3002", (String)"AppParamConsolePlugin_5", (String)BOS_PARAMETER, (Object[])new Object[0]));
        }
        if ((focusNode = this.getTreeView().getTreeState().getFocusNode()) == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"apprightpanel"});
            return;
        }
        Boolean isParent = Boolean.parseBoolean(String.valueOf(focusNode.getOrDefault("isParent", Boolean.TRUE)));
        if (isParent.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"apprightpanel"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (source.getKey().equalsIgnoreCase(FIELD_ACTBOOK)) {
            ListShowParameter para = ShowFormHelper.createShowListForm((String)"bd_accountbookstype", (boolean)true);
            para.setMultiSelect(false);
            CloseCallBack callback = new CloseCallBack("kd.bos.form.plugin.param.ParamConsolePlugin", FIELD_ACTBOOK);
            para.setCloseCallBack(callback);
            this.getView().showForm((FormShowParameter)para);
        } else if (source.getKey().equalsIgnoreCase(FIELD_ACCTINGBOOK)) {
            ListShowParameter para = ShowFormHelper.createShowListForm((String)"gl_accountbook", (boolean)true);
            para.setMultiSelect(false);
            CloseCallBack callback = new CloseCallBack("kd.bos.form.plugin.param.ParamConsolePlugin", FIELD_ACCTINGBOOK);
            para.setCloseCallBack(callback);
            this.getView().showForm((FormShowParameter)para);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (FIELD_ACTBOOK.equalsIgnoreCase(actionId)) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (rows == null || rows.isEmpty()) {
                return;
            }
            StringBuilder responser = new StringBuilder();
            for (ListSelectedRow row : rows) {
                responser.append(row.getName()).append(' ');
                this.getPageCache().put(SELECTED_ACCT_BOOK, SerializationUtils.toJsonString((Object)row));
            }
            responser = new StringBuilder(responser.toString().trim());
            this.getModel().setValue(FIELD_ACTBOOK, (Object)responser.toString());
            return;
        }
        if (FIELD_ACCTINGBOOK.equalsIgnoreCase(actionId)) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (rows == null || rows.isEmpty()) {
                return;
            }
            StringBuilder responser = new StringBuilder();
            for (ListSelectedRow row : rows) {
                responser.append(row.getNumber()).append(' ');
                this.getPageCache().put(SELECTED_ACCTING_BOOK, SerializationUtils.toJsonString((Object)row));
            }
            responser = new StringBuilder(responser.toString().trim());
            this.getModel().setValue(FIELD_ACCTINGBOOK, (Object)responser.toString());
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.treeNodeClick(evt.getNodeId().toString());
    }

    private void setViewTypeAndOrgStatus(String appId, boolean visible) {
        IFormView formView = this.getView();
        if (StringUtils.isBlank((CharSequence)appId)) {
            formView.setVisible(Boolean.FALSE, new String[]{"apprightpanel"});
        } else {
            formView.setVisible(Boolean.TRUE, new String[]{FIELD_VIEWTYPE, this.getShowOrgKey(), HEADPANEL});
            DynamicProperty acctbook = this.getModel().getDataEntityType().getProperty(FIELD_ACTBOOK);
            if (acctbook != null) {
                formView.setVisible(Boolean.valueOf(visible), new String[]{FIELD_ACTBOOK});
            }
        }
    }

    private void closeParameterForm() {
        TabStatus tabStatus = this.getStatus();
        this.closePage(tabStatus.getSysParamPageId());
        this.closePage(tabStatus.getAppParamPageId());
        this.closePage(tabStatus.getCustomPageId());
    }

    private void closePage(String pageId) {
        if (pageId != null) {
            HashMap<String, String> arg = new HashMap<String, String>();
            arg.put("pageId", pageId);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", arg);
        }
    }

    private boolean setViewTypeData(String cloudId, String appId) {
        String viewType = DEFAULTVIEWTYPE;
        IPageCache pageCache = this.getPageCache();
        String oldViewType = pageCache.get(CACHEKEY_VIEWTYPE);
        boolean viewTypeChange = false;
        if (StringUtils.isBlank((CharSequence)cloudId) && StringUtils.isBlank((CharSequence)appId)) {
            if (pageCache.get(CACHEKEY_VIEWTYPE) != null) {
                viewType = pageCache.get(CACHEKEY_VIEWTYPE);
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)cloudId) && StringUtils.isBlank((CharSequence)appId)) {
                return viewTypeChange;
            }
            DynamicObject bizApp = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_DEVPORTAL_BIZAPP, (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)appId)});
            if (bizApp != null && StringUtils.isNotBlank((Object)bizApp.get("orgfunc"))) {
                viewType = bizApp.get("orgfunc").toString();
                pageCache.put(HASVIEWTYPE, "true");
            }
            pageCache.put(CACHEKEY_VIEWTYPE, viewType);
            viewTypeChange = !StringUtils.equals((CharSequence)oldViewType, (CharSequence)viewType);
        }
        this.setViewTypeName(viewType);
        return viewTypeChange;
    }

    private void setViewTypeName(String viewType) {
        if ("true".equals(this.getPageCache().get("isInit"))) {
            this.getModel().setValue(FIELD_VIEWTYPE, (Object)ParameterUtils.getViewTypeName(viewType));
            this.getPageCache().put("viewTypeId", viewType);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String paramFormId = this.getPageCache().get(PARAM_FORM_ID);
        if (property instanceof OrgProp) {
            long orgId;
            Object newOrg = e.getChangeSet()[0].getNewValue();
            Object oldOrg = e.getChangeSet()[0].getOldValue();
            if (newOrg == null) {
                this.getModel().setValue(this.getShowOrgKey(), oldOrg);
                orgId = this.getFirstPermOrg(paramFormId);
            } else {
                DynamicObject obj;
                if (oldOrg == null) {
                    return;
                }
                if (newOrg instanceof Long ? (orgId = ((Long)newOrg).longValue()) == (Long)oldOrg : (orgId = (obj = (DynamicObject)newOrg).getLong(0)) == ((DynamicObject)oldOrg).getLong(0)) {
                    return;
                }
            }
            this.afterOrgPropChage(paramFormId, orgId);
        } else if (property instanceof TextProp && (property.getName().equals(FIELD_ACTBOOK) || property.getName().equals(FIELD_ACCTINGBOOK))) {
            Long orgId = this.getSelectedOrgId();
            if (orgId == null) {
                return;
            }
            Object newAcctBook = e.getChangeSet()[0].getNewValue();
            Object oldAcctBook = e.getChangeSet()[0].getOldValue();
            String pName = e.getProperty().getName();
            if (newAcctBook == null) {
                return;
            }
            String newAcctBookStr = null;
            if (newAcctBook instanceof String && (newAcctBookStr = (String)newAcctBook).equals(oldAcctBook)) {
                return;
            }
            long acctBookId = 0L;
            String selectAcctbook = this.getPageCache().get(SELECTED_ACCT_BOOK);
            if (StringUtils.isNotBlank((CharSequence)selectAcctbook)) {
                ListSelectedRow selectedRow;
                Object acctBookObj;
                if (StringUtils.isBlank((CharSequence)newAcctBookStr) && FIELD_ACTBOOK.equals(pName)) {
                    this.getPageCache().remove(SELECTED_ACCT_BOOK);
                    selectAcctbook = this.getPageCache().get(SELECTED_ACCT_BOOK);
                }
                if (null != selectAcctbook && (acctBookObj = (selectedRow = (ListSelectedRow)SerializationUtils.fromJsonString((String)selectAcctbook, ListSelectedRow.class)).getPrimaryKeyValue()) != null) {
                    acctBookId = (Long)acctBookObj;
                }
            }
            long acctingBookId = 0L;
            String seleAcctingBook = this.getPageCache().get(SELECTED_ACCTING_BOOK);
            if (StringUtils.isNotBlank((CharSequence)seleAcctingBook)) {
                ListSelectedRow selectedRow;
                Object acctingBookObj;
                if (StringUtils.isBlank((CharSequence)newAcctBookStr) && FIELD_ACCTINGBOOK.equals(pName)) {
                    this.getPageCache().remove(SELECTED_ACCTING_BOOK);
                    seleAcctingBook = this.getPageCache().get(SELECTED_ACCTING_BOOK);
                }
                if (null != seleAcctingBook && (acctingBookObj = (selectedRow = (ListSelectedRow)SerializationUtils.fromJsonString((String)seleAcctingBook, ListSelectedRow.class)).getPrimaryKeyValue()) != null) {
                    acctingBookId = (Long)acctingBookObj;
                }
            }
            String viewType = this.getPageCache().get(CACHEKEY_VIEWTYPE) == null ? DEFAULTVIEWTYPE : this.getPageCache().get(CACHEKEY_VIEWTYPE);
            Map<String, String> ids = this.getCloudAndAppId();
            ParameterShowParameter parameter = this.getAppParameterFormShowParameter(this.TARGET_PANEL_KEY, paramFormId, orgId, acctBookId, acctingBookId, viewType, ids.get(CLOUDID), ids.get(APPID));
            if (parameter != null) {
                this.getView().showForm((FormShowParameter)parameter);
                this.setAppParamPageId(parameter);
            }
        }
    }

    protected void afterOrgPropChage(String paramFormId, long orgId) {
        Map<String, String> ids;
        String viewType = this.getPageCache().get(CACHEKEY_VIEWTYPE) == null ? DEFAULTVIEWTYPE : this.getPageCache().get(CACHEKEY_VIEWTYPE);
        ParameterShowParameter parameter = this.getAppParameterFormShowParameter(this.TARGET_PANEL_KEY, paramFormId, orgId, 0L, 0L, viewType, (ids = this.getCloudAndAppId()).get(CLOUDID), ids.get(APPID));
        if (parameter != null) {
            this.getView().showForm((FormShowParameter)parameter);
            this.setAppParamPageId(parameter);
        }
        if (this.enableAcctBook(ids.get(CLOUDID), ids.get(APPID))) {
            this.getModel().setValue(FIELD_ACTBOOK, null);
        }
        this.getModel().setValue(FIELD_ACCTINGBOOK, null);
    }

    private Map<String, String> getCloudAndAppId() {
        TreeView treeView = (TreeView)this.getControl(this.APP_TREEKEY);
        Map focusNode = treeView.getTreeState().getFocusNode();
        HashMap<String, String> result = new HashMap<String, String>();
        if (focusNode != null) {
            if (Boolean.TRUE.equals(focusNode.get("isParent"))) {
                result.put(CLOUDID, focusNode.get(ID).toString());
                result.put(APPID, null);
            } else {
                result.put(CLOUDID, null);
                result.put(APPID, focusNode.get(ID).toString());
            }
        } else {
            result.put(CLOUDID, null);
            String appnumber = (String)this.getView().getFormShowParameter().getCustomParam(APPID);
            if (StringUtils.isNotBlank((CharSequence)appnumber)) {
                AppInfo app = AppMetadataCache.getAppInfo((String)appnumber);
                result.put(APPID, app.getAppId());
            } else {
                appnumber = this.getView().getFormShowParameter().getAppId();
                AppInfo app = AppMetadataCache.getAppInfo((String)appnumber);
                result.put(APPID, app.getId());
            }
        }
        return result;
    }

    private void showParameterForm(long orgId, String formId, String cloudId, String appId) {
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue(this.getShowOrgKey(), (Object)orgId);
        DynamicProperty acctbook = model.getDataEntityType().getProperty(FIELD_ACTBOOK);
        DynamicProperty acctingbook = model.getDataEntityType().getProperty(FIELD_ACCTINGBOOK);
        Object acctBookNumber = null;
        Object acctingBookNumber = null;
        if (this.enableAcctBook(cloudId, appId) && (acctbook != null || null != acctingbook)) {
            String viewTypeId = this.getPageCache().get("viewTypeId");
            acctBookNumber = ParameterReader.queryAcctBookId((String)cloudId, (String)appId, (String)viewTypeId, (long)orgId);
            List<String> acctBookId = this.querryAcctBookStype(acctBookNumber);
            model.setValue(FIELD_ACTBOOK, acctBookId);
            AppParam queryParam = new AppParam(cloudId, appId, viewTypeId, Long.valueOf(orgId), Long.valueOf(0L), Long.valueOf(0L));
            Map abMap = ParameterReader.queryAcctBook((AppParam)queryParam);
            if (null != abMap) {
                List<String> acctingBook = this.querryAcctingBooks((Long)abMap.get("FACCTINGBOOKID"));
                model.setValue(FIELD_ACCTINGBOOK, acctingBook);
            }
        }
        model.endInit();
        this.getView().updateView(this.getShowOrgKey());
        this.getView().updateView(FIELD_ACTBOOK);
        this.getView().updateView(FIELD_ACCTINGBOOK);
        this.getPageCache().put(PARAM_FORM_ID, formId);
        String viewTye = this.getPageCache().get(CACHEKEY_VIEWTYPE) == null ? DEFAULTVIEWTYPE : this.getPageCache().get(CACHEKEY_VIEWTYPE);
        long accountBookId = acctBookNumber == null ? 0L : (Long)acctBookNumber;
        long acctingBookId = acctingBookNumber == null ? 0L : (Long)acctingBookNumber;
        ParameterShowParameter showParameter = this.getAppParameterFormShowParameter(this.TARGET_PANEL_KEY, formId, orgId, accountBookId, acctingBookId, viewTye, cloudId, appId);
        this.getView().showForm((FormShowParameter)showParameter);
        this.setAppParamPageId(showParameter);
        this.showCustomPage();
    }

    protected void viewChange() {
    }

    protected long getFirstPermOrg(String formId) {
        HasPermOrgResult result;
        long orgId = this.getTopOrgId();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)formId);
        String appNumber = this.getView().getFormShowParameter().getAppId();
        String appid = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                appid = met.getAppId();
            }
        }
        if ((result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)formId, (String)"47150e89000000ac")) == null) {
            return orgId;
        }
        String cacheViewType = this.getPageCache().get("viewTypeId");
        String useOrgFunc = StringUtils.isBlank((CharSequence)cacheViewType) ? DEFAULTVIEWTYPE : cacheViewType;
        List viewTypeAllOrgIds = OrgUnitServiceHelper.getAllOrg((String)useOrgFunc);
        this.getPageCache().put(PERM_ORG_IDS, SerializationUtils.toJsonString((Object)viewTypeAllOrgIds));
        if (orgId == ParameterOrgUtils.getVirtualRootOrg().getOrgId()) {
            return orgId;
        }
        return viewTypeAllOrgIds.isEmpty() || viewTypeAllOrgIds.contains(orgId) ? orgId : (Long)viewTypeAllOrgIds.get(0);
    }

    private void queryBindParameter(TreeNode node) {
        block5: {
            HashMap nodeIds;
            block6: {
                block4: {
                    nodeIds = new HashMap();
                    node.iterate(10, n -> nodeIds.put(n.getId(), n));
                    if (!APP_U_CASE.equalsIgnoreCase(node.getType())) break block4;
                    List params = ParameterReader.getParameterObjects(null, (String)node.getId());
                    if (params == null || params.isEmpty()) break block5;
                    for (ParamPublishObject param : params) {
                        ((TreeNode)nodeIds.get(param.getAppId())).setData(Arrays.asList(param.getFormId(), param.isActBookEnable()));
                    }
                    break block5;
                }
                if (!CLOUD.equalsIgnoreCase(node.getType())) break block6;
                List params = ParameterReader.getParameterObjects((String)node.getId(), null);
                if (params == null || params.isEmpty()) break block5;
                for (ParamPublishObject param : params) {
                    ((TreeNode)nodeIds.get(param.getCloudId())).setData(Arrays.asList(param.getFormId(), param.isActBookEnable()));
                }
                break block5;
            }
            List params = ParameterReader.getParameterObjects(null, null);
            if (params != null && !params.isEmpty()) {
                for (ParamPublishObject param : params) {
                    ((TreeNode)nodeIds.get(PUBLICPARAMETERID)).setData(Arrays.asList(param.getFormId(), param.isActBookEnable()));
                }
            }
        }
    }

    protected TreeNode buildRootNode() {
        TreeNode root = this.getCloudAndAppTree();
        if (root != null) {
            root.setId("/biz");
            root.setText(ResManager.loadKDString((String)"\u5206\u7c7b", (String)"ParameterConsolePlugin_5", (String)BOS_PARAMETER, (Object[])new Object[0]));
            root.setParentid("");
            root.setIsOpened(true);
            List<String> clouds = this.getExistCloudApps(true);
            List<String> apps = this.getExistCloudApps(false);
            Map bizApps = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVPORTAL_BIZAPP, (QFilter[])new QFilter[]{new QFilter(ID, "in", apps).and(new QFilter(DEPLOYSTATUS, "=", (Object)"2"))});
            Iterator it = bizApps.entrySet().iterator();
            ArrayList<String> realApps = new ArrayList<String>(10);
            while (it.hasNext()) {
                DynamicObject app = (DynamicObject)it.next().getValue();
                realApps.add(app.getPkValue().toString());
            }
            this.filterCloudAndApp(root, clouds, realApps);
        }
        return root;
    }

    private void filterCloudAndApp(TreeNode root, List<String> clouds, List<String> apps) {
        Set<String> hideAppIds = AppParamConsolePlugin.getHideAppIds();
        if (root.getChildren() != null) {
            Iterator cloudit = root.getChildren().iterator();
            while (cloudit.hasNext()) {
                TreeNode cloud = (TreeNode)cloudit.next();
                if (cloud.getId().equalsIgnoreCase(PUBLICPARAMETERID)) continue;
                Iterator appit = cloud.getChildren().iterator();
                while (appit.hasNext()) {
                    TreeNode app = (TreeNode)appit.next();
                    if (!apps.contains(app.getId())) {
                        appit.remove();
                        continue;
                    }
                    if (!hideAppIds.contains(app.getId())) continue;
                    appit.remove();
                }
                if (!cloud.getChildren().isEmpty() || clouds.contains(cloud.getId())) continue;
                cloudit.remove();
            }
        }
    }

    public static Set<String> getHideAppIds() {
        HashSet<String> hideAppIds = new HashSet<String>(3);
        hideAppIds.add("83bfebc8000037ac");
        hideAppIds.add("TV3/VDJ86RC");
        hideAppIds.add("83bfebc800003dac");
        hideAppIds.add("W3NF+MX967M");
        if (DevVerifyServiceHelper.isOEMEnv()) {
            hideAppIds.add("198I/T67QJ+P");
        }
        return hideAppIds;
    }

    private List<String> getExistCloudApps(boolean isCloud) {
        String sql;
        DynamicObjectCollection systems;
        ArrayList<String> result = new ArrayList<String>();
        String field = "FCLOUDID";
        if (!isCloud) {
            field = "FAPPID";
        }
        if ((systems = SingleORM.query(null, (String)(sql = "select distinct " + field + " from t_bas_sysparaconsole where FENABLED ='1'"), null)) != null) {
            for (int i = 0; i < systems.size(); ++i) {
                String system = ((DynamicObject)systems.get(i)).getString(0);
                if (!StringUtils.isNotBlank((CharSequence)system)) continue;
                result.add(system);
            }
        }
        return result;
    }

    protected void clickFirstCloudNode(TreeNode root) {
        TreeView tree = (TreeView)this.getView().getControl(this.APP_TREEKEY);
        List cloudNodes = root.getChildren();
        if (CollectionUtils.isEmpty((Collection)cloudNodes)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"apprightpanel"});
            return;
        }
        TreeNode firstNode = (TreeNode)cloudNodes.get(0);
        firstNode = this.getUserSelectedNode(root);
        firstNode = this.getCustomInitApp(root, firstNode);
        tree.focusNode(firstNode);
        tree.expand(firstNode.getParentid());
        tree.treeNodeClick(root.getId(), firstNode.getId());
    }

    private TreeNode getCustomInitApp(TreeNode root, TreeNode firstNode) {
        Object switchToApp = this.getView().getFormShowParameter().getCustomParam("switchToApp");
        if (StringUtils.isNotBlank((Object)switchToApp)) {
            try {
                String bizAppId = BizAppServiceHelp.getAppIdByAppNumber((String)((String)switchToApp));
                TreeNode appNode = root.getTreeNode(bizAppId);
                firstNode = appNode != null ? appNode : (TreeNode)root.getChildren().get(0);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                firstNode = (TreeNode)root.getChildren().get(0);
            }
            this.getView().getFormShowParameter().getCustomParams().remove("switchToApp");
        }
        return firstNode;
    }

    private TreeNode getUserSelectedNode(TreeNode root) {
        String setting = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)"last_selected_param");
        if (!StringUtils.isEmpty((CharSequence)setting)) {
            Map map = (Map)SerializationUtils.fromJsonString((String)setting, Map.class);
            Object type = map.get("paramType");
            Object nodeId = map.get("selectedNodeId");
            if (type instanceof String && APP_L_CASE.equals((String)type) && null != nodeId) {
                String id = (String)nodeId;
                TreeNode node = root.getTreeNode(id, 10);
                if (null == node) {
                    return (TreeNode)root.getChildren().get(0);
                }
                return node;
            }
        }
        return (TreeNode)root.getChildren().get(0);
    }

    @Override
    protected AppParam buildAppParam(IParameterModel model) {
        ListSelectedRow selectedRow;
        Object acctingBookObj;
        long acctBookId;
        String appId;
        AppParam appParam = super.buildAppParam(model);
        IPageCache pageCache = this.getPageCache();
        String cloudId = model.getParamCloudId();
        if (!this.enableAcctBook(cloudId, appId = model.getParamAppId())) {
            acctBookId = 0L;
        } else {
            ListSelectedRow selectedRow2;
            Object acctBookObj;
            acctBookId = model.getAcctBookId();
            String selectAcctbook = pageCache.get(SELECTED_ACCT_BOOK);
            if (StringUtils.isNotBlank((CharSequence)selectAcctbook) && (acctBookObj = (selectedRow2 = (ListSelectedRow)SerializationUtils.fromJsonString((String)selectAcctbook, ListSelectedRow.class)).getPrimaryKeyValue()) != null) {
                acctBookId = (Long)acctBookObj;
            }
        }
        long acctingBookId = model.getAcctingBookId();
        String seleAcctingBook = pageCache.get(SELECTED_ACCTING_BOOK);
        if (StringUtils.isNotBlank((CharSequence)seleAcctingBook) && (acctingBookObj = (selectedRow = (ListSelectedRow)SerializationUtils.fromJsonString((String)seleAcctingBook, ListSelectedRow.class)).getPrimaryKeyValue()) != null) {
            acctingBookId = (Long)acctingBookObj;
        }
        appParam.setActBookId(Long.valueOf(acctBookId));
        appParam.setAcctingBookId(Long.valueOf(acctingBookId));
        return appParam;
    }

    private TreeNode getCloudAndAppTree() {
        TreeNode treeRoot = (TreeNode)BizAppServiceHelp.getSubsysTree(null, null, null, (String)APP_L_CASE, (boolean)true, (boolean)true, (boolean)true);
        this.filterCloudAndAppNodes(treeRoot);
        return treeRoot;
    }

    private void filterCloudAndAppNodes(TreeNode root) {
        List cloudNodes = root.getChildren();
        TreeNodeFilter treeNodeFilter = new TreeNodeFilter();
        cloudNodes = treeNodeFilter.filterCloudTreeNode(cloudNodes);
        root.setChildren(cloudNodes);
        for (TreeNode cloudNode : cloudNodes) {
            List appNodes = cloudNode.getChildren();
            if (CollectionUtils.isEmpty((Collection)appNodes)) continue;
            appNodes = treeNodeFilter.filterAppTreeNode(appNodes);
            cloudNode.setChildren(appNodes);
        }
    }

    private List<String> querryAcctBookStype(Object acctBookNumber) {
        if (acctBookNumber == null) {
            return null;
        }
        ArrayList<String> resultList = new ArrayList<String>(1);
        QFilter f1 = new QFilter(ID, "=", (Object)Long.parseLong(String.valueOf(acctBookNumber)));
        QFilter[] filters = new QFilter[]{f1};
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"name", (QFilter[])filters);
        if (null == dynamicObject || null == dynamicObject.get("name")) {
            return Stream.of("").collect(Collectors.toList());
        }
        resultList.add(dynamicObject.get("name").toString());
        return resultList;
    }

    private List<String> querryAcctingBooks(Long acctingBookNumber) {
        if (null == acctingBookNumber) {
            return null;
        }
        String sql = "SELECT FNUMBER FROM T_BD_ACCOUNTBOOKS WHERE FENABLE='1' AND FID=?";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(":FID", -5, (Object)acctingBookNumber));
        List acResult = (List)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]), e -> {
            ArrayList<String> nameList = new ArrayList<String>(8);
            while (e.next()) {
                nameList.add(e.getString(FNUMBER));
            }
            if (CollectionUtils.isEmpty(nameList)) {
                return null;
            }
            return nameList;
        });
        return acResult;
    }

    private boolean enableAcctBook(String cloudId, String appId) {
        ParamPublishObject publishObject = ParameterReader.getParameterObject((String)cloudId, (String)appId);
        return null != publishObject && publishObject.isActBookEnable();
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        TreeView treeView = (TreeView)this.getControl(this.APP_TREEKEY);
        String searchText = searchEnterEvent.getText();
        String searchTextFormCache = this.getPageCache().get("searchText");
        String searchTextTimeString = this.getPageCache().get("searchText_time");
        int searchTextTime = 1;
        if (StringUtils.isNotBlank((CharSequence)searchTextTimeString)) {
            searchTextTime = Integer.parseInt(searchTextTimeString);
        }
        String treeNodeFromCache = this.getPageCache().get(TREENODECACHE);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeNodeFromCache, TreeNode.class);
        List cloudNode = root.getChildren();
        ArrayList appNode = new ArrayList();
        for (TreeNode tn : cloudNode) {
            if (tn.getChildren() == null) continue;
            appNode.addAll(tn.getChildren());
        }
        ArrayList allNode = new ArrayList();
        allNode.addAll(cloudNode);
        allNode.addAll(appNode);
        if (searchText.equals(searchTextFormCache)) {
            String searchDataString = this.getPageCache().get("searchData");
            List listFormCache = null;
            if (searchDataString != null && !(listFormCache = SerializationUtils.fromJsonStringToList((String)searchDataString, TreeNode.class)).isEmpty()) {
                if (listFormCache.size() > searchTextTime) {
                    TreeNode focusNode = (TreeNode)listFormCache.get(searchTextTime);
                    treeView.focusNode(focusNode);
                    this.treeNodeClick(focusNode.getId());
                    treeView.expand(focusNode.getParentid());
                    this.getPageCache().put("searchText_time", String.valueOf(searchTextTime + 1));
                } else {
                    TreeNode focusNode = (TreeNode)listFormCache.get(0);
                    treeView.focusNode(focusNode);
                    this.treeNodeClick(focusNode.getId());
                    treeView.expand(focusNode.getParentid());
                    this.getPageCache().put("searchText_time", "1");
                }
            }
        } else {
            ArrayList<TreeNode> list = new ArrayList<TreeNode>();
            for (TreeNode node : allNode) {
                if (!node.getText().contains(searchText)) continue;
                list.add(node);
            }
            if (list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u4e0d\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"ParameterConsolePlugin_25", (String)BOS_PARAMETER, (Object[])new Object[0]));
            } else {
                TreeNode focusNode = (TreeNode)list.get(0);
                treeView.focusNode(focusNode);
                this.treeNodeClick(focusNode.getId());
                treeView.expand(focusNode.getParentid());
                this.getPageCache().put("searchText", searchText);
                this.getPageCache().put("searchText_time", "1");
                this.getPageCache().put("searchData", SerializationUtils.toJsonString(list));
            }
        }
    }

    private void treeNodeClick(String nodeId) {
        if ("/biz".equals(nodeId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"apprightpanel"});
        }
        this.closeParameterForm();
        this.getPageCache().put("nodeId", nodeId);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREENODECACHE), TreeNode.class);
        if (!root.getId().equalsIgnoreCase(nodeId)) {
            TreeNode checkedNode = root.getTreeNode(nodeId, 10);
            TreeView tree = (TreeView)this.getControl(this.APP_TREEKEY);
            tree.focusNode(checkedNode);
            if (checkedNode == null) {
                return;
            }
            try {
                this.showView(nodeId, root, checkedNode);
            }
            catch (KDException e) {
                UserConfigServiceHelper.clearSetting((long)RequestContext.get().getCurrUserId(), (String)"last_selected_param");
                throw e;
            }
            Tab tab = (Tab)this.getView().getControl("apptabap");
            if (tab != null) {
                tab.activeTab(TabStatus.APP_CUSTOM_TAB[0]);
            }
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("paramType", APP_L_CASE);
            map.put("selectedNodeId", checkedNode.getId());
            UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)"last_selected_param", (String)SerializationUtils.toJsonString(map));
        }
    }

    private void showView(String nodeId, TreeNode root, TreeNode checkedNode) throws KDException {
        List datas;
        this.getView().setVisible(Boolean.TRUE, new String[]{"apprightpanel"});
        Object nodeData = checkedNode.getData();
        if (null == nodeData || nodeData.equals(CLOUD_L_CASE) || nodeData.equals(APP_L_CASE)) {
            if (null != nodeData) {
                checkedNode.setType((String)checkedNode.getData());
                checkedNode.setData(null);
            }
            this.queryBindParameter(checkedNode);
            this.getPageCache().put(TREENODECACHE, SerializationUtils.toJsonString((Object)root));
        }
        String formId = (datas = (List)checkedNode.getData()) == null ? null : datas.get(0).toString();
        Boolean visible = datas == null ? Boolean.FALSE : (Boolean)datas.get(1);
        String cloudId = null;
        String appId = null;
        if (!APP_U_CASE.equalsIgnoreCase(checkedNode.getType())) {
            this.getPageCache().remove("app_curNodeId");
        }
        if (CLOUD.equalsIgnoreCase(checkedNode.getType())) {
            cloudId = checkedNode.getId();
        } else if (APP_U_CASE.equalsIgnoreCase(checkedNode.getType())) {
            if (!PUBLICPARAMETERID.equals(nodeId)) {
                ParamPublishObject param = ParameterReader.getParameterObject(null, (String)nodeId);
                if (null != param) {
                    String paraObjNumber = param.getFormId();
                    if (!paraObjNumber.equals(formId)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u914d\u7f6e\u53c2\u6570\u5df2\u7ecf\u5207\u6362\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u7cfb\u7edf\u53c2\u6570\u3002", (String)"ParameterConsolePlugin_14", (String)BOS_PARAMETER, (Object[])new Object[0]));
                        return;
                    }
                } else {
                    return;
                }
            }
            appId = checkedNode.getId();
            this.getPageCache().put("app_curNodeId", nodeId);
        }
        boolean isViewTypeChange = this.setViewTypeData(cloudId, appId);
        this.setViewTypeAndOrgStatus(appId, visible);
        if (!StringUtils.isBlank((CharSequence)formId)) {
            long orgId = this.getFirstPermOrg(formId);
            if (isViewTypeChange) {
                this.viewChange();
            }
            this.showParameterForm(orgId, formId, cloudId, appId);
        }
        this.setSingleOrgView(visible);
    }

    void syncParam(IParameterModel dataModel, DynamicObject currDynamicObject) {
        AppParam appParam = this.buildAppParam(dataModel);
        String viewType = appParam.getViewType();
        Long curOrgId = appParam.getOrgId();
        ParamPublishObject publishObject = parameterReaderService.getParameterObject(appParam.getCloudId(), appParam.getAppId());
        QFilter[] qFilters = new QFilter[]{new QFilter("FPARAMID", "=", (Object)publishObject.getId()), new QFilter("FVIEWTYPEID", "=", (Object)appParam.getViewType()), new QFilter("FACCTBOOKID", "=", (Object)0), new QFilter("FACCTINGBOOKID", "=", (Object)0), new QFilter("FORGID", "=", (Object)curOrgId), new QFilter("FPARAMCONFIG", "!=", null)};
        DynamicObjectCollection param = QueryServiceHelper.query((String)"bos_svc_sysparameter", (String)"FPARAMCONFIG", (QFilter[])qFilters);
        if (param.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u540c\u6b65\u7684\u53c2\u6570\uff0c\u8bf7\u524d\u5f80\u3010\u96c6\u56e2\u7ba1\u63a7\u3011\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"AppParamConsolePlugin_2", (String)BOS_PARAMETER, (Object[])new Object[0]));
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)param.get(0);
        String fParamConfigJson = dynamicObject.getString("FPARAMCONFIG");
        if (StringUtils.isBlank((CharSequence)fParamConfigJson)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u540c\u6b65\u7684\u53c2\u6570\uff0c\u8bf7\u524d\u5f80\u3010\u96c6\u56e2\u7ba1\u63a7\u3011\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"AppParamConsolePlugin_2", (String)BOS_PARAMETER, (Object[])new Object[0]));
            return;
        }
        SelectParamConfig selectParamConfig = (SelectParamConfig)SerializationUtils.fromJsonString((String)fParamConfigJson, SelectParamConfig.class);
        Map<String, Boolean> dbSyncParams = selectParamConfig.getSyncParams();
        Map<String, Object> syncParamValueMap = this.getSyncParamValueMap(currDynamicObject, dbSyncParams);
        if (syncParamValueMap.isEmpty()) {
            this.addDefaultSyncSubLog();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u3002", (String)"AppParamConsolePlugin_1", (String)BOS_PARAMETER, (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> searchParentIds = new ArrayList<Long>(1);
        searchParentIds.add(curOrgId);
        List orgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)viewType, searchParentIds, (boolean)false);
        if (CollectionUtils.isEmpty((Collection)orgIds)) {
            this.addDefaultSyncSubLog();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u3002", (String)"AppParamConsolePlugin_1", (String)BOS_PARAMETER, (Object[])new Object[0]));
            return;
        }
        appParam.setParamId(publishObject.getId());
        appParam.setOrgId(curOrgId);
        int count = this.syncParamToSubOrg(currDynamicObject.getDataEntityType().getName(), appParam, syncParamValueMap, orgIds);
        if (count > 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u3002", (String)"AppParamConsolePlugin_1", (String)BOS_PARAMETER, (Object[])new Object[0]));
        }
    }

    protected Map<String, Object> getSyncParamValueMap(DynamicObject currDynamicObject, Map<String, Boolean> dbSyncParams) {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)currDynamicObject.getDataEntityType().getName(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        DataEntityPropertyCollection properties = currDynamicObject.getDataEntityType().getProperties();
        HashMap<String, Object> syncParamValueMap = new HashMap<String, Object>(16);
        for (Map.Entry<String, Boolean> entry : dbSyncParams.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            String fieldKey = entry.getKey();
            if (properties.containsKey((Object)fieldKey)) {
                Object value = currDynamicObject.get(fieldKey);
                syncParamValueMap.put(fieldKey, value);
                continue;
            }
            Field field = entityMetadata.getFieldByKey(fieldKey);
            if (!(field instanceof TimeRangeField)) continue;
            TimeRangeField timeRangeField = (TimeRangeField)field;
            String startDateFieldKey = timeRangeField.getStartDateFieldKey();
            String endDateFieldKey = timeRangeField.getEndDateFieldKey();
            if (properties.containsKey((Object)startDateFieldKey)) {
                syncParamValueMap.put(startDateFieldKey, currDynamicObject.get(startDateFieldKey));
            }
            if (!properties.containsKey((Object)endDateFieldKey)) continue;
            syncParamValueMap.put(endDateFieldKey, currDynamicObject.get(endDateFieldKey));
        }
        return syncParamValueMap;
    }

    protected int syncParamToSubOrg(String paramFormId, AppParam appParam, Map<String, Object> syncParamValueMap, List<Long> orgIds) {
        QFilter[] qFilters = new QFilter[]{new QFilter("FPARAMID", "=", (Object)appParam.getParamId()), new QFilter("FVIEWTYPEID", "=", (Object)appParam.getViewType()), new QFilter("FACCTBOOKID", "=", (Object)0), new QFilter("FACCTINGBOOKID", "=", (Object)0), new QFilter("FORGID", "in", orgIds), new QFilter("FDATA", "!=", null)};
        DynamicObjectCollection children = QueryServiceHelper.query((String)"bos_svc_sysparameter", (String)"forgid,fdata", (QFilter[])qFilters);
        if (CollectionUtils.isEmpty((Collection)children)) {
            this.addDefaultSyncSubLog();
            return 1;
        }
        ArrayList<kd.bos.db.SqlParameter[]> updateList = new ArrayList<kd.bos.db.SqlParameter[]>(16);
        String updateSql = "UPDATE T_BAS_SYSPARAMETER SET fdata=? WHERE fparamid=? AND fviewtypeid=? AND forgid=? AND facctbookid=? AND facctingbookid=? ";
        ArrayList<Long> subOrgIds = new ArrayList<Long>(children.size());
        for (DynamicObject child : children) {
            String fdataJson = child.getString("FDATA");
            if (StringUtils.isBlank((CharSequence)fdataJson)) continue;
            long forgid = child.getLong("forgid");
            subOrgIds.add(forgid);
            String syncStr = this.getNewSynValueData(paramFormId, syncParamValueMap, fdataJson);
            kd.bos.db.SqlParameter[] sqlParams = new kd.bos.db.SqlParameter[]{new kd.bos.db.SqlParameter("fdata", 12, (Object)syncStr), new kd.bos.db.SqlParameter("fparamid", 12, (Object)appParam.getParamId()), new kd.bos.db.SqlParameter("fviewtypeid", 12, (Object)appParam.getViewType()), new kd.bos.db.SqlParameter("forgid", -5, (Object)forgid), new kd.bos.db.SqlParameter("facctbookid", -5, (Object)appParam.getActBookId()), new kd.bos.db.SqlParameter("facctingbookid", -5, (Object)appParam.getAcctingBookId())};
            updateList.add(sqlParams);
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)updateSql, updateList);
        long rootOrgId = ParameterOrgUtils.getParamRootOrgId();
        if (null != appParam.getOrgId() && appParam.getOrgId().equals(rootOrgId)) {
            LocalCacheUtils.remove((String)(RequestContext.get().getAccountId() + COMMON_PARAMETERS));
        }
        ParameterCache.removeParameter(appParam.getCloudId(), appParam.getAppId());
        ParameterCache.removeBatchParameter(appParam.getCloudId(), appParam.getAppId());
        this.addSyncSubLog(appParam.getOrgId(), syncParamValueMap, subOrgIds);
        return updateList.size();
    }

    private void addDefaultSyncSubLog() {
        try {
            ParamOpLogUtils.addLog(this.getView(), BT_SYNC_PARAMS, new MultiLangEnumBridge("\u540c\u6b65\u4e0b\u7ea7", "AppParamConsolePlugin_3", BOS_PARAMETER).getDescription(), "");
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private void addSyncSubLog(Long curOrgId, Map<String, Object> syncParamValueMap, List<Long> subOrgIds) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("crrOrgId:").append(curOrgId);
            builder.append(" syncParams:").append(SerializationUtils.toJsonString(syncParamValueMap));
            builder.append(" subOrgIds:").append(SerializationUtils.toJsonString(subOrgIds));
            ParamOpLogUtils.addLog(this.getView(), BT_SYNC_PARAMS, new MultiLangEnumBridge("\u540c\u6b65\u4e0b\u7ea7", "AppParamConsolePlugin_3", BOS_PARAMETER).getDescription(), null, new MultiLangEnumBridge("\u7ed3\u679c\uff1a%s", "ParameterConsolePlugin_100", BOS_PARAMETER), builder.toString());
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private String getNewSynValueData(String paramFormId, Map<String, Object> synValue, String jsonString) {
        DynamicObject dynamicObject = kd.bos.param.ParameterUtils.serializeToDataEntity(jsonString, paramFormId);
        for (Map.Entry<String, Object> entry : synValue.entrySet()) {
            dynamicObject.set(entry.getKey(), entry.getValue());
        }
        return SerializationUtils.toJsonString(this.getJsonStringMap(dynamicObject));
    }

    protected void setSingleOrgView(boolean visible) {
        SingleOrgContextHelper.createSystemParamSingleOrgContext((IFormView)this.getView(), (boolean)visible);
    }

    protected String getShowOrgKey() {
        return "orgfield";
    }

    protected long getTopOrgId() {
        String cacheViewType = this.getPageCache().get("viewTypeId");
        String useOrgFunc = StringUtils.isBlank((CharSequence)cacheViewType) ? DEFAULTVIEWTYPE : cacheViewType;
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        long viewId = OrgUnitServiceHelper.getViewIdByType((String)useOrgFunc);
        ArrayList<Long> viewIds = new ArrayList<Long>(1);
        viewIds.add(viewId);
        Map rootOrgIdMap = orgService.getRootOrgId(viewIds);
        Long rootOrg = (Long)rootOrgIdMap.get(viewId);
        if (rootOrg == null) {
            rootOrg = OrgUnitServiceHelper.getRootOrgId();
        }
        return rootOrg;
    }

    protected Long getSelectedOrgId() {
        Long orgId = null;
        DynamicObject orgObj = (DynamicObject)this.getModel().getDataEntity().get(this.getShowOrgKey());
        if (orgObj == null) {
            return null;
        }
        Object masterId = orgObj.get("masterid");
        if (masterId instanceof Long) {
            orgId = (Long)masterId;
        }
        return orgId;
    }

    private IFormView getAppView(String appParamPageId) {
        IFormView view = null;
        try {
            view = this.getView().getView(appParamPageId);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        if (view == null) {
            ParameterLog.info("view=null");
            view = this.getView().getViewNoPlugin(appParamPageId);
        }
        return view;
    }
}

