/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.parameter.ParameterShowParameter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.svc.util.TreeNodeFilter;

public class BillParamSetPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener,
TreeNodeQueryListener {
    private static final String KEY_TREEVIEW = "tree";
    private static final String KEY_SEARCH = "searchnode";
    private static final String PAGE_CACHE_ID = "TabParaSettings_PageId";
    private static final String TREE_CACHE = "treeCache";
    private static final String KEY_SEARCH_CACHE = "keyCache";
    private static final String SEARCH_RESULT_CAHCE = "resultCache";
    private static final String INDEX_CAHCE = "indexCache";
    private static final String FORM_NODE = "formNode";
    private static final String LOADED_APP_ID_SET = "LOADED_APP_ID_SET";
    private static final String BOS_PARAMETER = "bos-parameter";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        Search search = (Search)this.getView().getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void beforeBindData(EventObject e) {
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        TreeNode root = this.buildRootNode();
        tree.addNode(root);
        tree.setRootVisible(true);
        tree.focusNode(root);
        this.getPageCache().put(TREE_CACHE, SerializationUtils.toJsonString((Object)root));
    }

    private TreeNode buildRootNode() {
        TreeNode root = this.getCloudAndAppTree();
        if (root != null) {
            root.setId("rootNode");
            root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"BillParamSetPlugin_0", (String)BOS_PARAMETER, (Object[])new Object[0]));
            root.setParentid("");
            root.setIsOpened(true);
        }
        return root;
    }

    public void search(SearchEnterEvent evt) {
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        TreeNode root = this.getTreeNodeRoot();
        if (root == null) {
            return;
        }
        String key = evt.getText();
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        String cacheKey = this.getPageCache().get(KEY_SEARCH_CACHE);
        if (key.equals(cacheKey)) {
            String resultCache = this.getPageCache().get(SEARCH_RESULT_CAHCE);
            String[] searchNodeIds = (String[])SerializationUtils.fromJsonString((String)resultCache, String[].class);
            String indexCache = this.getPageCache().get(INDEX_CAHCE);
            int cachedIndex = Integer.parseInt(indexCache);
            if (cachedIndex == searchNodeIds.length) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b8c\u6210\u641c\u7d22\u3002", (String)"BillParamSetPlugin_1", (String)BOS_PARAMETER, (Object[])new Object[0]));
                this.getPageCache().put(INDEX_CAHCE, "0");
                return;
            }
            int currentIndex = cachedIndex;
            TreeNode tmpNode = root.getTreeNode(searchNodeIds[currentIndex]);
            this.clickNode(tree, root, tmpNode);
            this.getPageCache().put(INDEX_CAHCE, String.valueOf(++currentIndex));
        } else {
            Set<String> searchedEntitySet = this.searchNodeByNumberOrName(tree, root, key);
            if (searchedEntitySet.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u4e0d\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"BillParamSetPlugin_2", (String)BOS_PARAMETER, (Object[])new Object[0]));
            } else {
                String[] searchedEntityIdArray = searchedEntitySet.toArray(new String[0]);
                TreeNode firstNode = root.getTreeNode(searchedEntityIdArray[0]);
                this.clickNode(tree, root, firstNode);
                this.getPageCache().put(SEARCH_RESULT_CAHCE, SerializationUtils.toJsonString((Object)searchedEntityIdArray));
                this.getPageCache().put(INDEX_CAHCE, String.valueOf(1));
                this.getPageCache().put(KEY_SEARCH_CACHE, key);
            }
        }
    }

    private TreeNode getTreeNodeRoot() {
        String cache = this.getPageCache().get(TREE_CACHE);
        if (StringUtils.isBlank((CharSequence)cache)) {
            return null;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)cache, TreeNode.class);
        return root;
    }

    public void clickNode(TreeView tree, TreeNode root, TreeNode node) {
        tree.focusNode(node);
        tree.treeNodeClick(node.getParentid(), node.getId());
        if (node.getChildren() == null) {
            String id = node.getParentid();
            while (StringUtils.isNotBlank((CharSequence)id)) {
                TreeNode tmp = root.getTreeNode(id, 16);
                tree.expand(tmp.getId());
                id = tmp.getParentid();
            }
        } else {
            tree.expand(node.getId());
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        TreeNode treeNodeRoot = this.getTreeNodeRoot();
        if (treeNodeRoot == null) {
            return;
        }
        Set<String> loadedAppSet = this.getLoadedAppSet();
        TreeNode currNode = treeNodeRoot.getTreeNode(nodeId);
        if (StringUtils.equals((CharSequence)String.valueOf(currNode.getData()), (CharSequence)"app") && !loadedAppSet.contains(currNode.getId())) {
            String appId = currNode.getId();
            Map<String, List<TreeNode>> childrenMap = this.getChildrenMapByAppIds(new Object[]{appId});
            currNode.setChildren((List)childrenMap.getOrDefault(appId, new ArrayList(0)));
            this.getPageCache().put(TREE_CACHE, SerializationUtils.toJsonString((Object)treeNodeRoot));
            TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEW);
            tree.updateNode(currNode);
            loadedAppSet.add(currNode.getId());
            this.getPageCache().put(LOADED_APP_ID_SET, SerializationUtils.toJsonString(loadedAppSet));
        }
        this.showForm(nodeId);
    }

    private void showForm(String formId) {
        String paramFormId = null;
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Entity);
        if (StringUtils.isBlank((CharSequence)id)) {
            this.closeContainerPage();
            return;
        }
        EntityMetadata metadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Entity);
        List items = metadata.getItems();
        MainEntity entity = metadata.getRootEntity();
        if (entity instanceof BillEntity) {
            BillEntity billEntity = (BillEntity)entity;
            paramFormId = billEntity.getBillParameter();
        }
        if (StringUtils.isBlank(paramFormId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u4e0d\u652f\u6301\u5355\u636e\u53c2\u6570\u914d\u7f6e\u6216\u8005\u672a\u7ed1\u5b9a\u5355\u636e\u53c2\u6570\u8868\u5355\u3002", (String)"BillParamSetPlugin_3", (String)BOS_PARAMETER, (Object[])new Object[0]));
            this.closeContainerPage();
            return;
        }
        this.showParameterForm(paramFormId, formId, items);
    }

    private void closeContainerPage() {
        String pageId = this.getPageCache().get(PAGE_CACHE_ID);
        if (pageId != null) {
            HashMap<String, String> arg = new HashMap<String, String>();
            arg.put("pageId", pageId);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", arg);
            this.getPageCache().remove(PAGE_CACHE_ID);
        }
    }

    private void showParameterForm(String paramFormId, String formId, List<EntityItem<?>> items) {
        this.closeContainerPage();
        if (paramFormId != null) {
            ParameterShowParameter showParameter = new ParameterShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey("paramsetting");
            showParameter.setFormId(paramFormId);
            showParameter.setCustomParam("bindformid", (Object)formId);
            this.getView().showForm((FormShowParameter)showParameter);
            this.getPageCache().put(PAGE_CACHE_ID, showParameter.getPageId());
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u53c2\u6570\u8868\u5355\uff0c\u8bf7\u5148\u751f\u6210\u53c2\u6570\u8868\u5355\u5e76\u53d1\u5e03\u3002", (String)"BillParamSetPlugin_4", (String)BOS_PARAMETER, (Object[])new Object[0]));
        }
    }

    private Set<String> searchNodeByNumberOrName(TreeView tree, TreeNode root, String key) {
        String sql = " select t.FBIZAPPID,tp.fmasterid, t.fid,tl.fname from T_META_MAINENTITYINFO as t left join T_META_MAINENTITYINFO_L as tl on t.FID=tl.FID left join t_meta_bizapp as tp on t.fbizappid = tp.fid  where (t.fid like ? or tl.fname like ? ) and t.FISTEMPLATE = '0' and tl.FLOCALEID=? and ((t.FMODELTYPE=? and t.FNUMBERFIELDKEY<>' ' and t.FNAMEFIELDKEY<>' ') or t.FMODELTYPE=?) and t.FID not in ('bos_user_quickentry')";
        String sqlStrEntityId = RunModeServiceHelper.getEntityNumFromBlacklist();
        if (StringUtils.isNotEmpty((CharSequence)sqlStrEntityId)) {
            sql = sql + " and t.FID not in (" + sqlStrEntityId + ")";
        }
        Object[] sqlParams = new SqlParameter[]{new SqlParameter(12, (Object)("%" + key + "%")), new SqlParameter(12, (Object)("%" + key + "%")), new SqlParameter(12, (Object)RequestContext.get().getLang().name()), new SqlParameter(12, (Object)"BaseFormModel"), new SqlParameter(12, (Object)"BillFormModel")};
        ResultSetHandler action = rs -> {
            HashMap<String, Map> res = new HashMap<String, Map>(16);
            while (rs.next()) {
                String nowAppId = rs.getString(1);
                String preAppId = rs.getString(2);
                String appId = nowAppId;
                if (StringUtils.isNotBlank((CharSequence)preAppId)) {
                    appId = preAppId;
                }
                String formId = rs.getString(3);
                String name = rs.getString(4) == null ? "" : rs.getString(4);
                Map entityMap = res.getOrDefault(appId, new HashMap(0));
                entityMap.put(formId, name);
                res.put(appId, entityMap);
            }
            return res;
        };
        Map searchMap = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])sqlParams, (ResultSetHandler)action);
        Set<String> loadedAppSet = this.getLoadedAppSet();
        LinkedHashSet<String> toLoadAppId = new LinkedHashSet<String>(16);
        for (String appId : searchMap.keySet()) {
            if (loadedAppSet.contains(appId)) continue;
            toLoadAppId.add(appId);
        }
        Map<String, List<TreeNode>> childrenMap = this.getChildrenMapByAppIds(toLoadAppId.toArray());
        Iterator iterator = searchMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String appId = (String)entry.getKey();
            Map searchEntityIdSetMap = (Map)entry.getValue();
            TreeNode appNode = root.getTreeNode(appId);
            if (appNode == null) {
                iterator.remove();
                continue;
            }
            List nodeList = childrenMap.getOrDefault(appId, new ArrayList(0));
            if (nodeList.isEmpty()) {
                nodeList = appNode.getChildren();
            }
            appNode.setChildren(nodeList);
            Set entityIdSet = nodeList.stream().map(TreeNode::getId).collect(Collectors.toSet());
            searchEntityIdSetMap.entrySet().removeIf(searchEntity -> !entityIdSet.contains(searchEntity.getKey()));
        }
        if (!CollectionUtils.isEmpty(childrenMap)) {
            tree.updateNode(root);
        }
        Set<String> res = this.sortedByNameThenByNumber(searchMap);
        loadedAppSet.addAll(toLoadAppId);
        this.getPageCache().put(LOADED_APP_ID_SET, SerializationUtils.toJsonString(loadedAppSet));
        this.getPageCache().put(TREE_CACHE, SerializationUtils.toJsonString((Object)root));
        return res;
    }

    private Set<String> sortedByNameThenByNumber(Map<String, Map<String, String>> searchMap) {
        LinkedHashSet<String> res = new LinkedHashSet<String>(16);
        for (Map.Entry<String, Map<String, String>> entry : searchMap.entrySet()) {
            Map<String, String> entityIdMap = entry.getValue();
            Set<String> entityIds = entityIdMap.keySet();
            List collect = Arrays.stream(entityIds.toArray(new String[0])).sorted((entityId1, entityId2) -> {
                String name2;
                String name1 = String.valueOf(entityIdMap.get(entityId1));
                int compareTo = name1.compareTo(name2 = String.valueOf(entityIdMap.get(entityId2)));
                if (compareTo == 0) {
                    compareTo = entityId1.compareTo((String)entityId2);
                }
                return compareTo;
            }).collect(Collectors.toList());
            res.addAll(collect);
        }
        return res;
    }

    private Set<String> getLoadedAppSet() {
        Set<String> loadedAppSet = new LinkedHashSet<String>(16);
        String loadAppIdSetJson = this.getPageCache().get(LOADED_APP_ID_SET);
        if (StringUtils.isNotBlank((CharSequence)loadAppIdSetJson)) {
            loadedAppSet = (Set)SerializationUtils.fromJsonString((String)loadAppIdSetJson, Set.class);
        }
        return loadedAppSet;
    }

    private Map<String, List<TreeNode>> getChildrenMapByAppIds(Object[] appIds) {
        if (appIds == null || appIds.length == 0) {
            return new HashMap<String, List<TreeNode>>(0);
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select t.FID, t.FBIZAPPID, tl.FNAME, te.fdata, tp.fmasterid from T_META_MAINENTITYINFO as t ", new Object[0]).append("left join T_META_MAINENTITYINFO_L as tl on t.FID=tl.FID ", new Object[0]).append("left join t_meta_bizapp as tp on  t.fbizappid = tp.fid ", new Object[0]).append("left join t_meta_entity as te on t.fid = te.fnumber ", new Object[0]).append(" where (", new Object[0]).appendIn("t.fbizappid", appIds).append(" or ", new Object[0]).appendIn("tp.fmasterid", appIds).append(")", new Object[0]).append(" and t.FISTEMPLATE = '0' and tl.FLOCALEID='" + RequestContext.get().getLang().name() + "' and ", new Object[0]).append("((t.FMODELTYPE='BaseFormModel' and t.FNUMBERFIELDKEY<>' ' and t.FNAMEFIELDKEY<>' ') or ", new Object[0]).append("t.FMODELTYPE='BillFormModel' ) ", new Object[0]);
        String sqlStrEntityId = RunModeServiceHelper.getEntityNumFromBlacklist();
        if (StringUtils.isNotEmpty((CharSequence)sqlStrEntityId)) {
            sqlBuilder.append(" and t.FID not in (" + sqlStrEntityId + ")", new Object[0]);
        }
        sqlBuilder.append(" and te.ftype = 20", new Object[0]);
        ResultSetHandler action = rs -> {
            HashMap<String, List> appNodesMap = new HashMap<String, List>(16);
            while (rs.next()) {
                String fid = rs.getString(1);
                String fdata = rs.getString(4);
                if (StringUtils.isBlank((CharSequence)fdata) || StringUtils.isBlank((CharSequence)fid)) continue;
                TreeNode node = new TreeNode();
                String name = rs.getString(3) == null ? "" : rs.getString(3);
                node.setText(name);
                String fmasterid = rs.getString(5);
                if (StringUtils.isBlank((CharSequence)fmasterid)) {
                    node.setParentid(rs.getString(2));
                } else {
                    node.setParentid(fmasterid);
                }
                node.setId(fid);
                node.setType(FORM_NODE);
                List treeNodes = appNodesMap.getOrDefault(node.getParentid(), new ArrayList(10));
                treeNodes.add(node);
                appNodesMap.put(node.getParentid(), treeNodes);
            }
            for (Map.Entry entry : appNodesMap.entrySet()) {
                List treeNodes = (List)entry.getValue();
                treeNodes.sort(Comparator.comparing(TreeNode::getText).thenComparing(TreeNode::getId));
            }
            return appNodesMap;
        };
        Map appNodesMap = (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
        return appNodesMap;
    }

    private TreeNode getCloudAndAppTree() {
        TreeNode treeRoot = (TreeNode)BizAppServiceHelp.getSubsysTree(null, null, null, (String)"app", (boolean)true, (boolean)true, (boolean)true);
        this.filterCloudAndAppNodes(treeRoot);
        for (TreeNode cloudNode : treeRoot.getChildren()) {
            for (TreeNode appNode : cloudNode.getChildren()) {
                appNode.setChildren(new ArrayList(0));
            }
        }
        return treeRoot;
    }

    private void filterCloudAndAppNodes(TreeNode root) {
        List cloudNodes = root.getChildren();
        TreeNodeFilter treeNodeFilter = new TreeNodeFilter();
        cloudNodes = treeNodeFilter.filterCloudTreeNode(cloudNodes);
        root.setChildren(cloudNodes);
        for (TreeNode cloudNode : cloudNodes) {
            List appNodes = cloudNode.getChildren();
            if (CollectionUtils.isEmpty((Collection)appNodes)) continue;
            appNodes = treeNodeFilter.filterAppTreeNode(appNodes);
            cloudNode.setChildren(appNodes);
        }
        this.removeEmptyCloudNode(cloudNodes);
    }

    private void removeEmptyCloudNode(List<TreeNode> cloudNodes) {
        if (CollectionUtils.isEmpty(cloudNodes)) {
            return;
        }
        Iterator<TreeNode> cloudIterator = cloudNodes.iterator();
        while (cloudIterator.hasNext()) {
            TreeNode cloud = cloudIterator.next();
            List appNodes = cloud.getChildren();
            if (!CollectionUtils.isEmpty((Collection)appNodes)) continue;
            cloudIterator.remove();
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        TreeView tree = (TreeView)evt.getSource();
        String nodeId = (String)evt.getNodeId();
        TreeNode treeNodeRoot = this.getTreeNodeRoot();
        if (treeNodeRoot == null) {
            return;
        }
        TreeNode node = treeNodeRoot.getTreeNode(nodeId, 5);
        if (node == null) {
            return;
        }
        Set<String> loadedAppSet = this.getLoadedAppSet();
        String data = String.valueOf(node.getData());
        if (StringUtils.equals((CharSequence)String.valueOf(data), (CharSequence)"app") && !loadedAppSet.contains(nodeId)) {
            String appId = node.getId();
            Map<String, List<TreeNode>> childrenMap = this.getChildrenMapByAppIds(new Object[]{appId});
            node.setChildren((List)childrenMap.getOrDefault(appId, new ArrayList(0)));
            this.getPageCache().put(TREE_CACHE, SerializationUtils.toJsonString((Object)treeNodeRoot));
            tree.updateNode(node);
            tree.expand(nodeId);
            return;
        }
        tree.expand(nodeId);
    }
}

