/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CustomParamPlugin
extends AbstractFormPlugin {
    private static final String ENTRY_ENTITY = "entryentity";

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String isSys = customParams.getOrDefault("isSys", "false");
        if ("true".equals(isSys)) {
            this.showSysCustomParams();
            return;
        }
        this.showAppCustomParams();
    }

    private void showAppCustomParams() {
        String appId = (String)this.getView().getFormShowParameter().getCustomParam("appId");
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_customparam_app", (String)"id,name,number,value,key,sort", (QFilter[])new QFilter[]{new QFilter("appid", "=", (Object)appId)}, (String)"sort asc");
        int size = dynamicObjectMap.size();
        if (size < 1) {
            return;
        }
        this.updateEntity(size, dynamicObjectMap);
    }

    private void updateEntity(int size, Map<Object, DynamicObject> dynamicObjectMap) {
        IDataModel model = this.getModel();
        model.beginInit();
        if (size > 0) {
            model.batchCreateNewEntryRow(ENTRY_ENTITY, dynamicObjectMap.size());
        }
        int i = 0;
        for (DynamicObject dyObj : dynamicObjectMap.values()) {
            model.setValue("id", dyObj.get("id"), i);
            model.setValue("number", dyObj.get("number"), i);
            model.setValue("key", dyObj.get("key"), i);
            model.setValue("name", dyObj.get("name"), i);
            model.setValue("value", dyObj.get("value"), i);
            ((DynamicObject)model.getEntryEntity(ENTRY_ENTITY).get(i)).getDataEntityState().setFromDatabase(true);
            ++i;
        }
        model.endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void showSysCustomParams() {
        String groupId = (String)this.getView().getFormShowParameter().getCustomParam("groupId");
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_customparam", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)Long.parseLong(groupId))});
        int size = dynamicObjectMap.size();
        if (size < 1) {
            return;
        }
        this.updateEntity(size, dynamicObjectMap);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }
}

