/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IParameterModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.param.ParamPublishObject;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.param.AppParamConsolePlugin;
import kd.bos.form.plugin.param.ParamConsolePlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterOrgUtils;
import kd.bos.permission.model.AdminType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class FlatOrgAppParamConsolePlugin
extends AppParamConsolePlugin {
    private String FlatOrgAppParamUseFV_CALLBACK = "FlatOrgAppParamUseFVCallBack";
    private String FlatOrgAppParamUseFV = "FlatOrgAppParamUseFV";

    @Override
    public void initialize() {
        TreeView tree = (TreeView)this.getControl(this.APP_TREEKEY);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"acctbook"});
        this.addClickListeners(new String[]{"acctingbook"});
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    @Override
    public void tabSelected(TabSelectEvent tabSelectEvent) {
        super.tabSelected(tabSelectEvent);
        this.getView().setVisible(Boolean.TRUE, new String[]{this.getShowOrgKey()});
        this.getView().setVisible(Boolean.FALSE, new String[]{super.getShowOrgKey()});
        HashMap<String, String> comboMap = new HashMap<String, String>();
        comboMap.put("fp", ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7ec4\u7ec7\u540d\u79f0/\u7f16\u7801", (String)"FlatOrgAppParamConsolePlugin_1", (String)"bos-parameter", (Object[])new Object[0]));
        this.getView().updateControlMetadata("orgfieldlist", comboMap);
    }

    @Override
    protected void saveAppParam(IDataModel dataModel) {
        Long selectedOrgId = this.getSelectedOrgId();
        if (selectedOrgId == ParameterOrgUtils.getParamRootOrgId()) {
            DynamicObject dataEntity = dataModel.getDataEntity();
            super.saveAppParam(dataModel);
            this.syncParam((IParameterModel)dataModel, dataEntity);
        } else {
            super.saveAppParam(dataModel);
        }
    }

    @Override
    void syncParam(IParameterModel dataModel, DynamicObject currDynamicObject) {
        List gcFields = SystemParamServiceHelper.getGroupControlFields((String)currDynamicObject.getDataEntityType().getName());
        HashMap<String, Boolean> dbSyncParams = new HashMap<String, Boolean>(gcFields.size());
        for (String fieldKey : gcFields) {
            dbSyncParams.put(fieldKey, true);
        }
        Map<String, Object> syncParamValueMap = this.getSyncParamValueMap(currDynamicObject, dbSyncParams);
        if (syncParamValueMap.isEmpty()) {
            return;
        }
        AppParam appParam = this.buildAppParam(dataModel);
        ParamPublishObject publishObject = parameterReaderService.getParameterObject(appParam.getCloudId(), appParam.getAppId());
        appParam.setParamId(publishObject.getId());
        appParam.setOrgId(this.getSelectedOrgId());
        String ids = this.getPageCache().get("permOrgIds");
        List orgIds = SerializationUtils.fromJsonStringToList((String)ids, Long.class);
        int count = this.syncParamToSubOrg(currDynamicObject.getDataEntityType().getName(), appParam, syncParamValueMap, orgIds);
        if (count > 0) {
            log.info("\u53c2\u6570\u540c\u6b65\u4e0b\u7ea7\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e\u3002", (Object)count);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String paramFormId = this.getPageCache().get("paramFormId");
        if (this.getShowOrgKey().equals(property.getName())) {
            long orgId;
            Object newOrg = e.getChangeSet()[0].getNewValue();
            Object oldOrg = e.getChangeSet()[0].getOldValue();
            if (newOrg == null) {
                this.getModel().setValue(this.getShowOrgKey(), oldOrg);
                orgId = this.getFirstPermOrg(paramFormId);
            } else {
                if (oldOrg == null) {
                    return;
                }
                orgId = Long.parseLong(newOrg.toString());
                if (orgId == Long.parseLong(oldOrg.toString())) {
                    return;
                }
            }
            this.afterOrgPropChage(paramFormId, orgId);
            return;
        }
        super.propertyChanged(e);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if (this.FlatOrgAppParamUseFV_CALLBACK.equals(callBackId)) {
            UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)this.FlatOrgAppParamUseFV, (String)"1");
            return;
        }
    }

    @Override
    protected void viewChange() {
        String setting;
        String isInitComBo = this.getView().getPageCache().get("isInitComBo");
        if (isInitComBo == null && !this.isSuperAdminUser() && null == (setting = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)this.FlatOrgAppParamUseFV))) {
            String msg = ResManager.loadKDString((String)"\u5982\u9700\u4fee\u6539\u6570\u636e\u4e2d\u5fc3\u7ea7\u53c2\u6570\uff0c\u8bf7\u8054\u7cfbadministrator\u7ba1\u7406\u5458\u8fdb\u884c\u4fee\u6539\u3002", (String)"FlatOrgAppParamConsolePlugin_0", (String)"bos-parameter", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OK, new ConfirmCallBackListener(this.FlatOrgAppParamUseFV_CALLBACK, ParamConsolePlugin.class.getName()));
        }
        this.setOrgListCombo();
        this.getView().getPageCache().put("isInitComBo", "1");
    }

    @Override
    protected long getFirstPermOrg(String formId) {
        long orgId = this.getTopOrgId();
        long returnOrgId = super.getFirstPermOrg(formId);
        if (orgId == ParameterOrgUtils.getVirtualRootOrg().getOrgId()) {
            return orgId;
        }
        return returnOrgId;
    }

    @Override
    protected void setSingleOrgView(boolean visible) {
    }

    @Override
    protected long getTopOrgId() {
        long rootOrgId = !this.isSuperAdminUser() ? super.getTopOrgId() : ParameterOrgUtils.getParamRootOrgId();
        return rootOrgId;
    }

    @Override
    protected String getShowOrgKey() {
        return "orgfieldlist";
    }

    @Override
    protected Long getSelectedOrgId() {
        Long orgId = null;
        String orgIdStr = this.getModel().getDataEntity().getString(this.getShowOrgKey());
        if (StringUtils.isNotBlank((CharSequence)orgIdStr)) {
            orgId = Long.parseLong(orgIdStr);
        }
        return orgId;
    }

    private boolean isSuperAdminUser() {
        long userId = RequestContext.get().getCurrUserId();
        boolean adminUser = PermissionServiceHelper.isAdminUser((long)userId, (AdminType)AdminType.Administrator);
        boolean superAdmin = PermissionServiceHelper.isAdminUser((long)userId, (String)"10");
        return adminUser && superAdmin;
    }

    private void setOrgListCombo() {
        String ids = this.getPageCache().get("permOrgIds");
        List orgIds = null;
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            orgIds = SerializationUtils.fromJsonStringToList((String)ids, Long.class);
            QFilter orgFilter = new QFilter("id", "in", (Object)orgIds);
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{orgFilter}, (String)"number asc");
            ComboEdit orgfieldlist = (ComboEdit)this.getView().getControl(this.getShowOrgKey());
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
            if (this.isSuperAdminUser()) {
                ComboItem comboItem = new ComboItem(new LocaleString(ParameterOrgUtils.getVirtualRootOrg().getName()), String.valueOf(ParameterOrgUtils.getVirtualRootOrg().getOrgId()));
                comboItems.add(comboItem);
            }
            for (Map.Entry entry : dynamicObjectMap.entrySet()) {
                DynamicObject dyobj = (DynamicObject)entry.getValue();
                Long id = dyobj.getLong("id");
                String number = dyobj.getString("number");
                String name = dyobj.getString("name");
                ComboItem comboItem = new ComboItem(new LocaleString(number + " " + name), String.valueOf(id));
                comboItems.add(comboItem);
            }
            orgfieldlist.setComboItems(comboItems);
            this.getView().updateView(this.getShowOrgKey());
        }
    }
}

