/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.param.groupcontrol.GroupControlConfig;
import kd.bos.form.plugin.param.groupcontrol.GroupControlUtil;
import kd.bos.form.plugin.param.groupcontrol.SelectParam;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.util.CollectionUtils;

public class ParamSelectPlugin
extends AbstractFormPlugin
implements TreeNodeCheckListener,
F7SelectedListRemoveListener {
    private static final String TREEVIEWAP = "treeviewap";
    private static final String F7SELECTEDLIST_AP = "f7selectedlistap";
    private static final String BTN_OK = "btn_ok";
    private static final String SELECTEDFIELDS = "selectedFields";
    private static final String APP_ID = "appId";
    private static final String ENTITYMETA = "entitymeta";
    private static final String FORMMETA = "formmeta";
    private static final String SELECT_PARAM_TREE = "selectParamTree";
    private static final Integer SHOW_LEVEL = 2;
    private static final String ALL_CTR_PER_APP = "allCtrPerApp";
    private static final String CACHE_KEY_SELECT_PARAM_NEW = "newSelectParamList";
    private static final String CACHE_KEY_SELECT_PARAM_DEL = "delSelectParamList";
    private static final String CACHE_KEY_INDEX_MAP = "indexMap";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
        tree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        F7SelectedList f7 = (F7SelectedList)this.getView().getControl(F7SELECTEDLIST_AP);
        f7.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        f7.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
    }

    public void initialize() {
        super.initialize();
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        TreeView.TreeState state = treeView.getTreeState();
        F7SelectedList f7 = (F7SelectedList)this.getControl(F7SELECTEDLIST_AP);
        if (CollectionUtils.isEmpty((Collection)state.getSelectedNodeId())) {
            f7.removeAllItems();
            return;
        }
        List nodes = state.getCheckedNodes();
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(SELECT_PARAM_TREE), TreeNode.class);
        nodes.removeIf(node -> !root.getTreeNode(node.get("id").toString(), 16).getType().equals(ENTITYMETA));
        List items = nodes.stream().map(node -> new ValueTextItem(node.get("id").toString(), node.get("text").toString())).collect(Collectors.toList());
        f7.addItems(items);
    }

    public void click(EventObject evt) {
        Control ctl = (Control)evt.getSource();
        if (ctl.getKey().equals(BTN_OK)) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            String selectFields = this.getSelectFields();
            String fieldMapJson = this.getPageCache().get(ALL_CTR_PER_APP);
            Map<String, List<SelectParam>> selectParamListMap = this.getSelectParamListMap(selectFields);
            map.put(SELECTEDFIELDS, selectFields);
            map.put(ALL_CTR_PER_APP, fieldMapJson);
            map.put(CACHE_KEY_SELECT_PARAM_NEW, SerializationUtils.toJsonString(selectParamListMap.get("new")));
            map.put(CACHE_KEY_SELECT_PARAM_DEL, SerializationUtils.toJsonString(selectParamListMap.get("del")));
            map.put(CACHE_KEY_INDEX_MAP, this.getIndexMapJson());
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(map));
            this.getView().close();
        }
    }

    private Map<String, List<SelectParam>> getSelectParamListMap(String selectFields) {
        String preSelectParam = (String)this.getView().getFormShowParameter().getCustomParam(SELECTEDFIELDS);
        Set<String> preSelectParamSet = this.getFieldSet(preSelectParam);
        Set<String> selectParamSet = this.getFieldSet(selectFields);
        Object metaDataParamJson = this.getView().getFormShowParameter().getCustomParam("metaDataParam");
        Map metaDataParam = (Map)SerializationUtils.fromJsonString((String)String.valueOf(metaDataParamJson), Map.class);
        AppParam appParam = (AppParam)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParam("appParam")), AppParam.class);
        DynamicObjectCollection paramDynamicObjects = GroupControlUtil.getParamDynamicObjects(appParam);
        Map<Long, GroupControlConfig> paramGroupControlConfig = GroupControlUtil.getParamGroupControlConfig(appParam, paramDynamicObjects);
        List parentOrgIds = appParam.getOrgIds();
        Long currId = (Long)parentOrgIds.remove(0);
        Map<Long, Set<String>> parentLockMap = GroupControlUtil.getParentLockMap(paramGroupControlConfig, parentOrgIds);
        Set<String> parentLockSet = GroupControlUtil.getParentLockSet(parentLockMap);
        Collections.reverse(parentOrgIds);
        ArrayList<SelectParam> newSelectParamList = new ArrayList<SelectParam>(10);
        Map<Long, Map<String, Object>> orgParams = GroupControlUtil.getOrgParamValueMap(appParam, paramDynamicObjects);
        Map dataMap = orgParams.getOrDefault(currId, new HashMap(0));
        for (String string : selectParamSet) {
            if (preSelectParamSet.contains(string)) continue;
            SelectParam selectParam = new SelectParam((Map)metaDataParam.get(string));
            selectParam.setValue(GroupControlUtil.getShowValue(selectParam.getFieldKey(), dataMap, orgParams, parentOrgIds, parentLockMap));
            selectParam.setParentOrgGcControl(parentLockSet.contains(selectParam.getFieldKey()));
            newSelectParamList.add(selectParam);
        }
        ArrayList<SelectParam> delSelectParamList = new ArrayList<SelectParam>(10);
        for (String fieldId : preSelectParamSet) {
            if (selectParamSet.contains(fieldId)) continue;
            SelectParam selectParam = new SelectParam((Map)metaDataParam.get(fieldId));
            delSelectParamList.add(selectParam);
        }
        HashMap<String, List<SelectParam>> hashMap = new HashMap<String, List<SelectParam>>(2);
        hashMap.put("new", newSelectParamList);
        hashMap.put("del", delSelectParamList);
        return hashMap;
    }

    private Set<String> getFieldSet(String selectParams) {
        LinkedHashSet<String> preSelectParamSet = new LinkedHashSet<String>(16);
        if (StringUtils.isNotBlank((CharSequence)selectParams)) {
            String[] split;
            for (String param : split = selectParams.split(",")) {
                preSelectParamSet.add(param);
            }
        }
        return preSelectParamSet;
    }

    private String getSelectFields() {
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        TreeView.TreeState state = treeView.getTreeState();
        if (CollectionUtils.isEmpty((Collection)state.getSelectedNodeId())) {
            return "";
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(SELECT_PARAM_TREE), TreeNode.class);
        List flatNodeIds = state.getSelectedNodeId();
        flatNodeIds.removeIf(id -> !root.getTreeNode(id, 16).getType().equals(ENTITYMETA));
        if (!CollectionUtils.isEmpty((Collection)flatNodeIds)) {
            return flatNodeIds.stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        return "";
    }

    public void RemoveClick(F7SelectedListRemoveEvent evt) {
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
        if (evt.getParam() != null) {
            tree.uncheckNode(evt.getParam().toString());
        } else {
            tree.uncheckNodes(tree.getTreeState().getCheckedNodeIds());
        }
    }

    public void afterCreateNewData(EventObject e) {
        String paramId = (String)this.getView().getFormShowParameter().getCustomParam("paramFormId");
        String fieldStr = (String)this.getView().getFormShowParameter().getCustomParam(SELECTEDFIELDS);
        if (fieldStr == null) {
            fieldStr = "";
        }
        String[] seleFields = fieldStr.split(",");
        TreeNode root = this.buildAllTree(paramId);
        this.cacheFieldIndex(root);
        this.putAllControl2Cache(root);
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        treeView.addNode(root);
        this.setCheckedNodes(seleFields, treeView, root);
        this.getPageCache().put(SELECT_PARAM_TREE, SerializationUtils.toJsonString((Object)root));
    }

    private String getIndexMapJson() {
        return this.getPageCache().get(CACHE_KEY_INDEX_MAP);
    }

    private void cacheFieldIndex(TreeNode root) {
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>(16);
        int index = 0;
        this.collectIndex(root, indexMap, index);
        this.getPageCache().put(CACHE_KEY_INDEX_MAP, SerializationUtils.toJsonString(indexMap));
    }

    private int collectIndex(TreeNode node, Map<String, Integer> indexMap, int index) {
        if (node == null) {
            return index;
        }
        indexMap.put(node.getId(), index);
        ++index;
        List children = node.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return index;
        }
        for (TreeNode child : children) {
            index = this.collectIndex(child, indexMap, index);
        }
        return index;
    }

    private void putAllControl2Cache(TreeNode root) {
        List fChilds;
        HashMap map = new HashMap(16);
        HashMap<String, Object> crtMap = new HashMap<String, Object>(16);
        Object v = this.getView().getFormShowParameter().getCustomParam(APP_ID);
        String appId = String.valueOf(v);
        if (null != root && !CollectionUtils.isEmpty((Collection)(fChilds = root.getChildren()))) {
            for (TreeNode fc : fChilds) {
                List sChilds;
                String fType = fc.getType();
                if (ENTITYMETA.equals(fType)) {
                    crtMap.put(fc.getId(), fc.getData());
                }
                if (CollectionUtils.isEmpty((Collection)(sChilds = fc.getChildren()))) continue;
                for (TreeNode sc : sChilds) {
                    String sType = sc.getType();
                    if (!ENTITYMETA.equals(sType)) continue;
                    crtMap.put(sc.getId(), sc.getData());
                }
            }
        }
        map.put(appId, crtMap);
        this.getPageCache().put(ALL_CTR_PER_APP, SerializationUtils.toJsonString(map));
    }

    private TreeNode buildAllTree(String paramId) {
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)paramId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)paramId, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        formMetadata.createIndex();
        List controlAps = formMetadata.getItems();
        TreeNode root = null;
        TreeNode node = null;
        ArrayList<TreeNode> flatNodes = new ArrayList<TreeNode>(10);
        for (ControlAp ap : controlAps) {
            boolean hidden;
            ContainerAp cp;
            String name;
            String fieldKey = ap.getKey();
            Field field = entityMetadata.getFieldByKey(fieldKey);
            if (field instanceof RadioField || field instanceof BasedataPropField) continue;
            String id = String.valueOf(ap.getId());
            String string = name = ap.getName() != null ? ap.getName().getLocaleValue() : "";
            if (ap instanceof FormAp) {
                root = new TreeNode();
                root.setText(name);
                root.setId(id);
                root.setType("root");
                flatNodes.add(root);
                continue;
            }
            if (ap instanceof ContainerAp && (cp = (ContainerAp)ap).getItems().isEmpty()) continue;
            boolean bl = hidden = ap.isInvisible() || ap.isHidden() || StringUtils.isBlank((CharSequence)ap.getVisible());
            if (hidden) continue;
            node = new TreeNode();
            node.setData((Object)fieldKey);
            node.setId(id);
            node.setText(name);
            node.setIsOpened(true);
            node.setParentid(ap.getParentId());
            if (ap instanceof FieldAp) {
                node.setType(ENTITYMETA);
            } else {
                node.setType(FORMMETA);
            }
            flatNodes.add(node);
        }
        if (root != null) {
            root.setIsOpened(true);
        }
        root = (TreeNode)flatNodes.remove(0);
        root.setChildren(this.buildTreeByRecur(root.getId(), flatNodes));
        this.refactorTreeByRecur(root, 1);
        this.removeEmptyNodes(root);
        return root;
    }

    private void setCheckedNodes(String[] seleFields, TreeView treeView, TreeNode root) {
        LinkedHashSet<TreeNode> checkedNodes = new LinkedHashSet<TreeNode>(16);
        if (seleFields.length > 0 && !"".equals(seleFields[0])) {
            for (String field : seleFields) {
                TreeNode node2;
                if (StringUtils.isEmpty((CharSequence)field) || (node2 = root.getTreeNode(field, 16)) == null) continue;
                checkedNodes.add(node2);
            }
        }
        F7SelectedList f7 = (F7SelectedList)this.getControl(F7SELECTEDLIST_AP);
        treeView.checkNodes(new ArrayList(checkedNodes));
        checkedNodes.removeIf(node -> !node.getType().equals(ENTITYMETA));
        List items = checkedNodes.stream().map(node -> new ValueTextItem(node.getId(), node.getText())).collect(Collectors.toList());
        f7.addItems(items);
    }

    private void removeEmptyNodes(TreeNode root) {
        if (root.getChildren() == null) {
            return;
        }
        Iterator nodes = root.getChildren().iterator();
        while (nodes.hasNext()) {
            TreeNode node = (TreeNode)nodes.next();
            if (node.getChildren() != null) {
                this.removeEmptyNodes(node);
                if (!CollectionUtils.isEmpty((Collection)node.getChildren())) continue;
                nodes.remove();
                continue;
            }
            if (!FORMMETA.equals(node.getType())) continue;
            nodes.remove();
        }
    }

    private List<TreeNode> buildTreeByRecur(String id, List<TreeNode> nodes) {
        ArrayList<TreeNode> childList = new ArrayList<TreeNode>();
        for (TreeNode node : nodes) {
            if (!StringUtils.isNotBlank((CharSequence)node.getParentid()) || !node.getParentid().equals(id)) continue;
            childList.add(node);
        }
        for (TreeNode node : childList) {
            if (!StringUtils.isNotBlank((CharSequence)node.getId())) continue;
            node.setChildren(this.buildTreeByRecur(node.getId(), nodes));
        }
        if (childList.size() == 0) {
            return null;
        }
        return childList;
    }

    private List<TreeNode> refactorTreeByRecur(TreeNode curNode, int level) {
        ArrayList<TreeNode> downToUpMoveNodes = new ArrayList<TreeNode>(16);
        List childList = curNode.getChildren();
        int curLevel = level++;
        if (CollectionUtils.isEmpty((Collection)childList)) {
            if (ENTITYMETA.equals(curNode.getType()) && curLevel > SHOW_LEVEL) {
                downToUpMoveNodes.add(curNode);
            }
            return downToUpMoveNodes;
        }
        ArrayList<TreeNode> afterMoveChild = new ArrayList<TreeNode>(16);
        for (TreeNode sub : childList) {
            if (!StringUtils.isNotBlank((CharSequence)sub.getId())) continue;
            List<TreeNode> nodeRecur = this.refactorTreeByRecur(sub, level);
            if (!CollectionUtils.isEmpty(nodeRecur)) {
                downToUpMoveNodes.addAll(nodeRecur);
            }
            if (curLevel > SHOW_LEVEL || CollectionUtils.isEmpty(downToUpMoveNodes)) continue;
            for (TreeNode n : downToUpMoveNodes) {
                n.setParentid(curNode.getId());
            }
            afterMoveChild.addAll(downToUpMoveNodes);
            downToUpMoveNodes.clear();
        }
        if (curLevel <= SHOW_LEVEL && !CollectionUtils.isEmpty(afterMoveChild)) {
            curNode.setChildren(afterMoveChild);
        }
        return downToUpMoveNodes;
    }
}

