/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IParameterModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.param.ParamPublishObject;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.SingleOrgContextHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.param.ParameterUtils;
import kd.bos.form.plugin.utils.LocalCacheUtils;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.dataentity.SingleORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParamDcBinder;
import kd.bos.param.ParameterOrgUtils;
import kd.bos.param.ParameterReader;
import kd.bos.param.ParameterWriter;
import kd.bos.parameter.ParameterShowParameter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.model.AdminType;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class ParameterConsolePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
BeforeF7SelectListener,
SearchEnterListener {
    private static final String TREEKEY = "paratree";
    private static final String HEADPANEL = "headpanel";
    private static final String SPLITCONTAINER = "splitcontainerap";
    protected static final String BtnGroupCtl = "groupcontrol";
    private static final String BTNSAVE = "save";
    private static final String FIELD_VIEWTYPE = "viewtype";
    private static final String FIELD_ACTBOOK = "acctbook";
    private static final String FIELD_ACCTINGBOOK = "acctingbook";
    private static final String SELECTED_ACCT_BOOK = "selectedAcctBook";
    private static final String SELECTED_ACCTING_BOOK = "selectedAcctingBook";
    private static final String FIELD_ORG = "orgfield";
    private static final String FIELD_ORG_LIST = "orgfieldlist";
    private static final String DEFAULTVIEWTYPE = "15";
    private static final String CACHEKEY_VIEWTYPE = "orgF7SelViewTreeType";
    private static final String HASVIEWTYPE = "hasViewType";
    private static final String DISMENSIONSETFORM = "bos_param_dimensionset";
    private static final String PUBLICPARAMETERID = "public_parameter";
    private static final String FULL_CONFIG_APP = "18XR3MJ0W0ET";
    private static final String VISIBLE = "visible";
    private static final String DEPLOYSTATUS = "deploystatus";
    private static final String TREENODECACHE = "treenodecache";
    private static final String COMMON_PARAMETERS = "_commonparameters";
    private static final String CLOUD = "CLOUD";
    private static final String CLOUD_L_CASE = "cloud";
    private static final String TABPARASETTINGS_PAGEID = "TabParaSettings_PageId";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String BOS_PARAMETER = "bos-parameter";
    private static final String CLOUDID = "cloudId";
    private static final String APPID = "appId";
    private static final String APP_U_CASE = "APP";
    private static final String APP_L_CASE = "app";
    private static final String SUCCESS = "success";
    private static final String HAS_FORM_PERM = "hasFormPerm";
    private static final String FNAME = "FNAME";
    private static final String FNUMBER = "FNUMBER";
    private static final String PARAM_FORM_ID = "paramFormId";
    private static final String PERM_ORG_IDS = "permOrgIds";
    private static Log log = LogFactory.getLog(ParameterConsolePlugin.class);

    private long getRootOrgId() {
        String rootOrgIdStr = this.getView().getPageCache().get("rootOrgId");
        if (StringUtils.isNotBlank((CharSequence)rootOrgIdStr)) {
            return Long.parseLong(rootOrgIdStr);
        }
        long rootOrgId = !this.isSuperAdminUser() ? OrgUnitServiceHelper.getRootOrgId() : this.getRealRootOrgId();
        this.getView().getPageCache().put("rootOrgId", String.valueOf(rootOrgId));
        return rootOrgId;
    }

    private long getRealRootOrgId() {
        String rootOrgIdStr = this.getView().getPageCache().get("realRootOrgId");
        if (StringUtils.isNotBlank((CharSequence)rootOrgIdStr)) {
            return Long.parseLong(rootOrgIdStr);
        }
        long rootOrgId = ParameterOrgUtils.getParamRootOrgId();
        this.getView().getPageCache().put("realRootOrgId", String.valueOf(rootOrgId));
        return rootOrgId;
    }

    private boolean isSuperAdminUser() {
        long userId = RequestContext.get().getCurrUserId();
        boolean adminUser = PermissionServiceHelper.isAdminUser((long)userId, (AdminType)AdminType.Administrator);
        boolean superAdmin = PermissionServiceHelper.isAdminUser((long)userId, (String)"10");
        return adminUser && superAdmin;
    }

    private void setSingleOrgView(boolean visible) {
        if (ParameterOrgUtils.isTreeOrg()) {
            SingleOrgContextHelper.createSystemParamSingleOrgContext((IFormView)this.getView(), (boolean)visible);
        }
    }

    private String getShowOrgKey() {
        if (ParameterOrgUtils.isTreeOrg()) {
            return FIELD_ORG;
        }
        return FIELD_ORG_LIST;
    }

    private String getHiddenOrgKey() {
        if (!ParameterOrgUtils.isTreeOrg()) {
            return FIELD_ORG;
        }
        return FIELD_ORG_LIST;
    }

    private Long getSelectedOrgId() {
        return this.getSelectedOrgId(0L);
    }

    private Long getSelectedOrgId(long defaultOrgId) {
        long orgId = defaultOrgId;
        if (ParameterOrgUtils.isTreeOrg()) {
            DynamicObject orgObj = (DynamicObject)this.getModel().getDataEntity().get(this.getShowOrgKey());
            if (orgObj == null) {
                return null;
            }
            Object masterId = orgObj.get("masterid");
            if (masterId instanceof Long) {
                orgId = (Long)masterId;
            }
        } else {
            String orgIdStr = this.getModel().getDataEntity().getString(this.getShowOrgKey());
            if (StringUtils.isNotBlank((CharSequence)orgIdStr)) {
                orgId = Long.parseLong(orgIdStr);
            }
        }
        return orgId;
    }

    private void setOrgListCombo() {
        ORM orm = ORM.create();
        String ids = this.getPageCache().get(PERM_ORG_IDS);
        List orgIds = null;
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            orgIds = SerializationUtils.fromJsonStringToList((String)ids, Long.class);
            QFilter orgFilter = new QFilter("id", "in", (Object)orgIds);
            ComboEdit orgfieldlist = (ComboEdit)this.getView().getControl(this.getShowOrgKey());
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
            if (this.isSuperAdminUser()) {
                ComboItem comboItem = new ComboItem(new LocaleString(ParameterOrgUtils.getVirtualRootOrg().getName()), String.valueOf(ParameterOrgUtils.getVirtualRootOrg().getOrgId()));
                comboItems.add(comboItem);
            }
            try (DataSet bosOrgDataSet = orm.queryDataSet("param.queryorg", "bos_org", "id,name,number", new QFilter[]{orgFilter}, "number asc");){
                while (bosOrgDataSet.hasNext()) {
                    Row next = bosOrgDataSet.next();
                    Long id = next.getLong("id");
                    String name = next.getString("name");
                    ComboItem comboItem = new ComboItem(new LocaleString(name), String.valueOf(id));
                    comboItems.add(comboItem);
                }
            }
            orgfieldlist.setComboItems(comboItems);
            this.getView().updateView(this.getShowOrgKey());
        }
    }

    public void initialize() {
        TreeView tree = (TreeView)this.getControl(TREEKEY);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{FIELD_ACTBOOK});
        this.addClickListeners(new String[]{FIELD_ACCTINGBOOK});
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        IPageCache pageCache = this.getPageCache();
        String isViewType = pageCache.get(HASVIEWTYPE);
        String viewType = pageCache.get(CACHEKEY_VIEWTYPE) == null ? DEFAULTVIEWTYPE : pageCache.get(CACHEKEY_VIEWTYPE);
        String viewTypeId = pageCache.get("viewTypeId");
        if (ParameterOrgUtils.isTreeOrg()) {
            OrgEdit edit = (OrgEdit)this.getControl(this.getShowOrgKey());
            edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            edit.setViewTypeCache(viewTypeId);
            if (StringUtils.isNotBlank((CharSequence)isViewType)) {
                if (!viewType.equals(DEFAULTVIEWTYPE)) {
                    edit.setOrgFunc(viewType);
                }
            } else {
                edit.setOrgFunc(null);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        FormShowParameter showParameter = arg0.getFormShowParameter();
        if (showParameter instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)showParameter;
            String cachedId = this.getPageCache().get(PARAM_FORM_ID);
            if (cachedId == null) {
                return;
            }
            String ids = this.getPageCache().get(PERM_ORG_IDS);
            List orgIds = null;
            if (StringUtils.isNotBlank((CharSequence)ids)) {
                orgIds = SerializationUtils.fromJsonStringToList((String)ids, Long.class);
            }
            QFilter f = new QFilter("id", "in", (Object)orgIds);
            listShowParameter.getListFilterParameter().setFilter(f);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String level = "unit";
        String visible = "all";
        String deploystatus = "all";
        IPageCache pageCache = this.getPageCache();
        pageCache.put("level", level);
        pageCache.put(VISIBLE, visible);
        pageCache.put(DEPLOYSTATUS, deploystatus);
        TreeNode root = this.buildRootNode();
        if (root != null) {
            pageCache.put(TREENODECACHE, SerializationUtils.toJsonString((Object)root));
            TreeView tree = (TreeView)this.getView().getControl(TREEKEY);
            tree.addNode(root);
            pageCache.put("isInit", "true");
            this.clickFirstCloudNode(root);
            this.setSingleOrgView(false);
        }
    }

    private void checkButtonEnable(String paramFormId) {
        Map<String, Object> consolePermResult = this.checkPermission("modify", this.getView().getFormShowParameter().getFormId());
        Map<String, Object> permResult = this.checkPermission("modify", paramFormId);
        if (Boolean.TRUE.equals(consolePermResult.get(SUCCESS)) && Boolean.TRUE.equals(permResult.get(SUCCESS))) {
            String nodeID = this.getPageCache().get("nodeId");
            if (PUBLICPARAMETERID.equals(nodeID)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{BTNSAVE});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{BTNSAVE, BtnGroupCtl});
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{BTNSAVE, BtnGroupCtl});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (source.getKey().equalsIgnoreCase(FIELD_ACTBOOK)) {
            ListShowParameter para = ShowFormHelper.createShowListForm((String)"bd_accountbookstype", (boolean)true);
            para.setMultiSelect(false);
            CloseCallBack callback = new CloseCallBack((IFormPlugin)this, FIELD_ACTBOOK);
            para.setCloseCallBack(callback);
            this.getView().showForm((FormShowParameter)para);
        } else if (source.getKey().equalsIgnoreCase(FIELD_ACCTINGBOOK)) {
            ListShowParameter para = ShowFormHelper.createShowListForm((String)"gl_accountbook", (boolean)true);
            para.setMultiSelect(false);
            CloseCallBack callback = new CloseCallBack((IFormPlugin)this, FIELD_ACCTINGBOOK);
            para.setCloseCallBack(callback);
            this.getView().showForm((FormShowParameter)para);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (FIELD_ACTBOOK.equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (rows == null || rows.isEmpty()) {
                return;
            }
            StringBuilder responser = new StringBuilder();
            for (ListSelectedRow row : rows) {
                responser.append(row.getName()).append(' ');
                this.getPageCache().put(SELECTED_ACCT_BOOK, SerializationUtils.toJsonString((Object)row));
            }
            responser = new StringBuilder(responser.toString().trim());
            this.getModel().setValue(FIELD_ACTBOOK, (Object)responser.toString());
        } else if (FIELD_ACCTINGBOOK.equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (rows == null || rows.isEmpty()) {
                return;
            }
            StringBuilder responser = new StringBuilder();
            for (ListSelectedRow row : rows) {
                responser.append(row.getNumber()).append(' ');
                this.getPageCache().put(SELECTED_ACCTING_BOOK, SerializationUtils.toJsonString((Object)row));
            }
            responser = new StringBuilder(responser.toString().trim());
            this.getModel().setValue(FIELD_ACCTINGBOOK, (Object)responser.toString());
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.treeNodeClick(evt.getNodeId().toString());
    }

    private void setViewTypeAndOrgStatus(String cloudId, String appId, boolean visible) {
        IFormView formView = this.getView();
        if (StringUtils.isBlank((CharSequence)appId)) {
            formView.setVisible(Boolean.FALSE, new String[]{HEADPANEL});
            formView.setEnable(Boolean.FALSE, new String[]{BtnGroupCtl});
        } else {
            formView.setEnable(Boolean.TRUE, new String[]{BtnGroupCtl});
            formView.setVisible(Boolean.TRUE, new String[]{FIELD_VIEWTYPE, this.getShowOrgKey(), HEADPANEL});
            formView.setVisible(Boolean.FALSE, new String[]{this.getHiddenOrgKey()});
            DynamicProperty acctbook = this.getModel().getDataEntityType().getProperty(FIELD_ACTBOOK);
            if (acctbook != null) {
                formView.setVisible(Boolean.valueOf(visible), new String[]{FIELD_ACTBOOK});
            }
        }
    }

    private void closeParameterForm() {
        String pageId = this.getPageCache().get(TABPARASETTINGS_PAGEID);
        if (pageId != null) {
            HashMap<String, String> arg = new HashMap<String, String>();
            arg.put("pageId", pageId);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", arg);
            this.getPageCache().remove(TABPARASETTINGS_PAGEID);
        }
    }

    private boolean setViewTypeData(String cloudId, String appId) {
        String viewType = DEFAULTVIEWTYPE;
        IPageCache pageCache = this.getPageCache();
        String oldViewType = pageCache.get(CACHEKEY_VIEWTYPE);
        boolean viewTypeChange = false;
        if (StringUtils.isBlank((CharSequence)cloudId) && StringUtils.isBlank((CharSequence)appId)) {
            if (pageCache.get(CACHEKEY_VIEWTYPE) != null) {
                viewType = pageCache.get(CACHEKEY_VIEWTYPE);
            }
        } else {
            QFilter qFilter;
            if (StringUtils.isNotBlank((CharSequence)cloudId) && StringUtils.isBlank((CharSequence)appId)) {
                return viewTypeChange;
            }
            ORM orm = ORM.create();
            DynamicObject bizApp = orm.queryOne(BOS_DEVPORTAL_BIZAPP, new QFilter[]{qFilter = new QFilter("id", "=", (Object)appId)});
            if (bizApp != null && StringUtils.isNotBlank((Object)bizApp.get("orgfunc"))) {
                viewType = bizApp.get("orgfunc").toString();
                pageCache.put(HASVIEWTYPE, "true");
            }
            pageCache.put(CACHEKEY_VIEWTYPE, viewType);
            viewTypeChange = !StringUtils.equals((CharSequence)oldViewType, (CharSequence)viewType);
        }
        this.setViewTypeName(viewType);
        return viewTypeChange;
    }

    private void setViewTypeName(String viewType) {
        if ("true".equals(this.getPageCache().get("isInit"))) {
            this.getModel().setValue(FIELD_VIEWTYPE, (Object)ParameterUtils.getViewTypeName(viewType));
            this.getPageCache().put("viewTypeId", viewType);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        IPageCache pageCache = this.getPageCache();
        String cachedType = pageCache.get(CACHEKEY_VIEWTYPE);
        String viewType = cachedType != null ? cachedType : DEFAULTVIEWTYPE;
        IFormView parameterView = this.getView().getViewNoPlugin(pageCache.get(TABPARASETTINGS_PAGEID));
        String itemKey = evt.getItemKey();
        if (parameterView == null && !"refresh".equals(itemKey)) {
            return;
        }
        if (BtnGroupCtl.equals(itemKey)) {
            String paramFormId = pageCache.get(PARAM_FORM_ID);
            if (paramFormId == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53c2\u6570\u5355\u3002", (String)"ParameterConsolePlugin_0", (String)BOS_PARAMETER, (Object[])new Object[0]));
                return;
            }
            if (this.getSelectedOrgId() == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"ParameterConsolePlugin_1", (String)BOS_PARAMETER, (Object[])new Object[0]));
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(DISMENSIONSETFORM);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCustomParam(PARAM_FORM_ID, (Object)paramFormId);
            parameter.setCustomParam("orgId", (Object)this.getSelectedOrgId());
            parameter.setCustomParam("viewTreeType", (Object)viewType);
            if (parameterView == null) {
                return;
            }
            IPageCache parameterPageCache = (IPageCache)parameterView.getService(IPageCache.class);
            String cache = parameterPageCache.get("gcLockFieldKey");
            if (cache != null) {
                parameter.setCustomParam("gcLockFieldKey", (Object)cache);
            }
            Map<String, String> ids = this.getCloudAndAppId();
            ParamPublishObject param = ParameterReader.getParameterObject((String)ids.get(CLOUDID), (String)ids.get(APPID));
            parameter.setCustomParam("paramId", (Object)param.getId());
            this.getView().showForm(parameter);
        } else if (BTNSAVE.equals(itemKey)) {
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            String msg = "";
            String pageId = pageCache.get(TABPARASETTINGS_PAGEID);
            if (pageId != null && parameterView != null) {
                ListSelectedRow selectedRow;
                Object acctingBookObj;
                long acctBookId;
                String appId;
                IDataModel parameterModel = (IDataModel)parameterView.getService(IDataModel.class);
                DynamicObject dataEntity = parameterModel.getDataEntity();
                Map<String, Object> permResult = this.checkPermission("modify", dataEntity.getDataEntityType().getName());
                if (Boolean.FALSE.equals(permResult.get(SUCCESS))) {
                    this.getView().showTipNotification(permResult.get("msg").toString());
                    return;
                }
                permResult = this.checkPermission("modify", this.getView().getFormShowParameter().getFormId());
                if (Boolean.FALSE.equals(permResult.get(SUCCESS))) {
                    this.getView().showTipNotification(permResult.get("msg").toString());
                    return;
                }
                ParamDcBinder binder = new ParamDcBinder(dataEntity.getDynamicObjectType());
                binder.setOnlyDbProperty(false);
                DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
                jser.setSerializeComplexProperty(false);
                OperationResult result = parameterView.invokeOperation("donothing");
                List<FieldTip> fieldKeys = this.getMustInputKey(dataEntity);
                parameterView.showFieldTips(fieldKeys);
                this.getView().sendFormAction(parameterView.getParentView());
                int errotNum = fieldKeys.size();
                if (errotNum != 0) {
                    StringBuilder describ = new StringBuilder().append(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199", (String)"ParameterConsolePlugin_13", (String)BOS_PARAMETER, (Object[])new Object[0]));
                    ArrayList<String> fiedKeyTypes = new ArrayList<String>(16);
                    for (int i = 0; i < errotNum; ++i) {
                        if (i == errotNum - 1) {
                            describ.append("\u201c%s\u201d\u3002");
                        } else {
                            describ.append("\u201c%s\u201d,");
                        }
                        String paramKey = fieldKeys.get(i).getFieldKey();
                        String paramName = ParameterConsolePlugin.matchParamName(paramKey);
                        if (paramName.equals(paramKey)) {
                            paramName = ((IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)paramKey)).getDisplayName().getLocaleValue();
                        }
                        fiedKeyTypes.add(paramName);
                    }
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)describ.toString(), (String)"Save_10", (String)BOS_PARAMETER, (Object[])new Object[0]), fiedKeyTypes.toArray()));
                    return;
                }
                if (!result.isSuccess()) {
                    List allErrorInfo;
                    List validateErrors = result.getValidateResult().getValidateErrors();
                    if (validateErrors != null && !validateErrors.isEmpty() && (allErrorInfo = ((ValidateResult)validateErrors.get(0)).getAllErrorInfo()) != null && !allErrorInfo.isEmpty()) {
                        this.getView().showTipNotification(((OperateErrorInfo)allErrorInfo.get(0)).getMessage());
                        return;
                    }
                    this.getView().showTipNotification(result.getMessage());
                    return;
                }
                String jsonString = jser.serializeToString((Object)dataEntity, null);
                Map jsonStringMap = (Map)SerializationUtils.fromJsonString((String)jsonString, Map.class);
                DataEntityPropertyCollection prop = dataEntity.getDynamicObjectType().getProperties();
                for (IDataEntityProperty p : prop) {
                    if (!(p instanceof BooleanProp) || ((BooleanProp)p).getDefValue() == null || jsonStringMap.get(p.getName()) != null) continue;
                    if (((Boolean)((BooleanProp)p).getDefValue()).booleanValue()) {
                        jsonStringMap.put(p.getName(), Boolean.TRUE);
                        continue;
                    }
                    jsonStringMap.put(p.getName(), Boolean.FALSE);
                }
                jsonString = SerializationUtils.toJsonString((Object)jsonStringMap);
                IParameterModel model = (IParameterModel)parameterModel;
                String cloudId = model.getParamCloudId();
                if (!this.enableAcctBook(cloudId, appId = model.getParamAppId())) {
                    acctBookId = 0L;
                } else {
                    ListSelectedRow selectedRow2;
                    Object acctBookObj;
                    acctBookId = model.getAcctBookId();
                    String selectAcctbook = pageCache.get(SELECTED_ACCT_BOOK);
                    if (StringUtils.isNotBlank((CharSequence)selectAcctbook) && (acctBookObj = (selectedRow2 = (ListSelectedRow)SerializationUtils.fromJsonString((String)selectAcctbook, ListSelectedRow.class)).getPrimaryKeyValue()) != null) {
                        acctBookId = (Long)acctBookObj;
                    }
                }
                long acctingBookId = model.getAcctingBookId();
                String seleAcctingBook = pageCache.get(SELECTED_ACCTING_BOOK);
                if (StringUtils.isNotBlank((CharSequence)seleAcctingBook) && (acctingBookObj = (selectedRow = (ListSelectedRow)SerializationUtils.fromJsonString((String)seleAcctingBook, ListSelectedRow.class)).getPrimaryKeyValue()) != null) {
                    acctingBookId = (Long)acctingBookObj;
                }
                AppParam appParam = new AppParam(cloudId, appId, model.getViewType(), model.getOrgId(), Long.valueOf(acctBookId), Long.valueOf(acctingBookId));
                ParameterWriter.saveSystemParameter((AppParam)appParam, (String)jsonString);
                if (null != model.getOrgId() && model.getOrgId().equals(this.getRealRootOrgId())) {
                    LocalCacheUtils.remove((String)(RequestContext.get().getAccountId() + COMMON_PARAMETERS));
                }
                msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ParameterConsolePlugin_2", (String)BOS_PARAMETER, (Object[])new Object[0]);
                this.getView().showSuccessNotification(msg);
                try {
                    Object region = jsonStringMap.get("kdsysparametermqregion");
                    Object queue = jsonStringMap.get("kdsysparametermqqueue");
                    if (region != null && queue != null) {
                        MessagePublisher mq = MQFactory.get().createSimplePublisher(region.toString(), queue.toString());
                        HashMap<String, Object> systemParameter = new HashMap<String, Object>();
                        systemParameter.put(CLOUDID, cloudId);
                        systemParameter.put(APPID, appId);
                        systemParameter.put("viewType", model.getViewType());
                        systemParameter.put("orgId", model.getOrgId());
                        systemParameter.put("acctBookId", acctBookId);
                        systemParameter.put("acctingBookId", acctingBookId);
                        systemParameter.put("data", jsonString);
                        mq.publish(systemParameter);
                        log.info("MQ\u53d1\u9001\u7cfb\u7edf\u53c2\u6570\u6d88\u606f\uff1a" + SerializationUtils.toJsonString(systemParameter));
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            } else {
                msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a\u8bf7\u68c0\u67e5\u662f\u5426\u6253\u5f00\u53c2\u6570\u8868\u5355\u6216\u68c0\u67e5\u64cd\u4f5c\u6743\u9650\u3002", (String)"ParameterConsolePlugin_3", (String)BOS_PARAMETER, (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
            }
            AppLogInfo logInfo = this.buildLogInfo(msg, RequestContext.get().getOrgId());
            logService.addLog(logInfo);
        } else if ("refresh".equals(itemKey)) {
            this.closeParameterForm();
            String nodeID = this.getPageCache().get("nodeId");
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREENODECACHE), TreeNode.class);
            TreeNode checkedNode = root.getTreeNode(nodeID, 10);
            TreeView tree = (TreeView)this.getControl(TREEKEY);
            root = this.buildRootNode();
            pageCache.put(TREENODECACHE, SerializationUtils.toJsonString((Object)root));
            pageCache.remove(SELECTED_ACCT_BOOK);
            pageCache.remove(SELECTED_ACCTING_BOOK);
            tree.deleteAllNodes();
            tree.addNode(root);
            if (checkedNode != null && root != null && root.getTreeNode(nodeID, 10) != null && !root.getId().equalsIgnoreCase(nodeID)) {
                tree.focusNode(checkedNode);
                tree.expand(checkedNode.getParentid());
                this.showView(nodeID, root, checkedNode);
            } else {
                if (root != null) {
                    this.clickFirstCloudNode(root);
                }
                this.setSingleOrgView(false);
            }
        }
    }

    private List<FieldTip> getMustInputKey(DynamicObject dataEntity) {
        IDataEntityType type = dataEntity.getDataEntityType();
        DataEntityPropertyCollection props = type.getProperties();
        ArrayList<FieldTip> keys = new ArrayList<FieldTip>();
        for (IDataEntityProperty prop : props) {
            BasedataProp basedataProp;
            if (prop instanceof BooleanProp) continue;
            if (prop instanceof FieldProp) {
                FieldProp fieldProp = (FieldProp)prop;
                if (!fieldProp.isMustInput() || !StringUtils.isBlank((Object)dataEntity.get(fieldProp.getName()))) continue;
                keys.add(new FieldTip(FieldTip.FieldTipType.Error, fieldProp.getName(), new LocaleString(ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ParameterConsolePlugin_4", (String)BOS_PARAMETER, (Object[])new Object[0])).getLocaleValue()));
                continue;
            }
            if (!(prop instanceof BasedataProp) || !(basedataProp = (BasedataProp)prop).isMustInput() || !StringUtils.isBlank((Object)dataEntity.get(basedataProp.getName()))) continue;
            keys.add(new FieldTip(FieldTip.FieldTipType.Error, basedataProp.getName(), new LocaleString(ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ParameterConsolePlugin_4", (String)BOS_PARAMETER, (Object[])new Object[0])).getLocaleValue()));
        }
        return keys;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String paramFormId = this.getPageCache().get(PARAM_FORM_ID);
        if (property instanceof OrgProp || FIELD_ORG_LIST.equals(property.getName())) {
            long orgId;
            Object newOrg = e.getChangeSet()[0].getNewValue();
            Object oldOrg = e.getChangeSet()[0].getOldValue();
            if (newOrg == null) {
                this.getModel().setValue(this.getShowOrgKey(), oldOrg);
                orgId = this.getFirstPermOrg(paramFormId);
            } else {
                DynamicObject obj;
                if (oldOrg == null) {
                    return;
                }
                if (newOrg instanceof String ? (orgId = Long.parseLong(newOrg.toString())) == Long.parseLong(oldOrg.toString()) : (newOrg instanceof Long ? (orgId = ((Long)newOrg).longValue()) == (Long)oldOrg : (orgId = (obj = (DynamicObject)newOrg).getLong(0)) == ((DynamicObject)oldOrg).getLong(0))) {
                    return;
                }
            }
            Map<String, Object> result = this.checkPermission("view", paramFormId);
            if (Boolean.FALSE.equals(result.get(SUCCESS))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BTNSAVE, BtnGroupCtl});
                this.getView().showTipNotification(result.get("msg").toString());
                this.closeParameterForm();
                return;
            }
            this.checkButtonEnable(paramFormId);
            String viewType = this.getPageCache().get(CACHEKEY_VIEWTYPE) == null ? DEFAULTVIEWTYPE : this.getPageCache().get(CACHEKEY_VIEWTYPE);
            Map<String, String> ids = this.getCloudAndAppId();
            ParameterShowParameter parameter = this.getFormShowParameter(paramFormId, orgId, 0L, 0L, viewType, ids.get(CLOUDID), ids.get(APPID));
            if (parameter != null) {
                this.getView().showForm((FormShowParameter)parameter);
                this.getPageCache().put(TABPARASETTINGS_PAGEID, parameter.getPageId());
            }
            if (this.enableAcctBook(ids.get(CLOUDID), ids.get(APPID))) {
                this.getModel().setValue(FIELD_ACTBOOK, null);
            }
            this.getModel().setValue(FIELD_ACCTINGBOOK, null);
        } else if (property instanceof TextProp && (property.getName().equals(FIELD_ACTBOOK) || property.getName().equals(FIELD_ACCTINGBOOK))) {
            Map<String, Object> result;
            Long orgId = this.getSelectedOrgId(this.getRootOrgId());
            if (orgId == null) {
                return;
            }
            Object newAcctBook = e.getChangeSet()[0].getNewValue();
            Object oldAcctBook = e.getChangeSet()[0].getOldValue();
            String pName = e.getProperty().getName();
            if (newAcctBook == null) {
                return;
            }
            String newAcctBookStr = null;
            if (newAcctBook instanceof String && (newAcctBookStr = (String)newAcctBook).equals(oldAcctBook)) {
                return;
            }
            long acctBookId = 0L;
            String selectAcctbook = this.getPageCache().get(SELECTED_ACCT_BOOK);
            if (StringUtils.isNotBlank((CharSequence)selectAcctbook)) {
                ListSelectedRow selectedRow;
                Object acctBookObj;
                if (StringUtils.isBlank((CharSequence)newAcctBookStr) && FIELD_ACTBOOK.equals(pName)) {
                    this.getPageCache().remove(SELECTED_ACCT_BOOK);
                    selectAcctbook = this.getPageCache().get(SELECTED_ACCT_BOOK);
                }
                if (null != selectAcctbook && (acctBookObj = (selectedRow = (ListSelectedRow)SerializationUtils.fromJsonString((String)selectAcctbook, ListSelectedRow.class)).getPrimaryKeyValue()) != null) {
                    acctBookId = (Long)acctBookObj;
                }
            }
            long acctingBookId = 0L;
            String seleAcctingBook = this.getPageCache().get(SELECTED_ACCTING_BOOK);
            if (StringUtils.isNotBlank((CharSequence)seleAcctingBook)) {
                ListSelectedRow selectedRow;
                Object acctingBookObj;
                if (StringUtils.isBlank((CharSequence)newAcctBookStr) && FIELD_ACCTINGBOOK.equals(pName)) {
                    this.getPageCache().remove(SELECTED_ACCTING_BOOK);
                    seleAcctingBook = this.getPageCache().get(SELECTED_ACCTING_BOOK);
                }
                if (null != seleAcctingBook && (acctingBookObj = (selectedRow = (ListSelectedRow)SerializationUtils.fromJsonString((String)seleAcctingBook, ListSelectedRow.class)).getPrimaryKeyValue()) != null) {
                    acctingBookId = (Long)acctingBookObj;
                }
            }
            if (Boolean.FALSE.equals((result = this.checkPermission("view", paramFormId)).get(SUCCESS))) {
                this.getView().showTipNotification(result.get("msg").toString());
                this.closeParameterForm();
                return;
            }
            String viewType = this.getPageCache().get(CACHEKEY_VIEWTYPE) == null ? DEFAULTVIEWTYPE : this.getPageCache().get(CACHEKEY_VIEWTYPE);
            Map<String, String> ids = this.getCloudAndAppId();
            ParameterShowParameter parameter = this.getFormShowParameter(paramFormId, orgId, acctBookId, acctingBookId, viewType, ids.get(CLOUDID), ids.get(APPID));
            if (parameter != null) {
                this.getView().showForm((FormShowParameter)parameter);
                this.getPageCache().put(TABPARASETTINGS_PAGEID, parameter.getPageId());
            }
        }
    }

    private Map<String, String> getCloudAndAppId() {
        TreeView treeView = (TreeView)this.getControl(TREEKEY);
        Map focusNode = treeView.getTreeState().getFocusNode();
        HashMap<String, String> result = new HashMap<String, String>();
        if (focusNode != null) {
            if (Boolean.TRUE.equals(focusNode.get("isParent"))) {
                result.put(CLOUDID, focusNode.get("id").toString());
                result.put(APPID, null);
            } else {
                result.put(CLOUDID, null);
                result.put(APPID, focusNode.get("id").toString());
            }
        } else {
            result.put(CLOUDID, null);
            String appnumber = (String)this.getView().getFormShowParameter().getCustomParam(APPID);
            if (StringUtils.isNotBlank((CharSequence)appnumber)) {
                AppInfo app = AppMetadataCache.getAppInfo((String)appnumber);
                result.put(APPID, app.getAppId());
            } else {
                appnumber = this.getView().getFormShowParameter().getAppId();
                AppInfo app = AppMetadataCache.getAppInfo((String)appnumber);
                result.put(APPID, app.getId());
            }
        }
        return result;
    }

    private void showParameterForm(String formId, String cloudId, String appId, boolean isViewTypeChange) {
        AppParam queryParam;
        Map abMap;
        String viewTypeId;
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        IDataModel model = this.getModel();
        long orgId = this.getFirstPermOrg(formId);
        model.beginInit();
        if (isViewTypeChange && !ParameterOrgUtils.isTreeOrg()) {
            String isInitComBo = this.getView().getPageCache().get("isInitComBo");
            if (isInitComBo == null && !this.isSuperAdminUser()) {
                String msg = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u662f\u975eadministrator\u5206\u7ec4\u7ba1\u7406\u5458\uff0c\u65e0\u6570\u636e\u4e2d\u5fc3\u7ea7\u53c2\u6570\u4fee\u6539\u6743\u9650\u3002", (String)"ParameterConsolePlugin_24", (String)BOS_PARAMETER, (Object[])new Object[0]);
                this.getView().showConfirm(msg, MessageBoxOptions.OK);
            }
            this.setOrgListCombo();
            this.getView().getPageCache().put("isInitComBo", "1");
        }
        model.setValue(this.getShowOrgKey(), (Object)orgId);
        DynamicProperty acctbook = model.getDataEntityType().getProperty(FIELD_ACTBOOK);
        Object acctBookNumber = null;
        Object acctingBookNumber = null;
        if (this.enableAcctBook(cloudId, appId) && acctbook != null) {
            viewTypeId = this.getPageCache().get("viewTypeId");
            acctBookNumber = ParameterReader.queryAcctBookId((String)cloudId, (String)appId, (String)viewTypeId, (long)orgId);
            List<String> acctBookId = this.querryAcctBookStype(acctBookNumber);
            model.setValue(FIELD_ACTBOOK, acctBookId);
        }
        if ("83bfebc8000017ac".equals(appId) && null != (abMap = ParameterReader.queryAcctBook((AppParam)(queryParam = new AppParam(cloudId, appId, viewTypeId = this.getPageCache().get("viewTypeId"), Long.valueOf(orgId), Long.valueOf(0L), Long.valueOf(0L)))))) {
            List<String> acctingBook = this.querryAcctingBooks((Long)abMap.get("FACCTINGBOOKID"));
            model.setValue(FIELD_ACCTINGBOOK, acctingBook);
        }
        model.endInit();
        this.getView().updateView(this.getShowOrgKey());
        this.getView().updateView(FIELD_ACTBOOK);
        this.getView().updateView(FIELD_ACCTINGBOOK);
        this.getPageCache().put(PARAM_FORM_ID, formId);
        Map<String, Object> result = this.checkPermission("view", formId);
        if (Boolean.FALSE.equals(result.get(SUCCESS))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BTNSAVE, BtnGroupCtl});
            this.getView().showTipNotification(result.get("msg").toString());
            return;
        }
        String viewTye = this.getPageCache().get(CACHEKEY_VIEWTYPE) == null ? DEFAULTVIEWTYPE : this.getPageCache().get(CACHEKEY_VIEWTYPE);
        long accountBookId = acctBookNumber == null ? 0L : (Long)acctBookNumber;
        long acctingBookId = acctingBookNumber == null ? 0L : (Long)acctingBookNumber;
        ParameterShowParameter showParameter = this.getFormShowParameter(formId, orgId, accountBookId, acctingBookId, viewTye, cloudId, appId);
        this.getView().showForm((FormShowParameter)showParameter);
        this.checkButtonEnable(formId);
        this.getPageCache().put(TABPARASETTINGS_PAGEID, showParameter.getPageId());
    }

    private long getFirstPermOrg(String formId) {
        HasPermOrgResult result;
        long orgId = this.getRootOrgId();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)formId);
        String appNumber = this.getView().getFormShowParameter().getAppId();
        String appid = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                appid = met.getAppId();
            }
        }
        if ((result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)formId, (String)"47150e89000000ac")) == null) {
            return orgId;
        }
        String cacheViewType = this.getPageCache().get("viewTypeId");
        String useOrgFunc = StringUtils.isBlank((CharSequence)cacheViewType) ? DEFAULTVIEWTYPE : cacheViewType;
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        List permOrgIds = orgService.getAllOrg(useOrgFunc);
        this.getPageCache().put(PERM_ORG_IDS, SerializationUtils.toJsonString((Object)permOrgIds));
        if (orgId == ParameterOrgUtils.getVirtualRootOrg().getOrgId()) {
            return orgId;
        }
        return permOrgIds.isEmpty() || permOrgIds.contains(orgId) ? orgId : (Long)permOrgIds.get(0);
    }

    private ParameterShowParameter getFormShowParameter(String formId, long orgId, long acctBookId, long acctingBookId, String viewType, String cloudId, String appId) {
        ParameterShowParameter showParameter = new ParameterShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("settingspanel");
        showParameter.setFormId(formId);
        showParameter.setCustomParam("orgid", (Object)orgId);
        showParameter.setCustomParam("acctbookid", (Object)acctBookId);
        showParameter.setCustomParam("acctingbookid", (Object)acctingBookId);
        showParameter.setCustomParam("paramcloudid", (Object)cloudId);
        showParameter.setCustomParam("paramappid", (Object)appId);
        showParameter.setCustomParam(FIELD_VIEWTYPE, (Object)(viewType == null ? DEFAULTVIEWTYPE : viewType));
        long userId = Long.parseLong(RequestContext.get().getUserId());
        if (PermissionServiceHelper.isAdminUser((long)userId, (AdminType)AdminType.Administrator)) {
            showParameter.setHasRight(true);
        }
        return showParameter;
    }

    private void queryBindParameter(TreeNode node) {
        block5: {
            HashMap nodeIds;
            block6: {
                block4: {
                    nodeIds = new HashMap();
                    node.iterate(10, n -> nodeIds.put(n.getId(), n));
                    if (!APP_U_CASE.equalsIgnoreCase(node.getType())) break block4;
                    List params = ParameterReader.getParameterObjects(null, (String)node.getId());
                    if (params == null || params.isEmpty()) break block5;
                    for (ParamPublishObject param : params) {
                        ((TreeNode)nodeIds.get(param.getAppId())).setData(Arrays.asList(param.getFormId(), param.isActBookEnable()));
                    }
                    break block5;
                }
                if (!CLOUD.equalsIgnoreCase(node.getType())) break block6;
                List params = ParameterReader.getParameterObjects((String)node.getId(), null);
                if (params == null || params.isEmpty()) break block5;
                for (ParamPublishObject param : params) {
                    ((TreeNode)nodeIds.get(param.getCloudId())).setData(Arrays.asList(param.getFormId(), param.isActBookEnable()));
                }
                break block5;
            }
            List params = ParameterReader.getParameterObjects(null, null);
            if (params != null && !params.isEmpty()) {
                for (ParamPublishObject param : params) {
                    ((TreeNode)nodeIds.get(PUBLICPARAMETERID)).setData(Arrays.asList(param.getFormId(), param.isActBookEnable()));
                }
            }
        }
    }

    private TreeNode buildRootNode() {
        TreeNode root = this.getCloudAndAppTree();
        if (root != null) {
            root.setId("/biz");
            root.setText(ResManager.loadKDString((String)"\u5206\u7c7b", (String)"ParameterConsolePlugin_5", (String)BOS_PARAMETER, (Object[])new Object[0]));
            root.setParentid("");
            root.setIsOpened(true);
            List<String> clouds = this.getExistCloudApps(true);
            List<String> apps = this.getExistCloudApps(false);
            Map bizApps = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVPORTAL_BIZAPP, (QFilter[])new QFilter[]{new QFilter("id", "in", apps).and(new QFilter(DEPLOYSTATUS, "=", (Object)"2"))});
            Iterator it = bizApps.entrySet().iterator();
            ArrayList<String> realApps = new ArrayList<String>(10);
            while (it.hasNext()) {
                DynamicObject app = (DynamicObject)it.next().getValue();
                realApps.add(app.getPkValue().toString());
            }
            this.filterCloudAndApp(root, clouds, realApps);
        }
        return root;
    }

    private void filterCloudAndApp(TreeNode root, List<String> clouds, List<String> apps) {
        if (root.getChildren() != null) {
            Iterator cloudit = root.getChildren().iterator();
            while (cloudit.hasNext()) {
                TreeNode cloud = (TreeNode)cloudit.next();
                if (cloud.getId().equalsIgnoreCase(PUBLICPARAMETERID)) continue;
                Iterator appit = cloud.getChildren().iterator();
                while (appit.hasNext()) {
                    TreeNode app = (TreeNode)appit.next();
                    if (apps.contains(app.getId())) continue;
                    appit.remove();
                }
                if (!cloud.getChildren().isEmpty() || clouds.contains(cloud.getId())) continue;
                cloudit.remove();
            }
        }
    }

    private List<String> getExistCloudApps(boolean isCloud) {
        String sql;
        DynamicObjectCollection systems;
        ArrayList<String> result = new ArrayList<String>();
        String field = "FCLOUDID";
        if (!isCloud) {
            field = "FAPPID";
        }
        if ((systems = SingleORM.query(null, (String)(sql = "select distinct " + field + " from t_bas_sysparaconsole where FENABLED ='1'"), null)) != null) {
            for (int i = 0; i < systems.size(); ++i) {
                String system = ((DynamicObject)systems.get(i)).getString(0);
                if (!StringUtils.isNotBlank((CharSequence)system)) continue;
                result.add(system);
            }
        }
        return result;
    }

    private void clickFirstCloudNode(TreeNode root) {
        TreeView tree = (TreeView)this.getView().getControl(TREEKEY);
        IFormView pView = this.getView().getParentView();
        String nodeId = null;
        if (pView != null) {
            String appId = (String)pView.getFormShowParameter().getCustomParam("appid");
            if (StringUtils.isBlank((CharSequence)appId)) {
                appId = this.getView().getFormShowParameter().getAppId();
            }
            if (StringUtils.isBlank((CharSequence)appId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u5e94\u7528\u4e2d\u6253\u5f00\u53c2\u6570\u914d\u7f6e\u3002", (String)"ParameterConsolePlugin_7", (String)BOS_PARAMETER, (Object[])new Object[0]));
                this.getView().setEnable(Boolean.FALSE, new String[]{BTNSAVE, BtnGroupCtl});
                return;
            }
            AppInfo app = AppMetadataCache.getAppInfo((String)appId);
            if (!FULL_CONFIG_APP.equalsIgnoreCase(app.getId())) {
                nodeId = app.getId();
                SplitContainer sc = (SplitContainer)this.getView().getControl(SPLITCONTAINER);
                sc.changeFlexStatus(SplitDirection.left, Boolean.TRUE.booleanValue());
                tree.treeNodeClick(root.getId(), nodeId);
            } else {
                TreeNode firstNode = (TreeNode)root.getChildren().get(0);
                tree.focusNode(firstNode);
                tree.treeNodeClick(root.getId(), firstNode.getId());
                nodeId = firstNode.getId();
            }
        }
    }

    private void getLeafNodes(Map<String, TreeNode> map, TreeNode node) {
        if (node.getChildren() != null) {
            for (TreeNode childNode : node.getChildren()) {
                this.getLeafNodes(map, childNode);
            }
        } else {
            map.put(node.getId(), node);
            return;
        }
    }

    private Map<String, Object> checkPermission(String permItem, String entityId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        long orgId = this.getSelectedOrgId();
        if (orgId == 0L) {
            orgId = this.getRootOrgId();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(SUCCESS, Boolean.TRUE);
        String orgName = "";
        if (orgId == ParameterOrgUtils.getVirtualRootOrg().getOrgId()) {
            return result;
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        orgName = org.getLocaleString("name").toString();
        if (PermissionServiceHelper.isAdminUser((long)userId)) {
            return result;
        }
        PermissionControlType permControl = EntityMetadataCache.getPermissionControlType((String)entityId);
        String curDim = permControl.getDimension();
        switch (permItem) {
            case "modify": {
                int permCheckResult = PermissionServiceHelper.checkPermission((long)userId, (String)curDim, (long)orgId, (String)this.getView().getFormShowParameter().getAppId(), (String)entityId, (String)"4715a0df000000ac");
                if (permCheckResult != 0) break;
                result.put(SUCCESS, Boolean.FALSE);
                if ("bos_publicparametertpl".equals(entityId)) {
                    result.put("msg", ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5728\u6839\u7ec4\u7ec7\u4e0b\u6ca1\u6709\u516c\u5171\u53c2\u6570\u7684\u4fee\u6539\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"ParameterConsolePlugin_12", (String)BOS_PARAMETER, (Object[])new Object[0]));
                    break;
                }
                result.put("msg", String.format(ResManager.loadKDString((String)"\u7528\u6237\u6ca1\u6709\u5f53\u524d\u7ec4\u7ec7\u7684\u53c2\u6570\u4fee\u6539\u6743\u9650\uff0c\u7ec4\u7ec7\u540d\u79f0\uff1a%s\u3002", (String)"ParameterConsolePlugin_8", (String)BOS_PARAMETER, (Object[])new Object[0]), orgName));
                break;
            }
            case "view": {
                int permCheckResult = PermissionServiceHelper.checkPermission((long)userId, (String)curDim, (long)orgId, (String)this.getView().getFormShowParameter().getAppId(), (String)entityId, (String)"47150e89000000ac");
                if (permCheckResult != 0) break;
                result.put(SUCCESS, Boolean.FALSE);
                if ("bos_publicparametertpl".equals(entityId)) {
                    result.put("msg", ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5728\u6839\u7ec4\u7ec7\u4e0b\u6ca1\u6709\u516c\u5171\u53c2\u6570\u7684\u67e5\u770b\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"ParameterConsolePlugin_11", (String)BOS_PARAMETER, (Object[])new Object[0]));
                    break;
                }
                result.put("msg", String.format(ResManager.loadKDString((String)"\u7528\u6237\u6ca1\u6709\u5f53\u524d\u7ec4\u7ec7\u7684\u53c2\u6570\u67e5\u770b\u6743\u9650\uff0c\u7ec4\u7ec7\u540d\u79f0\uff1a%s\u3002", (String)"ParameterConsolePlugin_9", (String)BOS_PARAMETER, (Object[])new Object[0]), orgName));
                break;
            }
        }
        return result;
    }

    protected AppLogInfo buildLogInfo(String msg, Long orgId) {
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        String bizApppnumber = this.getView().getFormShowParameter().getAppId();
        String bizAppid = BizAppServiceHelp.getAppIdByAppNumber((String)bizApppnumber);
        logInfo.setBizAppID(bizAppid);
        logInfo.setBizObjID(this.getView().getEntityId());
        logInfo.setOrgID(orgId);
        logInfo.setOpTime(new Date());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(BTNSAVE, "");
        logInfo.setOpDescription(msg);
        return logInfo;
    }

    private TreeNode getCloudAndAppTree() {
        TreeNode treeRoot = (TreeNode)BizAppServiceHelp.getSubsysTree(null, null, null, (String)APP_L_CASE, (boolean)true, (boolean)true, (boolean)false);
        TreeNode commonNode = new TreeNode();
        commonNode.setId(PUBLICPARAMETERID);
        commonNode.setText(ResManager.loadKDString((String)"\u516c\u5171\u53c2\u6570", (String)"ParameterConsolePlugin_6", (String)BOS_PARAMETER, (Object[])new Object[0]));
        commonNode.setParentid("/biz");
        commonNode.setIsOpened(true);
        if (treeRoot != null) {
            treeRoot.addChild(0, commonNode);
        }
        return treeRoot;
    }

    private List<String> querryAcctBookStype(Object acctBookNumber) {
        if (acctBookNumber == null) {
            return null;
        }
        String sql = "SELECT FNAME FROM T_BD_ACCOUNTBOOKSTYPE WHERE FENABLE='1' AND FID=?";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(":FID", -5, (Object)Long.parseLong(String.valueOf(acctBookNumber))));
        List resultList = (List)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]), e -> {
            ArrayList<String> returnList = new ArrayList<String>(8);
            while (e.next()) {
                returnList.add(e.getString(FNAME));
            }
            if (returnList.size() == 0) {
                return null;
            }
            return returnList;
        });
        return resultList;
    }

    private List<String> querryAcctingBooks(Long acctingBookNumber) {
        if (null == acctingBookNumber) {
            return null;
        }
        String sql = "SELECT FNUMBER FROM T_BD_ACCOUNTBOOKS WHERE FENABLE='1' AND FID=?";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(":FID", -5, (Object)acctingBookNumber));
        List acResult = (List)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]), e -> {
            ArrayList<String> nameList = new ArrayList<String>(8);
            while (e.next()) {
                nameList.add(e.getString(FNUMBER));
            }
            if (CollectionUtils.isEmpty(nameList)) {
                return null;
            }
            return nameList;
        });
        return acResult;
    }

    private static String matchParamName(String paramKey) {
        String paramName;
        switch (paramKey) {
            case "yzjurl": {
                paramName = ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u5730\u5740", (String)"ParameterConsolePlugin_15", (String)BOS_PARAMETER, (Object[])new Object[0]);
                break;
            }
            case "eid": {
                paramName = ResManager.loadKDString((String)"\u5de5\u4f5c\u5708EID", (String)"ParameterConsolePlugin_16", (String)BOS_PARAMETER, (Object[])new Object[0]);
                break;
            }
            case "readkey": {
                paramName = ResManager.loadKDString((String)"\u53ea\u8bfb\u79d8\u94a5", (String)"ParameterConsolePlugin_17", (String)BOS_PARAMETER, (Object[])new Object[0]);
                break;
            }
            case "yzjkey": {
                paramName = ResManager.loadKDString((String)"\u7cfb\u7edf\u96c6\u6210\u79d8\u94a5", (String)"ParameterConsolePlugin_18", (String)BOS_PARAMETER, (Object[])new Object[0]);
                break;
            }
            case "imservicekey": {
                paramName = ResManager.loadKDString((String)"IM\u670d\u52a1\u79d8\u94a5", (String)"ParameterConsolePlugin_19", (String)BOS_PARAMETER, (Object[])new Object[0]);
                break;
            }
            case "git_url": {
                paramName = ResManager.loadKDString((String)"\u9ed8\u8ba4git\u5730\u5740", (String)"ParameterConsolePlugin_20", (String)BOS_PARAMETER, (Object[])new Object[0]);
                break;
            }
            default: {
                paramName = paramKey;
            }
        }
        return paramName;
    }

    private boolean enableAcctBook(String cloudId, String appId) {
        ParamPublishObject publishObject = ParameterReader.getParameterObject((String)cloudId, (String)appId);
        return publishObject.isActBookEnable();
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        TreeView treeView = (TreeView)this.getControl(TREEKEY);
        String searchText = searchEnterEvent.getText();
        String searchTextFormCache = this.getPageCache().get("searchText");
        String searchTextTimeString = this.getPageCache().get("searchText_time");
        int searchTextTime = 1;
        if (StringUtils.isNotBlank((CharSequence)searchTextTimeString)) {
            searchTextTime = Integer.parseInt(searchTextTimeString);
        }
        String treeNodeFromCache = this.getPageCache().get(TREENODECACHE);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeNodeFromCache, TreeNode.class);
        List cloudNode = root.getChildren();
        ArrayList appNode = new ArrayList();
        for (TreeNode tn : cloudNode) {
            if (tn.getChildren() == null) continue;
            appNode.addAll(tn.getChildren());
        }
        ArrayList<Object> allNode = new ArrayList<Object>();
        allNode.add(root);
        allNode.addAll(cloudNode);
        allNode.addAll(appNode);
        if (searchText.equals(searchTextFormCache)) {
            String searchDataString = this.getPageCache().get("searchData");
            List listFormCache = null;
            if (searchDataString != null && !(listFormCache = SerializationUtils.fromJsonStringToList((String)searchDataString, TreeNode.class)).isEmpty()) {
                if (listFormCache.size() > searchTextTime) {
                    TreeNode treeNode = (TreeNode)listFormCache.get(searchTextTime);
                    treeView.focusNode(treeNode);
                    this.treeNodeClick(treeNode.getId());
                    treeView.expand(treeNode.getParentid());
                    this.getPageCache().put("searchText_time", String.valueOf(searchTextTime + 1));
                } else {
                    TreeNode treeNode = (TreeNode)listFormCache.get(0);
                    treeView.focusNode(treeNode);
                    this.treeNodeClick(treeNode.getId());
                    treeView.expand(treeNode.getParentid());
                    this.getPageCache().put("searchText_time", "1");
                }
            }
        } else {
            ArrayList<TreeNode> list = new ArrayList<TreeNode>();
            for (TreeNode treeNode : allNode) {
                if (!treeNode.getText().contains(searchText)) continue;
                list.add(treeNode);
            }
            if (list.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4e0e\u201c%s\u201d\u7684\u76f8\u5173\u6570\u636e\u3002", (String)"ParameterDimenSetPlugin_4", (String)BOS_PARAMETER, (Object[])new Object[0]), searchText));
            } else {
                TreeNode focusNode = (TreeNode)list.get(0);
                treeView.focusNode(focusNode);
                this.treeNodeClick(focusNode.getId());
                treeView.expand(focusNode.getParentid());
                this.getPageCache().put("searchText", searchText);
                this.getPageCache().put("searchText_time", "1");
                this.getPageCache().put("searchData", SerializationUtils.toJsonString(list));
            }
        }
    }

    private void treeNodeClick(String nodeId) {
        if ("/biz".equals(nodeId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{HEADPANEL});
        }
        this.closeParameterForm();
        this.getPageCache().put("nodeId", nodeId);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREENODECACHE), TreeNode.class);
        if (!root.getId().equalsIgnoreCase(nodeId)) {
            TreeNode checkedNode = root.getTreeNode(nodeId, 10);
            TreeView tree = (TreeView)this.getControl(TREEKEY);
            tree.focusNode(checkedNode);
            if (checkedNode == null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BTNSAVE, BtnGroupCtl});
                return;
            }
            this.showView(nodeId, root, checkedNode);
        }
    }

    private void showView(String nodeId, TreeNode root, TreeNode checkedNode) {
        List datas;
        Object nodeData = checkedNode.getData();
        if (null == nodeData || nodeData.equals(CLOUD_L_CASE) || nodeData.equals(APP_L_CASE)) {
            if (null != nodeData) {
                checkedNode.setType((String)checkedNode.getData());
                checkedNode.setData(null);
            }
            this.queryBindParameter(checkedNode);
            this.getPageCache().put(TREENODECACHE, SerializationUtils.toJsonString((Object)root));
        }
        String formId = (datas = (List)checkedNode.getData()) == null ? null : datas.get(0).toString();
        Boolean visible = datas == null ? Boolean.FALSE : (Boolean)datas.get(1);
        String cloudId = null;
        String appId = null;
        if (CLOUD.equalsIgnoreCase(checkedNode.getType())) {
            cloudId = checkedNode.getId();
        } else if (APP_U_CASE.equalsIgnoreCase(checkedNode.getType())) {
            if (!PUBLICPARAMETERID.equals(nodeId)) {
                ParamPublishObject param = ParameterReader.getParameterObject(null, (String)nodeId);
                if (null != param) {
                    String paraObjNumber = param.getFormId();
                    if (!paraObjNumber.equals(formId)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u914d\u7f6e\u53c2\u6570\u5df2\u7ecf\u5207\u6362\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u7cfb\u7edf\u53c2\u6570\u3002", (String)"ParameterConsolePlugin_14", (String)BOS_PARAMETER, (Object[])new Object[0]));
                        return;
                    }
                } else {
                    return;
                }
            }
            appId = checkedNode.getId();
        }
        boolean isViewTypeChange = this.setViewTypeData(cloudId, appId);
        this.setViewTypeAndOrgStatus(cloudId, appId, visible);
        this.showParameterForm(formId, cloudId, appId, isViewTypeChange);
        this.setSingleOrgView(visible);
    }
}

