/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param.copy;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterOrgUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class FlatOrgParamCopyFromPlugin
extends AbstractFormPlugin {
    private static final String SOURCE_ORG = "sourceorglist";
    private static final String TARGET_ORG = "targetorgmullist";

    public void afterBindData(EventObject e) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        List orgList = orgService.getAllOrg("15");
        if (orgList.isEmpty()) {
            return;
        }
        HashMap<String, String> comboMap = new HashMap<String, String>();
        comboMap.put("fp", ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7ec4\u7ec7\u540d\u79f0/\u7f16\u7801", (String)"FlatOrgAppParamConsolePlugin_1", (String)"bos-parameter", (Object[])new Object[0]));
        this.getView().updateControlMetadata(SOURCE_ORG, comboMap);
        this.getView().updateControlMetadata(TARGET_ORG, comboMap);
        this.initSourceAndTargetOrgCombo(orgList);
        if (!"true".equals(this.getView().getFormShowParameter().getCustomParam("isFromSettingForm"))) {
            long sourceOrgId = this.getModel().getDataEntity().getLong("sourceorg_id");
            if (0L == sourceOrgId) {
                sourceOrgId = ParameterOrgUtils.getParamRootOrgId();
            }
            this.getModel().setValue(SOURCE_ORG, (Object)String.valueOf(sourceOrgId));
            DynamicObjectCollection targetorg = this.getModel().getDataEntity().getDynamicObjectCollection("targetorg");
            if (targetorg.isEmpty()) {
                return;
            }
            StringBuilder builder = new StringBuilder();
            for (DynamicObject org : targetorg) {
                DynamicObject dynamicObject = org.getDynamicObject("fbasedataid");
                if (dynamicObject == null) continue;
                String orgId = dynamicObject.getPkValue().toString();
                builder.append(orgId).append(",");
            }
            this.getModel().setValue(TARGET_ORG, (Object)builder.toString());
        }
        OrgEdit orgEdit = (OrgEdit)this.getControl("sourceorg");
        orgEdit.setMustInput(false);
    }

    private void initSourceAndTargetOrgCombo(List<Long> orgList) {
        Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", orgList)}, (String)"number asc");
        ComboEdit sourceOrgComboEdit = (ComboEdit)this.getView().getControl(SOURCE_ORG);
        MulComboEdit targetOrgMulComboEdit = (MulComboEdit)this.getView().getControl(TARGET_ORG);
        ArrayList<ComboItem> orgItems = new ArrayList<ComboItem>(10);
        ArrayList<ComboItem> sourceOrgItems = new ArrayList<ComboItem>(10);
        for (Map.Entry orgEntry : orgMap.entrySet()) {
            DynamicObject org = (DynamicObject)orgEntry.getValue();
            Long id = org.getLong("id");
            String name = org.getString("name");
            String number = org.getString("number");
            ComboItem comboItem = new ComboItem(new LocaleString(number + " " + name), String.valueOf(id));
            orgItems.add(comboItem);
        }
        ComboItem virtualRootOrg = new ComboItem(new LocaleString(ParameterOrgUtils.getVirtualRootOrg().getName()), String.valueOf(ParameterOrgUtils.getVirtualRootOrg().getOrgId()));
        sourceOrgItems.add(virtualRootOrg);
        sourceOrgItems.addAll(orgItems);
        sourceOrgComboEdit.setComboItems(sourceOrgItems);
        targetOrgMulComboEdit.setComboItems(orgItems);
        sourceOrgComboEdit.setMustInput(true);
        targetOrgMulComboEdit.setMustInput(true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String value;
        IDataEntityProperty property = e.getProperty();
        if (SOURCE_ORG.equals(property.getName())) {
            value = (String)this.getModel().getValue(SOURCE_ORG);
            if (StringUtils.isBlank((CharSequence)value) || String.valueOf(ParameterOrgUtils.getVirtualRootOrg().getOrgId()).equals(value)) {
                value = "0";
            }
            long sourceOrgId = Long.parseLong(value);
            this.getModel().setValue("sourceorg", (Object)sourceOrgId);
        }
        if (TARGET_ORG.equals(property.getName())) {
            value = (String)this.getModel().getValue(TARGET_ORG);
            if (StringUtils.isBlank((CharSequence)value)) {
                this.getModel().setValue("targetorg", (Object)new Long[0]);
                return;
            }
            String[] targetOrgs = value.split(",");
            if (targetOrgs.length == 0) {
                this.getModel().setValue("targetorg", (Object)new Long[0]);
                return;
            }
            ArrayList<Long> orgList = new ArrayList<Long>(targetOrgs.length);
            for (String orgId : targetOrgs) {
                if (StringUtils.isBlank((CharSequence)orgId)) continue;
                orgList.add(Long.parseLong(orgId));
            }
            this.getModel().setValue("targetorg", (Object)orgList.toArray());
        }
    }
}

