/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param.copy;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.param.copy.AppParamInfo;
import kd.bos.form.plugin.param.copy.ParamCopyUtil;
import kd.bos.form.plugin.param.copy.ParamInfo;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterOrgUtils;
import kd.bos.param.ParameterUtils;
import kd.bos.param.impl.ParameterReaderServiceImpl;

public class ParamCopyFromPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String PROJECT_NAME = "bos-parameter";
    private static final String APPID_PARAMID_KEY = "APPID_PARAMID_KEY";
    private static final String APPID_FORMID_KEY = "APPID_FORMID_KEY";
    private static final String SCOPE_KEY = "paramscope";
    private static final String SOURCE_ORG = "sourceorg";
    private static final String COPY_APP = "copyapp";
    private static final String BT_ADD_PARAM = "addparam";
    private static final String PARAM_ENTRY = "paramdetail";
    static final String APP_PARAM_INFO_LIST_KEY = "APP_PARAM_INFO_LIST_KEY";
    private static final ParameterReaderServiceImpl readerService = new ParameterReaderServiceImpl();
    private static final Log logger = LogFactory.getLog(ParamCopyFromPlugin.class);

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BasedataEdit edit = (BasedataEdit)this.getControl(COPY_APP);
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (BT_ADD_PARAM.equals(actionId)) {
            Map returnData = (Map)event.getReturnData();
            if (returnData == null) {
                return;
            }
            String appInfosJson = (String)returnData.get(APP_PARAM_INFO_LIST_KEY);
            this.getPageCache().put(APP_PARAM_INFO_LIST_KEY, appInfosJson);
            String checkNodesJson = (String)returnData.get("CHECK_NODES_KEY");
            this.getPageCache().put("CHECK_NODES_KEY", checkNodesJson);
            Map<String, Map<String, Object>> paramDataMap = this.getParamDataMap();
            String checkFieldJson = (String)returnData.get("CHECK_FIELD_KEY");
            List paramInfoList = SerializationUtils.fromJsonStringToList((String)checkFieldJson, ParamInfo.class);
            this.getModel().deleteEntryData(PARAM_ENTRY);
            this.getModel().updateCache();
            TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
            tableValueSetter.addField("id", new Object[0]);
            tableValueSetter.addField("seq", new Object[0]);
            tableValueSetter.addField("paramname", new Object[0]);
            tableValueSetter.addField("paramvalue", new Object[0]);
            tableValueSetter.addField("paramid", new Object[0]);
            tableValueSetter.addField("paramfieldkey", new Object[0]);
            tableValueSetter.addField("paramfieldapp", new Object[0]);
            int index = 1;
            for (ParamInfo paramInfo : paramInfoList) {
                Map<String, Object> dataMap = paramDataMap.get(paramInfo.getAppId());
                String fieldKey = paramInfo.getFieldKey();
                Object paramValue = dataMap.get(fieldKey);
                paramValue = this.getLimitLengthValue(paramValue, 50);
                String name = this.getLimitLengthValue(paramInfo.getName(), 50);
                tableValueSetter.addRow(new Object[]{DB.genGlobalLongId(), index, name, paramValue, paramInfo.getId(), fieldKey, paramInfo.getAppId()});
                ++index;
            }
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(PARAM_ENTRY, tableValueSetter);
            this.getModel().updateEntryCache(((AbstractFormDataModel)this.getModel()).getEntityEntity(PARAM_ENTRY));
        }
    }

    private String getLimitLengthValue(Object value, int length) {
        if (ObjectUtils.isEmpty((Object)value)) {
            value = "";
        } else if (String.valueOf(value).length() > length) {
            value = String.valueOf(value).substring(0, length);
        }
        return String.valueOf(value);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if ("bar_save".equals(evt.getItemKey())) {
            Object scope = this.getModel().getValue(SCOPE_KEY);
            this.getModel().updateEntryCache(((AbstractFormDataModel)this.getModel()).getEntityEntity(PARAM_ENTRY));
            if ("1".equals(scope) && this.getModel().getDataEntity().getDynamicObjectCollection(PARAM_ENTRY).isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u9700\u590d\u5236\u7684\u53c2\u6570\u3002", (String)"ParamCopyFromPlugin_0", (String)PROJECT_NAME, (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object scope;
        if (args.getSource() instanceof Save && "0".equals(scope = this.getModel().getValue(SCOPE_KEY)) && !this.getModel().getDataEntity().getDynamicObjectCollection(PARAM_ENTRY).isEmpty()) {
            this.getModel().deleteEntryData(PARAM_ENTRY);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if (BT_ADD_PARAM.equals(evt.getItemKey())) {
            DynamicObjectCollection copyAppCollection = this.getModel().getDataEntity().getDynamicObjectCollection(COPY_APP);
            if (copyAppCollection.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u9700\u590d\u5236\u7684\u5e94\u7528\u3002", (String)"ParamCopyFromPlugin_1", (String)PROJECT_NAME, (Object[])new Object[0]));
                return;
            }
            long sourceOrgId = this.getSourceOrgId();
            if (0L == sourceOrgId) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u6e90\u7ec4\u7ec7\u3002", (String)"ParamCopyFromPlugin_2", (String)PROJECT_NAME, (Object[])new Object[0]));
                return;
            }
            this.showSelectParamForm(this.getAppParamInfoListJson(copyAppCollection));
        }
    }

    private long getSourceOrgId() {
        String orgId;
        long sourceOrgId = this.getModel().getDataEntity().getLong("sourceorg_id");
        if (sourceOrgId == 0L && !ParameterOrgUtils.isTreeOrg() && !StringUtils.isBlank((CharSequence)(orgId = (String)this.getModel().getValue("sourceorglist")))) {
            sourceOrgId = Long.parseLong(orgId);
        }
        return sourceOrgId;
    }

    private String getAppParamInfoListJson(DynamicObjectCollection copyAppCollection) {
        String appParamInfoListJson = this.getPageCache().get(APP_PARAM_INFO_LIST_KEY);
        Map<String, String> appParamFormIdMap = ParamCopyUtil.getAppIdParamFormIdMap(this.getView());
        if (StringUtils.isNotBlank((CharSequence)appParamInfoListJson)) {
            List appParamInfoCacheList = SerializationUtils.fromJsonStringToList((String)appParamInfoListJson, AppParamInfo.class);
            HashMap<String, AppParamInfo> appParamInfoCacheMap = new HashMap<String, AppParamInfo>(appParamInfoCacheList.size());
            for (AppParamInfo appParamInfo : appParamInfoCacheList) {
                appParamInfoCacheMap.put(appParamInfo.getAppId(), appParamInfo);
            }
            ArrayList<AppParamInfo> appParamInfos = new ArrayList<AppParamInfo>(copyAppCollection.size());
            int index = 0;
            for (DynamicObject dynamicObject : copyAppCollection) {
                DynamicObject app = dynamicObject.getDynamicObject("fbasedataid");
                if (app == null) continue;
                String appId = app.getString("id");
                AppParamInfo appParamInfo = (AppParamInfo)appParamInfoCacheMap.get(appId);
                if (appParamInfo == null) {
                    appParamInfo = this.getAppParamInfo(appParamFormIdMap, app, index);
                } else {
                    appParamInfo.setIndex(index);
                }
                appParamInfos.add(appParamInfo);
                ++index;
            }
            appParamInfoListJson = SerializationUtils.toJsonString(appParamInfos);
            this.getPageCache().put(APP_PARAM_INFO_LIST_KEY, appParamInfoListJson);
            return appParamInfoListJson;
        }
        ArrayList<AppParamInfo> appParamInfoList = new ArrayList<AppParamInfo>(copyAppCollection.size());
        int index = 0;
        for (DynamicObject dynamicObject : copyAppCollection) {
            DynamicObject app = dynamicObject.getDynamicObject("fbasedataid");
            if (app == null) continue;
            AppParamInfo appParamInfo = this.getAppParamInfo(appParamFormIdMap, app, index);
            appParamInfoList.add(appParamInfo);
            ++index;
        }
        appParamInfoListJson = SerializationUtils.toJsonString(appParamInfoList);
        this.getPageCache().put(APP_PARAM_INFO_LIST_KEY, appParamInfoListJson);
        return appParamInfoListJson;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObjectCollection paramEntry;
        IDataEntityProperty property = e.getProperty();
        if (property == null) {
            return;
        }
        if (SCOPE_KEY.equals(property.getName())) {
            ChangeData[] changeSet = e.getChangeSet();
            ChangeData changeData = changeSet[0];
            Object newValue = changeData.getNewValue();
            this.setAppMulInput(newValue);
        }
        if (SOURCE_ORG.equals(property.getName())) {
            this.getModel().updateEntryCache(((AbstractFormDataModel)this.getModel()).getEntityEntity(PARAM_ENTRY));
            paramEntry = this.getModel().getDataEntity().getDynamicObjectCollection(PARAM_ENTRY);
            if (CollectionUtils.isEmpty((Collection)paramEntry)) {
                return;
            }
            Map<String, Map<String, Object>> paramDataMap = this.getParamDataMap();
            for (Object param : paramEntry) {
                String appId = param.getString("paramfieldapp_id");
                Map<String, Object> dataMap = paramDataMap.get(appId);
                Object paramValue = dataMap.get(param.getString("paramfieldkey"));
                paramValue = this.getLimitLengthValue(paramValue, 50);
                param.set("paramvalue", paramValue);
            }
            this.getModel().updateEntryCache(((AbstractFormDataModel)this.getModel()).getEntityEntity(PARAM_ENTRY));
            this.getView().updateView(PARAM_ENTRY);
        }
        if (COPY_APP.equals(property.getName())) {
            this.getModel().updateEntryCache(((AbstractFormDataModel)this.getModel()).getEntityEntity(PARAM_ENTRY));
            paramEntry = this.getModel().getDataEntity().getDynamicObjectCollection(PARAM_ENTRY);
            if (CollectionUtils.isEmpty((Collection)paramEntry)) {
                return;
            }
            DynamicObjectCollection copyAppCollection = this.getModel().getDataEntity().getDynamicObjectCollection(COPY_APP);
            HashSet<String> appIdSet = new HashSet<String>(copyAppCollection.size());
            for (DynamicObject copyApp : copyAppCollection) {
                DynamicObject app = copyApp.getDynamicObject("fbasedataid");
                if (app == null) continue;
                appIdSet.add(app.getString("id"));
            }
            ArrayList<Integer> deleteIndexList = new ArrayList<Integer>(10);
            for (int index = 0; index < paramEntry.size(); ++index) {
                DynamicObject param = (DynamicObject)paramEntry.get(index);
                if (appIdSet.contains(param.getString("paramfieldapp_id"))) continue;
                deleteIndexList.add(index);
            }
            if (!deleteIndexList.isEmpty()) {
                int[] deleteRows = new int[deleteIndexList.size()];
                for (int i = 0; i < deleteIndexList.size(); ++i) {
                    deleteRows[i] = (Integer)deleteIndexList.get(i);
                }
                this.getModel().deleteEntryRows(PARAM_ENTRY, deleteRows);
                this.getModel().updateEntryCache(((AbstractFormDataModel)this.getModel()).getEntityEntity(PARAM_ENTRY));
            }
        }
    }

    private boolean checkShowProgress() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection targetOrgCollection = dataEntity.getDynamicObjectCollection("targetorg");
        DynamicObjectCollection copyAppCollection = dataEntity.getDynamicObjectCollection(COPY_APP);
        if (copyAppCollection.isEmpty()) {
            Map<String, String> existParamFormAppsFromCache = ParamCopyUtil.getAppIdParamIdMap(this.getView());
            return targetOrgCollection.size() * existParamFormAppsFromCache.size() >= ParamCopyFromPlugin.getLimitCount();
        }
        return targetOrgCollection.size() * copyAppCollection.size() >= ParamCopyFromPlugin.getLimitCount();
    }

    public static int getLimitCount() {
        return 100;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(operateKey)) {
            afterDoOperationEventArgs.getOperationResult().setShowMessage(false);
            if (this.checkShowProgress()) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("bos_svc_paramcopying");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
                return;
            }
            ParamCopyUtil paramCopyUtil = new ParamCopyUtil(this.getView());
            paramCopyUtil.copy();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ParamCopyFromPlugin_3", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
    }

    private Map<String, Map<String, Object>> getParamDataMap() {
        long sourceOrgId = this.getSourceOrgId();
        DynamicObjectCollection copyAppCollection = this.getModel().getDataEntity().getDynamicObjectCollection(COPY_APP);
        HashMap<String, Map<String, Object>> res = new HashMap<String, Map<String, Object>>(16);
        SimpleDateFormat shortTimeFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat longTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (DynamicObject copyApp : copyAppCollection) {
            DynamicObject app = copyApp.getDynamicObject("fbasedataid");
            if (app == null) continue;
            String viewType = app.getString("orgfunc");
            if (StringUtils.isBlank((CharSequence)viewType)) {
                viewType = "15";
            }
            String appId = app.getString("id");
            AppParam appParam = new AppParam("", appId, viewType, Long.valueOf(sourceOrgId), Long.valueOf(0L), Long.valueOf(0L));
            DynamicObject systemParameter = null;
            try {
                systemParameter = readerService.getSystemParameter(appParam);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                res.put(appId, new HashMap(0));
                continue;
            }
            Map<String, Object> dataMap = ParameterUtils.formatDynamicObjectToDataMap(shortTimeFormat, longTimeFormat, (MainEntityType)systemParameter.getDataEntityType(), systemParameter);
            res.put(appId, dataMap);
        }
        return res;
    }

    private void setAppMulInput(Object newValue) {
        if ("1".equals(newValue)) {
            ((MulBasedataEdit)this.getControl(COPY_APP)).setMustInput(true);
        } else {
            ((MulBasedataEdit)this.getControl(COPY_APP)).setMustInput(false);
        }
    }

    private AppParamInfo getAppParamInfo(Map<String, String> appIdParamFormIdMap, DynamicObject app, int index) {
        String appId = app.getString("id");
        String appName = app.getString("name");
        String formId = appIdParamFormIdMap.get(appId);
        AppParamInfo appParamInfo = new AppParamInfo(appId, appName, formId);
        appParamInfo.setIndex(index);
        TreeNode treeNode = new TreeNode("", appId, appName);
        treeNode.setType("app");
        treeNode.setChildren(new ArrayList(10));
        appParamInfo.setAppNode(treeNode);
        return appParamInfo;
    }

    private void showSelectParamForm(String appParamInfoListJson) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_paramcopy_selectparam");
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.Modal);
        showParameter.setOpenStyle(style);
        showParameter.setCustomParam(APP_PARAM_INFO_LIST_KEY, (Object)appParamInfoListJson);
        showParameter.setCustomParam("CHECK_NODES_KEY", (Object)this.getCheckNodesIdJson());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BT_ADD_PARAM));
        this.getView().showForm(showParameter);
    }

    private String getCheckNodesIdJson() {
        String checkNodeIdJson = this.getPageCache().get("CHECK_NODES_KEY");
        if (StringUtils.isBlank((CharSequence)checkNodeIdJson)) {
            checkNodeIdJson = SerializationUtils.toJsonString(new ArrayList(0));
            this.getPageCache().put("CHECK_NODES_KEY", checkNodeIdJson);
            return checkNodeIdJson;
        }
        List checkNodeIds = SerializationUtils.fromJsonStringToList((String)checkNodeIdJson, String.class);
        DynamicObjectCollection paramEntry = this.getModel().getDataEntity().getDynamicObjectCollection(PARAM_ENTRY);
        HashSet<String> paramIdSet = new HashSet<String>(paramEntry.size());
        for (DynamicObject param : paramEntry) {
            String paramid = param.getString("paramid");
            paramIdSet.add(paramid);
        }
        checkNodeIds.removeIf(nodeId -> !paramIdSet.contains(nodeId));
        checkNodeIdJson = SerializationUtils.toJsonString((Object)checkNodeIds);
        return checkNodeIdJson;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = param.getListFilterParameter().getQFilters();
        QFilter qFilter = new QFilter("id", "in", (Object)ParamCopyUtil.getAppIdParamIdMap(this.getView()).keySet().toArray());
        if (CollectionUtils.isEmpty((Collection)qFilters) || qFilters.get(0) == null) {
            qFilters.add(qFilter);
        } else {
            ((QFilter)qFilters.get(0)).and(qFilter);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ParamCopyUtil.getAppIdParamIdMap(this.getView());
        this.setAppMulInput(this.getModel().getValue(SCOPE_KEY));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String format = dateFormat.format(new Date());
        this.getModel().setValue("name", (Object)("FZ" + format));
        this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
        OrgEdit orgEdit = (OrgEdit)this.getControl(SOURCE_ORG);
        orgEdit.setMustInput(true);
    }

    static class ParamDBInfo {
        private Long orgId;
        private String id;

        public ParamDBInfo(Long orgId, String id) {
            this.orgId = orgId;
            this.id = id;
        }

        public Long getOrgId() {
            return this.orgId;
        }

        public String getId() {
            return this.id;
        }
    }
}

