/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param.copy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.param.copy.AppParamInfo;
import kd.bos.form.plugin.param.copy.ParamInfo;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.util.CollectionUtils;

public class ParamCopySelectParamPlugin
extends AbstractFormPlugin
implements TreeNodeCheckListener,
TreeNodeQueryListener,
F7SelectedListRemoveListener {
    private static final String PROJECT_NAME = "bos-parameter";
    private static final String BT_OK = "ok";
    private static final String F7SELECTEDLIST_AP = "selectedlist";
    private static final String TREE = "paramtree";
    private static final String ENTITYMETA = "entitymeta";
    private static final String FORMMETA = "formmeta";
    private static final Integer SHOW_LEVEL = 2;
    static final String CHECK_NODES_KEY = "CHECK_NODES_KEY";
    static final String NODE_INDEX_KEY = "NODE_INDEX_KEY";
    static final String CHECK_FIELD_KEY = "CHECK_FIELD_KEY";
    private static final Log logger = LogFactory.getLog(ParamCopySelectParamPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BT_OK});
        TreeView tree = (TreeView)this.getView().getControl(TREE);
        tree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        tree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        F7SelectedList f7 = (F7SelectedList)this.getView().getControl(F7SELECTEDLIST_AP);
        f7.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        f7.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (BT_OK.equals(source.getKey())) {
            String appInfoListJson = this.getPageCache().get("APP_PARAM_INFO_LIST_KEY");
            String checkNodesJson = this.getPageCache().get(CHECK_NODES_KEY);
            List checkNodeSet = SerializationUtils.fromJsonStringToList((String)checkNodesJson, String.class);
            List<AppParamInfo> appParamInfoList = this.getAppParamInfoList();
            LinkedHashMap<String, TreeNode> flatNodesMap = new LinkedHashMap<String, TreeNode>(16);
            HashMap nodeAppMap = new HashMap(16);
            for (AppParamInfo appParamInfo : appParamInfoList) {
                TreeNode appNode = appParamInfo.getAppNode();
                if (!appParamInfo.isLoaded()) continue;
                flatNodesMap.put(appNode.getId(), appNode);
                LinkedHashMap<String, TreeNode> flatMap = new LinkedHashMap<String, TreeNode>(16);
                this.getFlatNodes(appNode.getChildren(), flatMap);
                flatMap.keySet().forEach(k -> nodeAppMap.put(k, appParamInfo.getAppId()));
                flatNodesMap.putAll(flatMap);
            }
            ArrayList<ParamInfo> paramInfoList = new ArrayList<ParamInfo>(checkNodeSet.size());
            for (String checkNodeId : checkNodeSet) {
                TreeNode treeNode = (TreeNode)flatNodesMap.get(checkNodeId);
                if (!ENTITYMETA.equals(treeNode.getType())) continue;
                ParamInfo paramInfo = new ParamInfo();
                paramInfo.setId(treeNode.getId());
                paramInfo.setFieldKey(String.valueOf(treeNode.getData()));
                paramInfo.setAppId((String)nodeAppMap.get(treeNode.getId()));
                paramInfo.setName(treeNode.getText());
                paramInfoList.add(paramInfo);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>(2);
            hashMap.put("APP_PARAM_INFO_LIST_KEY", appInfoListJson);
            hashMap.put(CHECK_NODES_KEY, checkNodesJson);
            hashMap.put(CHECK_FIELD_KEY, SerializationUtils.toJsonString(paramInfoList));
            this.getView().returnDataToParent(hashMap);
            this.getView().close();
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return;
        }
        Object parentNodeId = evt.getParentNodeId();
        if (!"".equals(parentNodeId)) {
            return;
        }
        this.loadAppNodeChildren(nodeId);
    }

    private boolean loadAppNodeChildren(String nodeId) {
        List<AppParamInfo> appParamInfoList = this.getAppParamInfoList();
        AppParamInfo appParamInfo = this.getAppParamInfo(nodeId, appParamInfoList);
        if (appParamInfo == null || appParamInfo.isLoaded()) {
            return false;
        }
        this.buildAllTree(appParamInfo);
        this.getPageCache().put("APP_PARAM_INFO_LIST_KEY", SerializationUtils.toJsonString(appParamInfoList));
        return true;
    }

    private AppParamInfo getAppParamInfo(String nodeId, List<AppParamInfo> appParamInfoList) {
        AppParamInfo appParamInfo = null;
        for (AppParamInfo paramInfo : appParamInfoList) {
            if (!nodeId.equals(paramInfo.getAppId())) continue;
            appParamInfo = paramInfo;
            break;
        }
        return appParamInfo;
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        TreeView treeView = (TreeView)this.getControl(TREE);
        TreeView.TreeState state = treeView.getTreeState();
        F7SelectedList f7 = (F7SelectedList)this.getControl(F7SELECTEDLIST_AP);
        if (CollectionUtils.isEmpty((Collection)state.getSelectedNodeId())) {
            this.cacheCheckNodes(new ArrayList<Map<String, Object>>(0));
            f7.removeAllItems();
            return;
        }
        Boolean checked = evt.getChecked();
        Object parentNodeId = evt.getParentNodeId();
        String nodeId = (String)evt.getNodeId();
        boolean isLoadedApp = false;
        if (checked.booleanValue() && StringUtils.isBlank((Object)parentNodeId)) {
            isLoadedApp = this.loadAppNodeChildren(nodeId);
        }
        List<TreeNode> appNodes = this.getAppParamInfoList().stream().map(AppParamInfo::getAppNode).collect(Collectors.toList());
        HashMap<String, TreeNode> flatNodeMap = new HashMap<String, TreeNode>(16);
        this.getFlatNodes(appNodes, flatNodeMap);
        if (isLoadedApp) {
            TreeNode appNode = (TreeNode)flatNodeMap.get(nodeId);
            LinkedHashMap<String, TreeNode> appFlatNodeMap = new LinkedHashMap<String, TreeNode>(16);
            this.getFlatNodes(appNode.getChildren(), appFlatNodeMap);
            treeView.checkNodes(new ArrayList(appFlatNodeMap.values()));
        }
        List<Map<String, Object>> nodes = state.getCheckedNodes();
        Map<String, Integer> indexMap = this.getIndexMapFromCache();
        nodes = nodes.stream().sorted(Comparator.comparingInt(n -> (Integer)indexMap.get(n.get("id")))).collect(Collectors.toList());
        this.cacheCheckNodes(nodes);
        nodes.removeIf(node -> !((TreeNode)flatNodeMap.get(node.get("id"))).getType().equals(ENTITYMETA));
        List items = nodes.stream().map(node -> new ValueTextItem(node.get("id").toString(), node.get("text").toString())).collect(Collectors.toList());
        f7.addItems(items);
    }

    private void cacheCheckNodes(List<Map<String, Object>> nodes) {
        ArrayList<String> checkNodeIdList = new ArrayList<String>(10);
        for (Map<String, Object> node : nodes) {
            String id = String.valueOf(node.get("id"));
            checkNodeIdList.add(id);
        }
        this.getPageCache().put(CHECK_NODES_KEY, SerializationUtils.toJsonString(checkNodeIdList));
    }

    public void RemoveClick(F7SelectedListRemoveEvent evt) {
        TreeView tree = (TreeView)this.getView().getControl(TREE);
        if (evt.getParam() != null) {
            tree.uncheckNode(evt.getParam().toString());
        } else {
            tree.uncheckNodes(tree.getTreeState().getCheckedNodeIds());
        }
        this.cacheCheckNodes(tree.getTreeState().getCheckedNodes());
    }

    public void afterCreateNewData(EventObject e) {
        List<AppParamInfo> appParamInfoList = this.getAppParamInfoList();
        ArrayList<TreeNode> appNodes = new ArrayList<TreeNode>(appParamInfoList.size());
        LinkedHashMap<String, TreeNode> flatNodesMap = new LinkedHashMap<String, TreeNode>(16);
        for (AppParamInfo appParamInfo : appParamInfoList) {
            TreeNode appNode = appParamInfo.getAppNode();
            if (appParamInfo.isLoaded()) {
                LinkedHashMap<String, TreeNode> flatMap = new LinkedHashMap<String, TreeNode>(16);
                this.getFlatNodes(appNode.getChildren(), flatMap);
                flatNodesMap.putAll(flatMap);
                this.cacheIndexMap(appParamInfo, flatMap);
            }
            appNodes.add(appNode);
        }
        TreeView treeView = (TreeView)this.getControl(TREE);
        treeView.addNodes(appNodes);
        this.setCheckedNodes(flatNodesMap);
    }

    private void getFlatNodes(List<TreeNode> nodes, Map<String, TreeNode> flatNodeMap) {
        if (nodes == null) {
            return;
        }
        for (TreeNode node : nodes) {
            flatNodeMap.put(node.getId(), node);
            this.getFlatNodes(node.getChildren(), flatNodeMap);
        }
    }

    private List<AppParamInfo> getAppParamInfoList() {
        String cacheJson = this.getPageCache().get("APP_PARAM_INFO_LIST_KEY");
        if (StringUtils.isBlank((CharSequence)cacheJson)) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Object appParamInfoListJson = parameter.getCustomParam("APP_PARAM_INFO_LIST_KEY");
            List paramInfoList = SerializationUtils.fromJsonStringToList((String)((String)appParamInfoListJson), AppParamInfo.class);
            this.getPageCache().put("APP_PARAM_INFO_LIST_KEY", SerializationUtils.toJsonString((Object)paramInfoList));
            return paramInfoList;
        }
        List appParamInfoList = SerializationUtils.fromJsonStringToList((String)cacheJson, AppParamInfo.class);
        return appParamInfoList;
    }

    private void setCheckedNodes(Map<String, TreeNode> flatNodesMap) {
        TreeView treeView = (TreeView)this.getControl(TREE);
        String checkNodesJson = (String)this.getView().getFormShowParameter().getCustomParam(CHECK_NODES_KEY);
        if (StringUtils.isBlank((CharSequence)checkNodesJson)) {
            this.getPageCache().put(CHECK_NODES_KEY, SerializationUtils.toJsonString(new ArrayList(0)));
            return;
        }
        this.getPageCache().put(CHECK_NODES_KEY, checkNodesJson);
        List checkNodeIdList = SerializationUtils.fromJsonStringToList((String)checkNodesJson, String.class);
        LinkedHashSet<TreeNode> checkedNodes = new LinkedHashSet<TreeNode>(16);
        for (String nodeId : checkNodeIdList) {
            TreeNode node2 = flatNodesMap.get(nodeId);
            if (node2 == null) continue;
            checkedNodes.add(node2);
        }
        F7SelectedList f7 = (F7SelectedList)this.getControl(F7SELECTEDLIST_AP);
        treeView.checkNodes(new ArrayList(checkedNodes));
        checkedNodes.removeIf(node -> !node.getType().equals(ENTITYMETA));
        List items = checkedNodes.stream().map(node -> new ValueTextItem(node.getId(), node.getText())).collect(Collectors.toList());
        f7.addItems(items);
    }

    private void buildAllTree(AppParamInfo appParamInfo) {
        appParamInfo.setLoaded(true);
        FormMetadata formMetadata = null;
        EntityMetadata entityMetadata = null;
        try {
            formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)appParamInfo.getParamFormId(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
            entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)appParamInfo.getParamFormId(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        }
        catch (Exception e) {
            this.cacheNodeIndex(appParamInfo);
            logger.error((Throwable)e);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7ed1\u5b9a\u7684\u53c2\u6570\u8868\u5355%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ParamCopySelectParamPlugin_0", (String)PROJECT_NAME, (Object[])new Object[0]), appParamInfo.getParamFormId()));
            return;
        }
        formMetadata.createIndex();
        List controlAps = formMetadata.getItems();
        TreeNode root = null;
        TreeNode node = null;
        ArrayList<TreeNode> flatNodes = new ArrayList<TreeNode>(10);
        for (ControlAp ap : controlAps) {
            boolean hidden;
            ContainerAp cp;
            String fieldKey = ap.getKey();
            Field field = entityMetadata.getFieldByKey(fieldKey);
            if (field instanceof RadioField || field instanceof BasedataPropField || ap instanceof ContainerAp && (cp = (ContainerAp)ap).getItems().isEmpty()) continue;
            String id = String.valueOf(ap.getId());
            String name = ap.getName().getLocaleValue();
            if (ap instanceof FormAp) {
                root = new TreeNode();
                root.setText(name);
                root.setId(id);
                root.setType("app");
                flatNodes.add(root);
                continue;
            }
            boolean bl = hidden = ap.isInvisible() || ap.isHidden() || StringUtils.isBlank((CharSequence)ap.getVisible());
            if (hidden) continue;
            node = new TreeNode();
            node.setData((Object)fieldKey);
            node.setId(id);
            node.setText(name);
            node.setIsOpened(true);
            node.setParentid(ap.getParentId());
            if (ap instanceof FieldAp) {
                node.setType(ENTITYMETA);
            } else {
                node.setType(FORMMETA);
            }
            flatNodes.add(node);
        }
        if (root != null) {
            root.setIsOpened(true);
        }
        root = (TreeNode)flatNodes.remove(0);
        root.setChildren(this.buildTreeByRecur(root.getId(), flatNodes));
        this.refactorTreeByRecur(root, 1);
        this.removeEmptyNodes(root);
        List children = root.getChildren();
        if (!CollectionUtils.isEmpty((Collection)children)) {
            TreeNode appNode = appParamInfo.getAppNode();
            for (TreeNode child : children) {
                child.setParentid(appNode.getId());
                appNode.addChild(child);
            }
        }
        Map<String, TreeNode> flatMap = this.cacheNodeIndex(appParamInfo);
        TreeView tree = (TreeView)this.getView().getControl(TREE);
        tree.addNodes(new ArrayList<TreeNode>(flatMap.values()));
        tree.expand(appParamInfo.getAppId());
    }

    private Map<String, TreeNode> cacheNodeIndex(AppParamInfo appParamInfo) {
        List loadedNodes = appParamInfo.getAppNode().getChildren();
        LinkedHashMap<String, TreeNode> flatMap = new LinkedHashMap<String, TreeNode>(16);
        this.getFlatNodes(loadedNodes, flatMap);
        this.cacheIndexMap(appParamInfo, flatMap);
        return flatMap;
    }

    private void cacheIndexMap(AppParamInfo appParamInfo, Map<String, TreeNode> flatMap) {
        Map<String, Integer> indexMap = this.getIndexMapFromCache();
        indexMap.put(appParamInfo.getAppNode().getId(), appParamInfo.getIndex() * 10000);
        int index = 1;
        for (TreeNode value : flatMap.values()) {
            indexMap.put(value.getId(), appParamInfo.getIndex() * 10000 + index);
            ++index;
        }
        this.getPageCache().put(NODE_INDEX_KEY, SerializationUtils.toJsonString(indexMap));
    }

    private Map<String, Integer> getIndexMapFromCache() {
        Map<String, Integer> indexMap = new HashMap<String, Integer>(16);
        String nodeIndexMapJson = this.getPageCache().get(NODE_INDEX_KEY);
        if (StringUtils.isNotBlank((CharSequence)nodeIndexMapJson)) {
            indexMap = (Map)SerializationUtils.fromJsonString((String)nodeIndexMapJson, Map.class);
        }
        return indexMap;
    }

    private void removeEmptyNodes(TreeNode root) {
        if (root.getChildren() == null) {
            return;
        }
        Iterator nodes = root.getChildren().iterator();
        while (nodes.hasNext()) {
            TreeNode node = (TreeNode)nodes.next();
            if (node.getChildren() != null) {
                this.removeEmptyNodes(node);
                if (!CollectionUtils.isEmpty((Collection)node.getChildren())) continue;
                nodes.remove();
                continue;
            }
            if (!FORMMETA.equals(node.getType())) continue;
            nodes.remove();
        }
    }

    private List<TreeNode> buildTreeByRecur(String id, List<TreeNode> nodes) {
        ArrayList<TreeNode> childList = new ArrayList<TreeNode>();
        for (TreeNode node : nodes) {
            if (!StringUtils.isNotBlank((CharSequence)node.getParentid()) || !node.getParentid().equals(id)) continue;
            childList.add(node);
        }
        for (TreeNode node : childList) {
            if (!StringUtils.isNotBlank((CharSequence)node.getId())) continue;
            node.setChildren(this.buildTreeByRecur(node.getId(), nodes));
        }
        if (childList.size() == 0) {
            return null;
        }
        return childList;
    }

    private List<TreeNode> refactorTreeByRecur(TreeNode curNode, int level) {
        ArrayList<TreeNode> downToUpMoveNodes = new ArrayList<TreeNode>(16);
        List childList = curNode.getChildren();
        int curLevel = level++;
        if (CollectionUtils.isEmpty((Collection)childList)) {
            if (ENTITYMETA.equals(curNode.getType()) && curLevel > SHOW_LEVEL) {
                downToUpMoveNodes.add(curNode);
            }
            return downToUpMoveNodes;
        }
        ArrayList<TreeNode> afterMoveChild = new ArrayList<TreeNode>(16);
        for (TreeNode sub : childList) {
            if (!StringUtils.isNotBlank((CharSequence)sub.getId())) continue;
            List<TreeNode> nodeRecur = this.refactorTreeByRecur(sub, level);
            if (!CollectionUtils.isEmpty(nodeRecur)) {
                downToUpMoveNodes.addAll(nodeRecur);
            }
            if (curLevel > SHOW_LEVEL || CollectionUtils.isEmpty(downToUpMoveNodes)) continue;
            for (TreeNode n : downToUpMoveNodes) {
                n.setParentid(curNode.getId());
            }
            afterMoveChild.addAll(downToUpMoveNodes);
            downToUpMoveNodes.clear();
        }
        if (curLevel <= SHOW_LEVEL && !CollectionUtils.isEmpty(afterMoveChild)) {
            curNode.setChildren(afterMoveChild);
        }
        return downToUpMoveNodes;
    }
}

