/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param.copy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.param.AppParamConsolePlugin;
import kd.bos.form.plugin.param.copy.CopyParam;
import kd.bos.form.plugin.param.copy.ParamCopyFromPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.dataentity.SingleORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParamDcBinder;
import kd.bos.param.ParameterCache;
import kd.bos.param.ParameterOrgUtils;
import kd.bos.param.ParameterUtils;
import kd.bos.param.impl.ParameterReaderServiceImpl;
import kd.bos.product.ICoreProductSettingService;
import kd.bos.schedule.executor.ExecutorService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class ParamCopyUtil {
    private static final String PROJECT_NAME = "bos-parameter";
    private static final String APPID_PARAMID_KEY = "APPID_PARAMID_KEY";
    private static final String APPID_FORMID_KEY = "APPID_FORMID_KEY";
    private static final String ORG_BY_VIEW_TYPE_KEY = "ORG_BY_VIEW_TYPE_KEY";
    private static final String SCOPE_KEY = "paramscope";
    private static final String COPY_APP = "copyapp";
    private static final String PARAM_ENTRY = "paramdetail";
    private static final ParameterReaderServiceImpl readerService = new ParameterReaderServiceImpl();
    private static final Log logger = LogFactory.getLog(ParamCopyUtil.class);
    private IFormView formView;
    private String taskId;

    public ParamCopyUtil() {
    }

    public ParamCopyUtil(IFormView formView) {
        this.formView = formView;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public Consumer<String> getConsumer() {
        return s -> {
            if (this.formView != null && "true".equals(this.formView.getPageCache().get("isFromTest"))) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public void copy() {
        DynamicObject dataEntity = this.formView.getModel().getDataEntity();
        long sourceOrgId = ParamCopyUtil.getSourceOrgId(this.formView);
        DynamicObjectCollection targetOrgCollection = dataEntity.getDynamicObjectCollection("targetorg");
        Set<Long> targetOrgIdSet = targetOrgCollection.stream().map(target -> {
            DynamicObject org = target.getDynamicObject("fbasedataid");
            return org.getLong("id");
        }).collect(Collectors.toSet());
        String paramScope = dataEntity.getString(SCOPE_KEY);
        boolean isUpdateAll = "0".equals(paramScope);
        DynamicObjectCollection copyAppCollection = dataEntity.getDynamicObjectCollection(COPY_APP);
        HashMap<String, String> appNameMap = new HashMap<String, String>(16);
        HashMap<String, String> appViewTypeMap = new HashMap<String, String>(copyAppCollection.size());
        for (DynamicObject copyApp : copyAppCollection) {
            void var14_13;
            DynamicObject app = copyApp.getDynamicObject("fbasedataid");
            if (app == null) continue;
            String string = app.getString("orgfunc");
            if (StringUtils.isBlank((CharSequence)string)) {
                String string2 = "15";
            }
            String appId = app.getString("id");
            appViewTypeMap.put(appId, (String)var14_13);
            appNameMap.put(appId, app.getString("name"));
        }
        Map<String, String> appIdParamIdMap = ParamCopyUtil.getAppIdParamIdMap(this.formView);
        if (CollectionUtils.isEmpty(appViewTypeMap)) {
            Map appDataCollection = BusinessDataReader.loadFromCache((String)"bos_devportal_bizapp", (String)"id,orgfunc", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)appIdParamIdMap.keySet().toArray())});
            for (Map.Entry entry : appDataCollection.entrySet()) {
                String viewType = ((DynamicObject)entry.getValue()).getString("orgfunc");
                if (StringUtils.isBlank((CharSequence)viewType)) {
                    viewType = "15";
                }
                appViewTypeMap.put((String)entry.getKey(), viewType);
            }
        }
        HashMap<String, List<String>> syncParamMap = new HashMap<String, List<String>>(16);
        if (!isUpdateAll) {
            DynamicObjectCollection paramEntry = ((AbstractFormDataModel)this.formView.getModel()).getEntityEntity(PARAM_ENTRY);
            for (DynamicObject param : paramEntry) {
                String appId = param.getString("paramfieldapp_id");
                List fieldKeyList = syncParamMap.getOrDefault(appId, new ArrayList(10));
                String fieldKey = param.getString("paramfieldkey");
                fieldKeyList.add(fieldKey);
                syncParamMap.put(appId, fieldKeyList);
            }
        }
        HashMap<String, Set<String>> allOrgByViewTypeMap = new HashMap<String, Set<String>>(16);
        for (String viewType : appViewTypeMap.values()) {
            if (allOrgByViewTypeMap.containsKey(viewType)) continue;
            Set<String> orgSetByViewType = this.getOrgSetByViewType(viewType);
            allOrgByViewTypeMap.put(viewType, orgSetByViewType);
        }
        CopyParam copyParam = new CopyParam();
        copyParam.setSourceOrgId(sourceOrgId);
        copyParam.setTargetOrgIdSet(targetOrgIdSet);
        copyParam.setUpdateAll(isUpdateAll);
        copyParam.setAppNameMap(appNameMap);
        copyParam.setAppViewTypeMap(appViewTypeMap);
        copyParam.setAppIdParamIdMap(appIdParamIdMap);
        copyParam.setSyncParamMap(syncParamMap);
        copyParam.setAllOrgByViewTypeMap(allOrgByViewTypeMap);
        copyParam.setCopyBaseData(dataEntity);
        this.copy(copyParam);
    }

    public void copy(CopyParam param) {
        long sourceOrgId = param.getSourceOrgId();
        Set<Long> targetOrgIdSet = param.getTargetOrgIdSet();
        boolean isUpdateAll = param.isUpdateAll();
        Map<String, String> appNameMap = param.getAppNameMap();
        Map<String, String> appViewTypeMap = param.getAppViewTypeMap();
        Map<String, String> appIdParamIdMap = param.getAppIdParamIdMap();
        Map<String, List<String>> syncParamMap = param.getSyncParamMap();
        this.feedbackProgress(0);
        Map<String, Set<String>> allOrgByViewTypeMap = param.getAllOrgByViewTypeMap();
        ArrayList<DynamicObject> logDynamicObjectList = new ArrayList<DynamicObject>(appViewTypeMap.size());
        HashSet<String> viewTypeSet = new HashSet<String>(appViewTypeMap.values());
        viewTypeSet.addAll(appViewTypeMap.keySet());
        Map<String, String> viewTypeNameMap = this.getViewTypeNameMap(viewTypeSet);
        int targetOrgSize = targetOrgIdSet.size();
        int batchCount = targetOrgSize * appViewTypeMap.size();
        int index = 1;
        Consumer<String> consumer = this.getConsumer();
        try {
            Date start = new Date();
            for (Map.Entry<String, String> entry : appViewTypeMap.entrySet()) {
                consumer.accept("");
                int startCount = index * targetOrgSize;
                ++index;
                String appId = entry.getKey();
                String paramId = appIdParamIdMap.get(appId);
                String viewType = entry.getValue();
                DynamicObject sourceOrgValue = null;
                HashMap<String, Object> syncParamValueMap = new HashMap(16);
                HashSet<Long> targetOrgs = new HashSet<Long>(targetOrgIdSet);
                try {
                    if (!isUpdateAll && !syncParamMap.containsKey(appId)) {
                        this.addLog(logDynamicObjectList, this.genLogObj(param.getCopyBaseData(), entry.getKey(), sourceOrgId, targetOrgIdSet, "1", String.format(ResManager.loadKDString((String)"\u90e8\u5206\u53c2\u6570\u5206\u5f55\u4e0d\u5305\u542b%s\u5e94\u7528\u3002", (String)"ParamCopyUtil_4", (String)PROJECT_NAME, (Object[])new Object[0]), appNameMap.get(appId)), start));
                        start = new Date();
                        this.feedbackProgress(startCount * 100 / batchCount);
                        continue;
                    }
                    Set<Object> orgSetByViewType = new HashSet(0);
                    if (allOrgByViewTypeMap.containsKey(viewType)) {
                        orgSetByViewType = allOrgByViewTypeMap.get(viewType);
                    }
                    if (!orgSetByViewType.contains(String.valueOf(sourceOrgId)) && (ParameterOrgUtils.isTreeOrg() || sourceOrgId != ParameterOrgUtils.getParamRootOrgId())) {
                        this.addLog(logDynamicObjectList, this.genLogObj(param.getCopyBaseData(), entry.getKey(), sourceOrgId, targetOrgIdSet, "1", String.format(ResManager.loadKDString((String)"\u6e90\u7ec4\u7ec7\u5728%s\u89c6\u56fe\u4e0b\u4e0d\u5b58\u5728\u3002", (String)"ParamCopyUtil_2", (String)PROJECT_NAME, (Object[])new Object[0]), viewTypeNameMap.get(viewType)), start));
                        start = new Date();
                        this.feedbackProgress(startCount * 100 / batchCount);
                        continue;
                    }
                    sourceOrgValue = readerService.getSystemParameter(new AppParam("", appId, viewType, Long.valueOf(sourceOrgId), Long.valueOf(0L), Long.valueOf(0L)));
                    if (!isUpdateAll) {
                        syncParamValueMap = this.getSyncParamValueMap(sourceOrgValue, syncParamMap.get(appId));
                    }
                    Set<Object> finalOrgSetByViewType = orgSetByViewType;
                    HashSet<Long> unContainTargetOrgs = new HashSet<Long>(16);
                    targetOrgs.removeIf(org -> {
                        if (!finalOrgSetByViewType.contains(String.valueOf(org))) {
                            unContainTargetOrgs.add((Long)org);
                            return true;
                        }
                        return false;
                    });
                    if (!unContainTargetOrgs.isEmpty()) {
                        DynamicObject logObj = this.genLogObj(param.getCopyBaseData(), entry.getKey(), sourceOrgId, unContainTargetOrgs, "1", String.format(ResManager.loadKDString((String)"\u76ee\u6807\u7ec4\u7ec7\u5728%s\u89c6\u56fe\u4e0b\u4e0d\u5b58\u5728\u3002", (String)"ParamCopyUtil_3", (String)PROJECT_NAME, (Object[])new Object[0]), viewTypeNameMap.get(viewType)), start);
                        this.addLog(logDynamicObjectList, logObj);
                        start = new Date();
                    }
                    if (targetOrgs.isEmpty()) {
                        this.feedbackProgress(startCount * 100 / batchCount);
                        continue;
                    }
                }
                catch (KDException e) {
                    this.addLog(logDynamicObjectList, this.genLogObj(param.getCopyBaseData(), entry.getKey(), sourceOrgId, targetOrgIdSet, "1", String.format(ResManager.loadKDString((String)"\u53c2\u6570\u590d\u5236\u5f02\u5e38\uff1a%s", (String)"ParamCopyUtil_5", (String)PROJECT_NAME, (Object[])new Object[0]), e.getMessage()), start));
                    continue;
                }
                catch (Exception e) {
                    throw e;
                }
                this.batchExecute(param.getCopyBaseData(), sourceOrgId, isUpdateAll, logDynamicObjectList, viewTypeNameMap, targetOrgSize, batchCount, startCount, appId, paramId, viewType, sourceOrgValue, syncParamValueMap, targetOrgs);
                this.feedbackProgress(startCount * 100 / batchCount);
                start = new Date();
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
        finally {
            if (logDynamicObjectList.size() > 0) {
                SaveServiceHelper.saveOperate((String)"bos_svc_paramcopy_result", (DynamicObject[])logDynamicObjectList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            }
        }
        this.feedbackProgress(100);
    }

    private void addLog(List<DynamicObject> logDynamicObjectList, DynamicObject logObj) {
        logDynamicObjectList.add(logObj);
        if (logDynamicObjectList.size() >= ParamCopyUtil.getBatchNumber()) {
            OperationResult result = SaveServiceHelper.saveOperate((String)"bos_svc_paramcopy_result", (DynamicObject[])logDynamicObjectList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                logger.error("saveLog fail:" + result.getMessage());
            }
            logDynamicObjectList.clear();
            return;
        }
        DynamicObjectCollection targetorg = logObj.getDynamicObjectCollection("targetorg");
        if (targetorg != null && targetorg.size() * logDynamicObjectList.size() > 10000) {
            SaveServiceHelper.saveOperate((String)"bos_svc_paramcopy_result", (DynamicObject[])logDynamicObjectList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            logDynamicObjectList.clear();
            return;
        }
    }

    private void batchExecute(DynamicObject copyBaseData, long sourceOrgId, boolean isUpdateAll, List<DynamicObject> logDynamicObjectList, Map<String, String> viewTypeNameMap, int targetOrgSize, int batchCount, int startCount, String appId, String paramId, String viewType, DynamicObject sourceOrgValue, Map<String, Object> syncParamValueMap, Set<Long> targetOrgs) {
        DynamicObject defaultValue = ParameterUtils.serializeToDataEntity("", sourceOrgValue.getDataEntityType().getName());
        if (defaultValue == null) {
            return;
        }
        String jsonData = SerializationUtils.toJsonString(this.getJsonStringMap(sourceOrgValue));
        Date start = new Date();
        ArrayList<Long> batchOrgIds = new ArrayList<Long>(targetOrgs);
        int batchNumber = ParamCopyUtil.getBatchNumber();
        int count = (int)Math.ceil((double)batchOrgIds.size() * 1.0 / (double)batchNumber);
        CloneUtils cloneUtils = new CloneUtils(false, false);
        for (int num = 0; num < count; ++num) {
            int startIndex = num * batchNumber;
            int endIndex = startIndex + batchNumber;
            if (endIndex > batchOrgIds.size()) {
                endIndex = batchOrgIds.size();
            }
            ArrayList<Long> orgIds = new ArrayList<Long>(batchOrgIds.subList(startIndex, endIndex));
            ArrayList logOrgIds = new ArrayList(orgIds);
            AppParam appParam = new AppParam("", appId, viewType, orgIds, Long.valueOf(0L), Long.valueOf(0L));
            appParam.setParamId(paramId);
            this.feedbackProgress((startCount - targetOrgSize + endIndex) * 100 / batchCount);
            try {
                Map<Long, String> dataMap = this.getCopyDataMap(isUpdateAll, syncParamValueMap, defaultValue, jsonData, cloneUtils, orgIds, appParam);
                this.batchCopyParamFromSourceOrgToTargetOrg(appParam, dataMap);
            }
            catch (KDException e) {
                this.addLog(logDynamicObjectList, this.genLogObj(copyBaseData, appId, sourceOrgId, new HashSet<Long>(orgIds), "1", String.format(ResManager.loadKDString((String)"\u53c2\u6570\u590d\u5236\u5f02\u5e38\uff1a%s", (String)"ParamCopyUtil_5", (String)PROJECT_NAME, (Object[])new Object[0]), e.getMessage()), start));
                continue;
            }
            catch (Exception e) {
                throw e;
            }
            this.addLog(logDynamicObjectList, this.genLogObj(copyBaseData, appId, sourceOrgId, new HashSet<Long>(logOrgIds), "0", String.format(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"ParamCopyUtil_0", (String)PROJECT_NAME, (Object[])new Object[0]), viewTypeNameMap.get(viewType)), start));
            start = new Date();
        }
    }

    private Map<Long, String> getCopyDataMap(boolean isUpdateAll, Map<String, Object> syncParamValueMap, DynamicObject defaultValue, String jsonData, CloneUtils cloneUtils, List<Long> orgIds, AppParam appParam) {
        HashMap<Long, String> dataMap = new HashMap<Long, String>(orgIds.size());
        Map<Object, Object> dataMapByOrgs = new HashMap(16);
        if (!isUpdateAll) {
            dataMapByOrgs = readerService.loadBatchSystemParameterByBatchOrg(appParam);
        }
        for (Long orgId : orgIds) {
            if (isUpdateAll) {
                dataMap.put(orgId, jsonData);
                continue;
            }
            String mergeJsonData = this.getMergeJsonData(syncParamValueMap, defaultValue, (Map)dataMapByOrgs.get(orgId.toString()), cloneUtils);
            dataMap.put(orgId, mergeJsonData);
        }
        return dataMap;
    }

    public static int getBatchNumber() {
        return 200;
    }

    private Map<String, String> getViewTypeNameMap(Set<String> viewTypeSet) {
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"bos_org_biz", (String)"fnumber,fname", (QFilter[])new QFilter[]{new QFilter("fnumber", "in", (Object)viewTypeSet.toArray())});
        HashMap<String, String> res = new HashMap<String, String>(loadFromCache.size());
        for (DynamicObject dynamicObject : loadFromCache.values()) {
            res.put(dynamicObject.getString("fnumber"), dynamicObject.getString("fname"));
        }
        return res;
    }

    private DynamicObject genLogObj(DynamicObject copyBaseData, String appId, Long sourceOrg, Set<Long> targetOrg, String copyStatus, String description, Date start) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_svc_paramcopy_result");
        if (copyBaseData != null) {
            dynamicObject.set("paramcopybasedata", copyBaseData.getPkValue());
        }
        dynamicObject.set("sourceorg", (Object)sourceOrg);
        if (!targetOrg.isEmpty()) {
            MulBasedataProp property = (MulBasedataProp)dynamicObject.getDataEntityType().getProperties().get((Object)"targetorg");
            DynamicObjectType itemPropertyType = property.getDynamicCollectionItemPropertyType();
            MulBasedataDynamicObjectCollection collection = new MulBasedataDynamicObjectCollection(itemPropertyType, (Object)dynamicObject);
            for (Long targetOrgId : targetOrg) {
                DynamicObject newObj = collection.addNew();
                newObj.set("fbasedataid_id", (Object)targetOrgId);
                newObj.set("pkid", (Object)DB.genLongId((String)"t_svc_paramcopy_res_torg"));
            }
            dynamicObject.set("targetorg", (Object)collection);
        }
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set(COPY_APP, (Object)appId);
        dynamicObject.set("copystatus", (Object)copyStatus);
        if (String.valueOf(description).length() > 200) {
            dynamicObject.set("description", (Object)description.substring(0, 200));
        } else {
            dynamicObject.set("description", (Object)description);
        }
        dynamicObject.set("billstatus", (Object)"A");
        dynamicObject.set("start", (Object)start);
        dynamicObject.set("end", (Object)new Date());
        return dynamicObject;
    }

    private void feedbackProgress(int progress) {
        if (StringUtils.isBlank((CharSequence)this.taskId)) {
            return;
        }
        ExecutorService.getInstance().getObjectFactory().getTaskDao().updateProgress(this.taskId, progress, "", new HashMap(0));
    }

    private void batchCopyParamFromSourceOrgToTargetOrg(AppParam appParam, Map<Long, String> dataMap) {
        String cloudId = appParam.getCloudId();
        String appId = appParam.getAppId();
        String paramId = appParam.getParamId();
        List orgIds = appParam.getOrgIds();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FID,FORGID", new Object[0]);
        sqlBuilder.append(" FROM T_BAS_SYSPARAMETER WHERE FPARAMID=", new Object[0]);
        sqlBuilder.append("'" + paramId + "'", new Object[0]);
        sqlBuilder.append("AND FVIEWTYPEID='" + appParam.getViewType() + "' AND FACCTBOOKID='" + appParam.getActBookId() + "' AND FACCTINGBOOKID='" + appParam.getAcctingBookId() + "'", new Object[0]);
        sqlBuilder.append(" AND ", new Object[0]);
        sqlBuilder.appendIn("FORGID", orgIds.toArray());
        Map paramInfoMap = (Map)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, resultSet -> {
            HashMap<Long, ParamCopyFromPlugin.ParamDBInfo> res = new HashMap<Long, ParamCopyFromPlugin.ParamDBInfo>(10);
            while (resultSet.next()) {
                String id = resultSet.getString("FID");
                Long orgId = resultSet.getLong("FORGID");
                res.put(orgId, new ParamCopyFromPlugin.ParamDBInfo(orgId, id));
            }
            return res;
        });
        String viewType = appParam.getViewType();
        long acctBookId = appParam.getActBookId();
        long acctingBookId = appParam.getAcctingBookId();
        Set updateParamEntrySet = paramInfoMap.entrySet();
        ArrayList<Object> updateParams = new ArrayList<Object>(updateParamEntrySet.size());
        if (!updateParamEntrySet.isEmpty()) {
            for (Map.Entry entry : updateParamEntrySet) {
                Long orgId = (Long)entry.getKey();
                Object[] paramArray = new Object[2];
                ParamCopyFromPlugin.ParamDBInfo paramDBInfo = (ParamCopyFromPlugin.ParamDBInfo)paramInfoMap.get(orgId);
                paramArray[0] = new SqlParameter("FDATA", 12, (Object)dataMap.get(orgId));
                paramArray[1] = new SqlParameter("FID", 12, (Object)paramDBInfo.getId());
                updateParams.add(paramArray);
            }
        }
        Set updateOrgSet = paramInfoMap.keySet();
        orgIds.removeAll(updateOrgSet);
        HashSet insertOrgIdSet = new HashSet(orgIds);
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(insertOrgIdSet.size());
        if (!insertOrgIdSet.isEmpty()) {
            for (Long orgId : insertOrgIdSet) {
                Object[] paramArray = new Object[]{new SqlParameter("FID", 12, (Object)Uuid16.create().toString()), new SqlParameter("FPARAMID", 12, (Object)paramId), new SqlParameter("FORGID", 12, (Object)orgId), new SqlParameter("FVIEWTYPEID", 12, (Object)viewType), new SqlParameter("FACCTBOOKID", -5, (Object)acctBookId), new SqlParameter("FACCTINGBOOKID", -5, (Object)acctingBookId), new SqlParameter("FDATA", 12, (Object)dataMap.get(orgId))};
                insertParams.add(paramArray);
            }
        }
        try (TXHandle tx = TX.required();){
            try {
                if (!updateParams.isEmpty()) {
                    String updateSql = "UPDATE T_BAS_SYSPARAMETER SET FDATA = ? WHERE FID = ? ";
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)updateSql, updateParams);
                }
                if (!insertParams.isEmpty()) {
                    String insertSql = "INSERT INTO T_BAS_SYSPARAMETER (FID, FPARAMID, FORGID, FVIEWTYPEID, FACCTBOOKID, FACCTINGBOOKID, FDATA) VALUES (?, ?, ?, ?, ?, ?, ?)";
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, insertParams);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                tx.markRollback();
            }
        }
        ParameterCache.removeParameter(cloudId, appId);
        ICoreProductSettingService settingService = (ICoreProductSettingService)ServiceFactory.getService(ICoreProductSettingService.class);
        settingService.clearAllCache();
    }

    private String getMergeJsonData(Map<String, Object> syncParamMap, DynamicObject defaultValue, Map<String, Object> dataMap, CloneUtils cloneUtils) {
        DynamicObject clone = (DynamicObject)cloneUtils.clone(defaultValue.getDataEntityType(), (Object)defaultValue);
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            clone.set(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : syncParamMap.entrySet()) {
            clone.set(entry.getKey(), entry.getValue());
        }
        return SerializationUtils.toJsonString(this.getJsonStringMap(clone));
    }

    private Map<String, Object> getJsonStringMap(DynamicObject dataEntity) {
        ParamDcBinder binder = new ParamDcBinder(dataEntity.getDynamicObjectType());
        binder.setOnlyDbProperty(false);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setSerializeComplexProperty(false);
        String jsonString = jser.serializeToString((Object)dataEntity, null);
        Map jsonStringMap = (Map)SerializationUtils.fromJsonString((String)jsonString, Map.class);
        DataEntityPropertyCollection properties = dataEntity.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            if (property instanceof BooleanProp && ((BooleanProp)property).getDefValue() != null && jsonStringMap.get(property.getName()) == null) {
                if (((Boolean)((BooleanProp)property).getDefValue()).booleanValue()) {
                    jsonStringMap.put(property.getName(), Boolean.TRUE);
                } else {
                    jsonStringMap.put(property.getName(), Boolean.FALSE);
                }
            }
            if (!(property instanceof ComboProp) && !(property instanceof TextProp)) continue;
            this.setNullValue(jsonStringMap, property);
        }
        return jsonStringMap;
    }

    private void setNullValue(Map<String, Object> jsonStringMap, IDataEntityProperty p) {
        if (p instanceof FieldProp && ((FieldProp)p).getDefValue() != null && jsonStringMap.get(p.getName()) == null) {
            jsonStringMap.put(p.getName(), null);
        }
    }

    protected Map<String, Object> getSyncParamValueMap(DynamicObject currDynamicObject, List<String> paramFieldKeyList) {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)currDynamicObject.getDataEntityType().getName(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        DataEntityPropertyCollection properties = currDynamicObject.getDataEntityType().getProperties();
        HashMap<String, Object> syncParamValueMap = new HashMap<String, Object>(16);
        for (String fieldKey : paramFieldKeyList) {
            if (properties.containsKey((Object)fieldKey)) {
                Object value = currDynamicObject.get(fieldKey);
                syncParamValueMap.put(fieldKey, value);
                continue;
            }
            Field field = entityMetadata.getFieldByKey(fieldKey);
            if (!(field instanceof TimeRangeField)) continue;
            TimeRangeField timeRangeField = (TimeRangeField)field;
            String startDateFieldKey = timeRangeField.getStartDateFieldKey();
            String endDateFieldKey = timeRangeField.getEndDateFieldKey();
            if (properties.containsKey((Object)startDateFieldKey)) {
                syncParamValueMap.put(startDateFieldKey, currDynamicObject.get(startDateFieldKey));
            }
            if (!properties.containsKey((Object)endDateFieldKey)) continue;
            syncParamValueMap.put(endDateFieldKey, currDynamicObject.get(endDateFieldKey));
        }
        return syncParamValueMap;
    }

    private Set<String> getOrgSetByViewType(String viewType) {
        IPageCache pageCache = this.formView.getPageCache();
        String orgJson = pageCache.get(ORG_BY_VIEW_TYPE_KEY + viewType);
        if (StringUtils.isBlank((CharSequence)orgJson)) {
            Set<String> cacheOrgSet = this.seachOrgSetByView(viewType);
            pageCache.put(ORG_BY_VIEW_TYPE_KEY + viewType, SerializationUtils.toJsonString(cacheOrgSet));
            return cacheOrgSet;
        }
        return (Set)SerializationUtils.fromJsonString((String)orgJson, Set.class);
    }

    public Set<String> seachOrgSetByView(String viewType) {
        List allOrgByViewNumber = OrgUnitServiceHelper.getAllOrgByViewNumber((String)viewType, (boolean)false);
        HashSet orgIds = new HashSet(allOrgByViewNumber);
        HashSet<String> cacheOrgSet = new HashSet<String>(orgIds.size());
        for (Long orgId : orgIds) {
            cacheOrgSet.add(String.valueOf(orgId));
        }
        return cacheOrgSet;
    }

    static Map<String, String> getAppIdParamIdMap(IFormView formView) {
        String cacheJson = formView.getPageCache().get(APPID_PARAMID_KEY);
        if (StringUtils.isNotBlank((CharSequence)cacheJson)) {
            return (Map)SerializationUtils.fromJsonString((String)cacheJson, Map.class);
        }
        return ParamCopyUtil.cacheAppParamData(formView, true);
    }

    static Map<String, String> getAppIdParamFormIdMap(IFormView formView) {
        String cacheJson = formView.getPageCache().get(APPID_FORMID_KEY);
        if (StringUtils.isNotBlank((CharSequence)cacheJson)) {
            return (Map)SerializationUtils.fromJsonString((String)cacheJson, Map.class);
        }
        return ParamCopyUtil.cacheAppParamData(formView, false);
    }

    private static Map<String, String> cacheAppParamData(IFormView formView, boolean getAppIdParamIdMap) {
        HashMap<String, String> appIdParamIdMap = new HashMap<String, String>(16);
        HashMap<String, String> appIdFormIdMap = new HashMap<String, String>(16);
        String sql = "SELECT  DISTINCT FAPPID,FID,FFORMID FROM T_BAS_SYSPARACONSOLE  WHERE FENABLED ='1'";
        DynamicObjectCollection systems = SingleORM.query(null, (String)sql, null);
        if (systems != null) {
            for (int i = 0; i < systems.size(); ++i) {
                String appId = ((DynamicObject)systems.get(i)).getString(0);
                String paramId = ((DynamicObject)systems.get(i)).getString(1);
                String formId = ((DynamicObject)systems.get(i)).getString(2);
                if (!StringUtils.isNotBlank((CharSequence)appId) || !StringUtils.isNotBlank((CharSequence)paramId)) continue;
                appIdParamIdMap.put(appId, paramId);
                appIdFormIdMap.put(appId, formId);
            }
        }
        if (!appIdParamIdMap.isEmpty()) {
            Set<String> appIdSet = ParamCopyUtil.getAppIds();
            appIdFormIdMap.entrySet().removeIf(entry -> !appIdSet.contains(entry.getKey()));
            appIdParamIdMap.entrySet().removeIf(entry -> !appIdSet.contains(entry.getKey()));
        }
        formView.getPageCache().put(APPID_FORMID_KEY, SerializationUtils.toJsonString(appIdFormIdMap));
        formView.getPageCache().put(APPID_PARAMID_KEY, SerializationUtils.toJsonString(appIdParamIdMap));
        if (getAppIdParamIdMap) {
            return appIdParamIdMap;
        }
        return appIdFormIdMap;
    }

    private static Set<String> getAppIds() {
        TreeNode treeRoot = (TreeNode)BizAppServiceHelp.getSubsysTree(null, null, null, (String)"app", (boolean)true, (boolean)true, (boolean)true);
        List cloudNodes = treeRoot.getChildren();
        Set<String> hideAppIds = AppParamConsolePlugin.getHideAppIds();
        HashSet<String> appIdSet = new HashSet<String>(10);
        if (CollectionUtils.isEmpty((Collection)cloudNodes)) {
            return appIdSet;
        }
        for (TreeNode cloudNode : cloudNodes) {
            List appNodes = cloudNode.getChildren();
            if (CollectionUtils.isEmpty((Collection)appNodes)) continue;
            for (TreeNode appNode : appNodes) {
                String appId = appNode.getId();
                if (!StringUtils.isNotBlank((CharSequence)appId) || hideAppIds.contains(appId)) continue;
                appIdSet.add(appId);
            }
        }
        return appIdSet;
    }

    private static long getSourceOrgId(IFormView formView) {
        String orgId;
        long sourceOrgId = formView.getModel().getDataEntity().getLong("sourceorg_id");
        if (sourceOrgId == 0L && !ParameterOrgUtils.isTreeOrg() && !StringUtils.isBlank((CharSequence)(orgId = (String)formView.getModel().getValue("sourceorglist")))) {
            sourceOrgId = Long.parseLong(orgId);
        }
        return sourceOrgId;
    }
}

