/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param.copy.progress;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;

public class ParamCopyProgressFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String JOBFORMINFO = "jobFormInfo";
    private static final String CACHEKEY_TASKID = "paramCopyTaskId";
    private static final String CACHEKEY_ISSTART = "isstart";
    private static final String CACHEKEY_ISFINISHED = "isfinished";
    private boolean canClose = false;
    private static final String BOS_PARAMETER = "bos-parameter";
    private static final String PROGRESSBARAP = "progressbarap";
    private static final Log log = LogFactory.getLog(ParamCopyProgressFormPlugin.class);
    private static final String BT_BACKGROUND = "background";

    public void registerListener(EventObject e) {
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESSBARAP);
        progressbar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{BT_BACKGROUND});
    }

    public void onProgress(ProgressEvent e) {
        try {
            String taskId = this.getTaskId();
            boolean start = this.isStart();
            this.getPageCache().put(CACHEKEY_ISSTART, String.valueOf(true));
            if (!start && StringUtils.isBlank((CharSequence)taskId)) {
                this.dispatchTask();
                return;
            }
            if (start && StringUtils.isBlank((CharSequence)taskId)) {
                this.stopBar();
                this.closeForm();
                return;
            }
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (taskInfo.isTaskEnd()) {
                boolean isFinished = this.isFinished();
                this.setFinished(true);
                if (!isFinished) {
                    e.setProgress(99);
                    this.setPress(99);
                    return;
                }
                this.finish();
            } else {
                int progress = taskInfo.getProgress();
                if (progress >= 100) {
                    progress = 99;
                }
                e.setProgress(progress);
                this.setPress(progress);
            }
        }
        catch (Exception exception) {
            this.stopBar();
            IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            parentView.showErrMessage(String.format(ResManager.loadKDString((String)"\u62a5\u9519\u4fe1\u606f:%s", (String)"ParamCopyProgressFormPlugin_0", (String)BOS_PARAMETER, (Object[])new Object[0]), exception.getMessage()), "");
            log.error((Throwable)exception);
            this.getView().sendFormAction(parentView);
            this.closeForm();
        }
    }

    private void setPress(int progress) {
        Label totalLabel = (Label)this.getControl("press");
        totalLabel.setText(progress + "%");
    }

    private void finish() {
        this.stopBar();
        this.getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"ParamCopyUtil_0", (String)BOS_PARAMETER, (Object[])new Object[0]));
        this.getView().sendFormAction(this.getParentView());
        this.closeForm();
    }

    private boolean isFinished() {
        String finished = this.getPageCache().get(CACHEKEY_ISFINISHED);
        if (StringUtils.isBlank((CharSequence)finished)) {
            return false;
        }
        return Boolean.parseBoolean(finished);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (!this.isStart()) {
            e.setCancel(true);
            return;
        }
        if (this.canClose || this.isFinished()) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getTaskId())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u628a\u590d\u5236\u4efb\u52a1\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\uff1f", (String)"ParamCopyProgressFormPlugin_3", (String)BOS_PARAMETER, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CLOSE_TO_BACKGROUND", (IFormPlugin)this));
            this.stopBar();
            e.setCancel(true);
        }
    }

    private void closeForm() {
        this.canClose = true;
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        this.getView().close();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        bar.stop();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        bar.start();
        String taskId = this.getTaskId();
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            bar.setPercent(progress);
            this.setPress(progress);
        }
    }

    private String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey(CACHEKEY_TASKID)) {
            return (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_TASKID);
        }
        return this.getPageCache().get(CACHEKEY_TASKID);
    }

    private boolean isStart() {
        String start = this.getPageCache().get(CACHEKEY_ISSTART);
        return "true".equals(start);
    }

    private void dispatchTask() {
        JobFormInfo jobFormInfo = this.buildJobFormInfo();
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        if (StringUtils.isBlank((CharSequence)taskId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u540e\u53f0\u4efb\u52a1\u542f\u52a8\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"ParamCopyProgressFormPlugin_1", (String)BOS_PARAMETER, (Object[])new Object[0]));
            log.info("\u53d1\u5e03\u4efb\u52a1\u5931\u8d25\uff0c\u8c03\u7528ScheduleServiceHelper.dispatch\uff0c\u8fd4\u56de\u4e86\u7a7a\u7684\u4efb\u52a1id");
        }
        this.putTaskId(taskId);
        this.putJobFormInfo(jobFormInfo);
    }

    private void putTaskId(String taskId) {
        this.getPageCache().put(CACHEKEY_TASKID, taskId);
    }

    private JobFormInfo buildJobFormInfo() {
        JobInfo jobInfo = new JobInfo();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        jobInfo.setName(ResManager.loadKDString((String)"\u53c2\u6570\u590d\u5236", (String)"ParamCopyProgressFormPlugin_4", (String)BOS_PARAMETER, (Object[])new Object[0]));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId(this.getView().getFormShowParameter().getAppId());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dataPageId", showParameter.getParentPageId());
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId(showParameter.getParentPageId());
        jobFormInfo.setRootPageId(showParameter.getRootPageId());
        jobFormInfo.setTimeout(3600);
        jobInfo.setTaskClassname("kd.bos.form.plugin.param.copy.progress.ParamCopyTask");
        jobFormInfo.setClickClassName("kd.bos.form.plugin.param.copy.progress.ParamCopyTaskClick");
        return jobFormInfo;
    }

    private void setFinished(boolean finished) {
        this.getPageCache().put(CACHEKEY_ISFINISHED, String.valueOf(finished));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        super.confirmCallBack(messageboxclosedevent);
        if ("CLOSE_TO_BACKGROUND".equals(messageboxclosedevent.getCallBackId())) {
            if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
                this.toBackground();
                return;
            }
            this.continueBar();
        }
    }

    private void continueBar() {
        ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
        bar.start();
    }

    private void toBackground() {
        this.closeForm();
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (!TaskClientProxy.isExistTask((String)taskId)) {
            JobFormInfo jobFormInfo = this.getJobFormInfo();
            TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
            BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
            ThreadPools.executeOnce((String)"task-background-monitor", (Runnable)subscriber);
        }
    }

    private void putJobFormInfo(JobFormInfo jobFormInfo) {
        if (jobFormInfo == null) {
            this.getPageCache().remove(JOBFORMINFO);
        } else {
            String str = SerializationUtils.toJsonString((Object)jobFormInfo);
            this.getPageCache().put(JOBFORMINFO, str);
        }
    }

    private JobFormInfo getJobFormInfo() {
        String str = null;
        str = this.getView().getFormShowParameter().getCustomParams().containsKey(JOBFORMINFO) ? (String)this.getView().getFormShowParameter().getCustomParam(JOBFORMINFO) : this.getPageCache().get(JOBFORMINFO);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
    }

    private IFormView getParentView() {
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        return this.getView().getViewNoPlugin(parentPageId);
    }
}

