/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.parameter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.ParameterHelper;
import kd.bos.data.impl.ParameterHelperServiceImpl;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ParameterEntityType;
import kd.bos.entity.datamodel.IParameterModel;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.param.ParamConvert;
import kd.bos.entity.param.ParamPublishObject;
import kd.bos.exception.KDException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IClientViewProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.param.ParameterReader;
import kd.bos.param.constant.UserParaType;
import kd.bos.param.impl.ParameterReaderServiceImpl;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class ParameterModel
extends FormDataModel
implements IParameterModel {
    private static final Log logger = LogFactory.getLog(ParameterModel.class);
    private long orgId;
    private String viewType;
    private long acctBookId;
    private long acctingBookId;
    private String paramCloudId;
    private String paramAppId;
    private String bindFormId;
    private long bindBillTypeId;
    private String extend;
    private List<String> lockFields;
    private List<String> groupControlFields;

    public ParameterModel(String entityNumber, String pageId, Map<Class<?>, Object> services) {
        super(entityNumber, pageId, services);
    }

    public ParameterModel(String entityNumber, String pageId, Map<Class<?>, Object> services, String bindFormId) {
        this(entityNumber, pageId, services);
        this.bindFormId = bindFormId;
    }

    public DynamicObject newDataEntity() {
        if (this.getDataEntityType() == MainEntityType.Empty) {
            return super.newDataEntity();
        }
        ParameterEntityType mainEntityType = (ParameterEntityType)this.getDataEntityType();
        long userId = RequestContext.get().getCurrUserId();
        switch (mainEntityType.getParameterType()) {
            case "public": {
                this.dataEntity = new ParameterReaderServiceImpl().getPublicParameter(mainEntityType.getName());
                break;
            }
            case "cloud": 
            case "application": {
                if (this.paramAppId == null) break;
                List orgIds = ParameterHelper.getSuperiorOrgIds((long)this.getOrgId(), (String)this.getViewType());
                ParamPublishObject param = ParameterReader.getParameterObject(null, (String)this.paramAppId);
                List gcFields = SystemParamServiceHelper.getGroupControlFields((String)param.getFormId());
                AppParam appParam = new AppParam(null, null, this.getViewType(), orgIds, this.getAcctBookId(), this.getAcctingBookId());
                appParam.setParamId(param.getId());
                appParam.setFormId(param.getFormId());
                appParam.setGcFields(gcFields);
                List<Map<String, Object>> orgParams = new ParameterHelperServiceImpl().getParamFromDBBySortOrg(appParam);
                if (orgIds.size() > 1) {
                    this.setGroupControlFields(gcFields);
                }
                if (orgParams.isEmpty()) break;
                List paramItems = ParamConvert.getParamItems((String)param.getFormId());
                Map rows = new HashMap(0);
                try {
                    rows = ParamConvert.getParamRows(orgParams, (List)paramItems);
                }
                catch (KDException e) {
                    logger.error((Throwable)e);
                    HashMap<String, Object> msgMap = new HashMap<String, Object>();
                    msgMap.put("content", e.getMessage());
                    msgMap.put("type", 1);
                    IClientViewProxy service = (IClientViewProxy)this.getService(IClientViewProxy.class);
                    service.addAction("ShowNotificationMsg", msgMap);
                }
                ArrayList reverOrgIds = new ArrayList(orgIds);
                Collections.reverse(reverOrgIds);
                List lockFields = ParameterHelper.getLockedParameterPlus(rows, (List)paramItems, reverOrgIds);
                this.setLockFields(lockFields);
                this.dataEntity = ParameterHelper.getParameterEntityPlusOrder((MainEntityType)this.getDataEntityType(), (long)this.getOrgId(), rows, (List)paramItems, reverOrgIds);
                break;
            }
            case "bill": {
                DynamicObject billParameter = ParameterReader.getBillParameter((String)this.getBindFormId());
                this.dataEntity = this.getCloneDataEntity(billParameter);
                break;
            }
            case "billtype": {
                DynamicObject billTypeParameter = ParameterReader.getBillTypeParameter((String)this.getBindFormId(), (String)this.getDataEntityType().getName(), (long)this.getBindBillTypeId());
                this.dataEntity = this.getCloneDataEntity(billTypeParameter);
                break;
            }
            case "option": {
                this.dataEntity = ParameterReader.getUserOptionParameter((Long)userId, (String)this.getBindFormId(), (String)this.getExtend());
                break;
            }
            case "listoption": {
                if (!StringUtils.isNotBlank((CharSequence)this.getBindFormId())) break;
                FormConfig listConfig = FormMetadataCache.getListFormConfig((String)this.getBindFormId());
                this.dataEntity = ParameterReader.getListOptionParameter((long)userId, (String)this.getBindFormId(), (String)listConfig.getListUserOption(), (String)this.getExtend());
                break;
            }
            case "gridoption": {
                String formId = this.getMainEntityType().getName();
                this.dataEntity = ParameterReader.getUserOptionParameter((Long)userId, (String)this.getBindFormId(), (String)formId, (UserParaType)UserParaType.GRID, (String)this.getExtend());
            }
        }
        if (this.dataEntity == null) {
            this.dataEntity = super.newDataEntity();
            super.createDefaultEntity();
        }
        return this.dataEntity;
    }

    private DynamicObject getCloneDataEntity(DynamicObject billParameter) {
        try {
            return (DynamicObject)new CloneUtils(false, false).clone(billParameter.getDataEntityType(), (Object)billParameter);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return billParameter;
        }
    }

    protected DynamicObject createDefaultEntity() {
        return this.dataEntity;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Long getAcctBookId() {
        return this.acctBookId;
    }

    public void setAcctBookId(Long acctBookId) {
        this.acctBookId = acctBookId;
    }

    public Long getAcctingBookId() {
        return this.acctingBookId;
    }

    public void setAcctingBookId(Long acctingBookId) {
        this.acctingBookId = acctingBookId;
    }

    public String getBindFormId() {
        return this.bindFormId;
    }

    public void setBindFormId(String bindFormId) {
        this.bindFormId = bindFormId;
    }

    public Long getBindBillTypeId() {
        return this.bindBillTypeId;
    }

    public void setBindBillTypeId(Long bindBillTypeId) {
        this.bindBillTypeId = bindBillTypeId;
    }

    public String getExtend() {
        return this.extend;
    }

    public void setExtend(String extend) {
        this.extend = extend;
    }

    public String getViewType() {
        return this.viewType;
    }

    public void setViewType(String viewType) {
        this.viewType = viewType;
    }

    public List<String> getLockFields() {
        return this.lockFields;
    }

    public void setLockFields(List<String> lockFields) {
        this.lockFields = lockFields;
    }

    public List<String> getGroupControlFields() {
        return this.groupControlFields;
    }

    public void setGroupControlFields(List<String> groupControlFields) {
        this.groupControlFields = groupControlFields;
    }

    public String getParamCloudId() {
        return this.paramCloudId;
    }

    public void setCloudId(String paramCloudId) {
        this.paramCloudId = paramCloudId;
    }

    public void setParamAppId(String paramAppId) {
        this.paramAppId = paramAppId;
    }

    public String getParamAppId() {
        return this.paramAppId;
    }
}

