/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.param;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.param.ParamPublishObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterLocalCache;
import kd.bos.param.ParameterLog;
import kd.bos.param.ParameterType;
import kd.bos.param.constant.UserParaType;

public class ParameterCache {
    private static final String TWO_STR_PLACEHOLDER = "%s.%s";
    private static final String THREE_STR_PLACEHOLER = "%s,%s,%s";
    private static final int BATCH_CACHE_TIME_OUT = 3600;
    private static final int INITIAL_COLLECTION_SIZE = 16;
    private static final String BS_PARAMETER_REGION = "PARAMETER";
    private static final String BILL_PARAM = "BILL_PARAMETER";
    private static final String BILL_PARAM_OBJ = "BILL_PARAM_OBJ";
    private static final String BILL_PARAM_VER = "BILL_PARAM_VER";
    private static final String LIST_PARAM = "LIST_PARAMETER";
    private static final String CUST_PARAM = "CUST_PARAMETER";
    private static final String SYSTEM_PARAM = "SYSTEM_PARAMETER";
    private static final String SP_PUBLISH_OBJECT = "SP_PUBLISH_OBJECT";
    private static final String BILLTYPE_PARAM = "BILLTYPE_PARAMETER";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("PARAMETER", new DistributeCacheHAPolicy(true, true));
    private static final Log logger = LogFactory.getLog(ParameterCache.class);

    private static String getRootCacheKey() {
        return ParameterCache.getRootCacheKey("bos_publicparametertpl");
    }

    private static String getRootCacheKey(String publicParamFormId) {
        String prefix = String.format(TWO_STR_PLACEHOLDER, CacheKeyUtil.getAcctId(), SYSTEM_PARAM);
        String cacheKey = ParameterCache.genCacheKey(prefix, publicParamFormId);
        return cacheKey;
    }

    private static String getBillParamRootCacheKey() {
        return String.format(TWO_STR_PLACEHOLDER, CacheKeyUtil.getAcctId(), BILL_PARAM);
    }

    private static String getBillParamObjRootCacheKey() {
        return String.format(TWO_STR_PLACEHOLDER, CacheKeyUtil.getAcctId(), BILL_PARAM_OBJ);
    }

    private static String getBillParamVerRootCacheKey() {
        return String.format(TWO_STR_PLACEHOLDER, CacheKeyUtil.getAcctId(), BILL_PARAM_VER);
    }

    private static String getListParamRootCacheKey() {
        return String.format(TWO_STR_PLACEHOLDER, CacheKeyUtil.getAcctId(), LIST_PARAM);
    }

    private static String getUserParamRootCacheKey(UserParaType userParaType, Long userId) {
        return String.format("%s.%s.%s", CacheKeyUtil.getAcctId(), "UserParaType" + userParaType.getValue(), userId);
    }

    private static String getCustParamRootCacheKey() {
        return String.format(TWO_STR_PLACEHOLDER, CacheKeyUtil.getAcctId(), CUST_PARAM);
    }

    private static String getPORootCacheKey() {
        return String.format(TWO_STR_PLACEHOLDER, CacheKeyUtil.getAcctId(), SP_PUBLISH_OBJECT);
    }

    private static String getBillTypeParamRootCacheKey() {
        return String.format(TWO_STR_PLACEHOLDER, CacheKeyUtil.getAcctId(), BILLTYPE_PARAM);
    }

    private static Map getAppParameterByType(String type) {
        Map cacheAll = cache.getAll(type);
        HashMap sessionCache = new HashMap(cacheAll.size());
        for (Map.Entry entry : cacheAll.entrySet()) {
            String value = (String)entry.getValue();
            if (StringUtils.isBlank((CharSequence)value)) continue;
            sessionCache.put(entry.getKey(), SerializationUtils.fromJsonString((String)value, Map.class));
        }
        return sessionCache;
    }

    private static String getFromCache(String type, String key) {
        Object map = ThreadCache.get((Object)type);
        if (map instanceof Map) {
            Map treadCacheMap = (Map)map;
            String value = (String)treadCacheMap.get(key);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                return value;
            }
            value = (String)cache.get(type, key);
            treadCacheMap.put(key, value);
            return value;
        }
        HashMap<String, String> treadCacheMap = new HashMap<String, String>(1);
        String value = (String)cache.get(type, key);
        treadCacheMap.put(key, value);
        ThreadCache.put((Object)type, treadCacheMap);
        return value;
    }

    private static void putToCache(String type, String key, String data) {
        Object map = ThreadCache.get((Object)type);
        if (map instanceof Map) {
            Map treadCacheMap = (Map)map;
            treadCacheMap.put(key, data);
        } else {
            HashMap<String, String> treadCacheMap = new HashMap<String, String>(1);
            treadCacheMap.put(key, data);
            ThreadCache.put((Object)type, treadCacheMap);
        }
        cache.put(type, key, (Object)data);
    }

    private static void removeCache(String type, String key) {
        Object map = ThreadCache.get((Object)type);
        if (map instanceof Map) {
            ((Map)map).remove(key);
        }
        cache.remove(type, key);
        ParameterLog.info("ParameterCache.removeCache ->type\uff1a" + type + ", Key\uff1a" + key);
    }

    private static void removeCache(String type) {
        ThreadCache.remove((Object)type);
        cache.removeType(type);
    }

    public static String loadBillParamVer(String key) {
        return ParameterCache.getFromCache(ParameterCache.getBillParamVerRootCacheKey(), key);
    }

    public static void putBillParamVer(String key, String version) {
        ParameterCache.putToCache(ParameterCache.getBillParamVerRootCacheKey(), key, version);
    }

    public static String loadBillParamObj(String key) {
        return ParameterCache.getFromCache(ParameterCache.getBillParamObjRootCacheKey(), key);
    }

    public static void putBillParamObj(String key, String data) {
        if (data == null) {
            return;
        }
        ParameterCache.putToCache(ParameterCache.getBillParamObjRootCacheKey(), key, data);
    }

    public static String loadBillParamFromCache(String key) {
        return ParameterCache.getFromCache(ParameterCache.getBillParamRootCacheKey(), key);
    }

    public static String loadListParamFromCache(String key, Long userId, String option) {
        return ParameterCache.getFromCache(ParameterCache.getListParamRootCacheKey() + userId, key + option);
    }

    public static void putBillParamToCache(String key, String data) {
        if (data == null) {
            return;
        }
        ParameterCache.putToCache(ParameterCache.getBillParamRootCacheKey(), key, data);
    }

    public static void putListParamToCache(String key, Long userId, String option, String data) {
        if (data == null) {
            return;
        }
        ParameterCache.putToCache(ParameterCache.getListParamRootCacheKey() + userId, key + option, data);
    }

    public static void removeBillParamCache(String key) {
        ParameterCache.removeCache(ParameterCache.getBillParamVerRootCacheKey(), key);
        ParameterCache.removeCache(ParameterCache.getBillParamObjRootCacheKey(), key);
        ParameterCache.removeCache(ParameterCache.getBillParamRootCacheKey(), key);
    }

    public static void removeListParamCache(String key, Long userId, String option) {
        ParameterCache.removeCache(ParameterCache.getListParamRootCacheKey() + userId, key + option);
    }

    public static String getUserParamFromCache(String bizFormId, Long userId, UserParaType paramType, String userParamFormId) {
        return ParameterCache.getFromCache(ParameterCache.getUserParamRootCacheKey(paramType, userId), bizFormId + userParamFormId);
    }

    public static void putUserParamToCache(String bizFormId, Long userId, UserParaType paramType, String userParamFormId, String data) {
        ParameterCache.putToCache(ParameterCache.getUserParamRootCacheKey(paramType, userId), bizFormId + userParamFormId, data);
    }

    public static void removeUserParamCache(String bizFormId, Long userId, UserParaType paramType, String userParamFormId) {
        ParameterCache.removeCache(ParameterCache.getUserParamRootCacheKey(paramType, userId), bizFormId + userParamFormId);
    }

    public static String getCustParamFromCache(Long userId, String formId, String paramKey) {
        String type = ParameterCache.getCustParamRootCacheKey();
        String cacheKey = String.format(THREE_STR_PLACEHOLER, userId, formId, paramKey);
        return ParameterCache.getFromCache(type, cacheKey);
    }

    public static void putCustParamToCache(Long userId, String formId, String paramKey, String paramValue) {
        String type = ParameterCache.getCustParamRootCacheKey();
        String cacheKey = String.format(THREE_STR_PLACEHOLER, userId, formId, paramKey);
        ParameterCache.putToCache(type, cacheKey, paramValue == null ? "" : paramValue);
    }

    public static void removeCustParamCache(Long userId, String formId, String paramKey) {
        String type = ParameterCache.getCustParamRootCacheKey();
        String cacheKey = String.format(THREE_STR_PLACEHOLER, userId, formId, paramKey);
        ParameterCache.removeCache(type, cacheKey);
    }

    public static void removeCustParamCache() {
        String type = ParameterCache.getCustParamRootCacheKey();
        ParameterCache.removeCache(type);
    }

    public static ParamPublishObject getParamPublishObject(String cloudId, String appId) {
        String key = ParameterCache.genPublishObjectCacheKey(cloudId, appId);
        String cache = ParameterCache.getFromCache(ParameterCache.getPORootCacheKey(), key);
        return StringUtils.isNotBlank((CharSequence)cache) ? (ParamPublishObject)SerializationUtils.fromJsonString((String)cache, ParamPublishObject.class) : null;
    }

    public static void putParamPublishObject(ParamPublishObject publishObject) {
        String key = ParameterCache.genPublishObjectCacheKey(publishObject.getCloudId(), publishObject.getAppId());
        ParameterCache.putToCache(ParameterCache.getPORootCacheKey(), key, SerializationUtils.toJsonString((Object)publishObject));
    }

    public static void removeParamPublishObject(String cloudId, String appId) {
        String key = ParameterCache.genPublishObjectCacheKey(cloudId, appId);
        ParameterCache.removeCache(ParameterCache.getPORootCacheKey(), key);
    }

    public static ParamPublishObject getPublicParam(String publicParamFormId) {
        String cacheJson = ParameterCache.getFromCache(ParameterCache.getPORootCacheKey(), ParameterCache.genCacheKey(publicParamFormId));
        return StringUtils.isNotBlank((CharSequence)cacheJson) ? (ParamPublishObject)SerializationUtils.fromJsonString((String)cacheJson, ParamPublishObject.class) : null;
    }

    public static void putPublicParam(ParamPublishObject publishObject) {
        ParameterCache.putToCache(ParameterCache.getPORootCacheKey(), ParameterCache.genCacheKey(publishObject.getFormId()), SerializationUtils.toJsonString((Object)publishObject));
    }

    public static void removePublicParam(String publicParamFormId) {
        ParameterCache.removeCache(ParameterCache.getPORootCacheKey(), ParameterCache.genCacheKey(publicParamFormId));
    }

    public static Map<String, Object> getPublicParameter() {
        return ParameterCache.getPublicParameter("bos_publicparametertpl");
    }

    public static Map<String, Object> getPublicParameter(String publicParamFormId) {
        Map<String, Object> localCache = ParameterLocalCache.getPublicParameter(publicParamFormId);
        ParameterLog.info("ParameterCache.getPublicParameter localCache=", null, localCache);
        String versionType = ParameterCache.getVersionType();
        if (localCache != null && ParameterCache.compareVer(versionType, publicParamFormId)) {
            return localCache;
        }
        String key = ParameterCache.genPublicCacheKey(ParameterType.Public, publicParamFormId);
        String cache = ParameterCache.getFromCache(ParameterCache.getRootCacheKey(publicParamFormId), key);
        if (StringUtils.isBlank((CharSequence)cache)) {
            return null;
        }
        Map sessionCache = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
        ParameterLocalCache.putPublicParameter(publicParamFormId, sessionCache);
        ParameterCache.putVer(versionType, publicParamFormId);
        return sessionCache;
    }

    public static void putPublicParameter(Map<String, Object> param) {
        ParameterCache.putPublicParameter(param, "bos_publicparametertpl");
    }

    public static void putPublicParameter(Map<String, Object> param, String publicParamFormId) {
        String key = ParameterCache.genPublicCacheKey(ParameterType.Public, publicParamFormId);
        ParameterCache.putToCache(ParameterCache.getRootCacheKey(publicParamFormId), key, SerializationUtils.toJsonString(param));
        String versionType = ParameterCache.getVersionType();
        ParameterCache.putVer(versionType, publicParamFormId);
    }

    @Deprecated
    public static Map<String, Object> getBatchAppParameterByOrg(String appId, String viewType, long orgId, long acctBookId) {
        AppParam appParam = new AppParam(null, appId, viewType, Long.valueOf(orgId), Long.valueOf(acctBookId), Long.valueOf(0L));
        return ParameterCache.getBatchAppParameterByOrg(appParam);
    }

    public static Map<String, Object> getBatchAppParameterByOrg(AppParam appParam) {
        if (null == appParam) {
            ParameterLog.info("ParameterCache.getBatchAppParameterByOrg(kd.bos.entity.param.AppParam)\uff0cappParam=null");
            return null;
        }
        Map cache = ParameterCache.getAppParamAllOrgRedisCache(appParam);
        if (CollectionUtils.isEmpty((Map)cache)) {
            return null;
        }
        ParameterLog.info("ParameterCache.getBatchAppParameterByOrg redisCache=", appParam, cache);
        if (!CollectionUtils.isEmpty((Map)cache)) {
            ParameterLocalCache.putBatchAppParameterByOrg(appParam.getAppId(), cache);
        }
        return cache;
    }

    static Map getAppParamAllOrgRedisCache(AppParam appParam) {
        String outterKey = ParameterCache.genAppOutterKey(ParameterType.App, appParam.getAppId());
        Map cache = ParameterCache.getAppParameterByType(ParameterCache.getRootCacheKey(outterKey));
        return cache;
    }

    @Deprecated
    public static Map<String, Object> getAppParameter(String appId, String viewType, long orgId, long acctBookId) {
        AppParam appParam = new AppParam(null, appId, viewType, Long.valueOf(orgId), Long.valueOf(acctBookId), Long.valueOf(0L));
        return ParameterCache.getAppParameter(appParam);
    }

    public static Map<String, Object> getAppParameter(AppParam appParam) {
        if (null == appParam) {
            ParameterLog.info("ParameterCache.getAppParameter(kd.bos.entity.param.AppParam),AppParam=null");
            return null;
        }
        Map<String, Object> localCache = ParameterLocalCache.getAppParameter(appParam);
        ParameterLog.info("ParameterCache.getAppParameter localCache=", appParam, localCache);
        String outterKey = ParameterCache.genAppOutterKey(ParameterType.App, appParam.getAppId());
        String versionType = ParameterCache.getVersionType();
        String appInnerKey = ParameterCache.genAppInnerKey(appParam);
        if (localCache != null && ParameterCache.compareVer(versionType, outterKey)) {
            return localCache;
        }
        String cache = ParameterCache.getFromCache(ParameterCache.getRootCacheKey(outterKey), appInnerKey);
        if (cache == null) {
            return null;
        }
        Map sessionCache = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
        ParameterLog.info("ParameterCache.getAppParameter redisCache=", appParam, sessionCache);
        if (!CollectionUtils.isEmpty((Map)sessionCache)) {
            ParameterLocalCache.putAppParameter(appParam, sessionCache);
            ParameterCache.putVer(versionType, outterKey);
        }
        return sessionCache;
    }

    private static String getVersionType() {
        String versionKey = "paramVersion." + CacheKeyUtil.getAcctId();
        return versionKey;
    }

    private static boolean compareVer(String type, String key) {
        String redisVer = ParameterCache.getFromCache(type, key);
        String localCacheVer = ParameterLocalCache.getVer(type, key);
        return redisVer != null && localCacheVer != null && StringUtils.equals((CharSequence)redisVer, (CharSequence)localCacheVer);
    }

    private static void putVer(String type, String key) {
        String cacheVersion = ParameterCache.getFromCache(type, key);
        if (StringUtils.isBlank((CharSequence)cacheVersion)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            cacheVersion = sdf.format(new Date());
            ParameterCache.putToCache(type, key, cacheVersion);
        }
        ParameterLocalCache.putVer(type, key, cacheVersion);
    }

    public static void removeVer(String type, String key) {
        ParameterCache.removeCache(type, key);
    }

    private static void removeType(String type) {
        ThreadCache.remove((Object)type);
        cache.removeType(type);
    }

    @Deprecated
    public static Map<String, Map<String, Object>> getBatchAppParameterByOrg(String appId, String viewType, List<Long> orgIds, long acctBookId) {
        AppParam appParam = new AppParam(null, appId, viewType, orgIds, Long.valueOf(acctBookId), Long.valueOf(0L));
        return ParameterCache.getBatchAppParameterByBatchOrg(appParam);
    }

    public static Map<String, Map<String, Object>> getBatchAppParameterByBatchOrg(AppParam appParam) {
        Map<String, Object> cacheMap;
        if (null == appParam) {
            ParameterLog.info("ParameterCache.getBatchAppParameterByBatchOrg(kd.bos.entity.param.AppParam),AppParam=null");
            return null;
        }
        Map<String, Map<String, Object>> localCache = ParameterLocalCache.getBatchAppParameterByOrg(appParam);
        String outterKey = ParameterCache.genAppOutterKey(ParameterType.App, appParam.getAppId());
        String versionType = ParameterCache.getVersionType();
        if (localCache != null && !ParameterCache.compareVer(versionType, outterKey)) {
            localCache = null;
        }
        ArrayList<Long> orgHasNulls = null;
        AppParam tempParam = new AppParam();
        tempParam.setViewType(appParam.getViewType());
        tempParam.setActBookId(appParam.getActBookId());
        tempParam.setAcctingBookId(appParam.getAcctingBookId());
        if (localCache != null && !localCache.isEmpty()) {
            for (Long orgId : appParam.getOrgIds()) {
                tempParam.setOrgId(orgId);
                String key = ParameterCache.genAppInnerKey(tempParam);
                Map<String, Object> value = localCache.get(key);
                if (value != null) continue;
                if (orgHasNulls == null) {
                    orgHasNulls = new ArrayList<Long>();
                }
                orgHasNulls.add(orgId);
            }
            if (orgHasNulls == null) {
                return localCache;
            }
        }
        if ((cacheMap = ParameterCache.getBatchAppParameterByOrg(appParam)) == null || cacheMap.isEmpty()) {
            return null;
        }
        HashMap<String, Map<String, Object>> sessionCache = new HashMap<String, Map<String, Object>>(16);
        ArrayList<Long> orgTemps = null;
        if (orgHasNulls != null) {
            orgTemps = orgHasNulls;
            for (Long orgId : orgTemps) {
                tempParam.setOrgId(orgId);
                String key = ParameterCache.genAppInnerKey(tempParam);
                Map parameter = (Map)cacheMap.get(key);
                localCache.put(key, parameter);
            }
            ParameterLocalCache.putBatchAppParameterByOrg(appParam.getAppId(), localCache);
            return localCache;
        }
        orgTemps = appParam.getOrgIds();
        for (Long orgId : orgTemps) {
            tempParam.setOrgId(orgId);
            String key = ParameterCache.genAppInnerKey(tempParam);
            Map parameter = (Map)cacheMap.get(key);
            sessionCache.put(key, parameter);
        }
        ParameterLocalCache.putBatchAppParameterByOrg(appParam.getAppId(), sessionCache);
        ParameterCache.putVer(versionType, outterKey);
        return sessionCache;
    }

    @Deprecated
    public static void putAppParameter(String appId, String viewType, long orgId, long acctBookId, Map<String, Object> param) {
        AppParam appParam = new AppParam(null, appId, viewType, Long.valueOf(orgId), Long.valueOf(acctBookId), Long.valueOf(0L));
        ParameterCache.putAppParameter(appParam, param);
    }

    public static void putAppParameter(AppParam appParam, Map<String, Object> param) {
        if (null == appParam) {
            ParameterLog.info("ParameterCache.putAppParameter(kd.bos.entity.param.AppParam),AppParam=null");
            return;
        }
        String outterKey = ParameterCache.genAppOutterKey(ParameterType.App, appParam.getAppId());
        String innerKey = ParameterCache.genAppInnerKey(appParam);
        ParameterCache.putToCache(ParameterCache.getRootCacheKey(outterKey), innerKey, SerializationUtils.toJsonString(param));
        ParameterCache.putVer(ParameterCache.getVersionType(), outterKey);
    }

    @Deprecated
    public static void putBatchAppParameter(String appId, String viewType, Long acctBookId, Map<String, Map<String, Object>> params) {
        AppParam appParam = new AppParam();
        appParam.setAppId(appId);
        appParam.setViewType(viewType);
        appParam.setActBookId(acctBookId);
        ParameterCache.putBatchAppParameter(appParam, params);
    }

    public static void putBatchAppParameter(AppParam appParam, Map<String, Map<String, Object>> params) {
        if (null == appParam) {
            ParameterLog.info("ParameterCache.putBatchAppParameter,AppParam=null");
            return;
        }
        if (null == params) {
            ParameterLog.info("ParameterCache.putBatchAppParameter,params=null");
            return;
        }
        String outterKey = ParameterCache.genAppOutterKey(ParameterType.App, appParam.getAppId());
        AppParam tempParam = new AppParam();
        tempParam.setViewType(appParam.getViewType());
        tempParam.setActBookId(appParam.getActBookId());
        tempParam.setAcctingBookId(appParam.getAcctingBookId());
        for (Map.Entry<String, Map<String, Object>> entry : params.entrySet()) {
            try {
                long entryValue = Long.parseLong(entry.getKey());
                tempParam.setOrgId(Long.valueOf(entryValue));
                String key = ParameterCache.genAppInnerKey(tempParam);
                ParameterCache.putToCache(ParameterCache.getRootCacheKey(outterKey), key, SerializationUtils.toJsonString(entry.getValue()));
            }
            catch (NumberFormatException numEx) {
                logger.error("\u7ec4\u7ec7Id\u8f6c\u6362\u5f02\u5e38, orgId = " + entry.getKey());
            }
        }
    }

    public static void removeParameter(String cloudId, String appId) {
        ParameterCache.removeParameter(cloudId, appId, "bos_publicparametertpl");
    }

    public static void removeParameter(String cloudId, String appId, String publicParamFormId) {
        ParameterLocalCache.removeParameter(cloudId, appId, publicParamFormId);
        if (StringUtils.isBlank((CharSequence)cloudId) && StringUtils.isNotBlank((CharSequence)appId)) {
            String outterKey = ParameterCache.genAppOutterKey(ParameterType.App, appId);
            ParameterCache.removeCache(ParameterCache.getRootCacheKey(outterKey));
            String versionType = ParameterCache.getVersionType();
            ParameterCache.removeVer(versionType, outterKey);
        } else {
            if (StringUtils.isNotBlank((CharSequence)cloudId) && StringUtils.isBlank((CharSequence)appId)) {
                return;
            }
            ParameterCache.removeCache(ParameterCache.getRootCacheKey(publicParamFormId), ParameterCache.genPublicCacheKey(ParameterType.Public, publicParamFormId));
            ParameterCache.removeVer(ParameterCache.getVersionType(), publicParamFormId);
        }
    }

    public static void removeBatchParameter(String cloudId, String appId) {
        ParameterLocalCache.removeBatchParameter(cloudId, appId);
        if (StringUtils.isBlank((CharSequence)cloudId) && StringUtils.isNotBlank((CharSequence)appId)) {
            String outterKey = ParameterCache.genAppOutterKey(ParameterType.App, appId);
            ParameterCache.removeType(ParameterCache.getRootCacheKey(outterKey));
        }
    }

    private static String genAppOutterKey(ParameterType type, String id) {
        return (type.getType() + "." + id).toLowerCase();
    }

    @Deprecated
    public static String genAppInnerKey(String viewType, long orgId, long acctBookId) {
        AppParam appParam = new AppParam();
        appParam.setViewType(viewType);
        appParam.setOrgId(Long.valueOf(orgId));
        appParam.setActBookId(Long.valueOf(acctBookId));
        appParam.setAcctingBookId(Long.valueOf(0L));
        return ParameterCache.genAppInnerKey(appParam);
    }

    public static String genAppInnerKey(AppParam appParam) {
        if (null == appParam) {
            ParameterLog.info("ParameterCache.genAppInnerKey(),AppParam=null");
            return null;
        }
        return (appParam.getViewType() + "." + String.valueOf(appParam.getOrgId()) + "." + String.valueOf(appParam.getActBookId()) + "." + String.valueOf(appParam.getAcctingBookId())).toLowerCase();
    }

    private static String genPublicCacheKey(ParameterType type, String publicParamFormId) {
        return (type.getType() + ".cache_key." + publicParamFormId).toLowerCase();
    }

    private static String genPublishObjectCacheKey(String cloudId, String appId) {
        return "publish." + (StringUtils.isNotBlank((CharSequence)cloudId) ? cloudId : (StringUtils.isNotBlank((CharSequence)appId) ? appId : "public"));
    }

    private static String genCacheKey(String ... keys) {
        StringBuilder builder = new StringBuilder("publish.");
        for (String key : keys) {
            builder.append(key).append(".");
        }
        builder.append("key");
        return builder.toString();
    }

    public static String getBillTypeParamFromCache(String formId, Long billTypeId) {
        String type = ParameterCache.getBillTypeParamRootCacheKey();
        String cacheKey = String.format(TWO_STR_PLACEHOLDER, formId, billTypeId);
        String cache = ParameterCache.getFromCache(type, cacheKey);
        return StringUtils.isNotBlank((CharSequence)cache) ? (String)SerializationUtils.fromJsonString((String)cache, String.class) : null;
    }

    public static void putBillTypeParamToCache(String formId, Long billTypeId, String data) {
        String type = ParameterCache.getBillTypeParamRootCacheKey();
        String cacheKey = String.format(TWO_STR_PLACEHOLDER, formId, billTypeId);
        ParameterCache.putToCache(type, cacheKey, SerializationUtils.toJsonString((Object)data));
    }

    public static void removeBillTypeParamCache(String formId, Long billTypeId) {
        String type = ParameterCache.getBillTypeParamRootCacheKey();
        String cacheKey = String.format(TWO_STR_PLACEHOLDER, formId, billTypeId);
        ParameterCache.removeCache(type, cacheKey);
    }
}

