/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.param;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.param.BillParam;
import kd.bos.entity.param.ParamPublishObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterLog;
import kd.bos.param.ParameterType;

public class ParameterLocalCache {
    private static final String SYSTEM_PARAM = "SYSTEM_PARAMETER";
    private static final String TYPE_BILL_PARAMETER_DYNMIC_OBJECT = "BillParam_Obj_";
    private static final String TYPE_BILL_PARAMETER_BILLPARAM = "BillParam_";
    private static final String TYPE_BILL_PARAMETER_VER = "BillParam_Ver_";
    private static final String BILLTYPE_PARAM = "BillType_Param_";
    private static final int INITIAL_COLLECTION_SIZE = 16;
    private static final Log logger = LogFactory.getLog(ParameterLocalCache.class);

    private static LocalMemoryCache getLocalCache(String acctId) {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(43200);
        info.setMaxMemSize(10000);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(acctId, SYSTEM_PARAM, info);
    }

    private static LocalMemoryCache getLocalBatchCache(String acctId) {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(3600);
        info.setMaxMemSize(100000);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(acctId, SYSTEM_PARAM, info);
    }

    public static ParamPublishObject getParamPublishObject(String cloudId, String appId) {
        LocalMemoryCache localCache = ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId());
        return (ParamPublishObject)localCache.get(ParameterLocalCache.genPublishObjectCacheKey(cloudId, appId));
    }

    public static void putParamPublishObject(ParamPublishObject publishObject) {
        LocalMemoryCache localCache = ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId());
        localCache.put(ParameterLocalCache.genPublishObjectCacheKey(publishObject.getCloudId(), publishObject.getAppId()), (Object)publishObject);
    }

    public static void removeParamPublishObject(String cloudId, String appId) {
        LocalMemoryCache localCache = ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId());
        localCache.remove(new String[]{ParameterLocalCache.genPublishObjectCacheKey(cloudId, appId)});
    }

    public static Map<String, Object> getPublicParameter() {
        return ParameterLocalCache.getPublicParameter("bos_publicparametertpl");
    }

    public static void putPublicParameter(String publicParamFormId, Map<String, Object> param) {
        LocalMemoryCache localCache = ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId());
        localCache.put(ParameterLocalCache.genPublicCacheKey(ParameterType.Public, publicParamFormId), param);
    }

    public static ParamPublishObject getPublicParam(String publicParamFormId) {
        LocalMemoryCache localCache = ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId());
        return (ParamPublishObject)localCache.get(ParameterLocalCache.genPublishObjectCacheKey(publicParamFormId));
    }

    public static void putPublicParam(ParamPublishObject publishObject) {
        LocalMemoryCache localCache = ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId());
        localCache.put(ParameterLocalCache.genPublishObjectCacheKey(publishObject.getFormId()), (Object)publishObject);
    }

    public static void removeParamPublishObject(String publicParamFormId) {
        LocalMemoryCache localCache = ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId());
        localCache.remove(new String[]{ParameterLocalCache.genPublishObjectCacheKey(publicParamFormId)});
    }

    public static Map<String, Object> getPublicParameter(String publicParamFormId) {
        LocalMemoryCache localCache = ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId());
        return (Map)localCache.get(ParameterLocalCache.genPublicCacheKey(ParameterType.Public, publicParamFormId));
    }

    public static void putPublicParameter(Map<String, Object> param) {
        ParameterLocalCache.putPublicParameter("bos_publicparametertpl", param);
    }

    @Deprecated
    public static Map<String, Object> getAppParameter(String appId, String viewType, long orgId, long acctBookId) {
        AppParam appParam = new AppParam(null, appId, viewType, Long.valueOf(orgId), Long.valueOf(acctBookId), Long.valueOf(0L));
        return ParameterLocalCache.getAppParameter(appParam);
    }

    public static Map<String, Object> getAppParameter(AppParam appParam) {
        if (null == appParam) {
            ParameterLog.info("ParameterLocalCache.getAppParameter(kd.bos.entity.param.AppParam),AppParam=null");
            return null;
        }
        Object cache = ParameterLocalCache.getAppParamAllOrgLocalCacheValue(appParam);
        return cache == null ? null : (Map)((Map)cache).get(ParameterLocalCache.genAppInnerKey(appParam.getViewType(), appParam.getOrgId(), appParam.getActBookId(), appParam.getAcctingBookId()));
    }

    static Object getAppParamAllOrgLocalCacheValue(AppParam appParam) {
        LocalMemoryCache localCache = ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId());
        String outterKey = ParameterLocalCache.genAppOutterKey(ParameterType.App, appParam.getAppId());
        Object cache = localCache.get(outterKey);
        return cache;
    }

    @Deprecated
    public static Map<String, Map<String, Object>> getBatchAppParameterByOrg(String appId, String viewType, List<Long> orgIds, long acctBookId) {
        AppParam appParam = new AppParam(null, appId, viewType, orgIds, Long.valueOf(acctBookId), Long.valueOf(0L));
        return ParameterLocalCache.getBatchAppParameterByOrg(appParam);
    }

    public static Map<String, Map<String, Object>> getBatchAppParameterByOrg(AppParam appParam) {
        String outterKey;
        if (null == appParam) {
            ParameterLog.info("ParameterLocalCache.getAppParameter(kd.bos.entity.param.AppParam),AppParam=null");
            return null;
        }
        HashMap<String, Map<String, Object>> lstRet = new HashMap<String, Map<String, Object>>(16);
        LocalMemoryCache localCache = ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId());
        Object cache = localCache.get(outterKey = ParameterLocalCache.genAppOutterKey(ParameterType.App, appParam.getAppId()));
        if (cache == null) {
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)appParam.getOrgIds())) {
            return lstRet;
        }
        for (Long orgId : appParam.getOrgIds()) {
            String key = ParameterLocalCache.genAppInnerKey(appParam.getViewType(), orgId, appParam.getActBookId(), appParam.getAcctingBookId());
            Map parameter = (Map)((Map)cache).get(key);
            lstRet.put(key, parameter);
        }
        return lstRet;
    }

    @Deprecated
    public static void putAppParameter(String appId, String viewType, long orgId, long acctBookId, Map<String, Object> param) {
        AppParam appParam = new AppParam(null, appId, viewType, Long.valueOf(orgId), Long.valueOf(acctBookId), Long.valueOf(0L));
        ParameterLocalCache.putAppParameter(appParam, param);
    }

    public static void putAppParameter(AppParam appParam, Map<String, Object> param) {
        String outterKey;
        if (null == appParam) {
            ParameterLog.info("ParameterLocalCache.putAppParameter(kd.bos.entity.param.AppParam),AppParam=null");
            return;
        }
        LocalMemoryCache localCache = ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId());
        HashMap<String, Map<String, Object>> cache = (HashMap<String, Map<String, Object>>)localCache.get(outterKey = ParameterLocalCache.genAppOutterKey(ParameterType.App, appParam.getAppId()));
        if (cache == null) {
            cache = new HashMap<String, Map<String, Object>>(16);
        }
        String innerKey = ParameterLocalCache.genAppInnerKey(appParam.getViewType(), appParam.getOrgId(), appParam.getActBookId(), appParam.getAcctingBookId());
        cache.put(innerKey, param);
        localCache.put(outterKey, cache);
    }

    public static void putBatchAppParameterByOrg(String appId, Map<String, Map<String, Object>> param) {
        String outterKey;
        LocalMemoryCache localCache = ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId());
        HashMap<String, Map<String, Object>> cache = (HashMap<String, Map<String, Object>>)localCache.get(outterKey = ParameterLocalCache.genAppOutterKey(ParameterType.App, appId));
        if (cache == null) {
            cache = new HashMap<String, Map<String, Object>>(16);
        }
        cache.putAll(param);
        localCache.put(outterKey, cache);
    }

    public static void removeParameter(String cloudId, String appId) {
        ParameterLocalCache.removeParameter(cloudId, appId, "bos_publicparametertpl");
    }

    public static void removeParameter(String cloudId, String appId, String publicParamFormId) {
        LocalMemoryCache localCache = ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId());
        if (StringUtils.isBlank((CharSequence)cloudId) && StringUtils.isNotBlank((CharSequence)appId)) {
            String outterKey = ParameterLocalCache.genAppOutterKey(ParameterType.App, appId);
            localCache.remove(new String[]{outterKey});
            logger.debug("\u5220\u9664\u672c\u5730\u5206\u5e03\u5f0f\u7f13\u5b58->outterKey\uff1a" + outterKey);
        } else {
            if (StringUtils.isNotBlank((CharSequence)cloudId) && StringUtils.isBlank((CharSequence)appId)) {
                return;
            }
            localCache.remove(new String[]{ParameterLocalCache.genPublicCacheKey(ParameterType.Public, publicParamFormId)});
        }
    }

    public static void removeBatchParameter(String cloudId, String appId) {
        LocalMemoryCache localCache = ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId());
        if (StringUtils.isBlank((CharSequence)cloudId) && StringUtils.isNotBlank((CharSequence)appId)) {
            String outterKey = ParameterLocalCache.genAppOutterKey(ParameterType.App, appId);
            localCache.remove(new String[]{outterKey});
        }
    }

    public static String getBillParamVer(String entityNumber) {
        return (String)ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId()).get(ParameterLocalCache.genBillParamVeraCacheKey(entityNumber));
    }

    public static void putBillParamVer(String entityNumber, String cacheVer) {
        ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId()).put(ParameterLocalCache.genBillParamVeraCacheKey(entityNumber), (Object)cacheVer);
    }

    static String getVer(String type, String key) {
        return (String)ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId()).get(type + "." + key);
    }

    static void putVer(String type, String key, String data) {
        ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId()).put(type + "." + key, (Object)data);
    }

    public static DynamicObject getBillParamDynamicObject(String entityNumber) {
        return (DynamicObject)ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId()).get(ParameterLocalCache.genBillParamDynamicObjectCacheKey(entityNumber));
    }

    public static void putBillParamDynamicObject(String entityNumber, DynamicObject billParam) {
        ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId()).put(ParameterLocalCache.genBillParamDynamicObjectCacheKey(entityNumber), (Object)billParam);
    }

    public static BillParam getBillParam(String entityNumber) {
        return (BillParam)ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId()).get(ParameterLocalCache.genBillParamCacheKey(entityNumber));
    }

    public static void putBillParam(String entityNumber, BillParam billParam) {
        ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId()).put(ParameterLocalCache.genBillParamCacheKey(entityNumber), (Object)billParam);
    }

    public static void removeBillParameter(String entityNumber) {
        LocalMemoryCache localMemoryCache = ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId());
        localMemoryCache.remove(new String[]{ParameterLocalCache.genBillParamCacheKey(entityNumber)});
        localMemoryCache.remove(new String[]{ParameterLocalCache.genBillParamDynamicObjectCacheKey(entityNumber)});
    }

    private static String genAppOutterKey(ParameterType type, String id) {
        return (type.getType() + "." + id).toLowerCase();
    }

    private static String genAppInnerKey(String viewType, long orgId, long acctBookId, long acctingBookId) {
        return (viewType + "." + orgId + "." + acctBookId + "." + acctingBookId).toLowerCase();
    }

    private static String genPublicCacheKey(ParameterType type, String publicParamFormId) {
        return (type.getType() + ".public." + publicParamFormId).toLowerCase();
    }

    private static String genPublishObjectCacheKey(String cloudId, String appId) {
        return "publish." + (StringUtils.isNotBlank((CharSequence)cloudId) ? cloudId : (StringUtils.isNotBlank((CharSequence)appId) ? appId : "public"));
    }

    private static String genPublishObjectCacheKey(String publicParamFormId) {
        return "publish." + publicParamFormId + ".public";
    }

    private static String genBillParamVeraCacheKey(String entityNumber) {
        return TYPE_BILL_PARAMETER_VER + entityNumber;
    }

    private static String genBillParamDynamicObjectCacheKey(String entityNumber) {
        return TYPE_BILL_PARAMETER_DYNMIC_OBJECT + entityNumber;
    }

    private static String genBillParamCacheKey(String entityNumber) {
        return TYPE_BILL_PARAMETER_BILLPARAM + entityNumber + "_" + RequestContext.get().getLang().getLangTag();
    }

    private static String genBillTypeParamCacheKey(String formId, Long billTypeId) {
        return BILLTYPE_PARAM + formId + "_" + billTypeId;
    }

    public static DynamicObject getBillTypeParameter(String formId, Long billTypeId) {
        return (DynamicObject)ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId()).get(ParameterLocalCache.genBillTypeParamCacheKey(formId, billTypeId));
    }

    public static void putBillTypeParameter(String formId, Long billTypeId, DynamicObject object) {
        ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId()).put(ParameterLocalCache.genBillTypeParamCacheKey(formId, billTypeId), (Object)object);
    }

    public static void removeBillTypeParameter(String formId, Long billTypeId) {
        LocalMemoryCache localCache = ParameterLocalCache.getLocalCache(CacheKeyUtil.getAcctId());
        localCache.remove(new String[]{ParameterLocalCache.genBillTypeParamCacheKey(formId, billTypeId)});
    }
}

