/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.param;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.FieldDefValue;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParamDcBinder;
import kd.bos.service.ServiceFactory;
import org.apache.commons.beanutils.ConvertUtils;

public class ParameterUtils {
    private static final Log logger = LogFactory.getLog(ParameterUtils.class);

    public static DynamicObject serializeToDataEntity(DynamicObjectCollection data, String formId) {
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            DynamicObject dynamicObject;
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
            DynamicObject dataEntity = (DynamicObject)entityType.createInstance();
            ParameterUtils.createDefaultEntity(entityType, dataEntity);
            String jsonStr = null;
            if (!CollectionUtils.isEmpty((Collection)data) && (dynamicObject = (DynamicObject)data.get(0)).getDataEntityType().getProperties().containsKey((Object)"FDATA")) {
                jsonStr = dynamicObject.getString("FDATA");
            }
            if (StringUtils.isNotBlank(jsonStr)) {
                Map map = (Map)SerializationUtils.fromJsonString(jsonStr, Map.class);
                if (map == null || !StringUtils.equals((CharSequence)((String)map.get("_Type_")), (CharSequence)formId)) {
                    logger.warn(String.format("formId\u4e0d\u7b49\u4e8e\u5e8f\u5217\u5316type\u5bf9\u5e94\u7684\u503c\uff0c\u5219\u4ee3\u8868\u4e0d\u540c\u6570\u636e\uff0c\u76f4\u63a5\u8fd4\u56de\u7a7a\u5305\uff0cformId=%s, map=%s", formId, map));
                    return dataEntity;
                }
                ParamDcBinder binder = new ParamDcBinder((DynamicObjectType)entityType);
                DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
                dataEntity = (DynamicObject)jser.deserializeFromString(jsonStr, (Object)dataEntity);
            }
            ParameterUtils.loadComplexProperty(dataEntity);
            return dataEntity;
        }
        return null;
    }

    public static DynamicObject serializeToDataEntity(String data, String formId) {
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
            DynamicObject dataEntity = (DynamicObject)entityType.createInstance();
            ParameterUtils.createDefaultEntity(entityType, dataEntity);
            if (StringUtils.isNotBlank((CharSequence)data)) {
                Map map = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                if (map == null || !StringUtils.equals((CharSequence)((String)map.get("_Type_")), (CharSequence)formId)) {
                    logger.warn(String.format("formId\u4e0d\u7b49\u4e8e\u5e8f\u5217\u5316type\u5bf9\u5e94\u7684\u503c\uff0c\u5219\u4ee3\u8868\u4e0d\u540c\u6570\u636e\uff0c\u76f4\u63a5\u8fd4\u56de\u7a7a\u5305\uff0cformId=%s, map=%s", formId, map));
                    return dataEntity;
                }
                ParamDcBinder binder = new ParamDcBinder((DynamicObjectType)entityType);
                DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
                dataEntity = (DynamicObject)jser.deserializeFromString(data, (Object)dataEntity);
            }
            ParameterUtils.loadComplexProperty(dataEntity);
            return dataEntity;
        }
        return null;
    }

    public static DynamicObject createDefaultEntity(MainEntityType mainEntityType, DynamicObject dataEntity) {
        DataEntityPropertyCollection propertyCollection = mainEntityType.getProperties();
        for (IDataEntityProperty property : propertyCollection) {
            if (property instanceof FieldProp) {
                FieldDefValue defValue2;
                if ("showcontent".equals(property.getName())) continue;
                Object defValue = ((FieldProp)property).getDefValue();
                if (property instanceof DateTimeProp && (defValue2 = ((FieldProp)property).getDefValue2()) != null) {
                    String varName = defValue2.getVarName();
                    if (varName != null) {
                        defValue = new Date();
                    } else {
                        String formula = defValue2.getFormula();
                        String[] formatData = formula.substring(formula.indexOf(40) + 1, formula.indexOf(41)).split(",");
                        SimpleDateFormat dateformat = new SimpleDateFormat(formatData[1].substring(1, formatData[1].length() - 1));
                        dateformat.setTimeZone(TimeZone.getTimeZone(formatData[2].substring(1, formatData[2].length() - 1)));
                        try {
                            defValue = dateformat.parse(formatData[0].substring(1, formatData[0].length() - 1));
                        }
                        catch (ParseException e) {
                            logger.error((Throwable)e);
                        }
                    }
                }
                dataEntity.set(property, defValue);
                continue;
            }
            if (!(property instanceof BasedataProp)) continue;
            FieldDefValue defValue2 = ((IFieldHandle)property).getDefValue2();
            String defValue = ((BasedataProp)property).getDefValue();
            if (defValue2 != null) {
                DynamicObjectType type = ((BasedataProp)property).getDynamicComplexPropertyType();
                DynamicObject val = ParameterUtils.getBasedata(type, defValue2.getFuncParameter());
                if (val == null) continue;
                dataEntity.set(property, (Object)val);
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)defValue)) continue;
            dataEntity.set(property, (Object)((BasedataProp)property).getDefValue());
        }
        return dataEntity;
    }

    private static DynamicObject getBasedata(DynamicObjectType type, String basedata) {
        Map basedataMap = (Map)SerializationUtils.fromJsonString((String)basedata, Map.class);
        Object id = basedataMap.get("id");
        DynamicObject ret = null;
        Map result = BusinessDataReader.loadFromCache((Object[])new Object[]{id}, (DynamicObjectType)type);
        if (!result.isEmpty()) {
            for (Map.Entry entry : result.entrySet()) {
                if (entry.getValue() == null) continue;
                ret = (DynamicObject)entry.getValue();
                break;
            }
        }
        return ret;
    }

    public static void loadComplexProperty(DynamicObject dataEntity) {
        DataEntityPropertyCollection properties = dataEntity.getDynamicObjectType().getProperties();
        ArrayList<Object> ids = new ArrayList<Object>(16);
        for (IDataEntityProperty property : properties) {
            BasedataEntityType dt;
            BasedataProp basedataProp;
            if (property instanceof BasedataProp) {
                basedataProp = (BasedataProp)property;
                dt = (BasedataEntityType)basedataProp.getComplexType((Object)dataEntity);
                if (dt == null && basedataProp instanceof ItemClassProp) {
                    dt = (BasedataEntityType)((ItemClassProp)basedataProp).getComplexType();
                }
                Object id = dataEntity.get(((BasedataProp)property).getRefIdProp());
                if (dt == null || id == null || ((BasedataProp)property).getValueComparator().compareValue(id)) continue;
                if (dt != null && dt.getPrimaryKey() != null && id.getClass() != dt.getPrimaryKey().getPropertyType()) {
                    id = ConvertUtils.convert((Object)id, (Class)dt.getPrimaryKey().getPropertyType());
                }
                try {
                    Map objs = BusinessDataReader.loadFromCache((Object[])new Object[]{id}, (DynamicObjectType)dt);
                    Iterator dynamicObject = (DynamicObject)objs.get(id);
                    dataEntity.set(property, (Object)dynamicObject);
                }
                catch (RuntimeException e) {
                    logger.error((Throwable)e);
                }
                continue;
            }
            if (!(property instanceof MulBasedataProp)) continue;
            basedataProp = (BasedataProp)((MulBasedataProp)property).getRefBaseProp();
            dt = (BasedataEntityType)basedataProp.getDynamicComplexPropertyType();
            String refId = basedataProp.getRefIdProp().getName();
            DynamicObjectCollection col = (DynamicObjectCollection)dataEntity.get(property.getName());
            ids.clear();
            for (DynamicObject obj : col) {
                ids.add(obj.get(refId));
            }
            DynamicObjectCollection collection = (DynamicObjectCollection)property.getValue((Object)dataEntity);
            collection.clear();
            Map objs = BusinessDataReader.loadFromCache((Object[])ids.toArray(), (DynamicObjectType)dt);
            for (DynamicObject obj : objs.values()) {
                DynamicObject newObj = new DynamicObject(((MulBasedataProp)property).getDynamicCollectionItemPropertyType());
                newObj.set("FBasedataId", (Object)obj);
                newObj.set("FBasedataId_id", obj.get(dt.getPrimaryKey().getName()));
                collection.add((Object)newObj);
            }
            dataEntity.set(property, (Object)collection);
        }
    }

    public static void saveOrUpdateParam(List<SqlParameter> params, String sql, boolean isUpdate) {
        try (TXHandle h = TX.requiresNew();){
            if (isUpdate) {
                DB.update((DBRoute)DBRoute.basedata, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
            } else {
                DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
            }
        }
    }

    public static Map<String, Object> formatDynamicObjectToDataMap(SimpleDateFormat shortTimeFormat, SimpleDateFormat longTimeFormat, MainEntityType entityType, DynamicObject dataEntity) {
        Map properties = entityType.getAllFields();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        ArrayList<Object> ids = new ArrayList<Object>(10);
        for (IDataEntityProperty dep : properties.values()) {
            Object obj = dataEntity.get(dep);
            if (obj == null && dep instanceof DynamicSimpleProperty) {
                dataMap.put(dep.getName(), "");
                continue;
            }
            if (dep instanceof BasedataProp) {
                try {
                    MainEntityType dt = EntityMetadataCache.getDataEntityType((String)((BasedataProp)dep).getBaseEntityId());
                    DynamicObject dynamicObject = BusinessDataReader.loadSingle((Object)dataEntity.get(((BasedataProp)dep).getRefIdProp()), (DynamicObjectType)dt);
                    BasedataEntityType basedataDT = (BasedataEntityType)dynamicObject.getDynamicObjectType();
                    IDataEntityProperty nameProp = basedataDT.findProperty(basedataDT.getNameProperty());
                    dataMap.put(dep.getName(), nameProp.getValueFast((Object)dynamicObject).toString());
                }
                catch (RuntimeException e) {
                    logger.error((Throwable)e);
                    dataMap.put(dep.getName(), "");
                }
                continue;
            }
            if (dep instanceof MulBasedataProp) {
                BasedataProp basedataProp = (BasedataProp)((MulBasedataProp)dep).getRefBaseProp();
                BasedataEntityType dt = (BasedataEntityType)basedataProp.getDynamicComplexPropertyType();
                String refId = basedataProp.getRefIdProp().getName();
                DynamicObjectCollection col = (DynamicObjectCollection)dataEntity.get(dep.getName());
                ids.clear();
                for (DynamicObject dobj : col) {
                    ids.add(dobj.get(refId));
                }
                DynamicObject[] dynamicObjects = BusinessDataReader.load((Object[])ids.toArray(), (DynamicObjectType)dt, (Boolean)Boolean.TRUE);
                IDataEntityProperty nameProp = dt.findProperty(dt.getNameProperty());
                ArrayList<String> returnValues = new ArrayList<String>(16);
                DynamicObject[] dynamicObjectArray = dynamicObjects;
                int n = dynamicObjectArray.length;
                for (int i = 0; i < n; ++i) {
                    DynamicObject dynamicObject = dynamicObjectArray[i];
                    returnValues.add(dynamicObject.get(nameProp.getName()).toString());
                }
                dataMap.put(dep.getName(), String.join((CharSequence)";", returnValues));
                continue;
            }
            if (dep instanceof MulComboProp) {
                String objs = obj == null ? "" : obj.toString();
                String[] selectVal = objs.split(",");
                StringBuilder value = new StringBuilder();
                List items = ((ComboProp)dep).getComboItems();
                block5: for (ValueMapItem item2 : items) {
                    for (String val : selectVal) {
                        if (!item2.getValue().equals(val)) continue;
                        value.append(' ').append(item2.getName().getLocaleValue());
                        continue block5;
                    }
                }
                dataMap.put(dep.getName(), value.toString().trim());
                continue;
            }
            if (dep instanceof ComboProp) {
                List items = ((ComboProp)dep).getComboItems();
                items.forEach(item -> {
                    if (item.getValue().equals(obj)) {
                        dataMap.put(dep.getName(), item.getName().getLocaleValue());
                    }
                });
                continue;
            }
            if (dep instanceof BooleanProp) {
                dataMap.put(dep.getName(), obj == Boolean.FALSE ? ResManager.loadKDString((String)"\u5426", (String)"ParameterHelper_0", (String)"bos-dao", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u662f", (String)"ParameterHelper_1", (String)"bos-dao", (Object[])new Object[0]));
                continue;
            }
            if (dep instanceof DateProp) {
                dataMap.put(dep.getName(), shortTimeFormat.format(obj));
                continue;
            }
            if (dep instanceof DateTimeProp) {
                dataMap.put(dep.getName(), longTimeFormat.format(obj));
                continue;
            }
            if (dep instanceof TimeProp) {
                dataMap.put(dep.getName(), null == obj || obj.equals(-1) ? "" : ParameterUtils.formatTime(Integer.parseInt(obj.toString())));
                continue;
            }
            if (null == obj || obj instanceof BigDecimal && ((BigDecimal)obj).longValue() == 0L || obj.equals(0) || "{}".equals(obj)) {
                dataMap.put(dep.getName(), "");
                continue;
            }
            dataMap.put(dep.getName(), obj);
        }
        return dataMap;
    }

    public static String formatTime(Integer time) {
        if (time != null && time >= 0) {
            String result = ParameterUtils.getTime(time);
            IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
            Long userId = RequestContext.get().getCurrUserId();
            Map timeFormat = inteService.getTimeFormat(userId);
            try {
                Date data = new SimpleDateFormat("HH:mm:ss").parse(result);
                return new SimpleDateFormat((String)timeFormat.get("timeFormat")).format(data);
            }
            catch (ParseException e) {
                return "";
            }
        }
        return "";
    }

    private static String getTime(Integer time) {
        if (time != null && time >= 0) {
            Integer hour = time / 3600;
            time = time % 3600;
            Integer minutes = time / 60;
            Integer second = time % 60;
            String result = (hour < 10 ? "0" : "") + hour + ":" + (minutes < 10 ? "0" : "") + minutes + ":" + (second < 10 ? "0" : "") + second;
            return result;
        }
        return "0";
    }
}

