/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.param.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.param.ParamOperationResult;
import kd.bos.entity.param.ParamPublishObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.dataentity.SingleORM;
import kd.bos.param.ParamDcBinder;
import kd.bos.param.ParameterCache;
import kd.bos.param.ParameterLocalCache;
import kd.bos.param.ParameterLog;
import kd.bos.param.ParameterReader;
import kd.bos.param.ParameterUtils;
import kd.bos.param.ParameterWriter;
import kd.bos.param.constant.UserParaType;
import kd.bos.param.impl.ParameterReaderServiceImpl;
import kd.bos.param.service.IParameterWriterService;
import kd.bos.product.ICoreProductSettingService;
import kd.bos.service.ServiceFactory;

public class ParameterWriterServiceImpl
implements IParameterWriterService {
    private static final String FID = ":FID";
    private static final String FORGID = ":FORGID";
    private static final String FVIEWTYPEID = ":FVIEWTYPEID";
    private static final String FACCTBOOKID = ":FACCTBOOKID";
    private static final String FACCTINGBOOKID = ":FACCTINGBOOKID";
    private static final String FPARAMID = ":FPARAMID";
    private static final String FSUBSYSTEM = ":FSUBSYSTEM";
    private static final String FDATA = ":FDATA";
    private static final String FFORMID = ":FFORMID";
    private static final String FBILLTYPEID = ":FBILLTYPEID";
    private static final String FUSERID = ":FUSERID";
    private static final String FEXTEND = ":FEXTEND";
    private static final String FISLISTOPTION = ":FISLISTOPTION";
    private static final String BOS_BILL_PARAMETER_TPL = "bos_billparametertpl";
    private static final Log logger = LogFactory.getLog(ParameterWriter.class);
    private static final String[] keys = new String[]{"aiserver", "aiappid", "aiprivatekey"};
    private static final ParameterReaderServiceImpl parameterReaderService = new ParameterReaderServiceImpl();

    public void saveSystemParameter(String cloudId, String appId, String viewType, long orgId, long acctBookId, String jsonData) {
        AppParam appParam = new AppParam(cloudId, appId, viewType, Long.valueOf(orgId), Long.valueOf(acctBookId), Long.valueOf(0L));
        this.saveSystemParameter(appParam, jsonData);
    }

    public void saveSystemParameter(AppParam appParam, String jsonData) {
        String sql;
        if (null == appParam) {
            ParameterLog.info("ParameterWriterService.saveSystemParameter\uff0cappParam=null");
            return;
        }
        appParam = (AppParam)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)appParam), AppParam.class);
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        String cloudId = appParam.getCloudId();
        String appId = appParam.getAppId();
        boolean isSysParam = ParameterWriterServiceImpl.isSysParam(appParam);
        ParamPublishObject param = isSysParam ? parameterReaderService.getPublicObject(appParam.getFormId()) : parameterReaderService.getParameterObject(cloudId, appId);
        StringBuilder sb = new StringBuilder("SELECT FID FROM T_BAS_SYSPARAMETER WHERE FPARAMID=? ");
        params.add(new SqlParameter(FPARAMID, 12, (Object)param.getId()));
        long orgId = appParam.getOrgId();
        String viewType = appParam.getViewType();
        long acctBookId = appParam.getActBookId();
        long acctingBookId = appParam.getAcctingBookId();
        if (StringUtils.isNotBlank((CharSequence)cloudId) && StringUtils.isBlank((CharSequence)appId)) {
            sb.append("AND FORGID=? AND FVIEWTYPEID=? AND FACCTBOOKID=? AND FACCTINGBOOKID=?");
            params.add(new SqlParameter(FORGID, -5, (Object)orgId));
            params.add(new SqlParameter(FVIEWTYPEID, 12, (Object)viewType));
            params.add(new SqlParameter(FACCTBOOKID, -5, (Object)acctBookId));
            params.add(new SqlParameter(FACCTINGBOOKID, -5, (Object)acctingBookId));
        } else if (StringUtils.isBlank((CharSequence)cloudId) && StringUtils.isNotBlank((CharSequence)appId)) {
            sb.append("AND FORGID=? AND FVIEWTYPEID=? AND FACCTBOOKID=? AND FACCTINGBOOKID=?");
            params.add(new SqlParameter(FORGID, -5, (Object)orgId));
            params.add(new SqlParameter(FVIEWTYPEID, 12, (Object)viewType));
            params.add(new SqlParameter(FACCTBOOKID, -5, (Object)acctBookId));
            params.add(new SqlParameter(FACCTINGBOOKID, -5, (Object)acctingBookId));
        } else {
            orgId = 0L;
            viewType = "0";
            acctBookId = 0L;
            acctingBookId = 0L;
        }
        DynamicObjectCollection existData = SingleORM.query(null, (String)sb.toString(), (Object[])params.toArray(new SqlParameter[params.size()]));
        params.clear();
        if (existData == null || existData.isEmpty()) {
            sql = "INSERT INTO T_BAS_SYSPARAMETER (FID, FPARAMID, FORGID, FVIEWTYPEID, FACCTBOOKID, FACCTINGBOOKID, FDATA) VALUES (?, ?, ?, ?, ?, ?, ?)";
            params.add(new SqlParameter(FID, 12, (Object)Uuid16.create().toString()));
            params.add(new SqlParameter(FPARAMID, 12, (Object)param.getId()));
            params.add(new SqlParameter(FORGID, 12, (Object)orgId));
            params.add(new SqlParameter(FVIEWTYPEID, 12, (Object)viewType));
            params.add(new SqlParameter(FACCTBOOKID, -5, (Object)acctBookId));
            params.add(new SqlParameter(FACCTINGBOOKID, -5, (Object)acctingBookId));
            params.add(new SqlParameter(FDATA, 12, (Object)jsonData));
            ParameterLog.info("ParameterWriter.saveSystemParameter insert, params:" + SerializationUtils.toJsonString(params) + ", sql:" + sql);
            ParameterUtils.saveOrUpdateParam(params, sql, false);
        } else {
            sql = "UPDATE T_BAS_SYSPARAMETER SET FDATA = ?, FACCTBOOKID = ?, FACCTINGBOOKID = ? WHERE FID = ? ";
            params.add(new SqlParameter(FDATA, 12, (Object)jsonData));
            params.add(new SqlParameter(FACCTBOOKID, -5, (Object)acctBookId));
            params.add(new SqlParameter(FACCTINGBOOKID, -5, (Object)acctingBookId));
            params.add(new SqlParameter(FID, 12, ((DynamicObject)existData.get(0)).get(0)));
            ParameterUtils.saveOrUpdateParam(params, sql, true);
            ParameterLog.info("ParameterWriter.saveSystemParameter update, params:" + SerializationUtils.toJsonString(params) + ", sql:" + sql);
        }
        logger.info("\u5e94\u7528\u53c2\u6570\u4fdd\u5b58\u65f6\uff0c\u6e05\u9664\u53c2\u6570\u7f13\u5b58\uff0ccloudId=" + cloudId + ", AppId=" + appId);
        if (isSysParam) {
            ParameterCache.removeParameter(cloudId, appId, appParam.getFormId());
        } else {
            ParameterCache.removeParameter(cloudId, appId);
        }
        ICoreProductSettingService settingService = (ICoreProductSettingService)ServiceFactory.getService(ICoreProductSettingService.class);
        settingService.clearAllCache();
    }

    private static boolean isSysParam(AppParam appParam) {
        boolean isSysParam;
        String cloudId = appParam.getCloudId();
        String appId = appParam.getAppId();
        boolean bl = isSysParam = StringUtils.isBlank((CharSequence)cloudId) && StringUtils.isBlank((CharSequence)appId);
        if (isSysParam && StringUtils.isBlank((CharSequence)appParam.getFormId())) {
            appParam.setFormId("bos_publicparametertpl");
        }
        return isSysParam;
    }

    @Deprecated
    public void saveSystemParameter(String viewType, long orgId, long acctBookId, String subSystem, String jsonData) {
        String sql = "SELECT FDATA FROM T_BAS_SYSPARAMETER WHERE FORGID=? AND FVIEWTYPEID=? AND FACCTBOOKID=? AND FSUBSYSTEM=?";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        params.add(new SqlParameter(FORGID, -5, (Object)orgId));
        params.add(new SqlParameter(FVIEWTYPEID, 12, (Object)viewType));
        params.add(new SqlParameter(FACCTBOOKID, -5, (Object)acctBookId));
        params.add(new SqlParameter(FSUBSYSTEM, 12, (Object)subSystem));
        DynamicObjectCollection existData = SingleORM.query(null, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
        if (existData == null || existData.isEmpty()) {
            sql = "INSERT INTO T_BAS_SYSPARAMETER (FORGID, FVIEWTYPEID, FACCTBOOKID, FSUBSYSTEM, FDATA) VALUES (?, ?, ?, ?, ?)";
            params.add(new SqlParameter(FDATA, 12, (Object)jsonData));
            ParameterUtils.saveOrUpdateParam(params, sql, false);
        } else {
            sql = "UPDATE T_BAS_SYSPARAMETER SET FDATA = ? WHERE FORGID=? AND FVIEWTYPEID=? AND FACCTBOOKID=? AND FSUBSYSTEM=? ";
            params.add(0, new SqlParameter(FDATA, 12, (Object)jsonData));
            ParameterUtils.saveOrUpdateParam(params, sql, true);
        }
    }

    @Deprecated
    public void saveSystemParameter(long orgId, long acctBookId, String subSystem, String jsonData) {
        String sql = "SELECT FDATA FROM T_BAS_SYSPARAMETER WHERE FORGID=? AND FACCTBOOKID=? AND FSUBSYSTEM=?";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        params.add(new SqlParameter(FORGID, -5, (Object)orgId));
        params.add(new SqlParameter(FACCTBOOKID, -5, (Object)acctBookId));
        params.add(new SqlParameter(FSUBSYSTEM, 12, (Object)subSystem));
        DynamicObjectCollection existData = SingleORM.query(null, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
        if (existData == null || existData.isEmpty()) {
            sql = "INSERT INTO T_BAS_SYSPARAMETER (FORGID, FACCTBOOKID, FSUBSYSTEM, FDATA) VALUES (?, ?, ?, ?)";
            params.add(new SqlParameter(FDATA, 12, (Object)jsonData));
            ParameterUtils.saveOrUpdateParam(params, sql, false);
        } else {
            sql = "UPDATE T_BAS_SYSPARAMETER SET FDATA = ? WHERE FORGID=? AND FACCTBOOKID=? AND FSUBSYSTEM=? ";
            params.add(0, new SqlParameter(FDATA, 12, (Object)jsonData));
            ParameterUtils.saveOrUpdateParam(params, sql, true);
        }
    }

    public void saveBillParameter(String formId, String jsonData) {
        String sql = "SELECT count(*) FROM T_BAS_BILLPARAMETER WHERE FFORMID=?";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        params.add(new SqlParameter(FFORMID, 12, (Object)formId));
        DynamicObjectCollection count = SingleORM.query(null, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
        if (count == null || count.isEmpty() || ((DynamicObject)count.get(0)).getLong(0) == 0L) {
            sql = "INSERT INTO T_BAS_BILLPARAMETER (FFORMID, FDATA) VALUES (?, ?)";
            params.add(new SqlParameter(FDATA, 12, (Object)jsonData));
            ParameterUtils.saveOrUpdateParam(params, sql, true);
        } else {
            sql = "UPDATE T_BAS_BILLPARAMETER SET FDATA = ? WHERE FFORMID=?";
            params.add(0, new SqlParameter(FDATA, 12, (Object)jsonData));
            ParameterUtils.saveOrUpdateParam(params, sql, false);
        }
        ParameterLocalCache.removeBillParameter(formId);
        ParameterCache.removeBillParamCache(formId);
    }

    public void saveBillParameter(String formId, Map<String, Object> params) {
        BillEntityType formDt;
        if (StringUtils.isNotBlank((CharSequence)formId) && params != null && (formDt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)formId)).getBillParameter() != null) {
            DynamicObject dataEntity = ParameterReader.getBillParameter((String)formId);
            if (dataEntity == null) {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)BOS_BILL_PARAMETER_TPL);
                dataEntity = new DynamicObject((DynamicObjectType)dt);
            }
            ParamDcBinder binder = new ParamDcBinder(dataEntity.getDynamicObjectType());
            binder.setOnlyDbProperty(false);
            binder.setSerializeDefaultValue(true);
            DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                dataEntity.set(key, value);
            }
            String jsonString = jser.serializeToString((Object)dataEntity, null);
            ParameterWriter.saveBillParameter((String)formId, (String)jsonString);
        }
    }

    public void saveUserOptionParameter(long userId, String formId, String extend, String jsonData, boolean isListOption) {
        this.saveUserOptionParameter(userId, formId, extend, isListOption ? UserParaType.LIST : UserParaType.DEFAULT, jsonData);
    }

    public void saveUserOptionParameter(long userId, String bizFormId, String extend, UserParaType paraType, String jsonData) {
        Map data;
        String sql = "SELECT count(*) FROM T_BAS_USERPARAMETER WHERE FUSERID=? AND FFORMID=? AND FEXTEND=? AND FISLISTOPTION=?";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        params.add(new SqlParameter(FUSERID, -5, (Object)userId));
        params.add(new SqlParameter(FFORMID, 12, (Object)bizFormId));
        params.add(new SqlParameter(FEXTEND, 12, (Object)(extend == null ? " " : extend)));
        params.add(new SqlParameter(FISLISTOPTION, 1, (Object)paraType.getValue()));
        DynamicObjectCollection count = SingleORM.query(null, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
        try (TXHandle h = TX.requiresNew();){
            if (count == null || count.isEmpty() || ((DynamicObject)count.get(0)).getLong(0) == 0L) {
                sql = "INSERT INTO T_BAS_USERPARAMETER (FUSERID, FFORMID, FEXTEND, FISLISTOPTION, FDATA) VALUES (?, ?, ?, ?, ?)";
                params.add(new SqlParameter(FDATA, 12, (Object)jsonData));
                DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
            } else {
                sql = "UPDATE T_BAS_USERPARAMETER SET FDATA = ? WHERE FUSERID = ? AND FFORMID=? AND FEXTEND=? AND FISLISTOPTION=? ";
                params.add(0, new SqlParameter(FDATA, 12, (Object)jsonData));
                DB.update((DBRoute)DBRoute.basedata, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)jsonData) && (data = (Map)SerializationUtils.fromJsonString((String)jsonData, Map.class)).get("_Type_") != null) {
            String paramFormId = data.get("_Type_").toString();
            ParameterCache.removeUserParamCache(bizFormId, userId, paraType, paramFormId + "." + (StringUtils.isBlank((CharSequence)extend) ? "" : extend));
        }
    }

    public void saveUserCustParameter(long userId, String formId, String paramKey, String paramValue) {
        String sql = "SELECT count(*) FROM T_BAS_USERPARAMETER WHERE FUSERID=? AND FFORMID=? AND FEXTEND=? AND FISLISTOPTION=?";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        params.add(new SqlParameter(FUSERID, -5, (Object)userId));
        params.add(new SqlParameter(FFORMID, 12, (Object)(StringUtils.isBlank((CharSequence)formId) ? " " : formId)));
        params.add(new SqlParameter(FEXTEND, 12, (Object)(StringUtils.isBlank((CharSequence)paramKey) ? " " : paramKey)));
        params.add(new SqlParameter(FISLISTOPTION, 16, (Object)Boolean.FALSE));
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getLong(1) > 0L;
                }
                return Boolean.FALSE;
            }
        };
        Boolean exist = (Boolean)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]), (ResultSetHandler)action);
        try (TXHandle h = TX.requiresNew();){
            if (!exist.booleanValue()) {
                sql = "INSERT INTO T_BAS_USERPARAMETER (FUSERID, FFORMID, FEXTEND, FISLISTOPTION, FDATA) VALUES (?, ?, ?, ?, ?)";
                params.add(new SqlParameter(FDATA, 12, (Object)paramValue));
                DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
            } else {
                sql = "UPDATE T_BAS_USERPARAMETER SET FDATA = ? WHERE FUSERID = ? AND FFORMID=? AND FEXTEND=? AND FISLISTOPTION=? ";
                params.add(0, new SqlParameter(FDATA, 12, (Object)paramValue));
                DB.update((DBRoute)DBRoute.base, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
            }
        }
        ParameterCache.removeCustParamCache(userId, formId, paramKey);
    }

    public void deleteUserCustParameter(String filter, SqlParameter[] params) {
        if (params == null || params.length == 0 || StringUtils.isBlank((CharSequence)filter)) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u5220\u9664\u7528\u6237\u81ea\u5b9a\u4e49\u53c2\u6570\u5931\u8d25\uff1a\u8bf7\u4f20\u5165\u5220\u9664\u6761\u4ef6", (String)"ParameterWriter_0", (String)"bos-dao", (Object[])new Object[0]));
        }
        String replaceAll = filter.replaceAll(" ", "");
        String eq = replaceAll.replaceAll("=", "");
        String eqw = replaceAll.replaceAll("=\\?", "");
        if ((replaceAll.length() - eq.length()) * 2 != replaceAll.length() - eqw.length()) {
            logger.info("To avoid SQL injection, it must be followed by?, Otherwise, do not delete the data");
            return;
        }
        String deleteSql = "DELETE FROM T_BAS_USERPARAMETER WHERE " + filter;
        try (TXHandle h = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.base, (String)deleteSql, (Object[])params);
        }
        ParameterCache.removeCustParamCache();
    }

    public void saveBillTypeParameter(String formId, long billTypeId, String jsonData) {
        if (billTypeId == 0L) {
            return;
        }
        String sql = " SELECT count(*) FROM T_BAS_BILLTYPEPARAMETER WHERE FFORMID=? AND FBILLTYPEID=? ";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        params.add(new SqlParameter(FFORMID, 12, (Object)formId));
        params.add(new SqlParameter(FBILLTYPEID, 12, (Object)billTypeId));
        DynamicObjectCollection count = SingleORM.query(null, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
        if (count == null || count.isEmpty() || ((DynamicObject)count.get(0)).getLong(0) == 0L) {
            sql = "INSERT INTO T_BAS_BILLTYPEPARAMETER (FFORMID, FBILLTYPEID, FDATA) VALUES (?, ?, ?)";
            params.add(new SqlParameter(FDATA, 12, (Object)jsonData));
            ParameterUtils.saveOrUpdateParam(params, sql, false);
        } else {
            sql = "UPDATE T_BAS_BILLTYPEPARAMETER SET FDATA = ? WHERE FFORMID=? AND FBILLTYPEID=? ";
            params.add(0, new SqlParameter(FDATA, 12, (Object)jsonData));
            ParameterUtils.saveOrUpdateParam(params, sql, true);
        }
        ParameterLocalCache.removeBillTypeParameter(formId, billTypeId);
        ParameterCache.removeBillTypeParamCache(formId, billTypeId);
    }

    public ParamOperationResult saveSmallKParameter(Map<String, Object> params) {
        ParamOperationResult result = new ParamOperationResult(true);
        DynamicObject dataEntity = ParameterReader.getPublicParameter();
        if (dataEntity == null) {
            ParamPublishObject param = ParameterReader.getParameterObject(null, null);
            if (param == null) {
                result.setSuccess(false);
                result.setMesseage(ResManager.loadKDString((String)"\u8868\u5355ID\u4e0d\u5b58\u5728\uff01", (String)"ParameterWriter_1", (String)"bos-dao", (Object[])new Object[0]));
                return result;
            }
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)param.getFormId());
            dataEntity = new DynamicObject((DynamicObjectType)mainEntityType);
        }
        for (Map.Entry entry : params.entrySet()) {
            if (!Arrays.asList(keys).contains(entry.getKey())) continue;
            dataEntity.set((String)entry.getKey(), entry.getValue());
        }
        String data = this.serialParams(dataEntity);
        ParameterWriter.saveSystemParameter(null, null, (String)"0", (long)0L, (long)0L, (String)data);
        return result;
    }

    public void removeParameterCache(String cloudId, String appId) {
        ParameterCache.removeParameter(cloudId, appId);
    }

    public void removeBatchParameterCache(String cloudId, String appId) {
        ParameterCache.removeBatchParameter(cloudId, appId);
    }

    private String serialParams(DynamicObject dataEntity) {
        ParamDcBinder binder = new ParamDcBinder(dataEntity.getDynamicObjectType());
        binder.setOnlyDbProperty(false);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setSerializeComplexProperty(false);
        return jser.serializeToString((Object)dataEntity, null);
    }
}

