/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.cache.CacheKeyUtil;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.BindingContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.log.service.elasticsearch.ElasticsearchService;
import kd.bos.log.service.util.EsPropertiesUtils;
import kd.bos.log.utils.EsSearchPluginCacheUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.ClientViewProxy;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;

public class LogEsSearchPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static final Log logger = LogFactory.getLog(LogEsSearchPlugin.class);
    private static final String BUTTON_REFRESH = "refresh";
    private static final String BUTTON_GO_HISTORY = "goback";
    private static final String START_DATE_KEY = "start_date";
    private static final String END_DATE_KEY = "end_date";
    private static final String PREVIOUS_KEY = "previous";
    private static final String NEXT_KEY = "next";
    private static final String CURRENT_KEY = "current";
    private static final String TOTAL_NUM_KEY = "total_num_new";
    private static final String PAGE_SELECT_KEY = "pageselect";
    private static final String TOTAL_PAGE_KEY = "totalpage";
    private static final String CURRENT_PAGE_NUM = "pagenum";

    public void initialize() {
        super.initialize();
    }

    public void afterBindData(EventObject e) {
        this.buildEsConfig();
        EsSearchPluginCacheUtils.updatePageIndex(this.getPageCache(), EsSearchPluginCacheUtils.Step.INIT);
        EsSearchPluginCacheUtils.initSearchAfterToCache(this.getPageCache());
        this.bindEntryData(EsSearchPluginCacheUtils.Step.INIT);
        this.dealLanguage();
    }

    private void dealLanguage() {
        if (RequestContext.get().getLang() == Lang.en_US) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"labelap6"});
            Label labelPage = (Label)this.getView().getControl("labelap4");
            labelPage.setText("Page");
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Date now = new Date();
        this.getModel().setValue(START_DATE_KEY, (Object)this.getStartOfDay(now));
        this.getModel().setValue(END_DATE_KEY, (Object)this.getEndOfDay(now));
    }

    private void bindEntryData(EsSearchPluginCacheUtils.Step step) {
        Date start = (Date)this.getModel().getValue(START_DATE_KEY);
        Date end = (Date)this.getModel().getValue(END_DATE_KEY);
        if (start == null || end == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65f6\u95f4\u7b5b\u9009\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LogEsSearchPlugin_8", (String)"bos-log-formplugin", (Object[])new Object[0]));
            return;
        }
        MainEntityType met = this.getModel().getDataEntityType();
        EntryGrid entry = (EntryGrid)this.getView().getControl("entryentity");
        Date now = new Date();
        DateTimeEdit startTimeEdit = (DateTimeEdit)this.getView().getControl(START_DATE_KEY);
        DateTimeEdit endTimeEdit = (DateTimeEdit)this.getView().getControl(END_DATE_KEY);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        startTimeEdit.setRelatedDate(simpleDateFormat.format(this.getStartOfDay(now)));
        endTimeEdit.setRelatedDate(simpleDateFormat.format(now));
        DynamicObject dataEntity = (DynamicObject)met.createInstance();
        DynamicObjectCollection doc = this.getEntryData(dataEntity, step);
        ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        if (doc == null || doc.size() <= 0) {
            Label labelPage = (Label)this.getView().getControl(TOTAL_PAGE_KEY);
            labelPage.setText(String.format(ResManager.loadKDString((String)"\u5171%d\u9875", (String)"LogEsSearchPlugin_5", (String)"bos-log-formplugin", (Object[])new Object[0]), 1));
            this.updateLabel(1);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TOTAL_NUM_KEY});
            HashMap<String, Cloneable> data = new HashMap<String, Cloneable>();
            data.put("rows", new ArrayList());
            data.put("dataindex", new HashMap());
            client.setEntryProperty("entryentity", "data", data);
            return;
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{TOTAL_NUM_KEY});
        ArrayList<List> rows = new ArrayList<List>();
        IDataEntityType entityType = ((DynamicObject)doc.get(0)).getDataEntityType();
        int i = 0;
        for (DynamicObject obj : doc) {
            BindingContext bindCtx = new BindingContext(entityType, obj, i++);
            rows.add(entry.getRowBindValue(bindCtx));
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("rows", rows);
        data.put("dataindex", entry.getDataIndex());
        client.setEntryProperty("entryentity", "data", data);
    }

    private DynamicObjectCollection getEntryData(DynamicObject dataEntity, EsSearchPluginCacheUtils.Step step) {
        DynamicObjectCollection doc = (DynamicObjectCollection)dataEntity.get("entryentity");
        doc.clear();
        ElasticsearchService service = ElasticsearchService.getInstance();
        try {
            String[] searchTime;
            Properties properties = this.buildEsConfig();
            if (properties == null) {
                return null;
            }
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            String searchFields = this.getPageCache().get(this.searchConditionKey());
            if (StringUtils.isNotEmpty((CharSequence)searchFields) && !"null".equals(searchFields)) {
                List condition = (List)JSONObject.parseObject((String)searchFields, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
                param.put("search", condition);
            }
            if ((searchTime = this.getSearchTime()) != null) {
                param.put("opTime", searchTime);
            }
            Integer limit = this.getPageSelect();
            param.put("limit", limit);
            Object[] searchAfterCurrent = EsSearchPluginCacheUtils.getSearchAfterFromCache(this.getPageCache(), step);
            param.put("searchAfter", searchAfterCurrent);
            SearchHits result = service.search(param, properties.getProperty("index"));
            Object[] searchAfterNext = null;
            if (EsSearchPluginCacheUtils.Step.INIT == step) {
                Label currentPage = (Label)this.getView().getControl(CURRENT_PAGE_NUM);
                currentPage.setText("1");
            }
            if (result != null) {
                SearchHit[] hits = result.getHits();
                Label label = (Label)this.getView().getControl(TOTAL_NUM_KEY);
                label.setText(String.format(ResManager.loadKDString((String)"\u5171%d\u6761", (String)"LogEsSearchPlugin_1", (String)"bos-log-formplugin", (Object[])new Object[0]), result.getTotalHits()));
                long totalNum = result.getTotalHits();
                int selectNumPage = this.getPageSelect();
                long totalPage = 1L;
                if (totalNum > 0L) {
                    long pageNum = totalNum % (long)selectNumPage;
                    totalPage = pageNum > 0L ? totalNum / (long)selectNumPage + 1L : totalNum / (long)selectNumPage;
                }
                Label labelPage = (Label)this.getView().getControl(TOTAL_PAGE_KEY);
                labelPage.setText(String.format(ResManager.loadKDString((String)"\u5171%d\u9875", (String)"LogEsSearchPlugin_5", (String)"bos-log-formplugin", (Object[])new Object[0]), totalPage));
                EsSearchPluginCacheUtils.saveTotalPageToCache(this.getPageCache(), totalPage);
                for (int i = 0; i < hits.length; ++i) {
                    SearchHit hit = hits[i];
                    Map temp = hit.getSourceAsMap();
                    DynamicObject row = doc.addNew();
                    row.set("id", (Object)i);
                    row.set("seq", (Object)i);
                    Date date = new Date(Long.parseLong(String.valueOf(temp.get("opTime"))));
                    row.set("username", temp.get("userName"));
                    row.set("account", temp.get("account"));
                    row.set("number", temp.get("number"));
                    row.set("orgname", temp.get("orgName"));
                    row.set("bizappname", temp.get("bizAppName"));
                    row.set("bizobjname", temp.get("bizObjName"));
                    row.set("opname", temp.get("opName"));
                    row.set("opdescription", temp.get("opDescription"));
                    row.set("optime", (Object)date);
                    row.set("clienttype", temp.get("clientType"));
                    row.set("clientip", temp.get("clientIp"));
                    row.set("clientname", temp.get("clientName"));
                    if (i != hits.length - 1) continue;
                    searchAfterNext = hit.getSortValues();
                }
            }
            EsSearchPluginCacheUtils.updateSearchAfterToCache(this.getPageCache(), searchAfterCurrent, searchAfterNext);
            return doc;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u673a\u64cd\u4f5c\u65e5\u5fd7elasticsearch\u65e5\u5fd7\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{PREVIOUS_KEY, NEXT_KEY});
    }

    private void updateLabel(int index) {
        Label labelPage = (Label)this.getView().getControl(CURRENT_PAGE_NUM);
        labelPage.setText(String.valueOf(index));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button) {
            int currentPage;
            String key = ((Button)source).getKey();
            if (NEXT_KEY.equals(key)) {
                long totalPage;
                int currentPage2 = EsSearchPluginCacheUtils.getCurrentPageIndex(this.getPageCache());
                if ((long)currentPage2 < (totalPage = EsSearchPluginCacheUtils.getTotalPageFromCache(this.getPageCache()))) {
                    int index = currentPage2 + 1;
                    this.updateLabel(index);
                    EsSearchPluginCacheUtils.updatePageIndex(this.getPageCache(), EsSearchPluginCacheUtils.Step.NEXT);
                    this.bindEntryData(EsSearchPluginCacheUtils.Step.NEXT);
                }
            } else if (PREVIOUS_KEY.equals(key) && (currentPage = EsSearchPluginCacheUtils.getCurrentPageIndex(this.getPageCache())) > 1) {
                int index = currentPage - 1;
                this.updateLabel(index);
                EsSearchPluginCacheUtils.updatePageIndex(this.getPageCache(), EsSearchPluginCacheUtils.Step.PREVIOUS);
                this.bindEntryData(EsSearchPluginCacheUtils.Step.PREVIOUS);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "refresh": {
                this.bindEntryData(EsSearchPluginCacheUtils.Step.CURRENT);
                break;
            }
            case "goback": {
                this.goToHistoryPage();
                break;
            }
        }
    }

    private void goToHistoryPage() {
        ListShowParameter fsp = new ListShowParameter();
        String pageId = this.getView().getPageId();
        String newPageId = pageId + "|bos_log_operation";
        fsp.setPageId(newPageId);
        IFormView iformView = this.getView().getView(newPageId);
        if (iformView != null) {
            Tab tab = (Tab)this.getView().getParentView().getControl("_submaintab_");
            if (tab != null) {
                tab.activeTab(newPageId);
                this.getView().sendFormAction(this.getView().getParentView());
            } else {
                tab = (Tab)this.getView().getParentView().getParentView().getControl("_submaintab_");
                if (tab != null) {
                    tab.activeTab(newPageId);
                    this.getView().sendFormAction(this.getView().getParentView().getParentView());
                }
            }
            return;
        }
        fsp.setBillFormId("bos_log_operation");
        fsp.setShowTitle(true);
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)fsp);
    }

    private String searchConditionKey() {
        return CacheKeyUtil.getAcctId() + "log-search-elasticsearch";
    }

    private String propertiesCacheKey() {
        return CacheKeyUtil.getAcctId() + "log-search-elasticsearch-properties";
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        Properties properties = this.buildEsConfig();
        if (properties == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u672a\u914d\u7f6eES\u65e5\u5fd7\u6240\u9700\u7684Elasticsearch\u4fe1\u606f\uff0c\u5982\u9700\u67e5\u8be2\u65e5\u5fd7\uff0c\u8bf7\u524d\u5f80\u4e0a\u673a\u64cd\u4f5c\u65e5\u5fd7\u67e5\u8be2\u3002", (String)"LogEsSearchPlugin_0", (String)"bos-log-formplugin", (Object[])new Object[0]));
            return;
        }
        List searchFields = searchEnterEvent.getSearchFields();
        if (CollectionUtils.isNotEmpty((Collection)searchFields)) {
            this.getPageCache().put(this.searchConditionKey(), JSONObject.toJSONString((Object)searchFields));
        } else {
            this.getPageCache().remove(this.searchConditionKey());
        }
        EsSearchPluginCacheUtils.updatePageIndex(this.getPageCache(), EsSearchPluginCacheUtils.Step.INIT);
        EsSearchPluginCacheUtils.initSearchAfterToCache(this.getPageCache());
        this.bindEntryData(EsSearchPluginCacheUtils.Step.INIT);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (END_DATE_KEY.equals(fieldKey) || START_DATE_KEY.equals(fieldKey)) {
            Date start = (Date)this.getModel().getValue(START_DATE_KEY);
            Date end = (Date)this.getModel().getValue(END_DATE_KEY);
            if (END_DATE_KEY.equals(fieldKey)) {
                if (end == null) {
                    return;
                }
                if (start == null) {
                    return;
                }
                if (end.before(start)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u5e94\u665a\u4e8e\u8d77\u59cb\u65f6\u95f4\u3002", (String)"LogEsSearchPlugin_3", (String)"bos-log-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                if (start == null) {
                    return;
                }
                if (end == null) {
                    return;
                }
                if (start.after(end)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u59cb\u65f6\u95f4\u5e94\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4\u3002", (String)"LogEsSearchPlugin_4", (String)"bos-log-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"LogEsSearchPlugin_2", (String)"bos-log-formplugin", (Object[])new Object[0])));
            EsSearchPluginCacheUtils.updatePageIndex(this.getPageCache(), EsSearchPluginCacheUtils.Step.INIT);
            EsSearchPluginCacheUtils.initSearchAfterToCache(this.getPageCache());
            this.bindEntryData(EsSearchPluginCacheUtils.Step.INIT);
            this.getView().hideLoading();
        } else if (PAGE_SELECT_KEY.equals(fieldKey)) {
            logger.info("\u5206\u9875\u6570\u88ab\u9009\u62e9");
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"LogEsSearchPlugin_2", (String)"bos-log-formplugin", (Object[])new Object[0])));
            EsSearchPluginCacheUtils.updatePageIndex(this.getPageCache(), EsSearchPluginCacheUtils.Step.INIT);
            EsSearchPluginCacheUtils.initSearchAfterToCache(this.getPageCache());
            this.bindEntryData(EsSearchPluginCacheUtils.Step.INIT);
            this.getView().hideLoading();
        }
    }

    private String[] getSearchTime() {
        Date start = (Date)this.getModel().getValue(START_DATE_KEY);
        Date end = (Date)this.getModel().getValue(END_DATE_KEY);
        if (start != null && end != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String startTime = simpleDateFormat.format(start);
            String endTime = simpleDateFormat.format(end);
            return new String[]{startTime, endTime};
        }
        return null;
    }

    private Map<String, List<String>> parseSearchConditionNew(List<Map<String, Object>> condition) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (int i = 0; i < condition.size(); ++i) {
            Map<String, Object> temp = condition.get(i);
            List fieldName = (List)temp.get("fieldName");
            List value = (List)temp.get("value");
            for (int j = 0; j < fieldName.size(); ++j) {
                String key = (String)fieldName.get(j);
                if (!result.containsKey(key)) {
                    result.put(key, new ArrayList());
                }
                ((List)result.get(key)).addAll(value);
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties initEsConfig() {
        JSONObject properties2 = EsPropertiesUtils.getTenantEsProperties();
        if (properties2 == null) return null;
        if (properties2.size() <= 0) return null;
        Properties config = new Properties();
        config.put("hostname", properties2.getString("host"));
        config.put("port", properties2.getString("port"));
        config.put("userName", properties2.getString("userName"));
        config.put("password", properties2.getString("passwd"));
        config.put("scheme", properties2.getString("schema"));
        String sql = "select top 6,0 fid,fname from t_log_index where fstatus='1' order by fcreatetime desc";
        try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.log, (String)sql);){
            ArrayList<String> indies = new ArrayList<String>(10);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String index = row.getString(1);
                indies.add(index);
            }
            if (indies.size() > 0) {
                config.put("index", String.join((CharSequence)",", indies));
            }
            Properties properties = config;
            return properties;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return null;
    }

    private Properties buildEsConfig() {
        String cache = this.getPageCache().get(this.propertiesCacheKey());
        if (StringUtils.isEmpty((CharSequence)cache)) {
            Properties properties = this.initEsConfig();
            if (properties != null) {
                this.getPageCache().put(this.propertiesCacheKey(), JSON.toJSONString((Object)properties));
                return properties;
            }
            return null;
        }
        Properties temp = (Properties)JSON.parseObject((String)cache, Properties.class);
        return temp;
    }

    private Date getEndOfDay(Date date) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime endOfDay = localDateTime.with(LocalTime.MAX);
        return Date.from(endOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }

    private Date getStartOfDay(Date date) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime startOfDay = localDateTime.with(LocalTime.MIN);
        return Date.from(startOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }

    private Integer getPageSelect() {
        String select = String.valueOf(this.getModel().getValue(PAGE_SELECT_KEY));
        for (PageEnum pageEnum : PageEnum.values()) {
            if (!pageEnum.getKey().equals(select)) continue;
            return pageEnum.getNum();
        }
        return PageEnum.TWENTY.getNum();
    }

    public static enum PageEnum {
        FIVE("1", 5),
        TEN("2", 10),
        TWENTY("3", 20),
        FIFTY("4", 50),
        ONE_HUNDRED("5", 100),
        TWO_HUNDRED("6", 200),
        FIVE_HUNDRED("7", 500),
        ONE_THOUSAND("8", 1000),
        TEN_THOUSAND("9", 10000);

        private String key;
        private Integer num;

        private PageEnum(String key, Integer num) {
            this.key = key;
            this.num = num;
        }

        public String getKey() {
            return this.key;
        }

        public Integer getNum() {
            return this.num;
        }
    }
}

