/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.sql.Date;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Properties;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.id.ID;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.log.formplugin.StrategyEnum;
import kd.bos.log.service.elasticsearch.ElasticsearchService;
import kd.bos.log.service.util.EsPropertiesUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import org.apache.commons.collections4.CollectionUtils;

public class LogIndexListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(LogIndexListPlugin.class);
    private static final String BUTTON_INIT = "inites";

    public void initialize() {
        super.initialize();
        this.checkButtonInitStatus();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "inites": {
                try {
                    this.initEsIndex();
                    ((ListView)this.getView()).refresh();
                }
                catch (Exception e) {
                    logger.error("\u4e0a\u673a\u64cd\u4f5c\u65e5\u5fd7ES\u7d22\u5f15\u521d\u59cb\u5316\u5f02\u5e38", (Throwable)e);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u65e5\u5fd7ES\u7d22\u5f15\u521d\u59cb\u5316\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"LogIndexListPlugin_3", (String)"bos-log-formplugin", (Object[])new Object[0]));
                }
                break;
            }
        }
    }

    private void initEsIndex() throws Exception {
        JSONObject properties = EsPropertiesUtils.getTenantEsProperties();
        if (properties == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u65e5\u5fd7ES\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"LogIndexListPlugin_0", (String)"bos-log-formplugin", (Object[])new Object[0]));
            return;
        }
        String indexTep = properties.getString("indexTep").toLowerCase();
        LocalDate now = LocalDate.now();
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("yyyy-MM");
        String time = now.format(timeFormatter);
        String tenantId = RequestContext.get().getTenantId().toLowerCase();
        String accountId = RequestContext.get().getAccountId().toLowerCase();
        if (!indexTep.contains(tenantId) || !indexTep.contains(accountId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u65e5\u5fd7ES\u914d\u7f6e\u7d22\u5f15\u6a21\u677f\u7684\u79df\u6237ID\u548c\u6570\u636e\u4e2d\u5fc3ID\u4e0e\u5f53\u524d\u73af\u5883\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"LogIndexListPlugin_1", (String)"bos-log-formplugin", (Object[])new Object[0]));
            return;
        }
        String createIndex = indexTep.replace("*", time) + "-1";
        logger.info("\u811a\u672c\u5347\u7ea7\u4e0a\u673a\u64cd\u4f5c\u65e5\u5fd7ES\u7d22\u5f15\u521b\u5efa\u5347\u7ea7\uff0c\u521b\u5efa\u7d22\u5f15\u4e3a\uff1a" + createIndex);
        ElasticsearchService service = ElasticsearchService.getInstance();
        boolean result = service.createIndex(createIndex);
        if (!result) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u65e5\u5fd7ES\u7d22\u5f15\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"LogIndexListPlugin_2", (String)"bos-log-formplugin", (Object[])new Object[0]));
            return;
        }
        long id = ID.genLongId();
        String sql = "insert into t_log_index (fid,fname,fcreatetime,fstatus,fstrategy) values (?,?,?,?,?)";
        Object[] record = new Object[]{id, createIndex, new Date(System.currentTimeMillis()), "1", LogIndexListPlugin.getCurrentStrategy().getValue()};
        DB.execute((DBRoute)DBRoute.log, (String)sql, (Object[])record);
    }

    private static StrategyEnum getCurrentStrategy() {
        JSONObject properties = EsPropertiesUtils.getTenantEsIndexStrategy();
        StrategyEnum strategy = StrategyEnum.NO_ONE;
        if (properties != null) {
            if (properties.containsKey((Object)"time") && properties.containsKey((Object)"capacity")) {
                strategy = StrategyEnum.TIMEWITHCAPACITY;
            } else if (properties.containsKey((Object)"time")) {
                strategy = StrategyEnum.TIME;
            } else if (properties.containsKey((Object)"capacity")) {
                strategy = StrategyEnum.CAPACITY;
            }
        }
        return strategy;
    }

    private void checkButtonInitStatus() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BUTTON_INIT});
        Properties config = this.initEsConfig();
        if (config != null && !config.containsKey("index")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BUTTON_INIT});
        }
    }

    private Properties initEsConfig() {
        JSONObject properties = EsPropertiesUtils.getTenantEsProperties();
        if (properties != null && properties.size() > 0) {
            ArrayList<String> indies;
            Properties config = new Properties();
            config.put("hostname", properties.getString("host"));
            config.put("port", properties.getString("port"));
            config.put("userName", properties.getString("userName"));
            config.put("password", properties.getString("passwd"));
            config.put("scheme", properties.getString("schema"));
            String sql = "select top 6,0 fid,fname from t_log_index where fstatus='1' order by fcreatetime desc";
            try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.log, (String)sql);){
                indies = new ArrayList<String>(10);
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    String index = row.getString(1);
                    indies.add(index);
                }
            }
            if (CollectionUtils.isNotEmpty(indies)) {
                config.put("index", String.join((CharSequence)",", indies));
            }
            return config;
        }
        return null;
    }
}

