/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.formplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterHint;
import kd.bos.orm.query.fulltext.QMatches;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class LogOpearteListColumnHelper {
    private List<ColumnItem> columnItemList = new ArrayList<ColumnItem>(4);

    void addColumnItem(ColumnItem item) {
        this.columnItemList.add(item);
    }

    void handFilter(QFilter qFilter) {
        for (ColumnItem item : this.columnItemList) {
            if (item.handFilter == null) continue;
            item.handFilter.handFilter(qFilter, item.propName, item.searchValue);
        }
    }

    void handColumnPackage(PackageDataEvent e) {
        Object source = e.getSource();
        if (!(source instanceof ColumnDesc)) {
            return;
        }
        ColumnDesc columnDesc = (ColumnDesc)source;
        for (ColumnItem item : this.columnItemList) {
            if (StringUtils.isEmpty((CharSequence)item.searchValue) || !StringUtils.equals((CharSequence)item.propName, (CharSequence)columnDesc.getKey()) || !StringUtils.isBlank((Object)e.getFormatValue())) continue;
            String[] array = item.propName.split("\\.");
            if (array.length != 2) {
                e.setFormatValue((Object)item.searchValue);
                continue;
            }
            String replacePropName = array[0] + "_id";
            Object replacePropValue = e.getRowData().get(replacePropName);
            if (replacePropValue instanceof Long) {
                Long userId = (Long)replacePropValue;
                if (userId == 0L || userId == -1L) {
                    e.setFormatValue((Object)item.searchValue);
                    continue;
                }
                e.setFormatValue((Object)userId);
                continue;
            }
            if (StringUtils.isBlank((Object)replacePropValue)) {
                e.setFormatValue((Object)item.searchValue);
                continue;
            }
            e.setFormatValue((Object)String.valueOf(replacePropValue));
        }
    }

    static class ColumnItem {
        private String propName;
        private String searchValue;
        private LogHandFilter handFilter;

        public ColumnItem(String propName, LogHandFilter handFilter) {
            this.propName = propName;
            this.handFilter = handFilter;
        }

        public ColumnItem(String propName, String searchValue) {
            this.propName = propName;
            this.searchValue = searchValue;
        }
    }

    @FunctionalInterface
    static interface LogHandFilter {
        public boolean handFilter(QFilter var1, String var2, String var3);
    }

    @SdkInternal
    public static class FastSearchFilter
    implements LogHandFilter {
        @Override
        public boolean handFilter(QFilter qFilter, String propName, String searchValue) {
            if (QMatches.isFtlike((QFilter)qFilter)) {
                qFilter.setQFilterHint((QFilterHint)QFilterHint.FTLIKE_STARTWITH);
                return true;
            }
            return false;
        }
    }
}

