/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.formplugin;

import com.tongtech.backport.java.util.Collections;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ChatEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.log.formplugin.LogOpearteListColumnHelper;
import kd.bos.log.service.LogSaveService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.service.InitailVersionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.svc.util.TimeFilterLimitUtils;
import kd.bos.util.CollectionUtils;

public class LogOperactionListPluginV3
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(LogOperactionListPluginV3.class);
    private TimeFilterLimitUtils timeFilterLimitUtils = new TimeFilterLimitUtils();
    private LogOpearteListColumnHelper listColumnHelper;
    private String anonymousUser = ResManager.loadKDString((String)"\u533f\u540d\u7528\u6237", (String)"LogOperactionListPluginV3_0", (String)"bos-log-formplugin", (Object[])new Object[0]);
    private String anonymousApp = ResManager.loadKDString((String)"\u7a7a\u5e94\u7528", (String)"LogOperactionListPluginV3_1", (String)"bos-log-formplugin", (Object[])new Object[0]);
    private String anonymousObj = ResManager.loadKDString((String)"\u7a7a\u5bf9\u8c61", (String)"LogOperactionListPluginV3_2", (String)"bos-log-formplugin", (Object[])new Object[0]);
    private String anonymousOrg = ResManager.loadKDString((String)"\u533f\u540d\u7ec4\u7ec7", (String)"LogOperactionListPluginV3_3", (String)"bos-log-formplugin", (Object[])new Object[0]);
    private static String[] queryKeys = new String[]{"opkey", "opproj", "opres"};

    private LogOpearteListColumnHelper getListColumnHelper() {
        if (this.listColumnHelper != null) {
            return this.listColumnHelper;
        }
        this.listColumnHelper = new LogOpearteListColumnHelper();
        this.listColumnHelper.addColumnItem(new LogOpearteListColumnHelper.ColumnItem("optime", (qFilter, propName, searchValue) -> {
            if (!TimeFilterLimitUtils.check((List)Collections.singletonList((Object)qFilter), (List)Collections.singletonList((Object)"optime"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u65f6\u95f4\u67e5\u8be2\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc7%d\u4e2a\u6708\u3002", (String)"LogOperactionListPlugin_0", (String)"bos-log-formplugin", (Object[])new Object[0]), 3));
            }
            return false;
        }));
        this.listColumnHelper.addColumnItem(new LogOpearteListColumnHelper.ColumnItem("user.name", this.anonymousUser));
        this.listColumnHelper.addColumnItem(new LogOpearteListColumnHelper.ColumnItem("bizapp.name", this.anonymousApp));
        this.listColumnHelper.addColumnItem(new LogOpearteListColumnHelper.ColumnItem("bizobj.name", this.anonymousObj));
        this.listColumnHelper.addColumnItem(new LogOpearteListColumnHelper.ColumnItem("org.name", this.anonymousOrg));
        this.listColumnHelper.addColumnItem(new LogOpearteListColumnHelper.ColumnItem("keyword,opname", new LogOpearteListColumnHelper.FastSearchFilter()));
        return this.listColumnHelper;
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        if (qFilters == null || qFilters.isEmpty()) {
            return;
        }
        for (QFilter qFilter : qFilters) {
            this.getListColumnHelper().handFilter(qFilter);
        }
        if (qFilters.size() > 1) {
            QFilter qFilter = (QFilter)qFilters.get(0);
            for (int i = 0; i < qFilters.size(); ++i) {
                QFilter filter = (QFilter)qFilters.get(i);
                if (!"optime".equals(filter.getProperty())) continue;
                qFilters.set(0, filter);
                qFilters.set(i, qFilter);
                break;
            }
        }
    }

    public void initialize() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.setOrderBy("optime desc");
        if (!LogOperactionListPluginV3.isZHCNEnv()) {
            billList.addCreateListDataProviderListener(beforeCreateListDataProviderArgs -> {
                MyListDataProvider listDataProvider = new MyListDataProvider();
                beforeCreateListDataProviderArgs.setListDataProvider((IListDataProvider)listDataProvider);
            });
        }
    }

    public void afterCreateNewData(EventObject e) {
        InitailVersionService service = (InitailVersionService)ServiceFactory.getService(InitailVersionService.class);
        boolean initailVersion = service.isInitailVersion(7);
        if (initailVersion) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"history_operation_log"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setMaxPageSize(Integer.valueOf(100));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (!(args.getSource() instanceof FormOperate)) {
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("logarchive".equalsIgnoreCase(operateKey)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_log_etl_page");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.getOpenStyle().setTargetKey("");
            parameter.setCaption(ResManager.loadKDString((String)"\u4e0a\u673a\u64cd\u4f5c\u65e5\u5fd7\u5f52\u6863\u8bbe\u7f6e", (String)"LogOperactionListPlugin_10", (String)"bos-log-formplugin", (Object[])new Object[0]));
            this.getView().showForm(parameter);
        } else if ("archive_search".equalsIgnoreCase(operateKey)) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("bos_log_archive_v3");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.getOpenStyle().setTargetKey("");
            parameter.setCaption(ResManager.loadKDString((String)"\u4e0a\u673a\u64cd\u4f5c\u5f52\u6863\u65e5\u5fd7", (String)"LogOperactionListPlugin_9", (String)"bos-log-formplugin", (Object[])new Object[0]));
            this.getView().showForm((FormShowParameter)parameter);
        } else if ("viewdetail".equals(operateKey)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            String opDesc = "";
            FormShowParameter formShowParameter = new FormShowParameter();
            OpenStyle style = new OpenStyle();
            style.setShowType(ShowType.Modal);
            formShowParameter.setOpenStyle(style);
            formShowParameter.setFormId("bos_log_operation_detail");
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u63cf\u8ff0", (String)"LogOperactionListPluginV3_4", (String)"bos-log-formplugin", (Object[])new Object[0]));
            formShowParameter.setCustomParam("content", (Object)opDesc);
            ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
            if (currentSelectedRowInfo == null) {
                this.getView().showForm(formShowParameter);
                return;
            }
            Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
            if (primaryKeyValue == null) {
                this.getView().showForm(formShowParameter);
                return;
            }
            String billListEntityId = ((IListView)this.getView()).getBillFormId();
            if (StringUtils.isBlank((CharSequence)billListEntityId)) {
                this.getView().showForm(formShowParameter);
                return;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)billListEntityId, (String)"opdesc,opdescproj,opdescres,opdescargs", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)});
            opDesc = LogOperactionListPluginV3.valueOf(dynamicObject.get("opdesc"));
            String opDescProj = LogOperactionListPluginV3.valueOf(dynamicObject.get("opdescproj"));
            String opDescRes = LogOperactionListPluginV3.valueOf(dynamicObject.get("opdescres"));
            String opDescArgs = LogOperactionListPluginV3.valueOf(dynamicObject.get("opdescargs"));
            opDesc = LogSaveService.getOpDisplayDesc((Lang)Lang.get(), (String)opDesc, (String)opDescProj, (String)opDescRes, (String)opDescArgs);
            formShowParameter.setCustomParam("content", (Object)opDesc);
            this.getView().showForm(formShowParameter);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("history_operation_log".equals(itemKey)) {
            this.openHistoryLog();
        }
    }

    private void openHistoryLog() {
        ListShowParameter parameter = new ListShowParameter();
        String billFormId = "bos_log_operation_web";
        parameter.setBillFormId(billFormId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        IFormView view = this.getView();
        if (view == null) {
            return;
        }
        IFormView mainView = view.getMainView();
        if (mainView == null) {
            view.showForm((FormShowParameter)parameter);
            return;
        }
        String mainPageId = mainView.getPageId();
        String formPageId = billFormId + mainPageId;
        parameter.setPageId(formPageId);
        IFormView formView = view.getViewNoPlugin(formPageId);
        if (formView != null) {
            formView.activate();
            view.sendFormAction(formView);
            return;
        }
        view.showForm((FormShowParameter)parameter);
    }

    public void chat(ChatEvent e) {
        e.setCancel(true);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List fastFilterColumns = args.getFastFilterColumns();
        if (!LogOperactionListPluginV3.isZHCNEnv()) {
            Iterator iterator = fastFilterColumns.iterator();
            while (iterator.hasNext()) {
                FilterColumn next = (FilterColumn)iterator.next();
                if (!"opname".equals(next.getFieldName())) continue;
                iterator.remove();
            }
        }
    }

    public void packageData(PackageDataEvent e) {
        this.getListColumnHelper().handColumnPackage(e);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
    }

    private static boolean isZHCNEnv() {
        return RequestContext.get().getLang() == Lang.zh_CN;
    }

    private static String valueOf(Object val) {
        if (StringUtils.isNotBlank((Object)val)) {
            return (String)val;
        }
        return "";
    }

    private static class MyListDataProvider
    extends ListDataProvider {
        private MyListDataProvider() {
        }

        protected boolean isRegisterProperty() {
            return true;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            long t1 = System.currentTimeMillis();
            QueryBuilder queryBuilder = super.getQueryBuilder();
            String selectFields = queryBuilder.getSelectFields();
            DynamicObjectType returnEntityType = queryBuilder.getReturnEntityType();
            StringBuilder builder = new StringBuilder();
            builder.append(selectFields);
            for (String key : queryKeys) {
                DynamicSimpleProperty simpleProperty = new DynamicSimpleProperty(key, String.class, (Object)"");
                returnEntityType.registerSimpleProperty(simpleProperty);
                builder.append(",").append(key);
            }
            queryBuilder.setSelectFields(builder.toString());
            DynamicObjectCollection rows = super.getData(start, limit);
            long t2 = System.currentTimeMillis();
            logger.debug("getData\u8017\u65f6\uff1a" + (t2 - t1));
            HashSet<String> entityNums = new HashSet<String>();
            for (DynamicObject row : rows) {
                String entityNum = LogOperactionListPluginV3.valueOf(row.get("bizobj.number"));
                String opkey = LogOperactionListPluginV3.valueOf(row.get("opkey"));
                String opproj = LogOperactionListPluginV3.valueOf(row.get("opproj"));
                String opres = LogOperactionListPluginV3.valueOf(row.get("opres"));
                if (!StringUtils.isBlank((CharSequence)opproj) || !StringUtils.isBlank((CharSequence)opres) || !StringUtils.isNotBlank((CharSequence)opkey)) continue;
                entityNums.add(String.valueOf(entityNum));
            }
            long t3 = System.currentTimeMillis();
            HashMap operateMap = entityNums.isEmpty() ? new HashMap(4) : EntityMetadataCache.getDataEntityOperations(entityNums);
            long t4 = System.currentTimeMillis();
            logger.debug("getDataEntityOperations\u8017\u65f6\uff1a" + (t4 - t3));
            for (DynamicObject row : rows) {
                Map localName;
                Object localValue;
                Object name;
                Optional<Map> option;
                List maps;
                String displayOpName;
                String opname = LogOperactionListPluginV3.valueOf(row.get("opname"));
                String entityNum = LogOperactionListPluginV3.valueOf(row.get("bizobj.number"));
                String opkey = LogOperactionListPluginV3.valueOf(row.get("opkey"));
                String opproj = LogOperactionListPluginV3.valueOf(row.get("opproj"));
                String opres = LogOperactionListPluginV3.valueOf(row.get("opres"));
                String string = displayOpName = StringUtils.isNotBlank((CharSequence)opkey) ? opkey : opname;
                if (StringUtils.isNotBlank((CharSequence)opproj) && StringUtils.isNotBlank((CharSequence)opres) && StringUtils.isNotBlank((CharSequence)opname)) {
                    displayOpName = ResManager.loadKDString((String)opname, (String)opres, (String)opproj, (Object[])new Object[0]);
                } else if (!StringUtils.isBlank((CharSequence)opkey) && !StringUtils.isBlank((CharSequence)entityNum) && CollectionUtils.isNotEmpty((Collection)(maps = (List)operateMap.get(entityNum))) && (option = maps.stream().filter(item -> StringUtils.equals((CharSequence)String.valueOf(item.get("key")), (CharSequence)opkey)).findAny()).isPresent() && (name = option.get().get("name")) instanceof Map && (localValue = (localName = (Map)name).get(RequestContext.get().getLang().toString())) != null) {
                    displayOpName = LogOperactionListPluginV3.valueOf(localValue);
                }
                row.set("opname", (Object)displayOpName);
            }
            long t5 = System.currentTimeMillis();
            logger.debug("\u7ec4\u7ec7\u6570\u636e\u8017\u65f6\uff1a" + (t5 - t4));
            return rows;
        }
    }
}

