/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.formplugin;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.log.service.rabbitmq.MQPublishService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class LogSendFailRecordsPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(LogSendFailRecordsPlugin.class);

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "resend": {
                try {
                    this.resend();
                }
                catch (IOException | InterruptedException | TimeoutException e) {
                    logger.error((Throwable)e);
                }
                break;
            }
        }
    }

    private void resend() throws IOException, TimeoutException, InterruptedException {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        Object[] fids = rows.getPrimaryKeyValues();
        if (fids.length > 0 && fids.length <= 10) {
            String sql = "SELECT FID,FMESSAGE FROM T_LOG_FAILRECORD WHERE FID IN (" + StringUtils.join((Object[])fids, (char)',') + ')';
            try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.log, (String)sql);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    long id = row.getLong(0);
                    String message = row.getString(1);
                    boolean result = MQPublishService.getInstance().sendForResult((Object)message);
                    if (!result) continue;
                    this.clearRecord(id);
                }
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u53d1\u4fe1\u606f\u603b\u6570\u5e94\u5927\u4e8e0\u4e14\u5c0f\u4e8e\u7b49\u4e8e10\u3002", (String)"LogSendFailRecordsPlugin_0", (String)"bos-log-formplugin", (Object[])new Object[0]));
        }
    }

    private void clearRecord(long id) {
        try {
            String sql = "DELETE FROM T_LOG_FAILRECORD WHERE FID=" + id;
            DB.execute((DBRoute)DBRoute.log, (String)sql);
        }
        catch (Exception e) {
            logger.error("kafka \u64cd\u4f5c\u65e5\u5fd7\u91cd\u8bd5\u6295\u9012\u4efb\u52a1\u6e05\u9664\u53d1\u9001\u6210\u529f\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
        }
    }
}

