/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.business.plugin;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.business.plugin.UniqueValidateEnum;
import kd.bos.coderule.opplugin.constants.CodeRulePluginContants;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class AbstractUniqueBillno {
    protected static final Log logger = LogFactory.getLog(AbstractUniqueBillno.class);
    protected List<Map<String, Object>> fields;
    protected UniqueValidateEnum uniqueValidateEnum = CodeRulePluginContants.UNIQUE_DEFAULT_VALUE;

    public boolean validateGrpFieldUnique(String billNoFldKey, List<Map<String, Object>> validationList, DynamicObject dynamicObject) {
        List fields;
        Map<String, Object> validationInfo;
        boolean onlyBillNoUnique = false;
        Iterator<Map<String, Object>> iterator = validationList.iterator();
        while (!(!iterator.hasNext() || ((Boolean)(validationInfo = iterator.next()).get("enabled")).booleanValue() && "GroupFieldUnique".equals((String)validationInfo.get("ruleType")) && (onlyBillNoUnique = this.validateField(billNoFldKey, fields = (List)validationInfo.get("fields"), dynamicObject)))) {
        }
        return onlyBillNoUnique;
    }

    protected boolean validateField(String billNoFldKey, List<Map<String, Object>> fields, DynamicObject dynamicObject) {
        if (fields.size() == 1 && fields.get(0).containsValue(billNoFldKey)) {
            this.uniqueValidateEnum = UniqueValidateEnum.SINGULAR;
            logger.info("[CodeRuleOp]\u627e\u5230\u7f16\u7801\u552f\u4e00\u6027\u6821\u9a8c");
            return true;
        }
        return false;
    }

    public boolean checkReatedInDB(String entityNum, QFilter[] qFilters) {
        return QueryServiceHelper.exists((String)entityNum, (QFilter[])qFilters);
    }

    public Map<String, DynamicObject> checkRepeatDateInDB(String entityNum, String billNoKey, Map<String, DynamicObject> dynamicObjectMap, QFilter[] qFilters) {
        if (dynamicObjectMap == null || dynamicObjectMap.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, DynamicObject> repeatData = new LinkedHashMap<String, DynamicObject>();
        Set<String> selectFields = this.getSelectFields();
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entityNum, (String)String.join((CharSequence)",", selectFields), (QFilter[])qFilters);
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return null;
        }
        for (DynamicObject dynamicObject : collection) {
            String billNo = dynamicObject.getString(billNoKey);
            DynamicObject data = dynamicObjectMap.get(billNo);
            if (data == null) continue;
            if (this.uniqueValidateEnum == UniqueValidateEnum.SINGULAR) {
                repeatData.put(billNo, data);
                continue;
            }
            boolean isRepeat = true;
            for (String selectField : selectFields) {
                if (StringUtils.equals((CharSequence)billNoKey, (CharSequence)selectField) || this.isEqualsData(dynamicObject.get(selectField), data.get(selectField))) continue;
                isRepeat = false;
                break;
            }
            if (!isRepeat) continue;
            repeatData.put(billNo, data);
        }
        return repeatData;
    }

    private boolean isEqualsData(Object queryData, Object curData) {
        if (curData instanceof DynamicObject) {
            return this.equalsValue(queryData, ((DynamicObject)curData).getPkValue());
        }
        if (curData instanceof ILocaleString) {
            return this.equalsValue(queryData, queryData.toString());
        }
        return this.equalsValue(queryData, curData);
    }

    public QFilter[] buildQFilter(String billNoFldKey, String number, DynamicObject dynamicObject) {
        return new QFilter[]{new QFilter(billNoFldKey, "=", (Object)number)};
    }

    public QFilter[] buildQFilter(String billNoFldKey, LinkedHashMap<String, DynamicObject> dynamicObjectMap) {
        return new QFilter(billNoFldKey, "in", dynamicObjectMap.keySet()).toArray();
    }

    public Set<String> getSelectFields() {
        if (this.fields == null) {
            return Collections.emptySet();
        }
        HashSet<String> fieldsResult = new HashSet<String>(this.fields.size());
        for (Map<String, Object> field : this.fields) {
            String fullField = (String)field.get("id");
            if (fullField.contains(".")) {
                fullField = fullField.substring(0, fullField.indexOf(46));
            }
            fieldsResult.add(fullField);
        }
        return fieldsResult;
    }

    private boolean equalsValue(Object v1, Object v2) {
        if (v1 == null) {
            return v2 == null;
        }
        if (v1 instanceof Integer && v2 instanceof Long) {
            return ((Integer)v1).longValue() == ((Long)v2).longValue();
        }
        if (v1 instanceof Long && v2 instanceof Integer) {
            return ((Long)v1).longValue() == ((Integer)v2).longValue();
        }
        if (v1 instanceof BigDecimal && v2 instanceof BigDecimal) {
            return ((BigDecimal)v1).compareTo((BigDecimal)v2) == 0;
        }
        if (v1 instanceof String && v2 instanceof String) {
            return ((String)v1).trim().equals(((String)v2).trim());
        }
        return v1.equals(v2);
    }
}

