/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.business.plugin;

import java.util.HashMap;
import java.util.Map;
import kd.bos.business.plugin.CodeRuleGroup;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.util.MultiLangEnumBridge;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;

public class CodeRuleOpStatusRecord {
    private static final String BOS_CODERULE = "bos-coderule";
    private OperateSourceStatus sourceStatus = OperateSourceStatus.DEFAULT;
    private Map<DynamicObject, OperateProcess> dataOperateProcess = new HashMap<DynamicObject, OperateProcess>(16);
    private Map<DynamicObject, CodeRuleInfo> needRecycleCodeRule = new HashMap<DynamicObject, CodeRuleInfo>(2);
    private Map<DynamicObject, CodeRuleGroup> updateCodeRuleGroup;
    private Map<DynamicObject, CodeRuleGroup> useInterruptionGroup;
    private Map<DynamicObject, CodeRuleGroup> updateMaxNumberGroup;

    public OperateSourceStatus getOperateSourceStatus() {
        return this.sourceStatus;
    }

    public void tagOperateSourceStatus(OperateSourceStatus sourceStatus) {
        this.sourceStatus = sourceStatus;
    }

    CodeRuleOpStatusRecord() {
    }

    public void initDataOperateProcess(DynamicObject[] allData) {
        for (DynamicObject data : allData) {
            this.dataOperateProcess.put(data, new OperateProcess());
        }
    }

    public void tagDataStatus(DynamicObject data, DataStatus dataStatus) {
        OperateProcess operateProcess = this.dataOperateProcess.get(data);
        if (operateProcess != null) {
            operateProcess.setDataStatus(dataStatus);
        }
    }

    public void batchTagDataStatus(DynamicObject[] allData, DataStatus dataStatus) {
        for (DynamicObject data : allData) {
            OperateProcess operateProcess = this.dataOperateProcess.get(data);
            if (operateProcess == null) continue;
            operateProcess.setDataStatus(dataStatus);
        }
    }

    public void tagBillNoStatus(DynamicObject data, BillNoStatus billNoStatus) {
        OperateProcess operateProcess = this.dataOperateProcess.get(data);
        if (operateProcess != null) {
            operateProcess.setBillNoStatus(billNoStatus);
        }
    }

    public void tagResultStatus(DynamicObject data, ResultStatus resultStatus) {
        OperateProcess operateProcess = this.dataOperateProcess.get(data);
        if (operateProcess != null) {
            operateProcess.setResultStatus(resultStatus);
        }
    }

    public void tagRecycleStatus(DynamicObject data, RecycleStatus recycleStatus) {
        OperateProcess operateProcess = this.dataOperateProcess.get(data);
        if (operateProcess != null) {
            operateProcess.setRecycleStatus(recycleStatus);
        }
    }

    public RecycleStatus getDataRecycleStatus(DynamicObject data) {
        OperateProcess operateProcess = this.dataOperateProcess.get(data);
        if (operateProcess != null) {
            return operateProcess.getRecycleStatus();
        }
        return RecycleStatus.DEFAULT;
    }

    public ResultStatus getDataResultStatus(DynamicObject data) {
        OperateProcess operateProcess = this.dataOperateProcess.get(data);
        if (operateProcess != null) {
            return operateProcess.getResultStatus();
        }
        return ResultStatus.DEFAULT;
    }

    public BillNoStatus getBillNoStatus(DynamicObject data) {
        OperateProcess operateProcess = this.dataOperateProcess.get(data);
        if (operateProcess != null) {
            return operateProcess.getBillNoStatus();
        }
        return BillNoStatus.DEFAULT;
    }

    public Map<DynamicObject, OperateProcess> getDataOperateProcess() {
        return this.dataOperateProcess;
    }

    public CodeRuleInfo getNeedRecycleCodeRule(DynamicObject data) {
        return this.needRecycleCodeRule.get(data);
    }

    public void setNeedRecycleCodeRule(DynamicObject data, CodeRuleInfo codeRuleInfo) {
        this.needRecycleCodeRule.put(data, codeRuleInfo);
    }

    public Map<DynamicObject, CodeRuleGroup> getUpdateCodeRuleGroup() {
        return this.updateCodeRuleGroup;
    }

    public void setUpdateCodeRuleGroup(Map<DynamicObject, CodeRuleGroup> updateCodeRuleGroup) {
        this.updateCodeRuleGroup = updateCodeRuleGroup;
    }

    public Map<DynamicObject, CodeRuleGroup> getUseInterruptionGroup() {
        return this.useInterruptionGroup;
    }

    public void setUseInterruptionGroup(Map<DynamicObject, CodeRuleGroup> useInterruptionGroup) {
        this.useInterruptionGroup = useInterruptionGroup;
    }

    public Map<DynamicObject, CodeRuleGroup> getUpdateMaxNumberGroup() {
        return this.updateMaxNumberGroup;
    }

    public void setUpdateMaxNumberGroup(Map<DynamicObject, CodeRuleGroup> updateMaxNumberGroup) {
        this.updateMaxNumberGroup = updateMaxNumberGroup;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u64cd\u4f5c\u6765\u6e90\u72b6\u6001\uff1a", (String)"CodeRuleOpStatusRecord_27", (String)BOS_CODERULE, (Object[])new Object[0])).append(this.sourceStatus.getDesc()).append(System.lineSeparator());
        for (Map.Entry<DynamicObject, OperateProcess> processEntry : this.dataOperateProcess.entrySet()) {
            sb.append(ResManager.loadKDString((String)"\u5185\u7801\uff1a", (String)"CodeRuleOpStatusRecord_28", (String)BOS_CODERULE, (Object[])new Object[0])).append(processEntry.getKey().getPkValue()).append('\uff0c');
            sb.append(processEntry.getValue().processToString()).append(System.lineSeparator());
        }
        return sb.toString();
    }

    static enum RecycleStatus {
        DEFAULT(new MultiLangEnumBridge("\u65e0\u9700\u56de\u6536\u7f16\u53f7", "CodeRuleOpStatusRecord_24", "bos-coderule")),
        USER_INPUT_RECYCLE_OLD(new MultiLangEnumBridge("\u7528\u6237\u4f20\u5165\u65b0\u7f16\u53f7\u65e7\u7f16\u53f7\u9700\u8981\u56de\u6536", "CodeRuleOpStatusRecord_25", "bos-coderule")),
        GENERATE_NEW_RECYCLE_OLD(new MultiLangEnumBridge("\u91cd\u65b0\u7f16\u53f7\u65e7\u7f16\u53f7\u9700\u8981\u56de\u6536", "CodeRuleOpStatusRecord_26", "bos-coderule"));

        private MultiLangEnumBridge desc;

        public String getDesc() {
            return this.desc.loadKDString();
        }

        private RecycleStatus(MultiLangEnumBridge desc) {
            this.desc = desc;
        }
    }

    static enum ResultStatus {
        DEFAULT(new MultiLangEnumBridge("\u672a\u83b7\u53d6\u64cd\u4f5c\u7ed3\u679c", "CodeRuleOpStatusRecord_17", "bos-coderule")),
        NO_NUMBER_GENERATE(new MultiLangEnumBridge("\u672a\u751f\u6210\u7f16\u53f7", "CodeRuleOpStatusRecord_18", "bos-coderule")),
        NOT_MATCH_RULE(new MultiLangEnumBridge("\u672a\u5339\u914d\u5230\u7f16\u7801\u89c4\u5219", "CodeRuleOpStatusRecord_19", "bos-coderule")),
        NEW_NUMBER_CACHE(new MultiLangEnumBridge("\u7531\u9875\u9762\u7f13\u5b58\u751f\u6210\u7f16\u53f7", "CodeRuleOpStatusRecord_20", "bos-coderule")),
        NEW_NUMBER_UNIQUE(new MultiLangEnumBridge("\u7531\u552f\u4e00\u6027\u6821\u9a8c\u751f\u6210\u7f16\u53f7", "CodeRuleOpStatusRecord_21", "bos-coderule")),
        NEW_NUMBER(new MultiLangEnumBridge("\u751f\u6210\u7f16\u53f7", "CodeRuleOpStatusRecord_22", "bos-coderule")),
        UPDATE_NUMBER(new MultiLangEnumBridge("\u66f4\u65b0\u7f16\u53f7", "CodeRuleOpStatusRecord_23", "bos-coderule"));

        private MultiLangEnumBridge desc;

        public String getDesc() {
            return this.desc.loadKDString();
        }

        private ResultStatus(MultiLangEnumBridge desc) {
            this.desc = desc;
        }
    }

    static enum BillNoStatus {
        DEFAULT(new MultiLangEnumBridge("\u672a\u83b7\u53d6\u5355\u636e\u7f16\u53f7\u72b6\u6001", "CodeRuleOpStatusRecord_11", "bos-coderule")),
        EMPTY(new MultiLangEnumBridge("\u5355\u636e\u7f16\u53f7\u4e3a\u7a7a", "CodeRuleOpStatusRecord_12", "bos-coderule")),
        NOT_EMPTY(new MultiLangEnumBridge("\u5355\u636e\u7f16\u53f7\u6709\u503c", "CodeRuleOpStatusRecord_13", "bos-coderule")),
        FORMAT_MISMATCH(new MultiLangEnumBridge("\u5355\u636e\u7f16\u53f7\u683c\u5f0f\u4e0d\u4e00\u81f4\u5224\u65ad\u5f53\u524d\u573a\u666f\u662f\u5355\u5143\u6d4b\u8bd5", "CodeRuleOpStatusRecord_14", "bos-coderule")),
        IS_USER_INPUT(new MultiLangEnumBridge("\u7f16\u53f7\u662f\u7528\u6237\u4f20\u5165", "CodeRuleOpStatusRecord_15", "bos-coderule")),
        IS_EXCEL_INPUT(new MultiLangEnumBridge("\u7f16\u53f7\u662fExcel\u4e2d\u586b\u5199", "CodeRuleOpStatusRecord_16", "bos-coderule"));

        private MultiLangEnumBridge desc;

        public String getDesc() {
            return this.desc.loadKDString();
        }

        private BillNoStatus(MultiLangEnumBridge desc) {
            this.desc = desc;
        }
    }

    static enum DataStatus {
        DEFAULT(new MultiLangEnumBridge("\u672a\u8fdb\u5165\u6570\u636e\u72b6\u6001\u5224\u65ad", "CodeRuleOpStatusRecord_7", "bos-coderule")),
        BATCH_GENERATE(new MultiLangEnumBridge("\u5f53\u524d\u4e3a\u6279\u91cf\u751f\u6210", "CodeRuleOpStatusRecord_8", "bos-coderule")),
        DATA_NEW(new MultiLangEnumBridge("\u5f53\u524d\u4e3a\u65b0\u589e", "CodeRuleOpStatusRecord_9", "bos-coderule")),
        DATA_UPDATE(new MultiLangEnumBridge("\u5f53\u524d\u4e3a\u66f4\u65b0", "CodeRuleOpStatusRecord_10", "bos-coderule"));

        private MultiLangEnumBridge desc;

        public String getDesc() {
            return this.desc.loadKDString();
        }

        private DataStatus(MultiLangEnumBridge desc) {
            this.desc = desc;
        }
    }

    static enum OperateSourceStatus {
        DEFAULT(new MultiLangEnumBridge("\u672a\u5f00\u59cb\u64cd\u4f5c", "CodeRuleOpStatusRecord_6", "bos-coderule")),
        WEBAPI_BATCH_GENERATE(new MultiLangEnumBridge("WebApi\u6279\u91cf\u5904\u7406\u591a\u6761\u6570\u636e", "CodeRuleOpStatusRecord_1", "bos-coderule")),
        IMPORT_BATCH_GENERATE(new MultiLangEnumBridge("\u5bfc\u5165\u6279\u91cf\u5904\u7406\u591a\u6761\u6570\u636e", "CodeRuleOpStatusRecord_2", "bos-coderule")),
        ISC_BATCH_GENERATE(new MultiLangEnumBridge("\u96c6\u6210\u6279\u91cf\u5904\u7406\u591a\u6761\u6570\u636e", "CodeRuleOpStatusRecord_3", "bos-coderule")),
        PUSH_GENERATE_NUMBERS(new MultiLangEnumBridge("\u5217\u8868\u6216\u5168\u90e8\u4e0b\u63a8\u6279\u91cf\u5904\u7406\u591a\u6761\u6570\u636e", "CodeRuleOpStatusRecord_4", "bos-coderule")),
        BILL_GENERATE_NUMBER(new MultiLangEnumBridge("\u8868\u5355\u6216\u5217\u8868\u4ec5\u5904\u7406\u4e00\u6761\u6570\u636e", "CodeRuleOpStatusRecord_5", "bos-coderule"));

        private MultiLangEnumBridge desc;

        public String getDesc() {
            return this.desc.loadKDString();
        }

        private OperateSourceStatus(MultiLangEnumBridge desc) {
            this.desc = desc;
        }
    }

    static class OperateProcess {
        private DataStatus dataStatus = DataStatus.DEFAULT;
        private BillNoStatus billNoStatus = BillNoStatus.DEFAULT;
        private ResultStatus resultStatus = ResultStatus.DEFAULT;
        private RecycleStatus recycleStatus = RecycleStatus.DEFAULT;

        OperateProcess() {
        }

        public DataStatus getDataStatus() {
            return this.dataStatus;
        }

        public void setDataStatus(DataStatus dataStatus) {
            this.dataStatus = dataStatus;
        }

        public BillNoStatus getBillNoStatus() {
            return this.billNoStatus;
        }

        public void setBillNoStatus(BillNoStatus billNoStatus) {
            this.billNoStatus = billNoStatus;
        }

        public ResultStatus getResultStatus() {
            return this.resultStatus;
        }

        public void setResultStatus(ResultStatus resultStatus) {
            this.resultStatus = resultStatus;
        }

        public RecycleStatus getRecycleStatus() {
            return this.recycleStatus;
        }

        public void setRecycleStatus(RecycleStatus recycleStatus) {
            this.recycleStatus = recycleStatus;
        }

        public String processToString() {
            return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u72b6\u6001\uff1a%1$s\uff0c\u5355\u636e\u7f16\u53f7\u72b6\u6001\uff1a%2$s\uff0c\u64cd\u4f5c\u7ed3\u679c\u72b6\u6001\uff1a%3$s\uff0c\u7f16\u53f7\u56de\u6536\u72b6\u6001\uff1a%4$s\u3002", (String)"CodeRuleOpStatusRecord_0", (String)CodeRuleOpStatusRecord.BOS_CODERULE, (Object[])new Object[0]), this.dataStatus.getDesc(), this.billNoStatus.getDesc(), this.resultStatus.getDesc(), this.recycleStatus.getDesc());
        }
    }
}

