/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.business.plugin;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.business.plugin.AbstractUniqueBillno;
import kd.bos.business.plugin.UniqueValidateEnum;
import kd.bos.coderule.util.CodeRuleSystemParam;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.InteTimeZone;

public class UniqueBillno
extends AbstractUniqueBillno {
    @Override
    protected boolean validateField(String billNoFldKey, List<Map<String, Object>> fields, DynamicObject dynamicObject) {
        Optional<Map> field;
        if (!CodeRuleSystemParam.getMcParam("unique_billno.validate_field")) {
            return super.validateField(billNoFldKey, fields, dynamicObject);
        }
        if (fields.size() == 1 && fields.get(0).containsValue(billNoFldKey)) {
            this.fields = fields;
            this.uniqueValidateEnum = UniqueValidateEnum.SINGULAR;
            logger.info("[CodeRuleOp]\u627e\u5230\u7f16\u7801\u552f\u4e00\u6027\u6821\u9a8c");
            return true;
        }
        if (fields.size() > 1 && (field = fields.stream().filter(x -> x.containsValue(billNoFldKey)).findFirst()).isPresent() && this.validateFieldInProperties(fields, dynamicObject)) {
            this.fields = fields;
            this.uniqueValidateEnum = UniqueValidateEnum.MULTI;
            logger.info("[CodeRuleOp]\u627e\u5230\u7f16\u7801\u552f\u4e00\u6027\u6821\u9a8c");
            return true;
        }
        return false;
    }

    private boolean validateFieldInProperties(List<Map<String, Object>> fields, DynamicObject dynamicObject) {
        for (Map<String, Object> field : fields) {
            IDataEntityProperty dataEntityProperty;
            String fieldKey = (String)field.entrySet().iterator().next().getValue();
            if (fieldKey.contains(".")) {
                fieldKey = fieldKey.substring(0, fieldKey.indexOf(46));
            }
            if ((dataEntityProperty = (IDataEntityProperty)dynamicObject.getDataEntityType().getProperties().get((Object)fieldKey)) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public QFilter[] buildQFilter(String billNoFldKey, String number, DynamicObject dynamicObject) {
        if (!CodeRuleSystemParam.getMcParam("unique_billno.build_qfilter")) {
            return super.buildQFilter(billNoFldKey, number, dynamicObject);
        }
        if (this.fields == null) {
            throw new KDException(new ErrorCode("UniqueBillno", ResManager.loadKDString((String)"\u8bbe\u8ba1\u5668\u552f\u4e00\u6821\u9a8c\u6ca1\u6709\u5339\u914d\u5230\u7f16\u53f7\u5b57\u6bb5, \u8bf7\u68c0\u67e5\u4ee3\u7801\u3002", (String)"UniqueBillno_0", (String)"bos-coderule", (Object[])new Object[0])), new Object[0]);
        }
        if (this.uniqueValidateEnum == UniqueValidateEnum.SINGULAR) {
            return new QFilter[]{new QFilter(billNoFldKey, "=", (Object)number)};
        }
        return this.buildQFilterForMulti(billNoFldKey, number, dynamicObject);
    }

    private QFilter[] buildQFilterForMulti(String billNoFldKey, String number, DynamicObject dynamicObject) {
        int size = this.fields.size();
        QFilter[] qFilters = new QFilter[size];
        int i = 0;
        for (Map field : this.fields) {
            String fieldKey = (String)field.entrySet().iterator().next().getValue();
            if (fieldKey.contains(".")) {
                fieldKey = fieldKey.substring(0, fieldKey.indexOf(46));
            }
            Object fieldValueObj = dynamicObject.get(fieldKey);
            if (fieldKey.equals(billNoFldKey)) {
                fieldValueObj = number;
            }
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)dynamicObject.getDataEntityType().getProperties().get((Object)fieldKey);
            Object[] fieldValues = this.formatValue(dataEntityProperty, fieldValueObj);
            qFilters[i] = new QFilter(fieldKey, "=", fieldValues[0]);
            ++i;
        }
        return qFilters;
    }

    private Object[] formatValue(IDataEntityProperty property, Object value) {
        Object[] values = new Object[2];
        values[0] = value;
        Object object = values[1] = value == null ? ResManager.loadKDString((String)"\u7a7a\u503c", (String)"UniqueBillno_1", (String)"bos-mservice-operation", (Object[])new Object[0]) : String.valueOf(value);
        if (property instanceof MuliLangTextProp) {
            values[0] = value == null ? "" : value.toString();
            Object object2 = values[1] = value == null ? ResManager.loadKDString((String)"\u7a7a\u503c", (String)"UniqueBillno_1", (String)"bos-mservice-operation", (Object[])new Object[0]) : value.toString();
        }
        if (property instanceof BasedataProp) {
            BasedataProp bdProp = (BasedataProp)property;
            if (value == null) {
                values[0] = bdProp.getRefIdProp() instanceof LongProp ? Long.valueOf(0L) : "";
                values[1] = ResManager.loadKDString((String)"\u7a7a\u503c", (String)"UniqueBillno_1", (String)"bos-mservice-operation", (Object[])new Object[0]);
            } else if (value instanceof DynamicObject) {
                values[0] = ((DynamicObject)value).getPkValue();
                values[1] = bdProp.getDisplayValue(value);
            }
        } else if (property instanceof ComboProp) {
            values[1] = ((ComboProp)property).getItemByName((String)value);
        } else if (property instanceof IntegerProp) {
            DecimalFormat format = new DecimalFormat("0");
            values[1] = format.format(value);
        } else if (property instanceof DecimalProp) {
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append(",###.");
            for (int i = 1; i <= ((DecimalProp)property).getScale(); ++i) {
                sBuilder.append('0');
            }
            DecimalFormat format = new DecimalFormat(sBuilder.toString());
            values[1] = format.format(value);
        } else if (property instanceof DateProp) {
            if (value != null) {
                InteTimeZone zone = ((DateTimeProp)property).getTimeZone(Long.valueOf(0L));
                values[1] = zone.format((Date)value, (DateFormat)new SimpleDateFormat("yyyy-MM-dd"));
            }
        } else if (property instanceof DateTimeProp) {
            if (value != null) {
                InteTimeZone zone = ((DateTimeProp)property).getTimeZone(Long.valueOf(0L));
                values[1] = zone.format((Date)value, (DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            }
        } else if (property instanceof BooleanProp) {
            values[1] = (Boolean)value != false ? ResManager.loadKDString((String)"\u662f", (String)"UniqueBillno_2", (String)"bos-mservice-operation", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"UniqueBillno_3", (String)"bos-mservice-operation", (Object[])new Object[0]);
        } else if (property instanceof TextProp && StringUtils.isBlank((Object)value)) {
            value = "";
            values[1] = StringUtils.isBlank((Object)value) ? ResManager.loadKDString((String)"\u7a7a\u503c", (String)"UniqueBillno_1", (String)"bos-mservice-operation", (Object[])new Object[0]) : value;
        }
        return values;
    }
}

