/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule;

import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import kd.bos.coderule.newedit.PageCacheUtil;
import kd.bos.coderule.util.TreeListQueryUtil;
import kd.bos.coderule.util.TreeListUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.svc.util.TreeNodeFilter;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractCodeRuleTreeListPlugin
extends AbstractListPlugin
implements TreeNodeQueryListener,
TreeNodeClickListener,
SearchEnterListener {
    public static final String TREE_NUMBER = "subsystemtree";
    public static final String BILLLISTAP = "billlistap";
    public static final String CODERULE_TREE_SEARCH_NODES = "coderule_tree_search_nodes_";
    public static final String CODERULE_TREE_SEARCH_TEXT = "coderule_tree_search_text_";
    public static final String TREE_SEARCH_QUEUE_END_FLAG = "QUEUE_END";
    private static final String OBJECT_APP_ID = "bizobjectid.bizappid.id";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView systeTtree = (TreeView)this.getControl(TREE_NUMBER);
        systeTtree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        systeTtree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getView().getControl("searchap");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initTree();
    }

    private void initTree() {
        TreeView tree = (TreeView)this.getView().getControl(TREE_NUMBER);
        tree.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"AbstractCodeRuleTreeListPlugin_0", (String)"bos-coderule", (Object[])new Object[0]));
        root.setId("0");
        root.setIsOpened(true);
        tree.addNode(root);
        List<TreeNode> cloudNodes = TreeListUtil.getAllCloudNodes(this.getPageCache());
        TreeListUtil.addNodes(this.getPageCache(), tree, cloudNodes);
        tree.focusNode(root);
        QFilter filter = new TreeNodeFilter(TreeNodeFilter.FilterTypeEnum.ONLY_APP).getAppFilter(OBJECT_APP_ID);
        if (filter != null) {
            this.getPageCache().put("curbizobjectid", filter.toSerializedString());
        }
    }

    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        this.refreshNode(treeNodeEvent.getNodeId().toString());
    }

    public void setFilter(SetFilterEvent e) {
        String curbizobjectid = this.getPageCache().get("curbizobjectid");
        if (StringUtils.isBlank((CharSequence)curbizobjectid)) {
            return;
        }
        QFilter qFilter = QFilter.fromSerializedString((String)curbizobjectid);
        e.getQFilters().add(qFilter);
    }

    private void refreshNode(String nodeId) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        String id = nodeId;
        String filterString = "";
        if ("0".equals(id)) {
            QFilter filter = new TreeNodeFilter(TreeNodeFilter.FilterTypeEnum.ONLY_APP).getAppFilter(OBJECT_APP_ID);
            if (filter != null) {
                filterString = filter.toSerializedString();
            }
            TreeListQueryUtil.afterTreeNodeClick(this.getPageCache(), billList, filterString);
            return;
        }
        int level = Integer.parseInt(id.split("_split_")[0]);
        String trueId = id.split("_split_")[1];
        if (level == 1) {
            filterString = TreeListQueryUtil.getFilterByCloud(billList, trueId);
        } else if (level == 2) {
            filterString = TreeListQueryUtil.getFilterByApp(billList, trueId);
        } else if (level == 3) {
            filterString = TreeListQueryUtil.getFilterByForm(billList, trueId);
        }
        TreeListQueryUtil.afterTreeNodeClick(this.getPageCache(), billList, filterString);
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        TreeView treeView = (TreeView)treeNodeEvent.getSource();
        String parentId = String.valueOf(treeNodeEvent.getNodeId());
        int level = Integer.parseInt(parentId.split("_split_")[0]);
        List<TreeNode> treeNodes = null;
        if (level == 1) {
            treeNodes = TreeListUtil.getAppNodesByCloudId(this.getPageCache(), parentId);
        } else if (level == 2) {
            treeNodes = TreeListUtil.getFormNodesByAppId(this.getPageCache(), parentId);
        }
        TreeListUtil.addNodes(this.getPageCache(), treeView, treeNodes, parentId);
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRow currentListSelectedRow = evt.getCurrentListSelectedRow();
        if (currentListSelectedRow == null) {
            return;
        }
        Object value = currentListSelectedRow.getPrimaryKeyValue();
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_coderule", (String)"id, bizobjectid", (QFilter[])new QFilter("id", "=", (Object)value.toString()).toArray());
        if (dynamicObject == null) {
            return;
        }
        String bizobjectNumber = dynamicObject.getString("bizobjectid");
        if (StringUtils.isBlank((CharSequence)bizobjectNumber)) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select fid, fdentityid");
        sql.append(" from t_meta_mainentityinfo");
        sql.append(" where fid = '").append(bizobjectNumber).append("' ");
        String bizobjectId = (String)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), null, rs -> {
            String result = "";
            while (rs.next()) {
                String id = rs.getString(2);
                if (StringUtils.isBlank((CharSequence)id)) continue;
                result = "3_split_" + id;
            }
            return result;
        });
        if (StringUtils.isBlank((CharSequence)bizobjectId)) {
            return;
        }
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.offer(bizobjectId);
        this.tryFocusNode("", queue, false);
    }

    public void search(SearchEnterEvent evt) {
        Queue<Object> nodeIdQueueInDB;
        String text = evt.getText();
        String flagStr = this.getPageCache().get(CODERULE_TREE_SEARCH_TEXT + text);
        if (StringUtils.isBlank((CharSequence)flagStr) || String.valueOf(false).equals(flagStr)) {
            this.getPageCache().put(CODERULE_TREE_SEARCH_TEXT + text, String.valueOf(true));
            List<String> cloudIds = TreeListQueryUtil.searchCloudByName(text);
            List<String> appIds = TreeListQueryUtil.searchBizappByName(text);
            List<String> entityIds = TreeListQueryUtil.searchEntityByName(text);
            nodeIdQueueInDB = new LinkedList<Object>();
            nodeIdQueueInDB.addAll(cloudIds);
            nodeIdQueueInDB.addAll(appIds);
            nodeIdQueueInDB.addAll(entityIds);
            if (!nodeIdQueueInDB.isEmpty()) {
                nodeIdQueueInDB.offer(TREE_SEARCH_QUEUE_END_FLAG);
            }
            PageCacheUtil.putQueueToPageCache(this.getPageCache(), CODERULE_TREE_SEARCH_NODES + text, nodeIdQueueInDB);
        } else {
            nodeIdQueueInDB = PageCacheUtil.getQueueFromPageCache(this.getPageCache(), CODERULE_TREE_SEARCH_NODES + text);
        }
        if (CollectionUtils.isEmpty(nodeIdQueueInDB)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u4e0d\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"AbstractCodeRuleTreeListPlugin_1", (String)"bos-coderule", (Object[])new Object[0]));
            return;
        }
        this.tryFocusNode(text, nodeIdQueueInDB, true);
    }

    protected void tryFocusNode(String text, Queue<Object> nodeIdQueueInDB, boolean isRefreshList) {
        LinkedHashSet<Object> loadNodes = PageCacheUtil.getSetFromPageCache(this.getPageCache(), "coderule_tree_nodes");
        String nodeId = this.searchNodeFromTree(nodeIdQueueInDB, loadNodes, text);
        if (!"".equals(nodeId)) {
            TreeView tree = (TreeView)this.getView().getControl(TREE_NUMBER);
            TreeNode node = new TreeNode();
            node.setId(nodeId);
            tree.focusNode(node);
            if (isRefreshList) {
                this.refreshNode(nodeId);
            }
        }
    }

    private String searchNodeFromTree(Queue<Object> nodeIdQueueInDB, Set<Object> loadNodes, String text) {
        String nodeId = "";
        while (!nodeIdQueueInDB.isEmpty()) {
            Object searchNodeIdObj = nodeIdQueueInDB.poll();
            String searchNodeId = searchNodeIdObj.toString();
            if (TREE_SEARCH_QUEUE_END_FLAG.equals(searchNodeId)) {
                if (nodeIdQueueInDB.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u4e0d\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"AbstractCodeRuleTreeListPlugin_1", (String)"bos-coderule", (Object[])new Object[0]));
                    return "";
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\u3002", (String)"AbstractCodeRuleTreeListPlugin_2", (String)"bos-coderule", (Object[])new Object[0]));
                nodeIdQueueInDB.offer(searchNodeIdObj);
                if (!nodeIdQueueInDB.isEmpty() && nodeIdQueueInDB.size() > 1) {
                    searchNodeIdObj = nodeIdQueueInDB.poll();
                    searchNodeId = searchNodeIdObj.toString();
                }
            }
            String nodePre = searchNodeId.split("_split_")[0];
            boolean flag = false;
            if (nodePre.equals("1")) {
                flag = loadNodes.contains(searchNodeId);
            } else if (nodePre.equals("2")) {
                flag = this.tryExpandCloudByAppId(searchNodeId);
            } else if (nodePre.equals("3")) {
                flag = this.tryExpandAppByEntityId(searchNodeId);
            }
            if (!flag) continue;
            nodeId = searchNodeId;
            nodeIdQueueInDB.offer(searchNodeIdObj);
            break;
        }
        PageCacheUtil.putQueueToPageCache(this.getPageCache(), CODERULE_TREE_SEARCH_NODES + text, nodeIdQueueInDB);
        return nodeId;
    }

    private boolean tryExpandCloudByAppId(String appId) {
        String cloudId = TreeListQueryUtil.searchCloudIdByAppId(appId.split("_split_")[1]);
        if (!PageCacheUtil.getSetFromPageCache(this.getPageCache(), "coderule_tree_nodes").contains(cloudId)) {
            return false;
        }
        TreeView tree = (TreeView)this.getView().getControl(TREE_NUMBER);
        List<TreeNode> treeNodes = TreeListUtil.getAppNodesByCloudId(this.getPageCache(), cloudId);
        TreeListUtil.addNodes(this.getPageCache(), tree, treeNodes, cloudId);
        if (!PageCacheUtil.getSetFromPageCache(this.getPageCache(), "coderule_tree_nodes").contains(appId)) {
            return false;
        }
        tree.expand(cloudId);
        return true;
    }

    private boolean tryExpandAppByEntityId(String entityId) {
        String appId = TreeListQueryUtil.searchAppIdByEntityId(entityId.split("_split_")[1]);
        if (StringUtils.isBlank((CharSequence)appId) || !appId.contains("_split_")) {
            return false;
        }
        String cloudId = TreeListQueryUtil.searchCloudIdByAppId(appId.split("_split_")[1]);
        if (!PageCacheUtil.getSetFromPageCache(this.getPageCache(), "coderule_tree_nodes").contains(cloudId)) {
            return false;
        }
        TreeView tree = (TreeView)this.getView().getControl(TREE_NUMBER);
        List<TreeNode> appNodes = TreeListUtil.getAppNodesByCloudId(this.getPageCache(), cloudId);
        TreeListUtil.addNodes(this.getPageCache(), tree, appNodes, cloudId);
        if (!PageCacheUtil.getSetFromPageCache(this.getPageCache(), "coderule_tree_nodes").contains(appId)) {
            return false;
        }
        List<TreeNode> entityNodes = TreeListUtil.getFormNodesByAppId(this.getPageCache(), appId);
        TreeListUtil.addNodes(this.getPageCache(), tree, entityNodes, appId);
        if (!PageCacheUtil.getSetFromPageCache(this.getPageCache(), "coderule_tree_nodes").contains(entityId)) {
            return false;
        }
        tree.expand(cloudId);
        tree.expand(appId);
        return true;
    }
}

