/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.service.cache.CodeRuleCacheMrg;
import kd.bos.coderule.util.CodeRuleUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

@Deprecated
public class CodeRuleApplicationConditionEditPlugin
extends AbstractFormPlugin {
    private static final String CODE_RULE_APP_COND_PRO = "bos_coderuleappcondpro";
    private static final String CR_APP_COND_PRO_VALUE = "bos_crappcondprovalue";
    private static final String BTN_CONFIRM = "btn_confirm";
    private static final String PROPERTY = "property";
    private static final String PROPERTY_ID = "propertyid";
    private static final String PROPERTY_VALUE = "propertyvalue";
    private static final String PROPERTY_VALUE_ID = "propertyvalueid";
    private static final String DISPLAY_NAME = "displayname";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
    }

    public void afterCreateNewData(EventObject e) {
        this.getConfiguredDate();
        List<Map<String, String>> propertyList = this.initProperty();
        this.loadConfiguredDate(propertyList);
    }

    private void getConfiguredDate() {
        String codeRuleId = (String)this.getView().getFormShowParameter().getCustomParam("coderuleid");
        QFilter[] qf = new QFilter("id", "=", (Object)codeRuleId).toArray();
        DynamicObjectCollection conditionEntry = QueryServiceHelper.query((String)"bos_coderule", (String)"id, conditionentry.id entryid, conditionentry.property propertyid, conditionentry.propertyvalue propertyvalueid", (QFilter[])qf);
        if (CollectionUtils.isEmpty((Collection)conditionEntry)) {
            return;
        }
        QFilter filterPro = new QFilter("appcondpro.id", "=", (Object)((DynamicObject)conditionEntry.get(0)).getString(PROPERTY_ID));
        QFilter filterVal = new QFilter("id", "=", (Object)((DynamicObject)conditionEntry.get(0)).getString(PROPERTY_VALUE_ID));
        String selectFields = "id, appcondpro.id proid, appcondpro.number number, value";
        QFilter[] filters = new QFilter[]{filterPro, filterVal};
        DynamicObjectCollection conditions = QueryServiceHelper.query((String)CR_APP_COND_PRO_VALUE, (String)selectFields, (QFilter[])filters);
        ArrayList result = new ArrayList();
        for (DynamicObject condition : conditions) {
            HashMap<String, String> conditionMap = new HashMap<String, String>();
            conditionMap.put(PROPERTY, condition.getString("number"));
            conditionMap.put(PROPERTY_VALUE, condition.getString("value"));
            conditionMap.put(PROPERTY_ID, condition.getString("proid"));
            conditionMap.put(PROPERTY_VALUE_ID, condition.getString("id"));
            result.add(conditionMap);
        }
        this.getPageCache().put("conditions", SerializationUtils.toJsonString(result));
    }

    private List<Map<String, String>> initProperty() {
        IDataModel model = this.getModel();
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("dtval");
        QFilter[] qfArr = new QFilter("number", "=", (Object)entityNumber).toArray();
        DynamicObject objectType = BusinessDataServiceHelper.loadSingle((String)"bos_objecttype", (String)"id", (QFilter[])qfArr);
        if (objectType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u641c\u7d22\u4e0d\u5230\u4e1a\u52a1\u5bf9\u8c61\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u6216\u786e\u8ba4\u4e1a\u52a1\u5bf9\u8c61\u662f\u5426\u5b58\u5728\u3002", (String)"CodeRuleApplicationConditionEditPlugin_4", (String)"bos-coderule", (Object[])new Object[0]));
        }
        List<Map<String, String>> propertyList = this.getPropertyList(entityNumber);
        model.setValue("objectid", objectType.getPkValue(), 0);
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(PROPERTY);
        ArrayList<ComboItem> properties = new ArrayList<ComboItem>(propertyList.size());
        for (Map<String, String> propertyMap : propertyList) {
            properties.add(new ComboItem(new LocaleString(propertyMap.get(DISPLAY_NAME)), propertyMap.get(PROPERTY)));
        }
        comboEdit.setComboItems(properties);
        return propertyList;
    }

    private List<Map<String, String>> getPropertyList(String number) {
        List<Map<String, String>> propertyList = this.getSimpleProperties(number, null);
        propertyList.addAll(this.getBaseDataProperties(number));
        return propertyList;
    }

    private List<Map<String, String>> getSimpleProperties(String number, BasedataProp baseDataProp) {
        MainEntityType objectType = EntityMetadataCache.getDataEntityType((String)number);
        DataEntityPropertyCollection entitySet = objectType.getProperties();
        List simpleFields = entitySet.getSimpleProperties(false);
        ArrayList<Map<String, String>> simpleResult = new ArrayList<Map<String, String>>();
        for (ISimpleProperty simpleProperty : simpleFields) {
            DynamicProperty property = (DynamicProperty)simpleProperty;
            if (property.getDisplayName() == null) continue;
            String langName = RequestContext.get().getLang().name();
            HashMap<String, Object> propertyMap = new HashMap<String, Object>();
            if (baseDataProp != null) {
                propertyMap.put(PROPERTY, baseDataProp.getName() + "." + property.getName());
                propertyMap.put(DISPLAY_NAME, (String)baseDataProp.getDisplayName().get((Object)langName) + "." + (String)property.getDisplayName().get((Object)langName));
                simpleResult.add(propertyMap);
                if (simpleResult.size() != 2) continue;
                return simpleResult;
            }
            if (this.unSupportedProp(property)) continue;
            propertyMap.put(PROPERTY, property.getName());
            propertyMap.put(DISPLAY_NAME, property.getDisplayName().get((Object)langName));
            simpleResult.add(propertyMap);
        }
        return simpleResult;
    }

    private boolean unSupportedProp(DynamicProperty property) {
        if (property instanceof DateTimeProp || property instanceof TimeProp || property instanceof AdminDivisionProp) {
            return this.isNotExistProp(property.getName());
        }
        return false;
    }

    private boolean isNotExistProp(String propertyName) {
        String conditions = this.getPageCache().get("conditions");
        if (StringUtils.isBlank((CharSequence)conditions)) {
            return true;
        }
        List configuredDates = (List)SerializationUtils.fromJsonString((String)conditions, List.class);
        if (configuredDates == null || configuredDates.size() == 0) {
            return true;
        }
        for (Map configuredDate : configuredDates) {
            if (!propertyName.equals(configuredDate.get(PROPERTY))) continue;
            return false;
        }
        return true;
    }

    private List<Map<String, String>> getBaseDataProperties(String number) {
        MainEntityType objectType = EntityMetadataCache.getDataEntityType((String)number);
        DataEntityPropertyCollection entitySet = objectType.getProperties();
        List complexFields = entitySet.getComplexProperties(false);
        ArrayList<Map<String, String>> baseDataResult = new ArrayList<Map<String, String>>();
        for (IComplexProperty complexProperty : complexFields) {
            BasedataProp basedataProp;
            String baseEntityId;
            if (complexProperty instanceof FlexProp || complexProperty instanceof ItemClassProp || !(complexProperty instanceof BasedataProp) || (baseEntityId = (basedataProp = (BasedataProp)complexProperty).getBaseEntityId()) == null) continue;
            baseDataResult.addAll(this.getSimpleProperties(baseEntityId, basedataProp));
        }
        return baseDataResult;
    }

    private void loadConfiguredDate(List<Map<String, String>> propertyList) {
        IDataModel model = this.getModel();
        List conditions = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("conditions"), List.class);
        if (conditions == null || conditions.size() == 0) {
            return;
        }
        for (Map condition : conditions) {
            if (!this.isExistProperty(propertyList, (String)condition.get(PROPERTY))) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5df2\u914d\u7f6e\u7684\u5b57\u6bb5\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"CodeRuleApplicationConditionEditPlugin_1", (String)"bos-coderule", (Object[])new Object[0]), condition.get(PROPERTY)));
            }
            model.setValue(PROPERTY, condition.get(PROPERTY), 0);
            model.setValue(PROPERTY_VALUE, condition.get(PROPERTY_VALUE), 0);
            model.setValue(PROPERTY_ID, condition.get(PROPERTY_ID), 0);
            model.setValue(PROPERTY_VALUE_ID, condition.get(PROPERTY_VALUE_ID), 0);
        }
    }

    private boolean isExistProperty(List<Map<String, String>> propertyList, String property) {
        for (Map<String, String> properties : propertyList) {
            if (!property.equals(properties.get(PROPERTY))) continue;
            return true;
        }
        return false;
    }

    public void click(EventObject evt) {
        IDataModel model = this.getModel();
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)BTN_CONFIRM)) {
            String codeRuleId = (String)this.getView().getFormShowParameter().getCustomParam("coderuleid");
            String objectId = (String)this.getView().getFormShowParameter().getCustomParam("dtval");
            if (StringUtils.isNotBlank((Object)model.getValue(PROPERTY, 0))) {
                if (!this.validateAndSaveProp()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"CodeRuleApplicationConditionEditPlugin_2", (String)"bos-coderule", (Object[])new Object[0]));
                    return;
                }
                if (this.dataValidate(codeRuleId, objectId)) {
                    return;
                }
                this.updateAndSaveConditionEntry(codeRuleId);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CodeRuleApplicationConditionEditPlugin_3", (String)"bos-coderule", (Object[])new Object[0]));
            } else {
                this.deleteEmptyCondition(codeRuleId, objectId);
            }
            String type = CodeRuleCacheMrg.getType4EntityCodeRules();
            CodeRuleCacheMrg.clearCache(type, objectId);
        }
    }

    private void updateAndSaveConditionEntry(String codeRuleId) {
        IDataModel model = this.getModel();
        DynamicObject dataInfo = BusinessDataServiceHelper.loadSingle((Object)codeRuleId, (String)"bos_coderule");
        DynamicObjectCollection conditionEntrys = dataInfo.getDynamicObjectCollection("conditionentry");
        conditionEntrys.clear();
        DynamicObject dynaObj = new DynamicObject(conditionEntrys.getDynamicObjectType());
        dynaObj.set(PROPERTY, model.getValue(PROPERTY_ID, 0));
        dynaObj.set(PROPERTY_VALUE, model.getValue(PROPERTY_VALUE_ID, 0));
        dynaObj.set("id", (Object)codeRuleId);
        dynaObj.set("seq", (Object)1);
        conditionEntrys.add((Object)dynaObj);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataInfo});
    }

    private boolean validateAndSaveProp() {
        IDataModel model = this.getModel();
        if (StringUtils.isBlank((Object)model.getValue(PROPERTY_ID, 0)) || StringUtils.isBlank((Object)model.getValue(PROPERTY_VALUE_ID, 0))) {
            String objectId = (String)this.getView().getFormShowParameter().getCustomParam("dtval");
            if (objectId == null || "".equals(objectId)) {
                return false;
            }
            String propertyId = this.queryAndSaveProperty(objectId);
            String propertyValueId = this.queryAndSavePropertyValue(propertyId);
            if (StringUtils.isBlank((CharSequence)propertyId) || StringUtils.isBlank((CharSequence)propertyValueId)) {
                return false;
            }
            model.setValue(PROPERTY_ID, (Object)propertyId, 0);
            model.setValue(PROPERTY_VALUE_ID, (Object)propertyValueId, 0);
            return true;
        }
        return true;
    }

    private String queryAndSaveProperty(String objectId) {
        IDataModel model = this.getModel();
        String propertyId = "";
        QFilter filterObj = new QFilter("bizobjectid", "=", (Object)objectId);
        QFilter filterNum = new QFilter("number", "=", model.getValue(PROPERTY, 0));
        QFilter[] filters = new QFilter[]{filterObj, filterNum};
        DynamicObject propertyObject = BusinessDataServiceHelper.loadSingle((String)CODE_RULE_APP_COND_PRO, (String)"id", (QFilter[])filters);
        if (propertyObject == null) {
            DynamicObject newProperty = BusinessDataServiceHelper.newDynamicObject((String)CODE_RULE_APP_COND_PRO);
            newProperty.set("bizobjectid", (Object)objectId);
            newProperty.set("number", model.getValue(PROPERTY, 0));
            Object[] propertyResult = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newProperty});
            DynamicObject result = (DynamicObject)propertyResult[0];
            propertyId = String.valueOf(result.getPkValue());
        } else {
            propertyId = propertyObject.getString("id");
        }
        return propertyId;
    }

    private String queryAndSavePropertyValue(String propertyId) {
        IDataModel model = this.getModel();
        String propertyValueId = "";
        QFilter filterPro = new QFilter("appcondpro", "=", (Object)propertyId);
        QFilter filterVal = new QFilter("value", "=", model.getValue(PROPERTY_VALUE));
        QFilter[] filtersVal = new QFilter[]{filterPro, filterVal};
        DynamicObject propertyValObject = BusinessDataServiceHelper.loadSingle((String)CR_APP_COND_PRO_VALUE, (String)"id", (QFilter[])filtersVal);
        if (propertyValObject == null) {
            DynamicObject newPropertyVal = BusinessDataServiceHelper.newDynamicObject((String)CR_APP_COND_PRO_VALUE);
            newPropertyVal.set("appcondpro", (Object)propertyId);
            newPropertyVal.set("value", model.getValue(PROPERTY_VALUE));
            Object[] propertyValResult = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newPropertyVal});
            DynamicObject valResult = (DynamicObject)propertyValResult[0];
            propertyValueId = String.valueOf(valResult.getPkValue());
        } else {
            propertyValueId = propertyValObject.getString("id");
        }
        return propertyValueId;
    }

    private boolean dataValidate(String codeRuleId, String objectId) {
        HashMap<String, Object> conditionMap = new HashMap<String, Object>();
        conditionMap.put(PROPERTY, this.getModel().getValue(PROPERTY_ID, 0));
        conditionMap.put(PROPERTY_VALUE, this.getModel().getValue(PROPERTY_VALUE_ID, 0));
        String msg = CodeRuleUtils.isDuplicateCodeRule(objectId, codeRuleId, null, conditionMap);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.getView().showErrorNotification(msg);
            return true;
        }
        return false;
    }

    private void deleteEmptyCondition(String codeRuleId, String objectId) {
        if (codeRuleId != null) {
            String str = CodeRuleUtils.isDuplicateCodeRule(objectId, codeRuleId, null, new HashMap<String, Object>());
            if (StringUtils.isBlank((CharSequence)str)) {
                this.deleteEntry(codeRuleId);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CodeRuleApplicationConditionEditPlugin_3", (String)"bos-coderule", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(str);
            }
        }
    }

    private void deleteEntry(String id) {
        try (TXHandle h = TX.beginRequired();){
            try {
                Object[] params = new SqlParameter[]{new SqlParameter(":Fid", 1, (Object)id)};
                String SQL = "delete from T_CR_AppCondition where Fid = ?;";
                DB.execute((DBRoute)DBRoute.basedata, (String)SQL, (Object[])params);
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String changedName = e.getProperty().getName();
        if (PROPERTY.equals(changedName) && StringUtils.isNotBlank((Object)model.getValue(PROPERTY_ID, 0))) {
            model.setValue(PROPERTY_ID, (Object)"", 0);
            model.setValue(PROPERTY_VALUE, (Object)"", 0);
        }
        if (PROPERTY_VALUE.equals(changedName) && StringUtils.isNotBlank((Object)model.getValue(PROPERTY_VALUE_ID, 0))) {
            model.setValue(PROPERTY_VALUE_ID, (Object)"", 0);
        }
    }
}

