/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.coderule.util.CodeRuleUtils;
import kd.bos.coderule.util.Util;
import kd.bos.coderule.util.intermitno.IntermitNoDetectDTO;
import kd.bos.coderule.util.intermitno.IntermitNoDetectUtil;
import kd.bos.coderule.util.intermitno.task.CreateDetectTaskUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class CodeRuleIntermitNoDetectPlugin
extends AbstractFormPlugin {
    private static final String MAN_BTN = "man_btn";
    private static final String AUTO_BTN = "auto_btn";
    private static final String MAN_OVER = "man_over";
    private static final String AUTO_OVER = "auto_over";
    private static final String HAS_DETECTED = "has_detected";
    private static final String HAS_ADD_JOB = "has_add_job";
    private static final String PKS_KEY = "pks_key";
    private static final String PKS_KEY_LOST = "pks_key_lost";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"man_check_btn", "view_data_btn", "auto_check_btn"});
    }

    public void afterCreateNewData(EventObject e) {
        this.setPaneVisible(MAN_BTN);
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String pkValues = (String)this.getView().getFormShowParameter().getCustomParam("selectedCodeRuleIds");
        if ("man_check_btn".equalsIgnoreCase(c.getKey())) {
            if (pkValues != null) {
                try {
                    ArrayList<String> allIntermitIds = new ArrayList<String>();
                    ArrayList<String> lostIntermitIds = new ArrayList<String>();
                    for (String pk : pkValues.split(",")) {
                        IntermitNoDetectDTO intermitNoDetectDTO = IntermitNoDetectUtil.checkCodeRuleIntermitNo(pk);
                        allIntermitIds.addAll(intermitNoDetectDTO.getAllIntermitIds());
                        lostIntermitIds.addAll(intermitNoDetectDTO.getLostIntermitIds());
                    }
                    if (!CollectionUtils.isEmpty(allIntermitIds)) {
                        this.setPksPageCache(allIntermitIds, PKS_KEY);
                    }
                    if (!CollectionUtils.isEmpty(lostIntermitIds)) {
                        this.setPksPageCache(lostIntermitIds, PKS_KEY_LOST);
                    }
                    this.getPageCache().put(HAS_DETECTED, Boolean.TRUE.toString());
                    this.setPaneVisible(MAN_OVER);
                }
                catch (Exception e) {
                    this.getView().showMessage(e.getMessage(), Util.exInfoToStr(e), MessageTypes.Default);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u7f16\u7801\u89c4\u5219\u3002", (String)"CodeRuleIntermitNoDetectPlugin_0", (String)"bos-coderule", (Object[])new Object[0]));
            }
        } else if ("view_data_btn".equalsIgnoreCase(c.getKey())) {
            if (Boolean.parseBoolean(this.getPageCache().get(HAS_DETECTED))) {
                CodeRuleUtils.openBillFormListByPks(this, "bos_coderule_intermitno", this.getPksFromPageCache(PKS_KEY), this.getPksFromPageCache(PKS_KEY_LOST));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u6267\u884c\u624b\u52a8\u68c0\u6d4b\u3002", (String)"CodeRuleIntermitNoDetectPlugin_1", (String)"bos-coderule", (Object[])new Object[0]));
            }
        } else if ("auto_check_btn".equalsIgnoreCase(c.getKey())) {
            CreateDetectTaskUtil.createTask(pkValues.split(","));
            this.getPageCache().put(HAS_ADD_JOB, Boolean.TRUE.toString());
            this.setPaneVisible(AUTO_OVER);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{MAN_BTN, AUTO_BTN});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        if ("radiogroup".equalsIgnoreCase(proName)) {
            Object radioValue = e.getChangeSet()[0].getNewValue();
            if ("man".equals(radioValue)) {
                if (Boolean.parseBoolean(this.getPageCache().get(HAS_DETECTED))) {
                    this.setPaneVisible(MAN_OVER);
                } else {
                    this.setPaneVisible(MAN_BTN);
                }
            } else if ("auto".equals(radioValue)) {
                if (Boolean.parseBoolean(this.getPageCache().get(HAS_ADD_JOB))) {
                    this.setPaneVisible(AUTO_OVER);
                } else {
                    this.setPaneVisible(AUTO_BTN);
                }
            }
        }
        this.getView().updateView();
    }

    private void setPksPageCache(List<String> allIntermitIds, String key) {
        StringBuilder sb = new StringBuilder();
        sb.append(allIntermitIds.get(0));
        for (int i = 1; i < allIntermitIds.size(); ++i) {
            sb.append(',').append(allIntermitIds.get(i));
        }
        this.getPageCache().put(key, sb.toString());
    }

    private List<Object> getPksFromPageCache(String key) {
        String str = this.getPageCache().get(key);
        if (StringUtils.isNotEmpty((String)str)) {
            List<String> strings = Arrays.asList(str.split(","));
            return Optional.ofNullable(strings).map(Collection::stream).orElseGet(Stream::empty).map(x -> x).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    private void setPaneVisible(String btnKey) {
        if (MAN_BTN.equals(btnKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"man_check_pane"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"man_over_pane", "auto_check_pane", "auto_over_pane"});
        } else if (AUTO_BTN.equals(btnKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"auto_check_pane"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"man_check_pane", "man_over_pane", "auto_over_pane"});
        } else if (MAN_OVER.equalsIgnoreCase(btnKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"man_over_pane"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"man_check_pane", "auto_check_pane", "auto_over_pane"});
        } else if (AUTO_OVER.equalsIgnoreCase(btnKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"auto_over_pane"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"man_check_pane", "man_over_pane", "auto_check_pane"});
        }
    }
}

