/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule;

import java.util.EventObject;
import java.util.Iterator;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.service.cache.CodeRuleCache;
import kd.bos.coderule.util.AppLogUtil;
import kd.bos.coderule.util.CodeRuleFastUtil;
import kd.bos.coderule.util.CodeRuleUtils;
import kd.bos.coderule.util.CommonUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class CodeRuleIntermitNoEditPlugin
extends AbstractBasePlugIn {
    public static final String CODERULEID = "coderuleid";
    public static final String SORTITEMVALUE = "sortitemvalue";
    private static final String SORTITEMVALUE_1 = "sortitemvalue1";
    private static final String SERIAL = "serial";
    private static final String BOS_CODERULE = "bos-coderule";

    public void afterCreateNewData(EventObject e) {
        this.reload();
    }

    public void afterLoadData(EventObject e) {
        this.reload();
    }

    public void reload() {
        Object codeRuleObj = this.getModel().getValue(CODERULEID);
        if (codeRuleObj == null) {
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)codeRuleObj;
        CodeRuleInfo codeRuleInfo = CodeRuleCache.reloadCodeRuleById(String.valueOf(dynamicObject.getPkValue()));
        if (codeRuleInfo.isFast()) {
            this.getModel().setValue(CODERULEID, (Object)CodeRuleFastUtil.getCloneAndAddFastTag(dynamicObject));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        if ("save".equals(e.getOperateKey())) {
            DynamicObject codeRuleObj = (DynamicObject)this.getModel().getValue(CODERULEID);
            if (codeRuleObj != null) {
                this.recordOperationLog(codeRuleObj, e.getOperationResult().isSuccess());
                CodeRuleUtils.clearCache(new String[]{(String)codeRuleObj.getPkValue()});
            }
            this.getView().close();
        }
    }

    private void recordOperationLog(DynamicObject codeRuleObj, boolean isSuccess) {
        String fromDatabase = this.getPageCache().get("pagecache_coderule_intermit_isfromdata");
        Object serial = this.getModel().getValue(SERIAL);
        String sortItemValue = this.getModel().getValue(SORTITEMVALUE).toString();
        if (Boolean.parseBoolean(fromDatabase)) {
            String oldValue = this.getPageCache().get("pagecache_coderule_oldValue");
            String newValue = this.getPageCache().get("pagecache_coderule_newValue");
            oldValue = StringUtils.isEmpty((String)oldValue) ? serial.toString() : oldValue;
            String string = newValue = StringUtils.isEmpty((String)newValue) ? serial.toString() : newValue;
            if (AppLogUtil.checkSortItemValue(sortItemValue)) {
                AppLogUtil.insertAppLog(this.getView(), codeRuleObj, new MultiLangEnumBridge("\u4fee\u6539\u65ad\u53f7", "CodeRuleIntermitNoEditPlugin_3", BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u4fee\u6539\u524d\u53f7\u7801:%3$s\uff0c\u4fee\u6539\u540e\u53f7\u7801:%4$s\u3002", "AppLogUtil_1", BOS_CODERULE), isSuccess, "" + codeRuleObj.getPkValue(), CommonUtil.getDynamicObjProperties(codeRuleObj, "name").toString(), oldValue, newValue);
            } else {
                AppLogUtil.insertAppLog(this.getView(), codeRuleObj, new MultiLangEnumBridge("\u4fee\u6539\u65ad\u53f7", "CodeRuleMaxSerialEditPlugin_5", BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u4f9d\u636e\uff1a%3$s\uff0c\u4fee\u6539\u524d\u53f7\u7801\uff1a%4$s\uff0c\u4fee\u6539\u540e\u53f7\u7801%5$s\u3002", "AppLogUtil_1", BOS_CODERULE), isSuccess, "" + codeRuleObj.getPkValue(), CommonUtil.getDynamicObjProperties(codeRuleObj, "name").toString(), CommonUtil.convertSortItem(sortItemValue), oldValue, newValue);
            }
            return;
        }
        if (AppLogUtil.checkSortItemValue(sortItemValue)) {
            AppLogUtil.insertAppLog(this.getView(), codeRuleObj, new MultiLangEnumBridge("\u65b0\u589e\u65ad\u53f7", "CodeRuleIntermitNoEditPlugin_5", BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u53f7\u7801:%s\u3002", "AppLogUtil_1", BOS_CODERULE), isSuccess, "" + codeRuleObj.getPkValue(), CommonUtil.getDynamicObjProperties(codeRuleObj, "name").toString(), serial.toString());
        } else {
            AppLogUtil.insertAppLog(this.getView(), codeRuleObj, new MultiLangEnumBridge("\u65b0\u589e\u65ad\u53f7", "CodeRuleIntermitNoEditPlugin_5", BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u4f9d\u636e:%1$s\uff0c\u53f7\u7801:%2$s\u3002", "AppLogUtil_1", BOS_CODERULE), isSuccess, "" + codeRuleObj.getPkValue(), CommonUtil.getDynamicObjProperties(codeRuleObj, "name").toString(), CommonUtil.convertSortItem(sortItemValue), serial.toString());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        if (e.getSource() instanceof AbstractOperate) {
            AbstractOperate op = (AbstractOperate)e.getSource();
            String operateKey = op.getOperateKey();
            DynamicObject codeRuleObj = (DynamicObject)this.getModel().getValue(CODERULEID);
            if ("save".equals(operateKey)) {
                if (codeRuleObj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u89c4\u5219\u3002", (String)"CodeRuleIntermitNoEditPlugin_0", (String)BOS_CODERULE, (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                String sortItemValue = this.getModel().getValue(SORTITEMVALUE).toString();
                boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
                this.getPageCache().put("pagecache_coderule_intermit_isfromdata", String.valueOf(fromDatabase));
                if (!fromDatabase) {
                    sortItemValue = this.getModel().getValue(SORTITEMVALUE_1).toString();
                }
                sortItemValue = StringUtils.isBlank((String)sortItemValue) ? "_split_" : sortItemValue;
                Object serial = this.getModel().getValue(SERIAL);
                if (serial == null || StringUtils.isEmpty((String)serial.toString()) || Long.parseLong(serial.toString()) <= 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6709\u6548\u7684\u201c\u65ad\u53f7\u201d\u3002", (String)"CodeRuleIntermitNoEditPlugin_1", (String)BOS_CODERULE, (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                if (this.checkSortItemValueDuplicate(sortItemValue, serial)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u201c\u65ad\u53f7\u201d\u5728\u65ad\u53f7\u8868\u4e2d\u5df2\u5b58\u5728\u3002", (String)"CodeRuleIntermitNoEditPlugin_2", (String)BOS_CODERULE, (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                this.getModel().setValue(SORTITEMVALUE, (Object)sortItemValue);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        if (proName.equalsIgnoreCase(SERIAL)) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            Object newValue = e.getChangeSet()[0].getNewValue();
            this.getPageCache().put("pagecache_coderule_oldValue", oldValue == null ? null : oldValue.toString());
            this.getPageCache().put("pagecache_coderule_newValue", newValue == null ? null : newValue.toString());
        }
    }

    public void afterBindData(EventObject e) {
        boolean dataChanged = this.getModel().getDataChanged();
        boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (!fromDatabase) {
            IFormView parentView = this.getView().getParentView();
            if (parentView == null) {
                return;
            }
            Object coderuleid = parentView.getFormShowParameter().getCustomParams().get(CODERULEID);
            if (coderuleid != null) {
                DynamicObject rule;
                DynamicObject codeRule = BusinessDataServiceHelper.loadSingle(coderuleid, (String)"bos_coderule", (String)"id, name, ruleentry, issortitem");
                this.getModel().setValue(CODERULEID, (Object)codeRule);
                this.getView().setEnable(Boolean.FALSE, new String[]{CODERULEID});
                boolean issortitem = false;
                DynamicObjectCollection ruleEntry = codeRule.getDynamicObjectCollection("ruleentry");
                Iterator iterator = ruleEntry.iterator();
                while (iterator.hasNext() && !(issortitem = (rule = (DynamicObject)iterator.next()).getBoolean("issortitem"))) {
                }
                this.getView().setEnable(Boolean.valueOf(issortitem), new String[]{SORTITEMVALUE_1});
            }
        } else {
            Object coderuleObj = this.getModel().getValue(CODERULEID);
            if (coderuleObj == null) {
                throw new KDException(new ErrorCode("CodeRuleIntermitNoError", ResManager.loadKDString((String)"\u65ad\u53f7\u7f16\u8f91\u65f6\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7f16\u7801\u89c4\u5219", (String)"CodeRuleIntermitNoEditPlugin_7", (String)BOS_CODERULE, (Object[])new Object[0])), new Object[0]);
            }
            CodeRuleUtils.bindSortItem(this.getModel());
            this.getView().setEnable(Boolean.FALSE, new String[]{SORTITEMVALUE_1});
        }
        this.getModel().setDataChanged(dataChanged);
    }

    private boolean checkSortItemValueDuplicate(String sortItemValue, Object serial) {
        QFilter qf = new QFilter(SORTITEMVALUE, "=", (Object)sortItemValue);
        qf.and(CODERULEID, "=", (Object)((String)((DynamicObject)this.getModel().getValue(CODERULEID)).getPkValue()));
        qf.and("seqSegmentEntryID", "=", (Object)((String)this.getModel().getValue("seqsegmententryid")));
        if (serial != null) {
            qf.and(SERIAL, "=", (Object)Long.valueOf(serial.toString()));
        }
        return QueryServiceHelper.exists((String)"bos_coderule_intermitno", (QFilter[])new QFilter[]{qf});
    }
}

