/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.service.cache.CodeRuleCache;
import kd.bos.coderule.util.AppLogUtil;
import kd.bos.coderule.util.CodeRuleFastUtil;
import kd.bos.coderule.util.CommonUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;

public class CodeRuleIntermitNoListPlugin
extends AbstractListPlugin {
    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection pageData = e.getPageData();
        for (DynamicObject dynamicObject : pageData) {
            String sortitemvalue = dynamicObject.getString("sortitemvalue");
            if (!StringUtils.isBlank((CharSequence)sortitemvalue.replaceAll("_split_", ""))) continue;
            dynamicObject.set("sortitemvalue", (Object)"");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        AbstractOperate op;
        String operateKey;
        if (e.getSource() instanceof AbstractOperate && "delete".equals(operateKey = (op = (AbstractOperate)e.getSource()).getOperateKey())) {
            Object[] primaryKeyValues = e.getListSelectedData().getPrimaryKeyValues();
            if (null == primaryKeyValues || primaryKeyValues.length <= 0) {
                return;
            }
            Object[] dynamicObjectArr = BusinessDataServiceHelper.load((String)"bos_coderule_intermitno", (String)"coderuleid, sortitemvalue, serial", (QFilter[])new QFilter("id", "in", (Object)primaryKeyValues).toArray());
            if (dynamicObjectArr == null || dynamicObjectArr.length <= 0) {
                return;
            }
            this.getPageCache().put("CODERULE_PRIMARYKEYVALUES", DynamicObjectSerializeUtil.serialize((Object[])dynamicObjectArr, (DynamicObjectType)this.getModel().getDataEntityType()));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        OperationResult operationResult = e.getOperationResult();
        if (operationResult != null && operationResult.isSuccess() && "delete".equals(operateKey)) {
            String dynamicsStr = this.getPageCache().get("CODERULE_PRIMARYKEYVALUES");
            if (StringUtils.isBlank((CharSequence)dynamicsStr)) {
                return;
            }
            Object[] dynamicObjects = DynamicObjectSerializeUtil.deserialize((String)dynamicsStr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_coderule_intermitno"));
            ArrayList<AppLogInfo> appLogInfos = new ArrayList<AppLogInfo>(dynamicObjects.length);
            for (Object dynamicObj : dynamicObjects) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObj;
                DynamicObject codeRuleObj = dynamicObject.getDynamicObject("coderuleid");
                String coderuleid = "" + codeRuleObj.getPkValue();
                String sortItemValue = dynamicObject.getString("sortitemvalue");
                String newValue = dynamicObject.getString("serial");
                OpLogAppInfo appLogInfo = AppLogUtil.checkSortItemValue(sortItemValue) ? AppLogUtil.buildAppLog(this.getView(), dynamicObject, new MultiLangEnumBridge("\u65ad\u53f7\u8868\u5220\u9664", "CodeRuleIntermitNoListPlugin_0", "bos-coderule"), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u53f7\u7801:%3$s\u3002", "BOS_CODERULE_6", "bos-coderule"), operationResult.isSuccess(), coderuleid, CommonUtil.getDynamicObjProperties(codeRuleObj, "name").toString(), newValue) : AppLogUtil.buildAppLog(this.getView(), dynamicObject, new MultiLangEnumBridge("\u65ad\u53f7\u8868\u5220\u9664", "CodeRuleIntermitNoListPlugin_0", "bos-coderule"), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u4f9d\u636e:%3$s\uff0c\u53f7\u7801:%4$s\u3002", "BOS_CODERULE_5", "bos-coderule"), operationResult.isSuccess(), coderuleid, CommonUtil.getDynamicObjProperties(codeRuleObj, "name").toString(), sortItemValue, newValue);
                appLogInfos.add((AppLogInfo)appLogInfo);
            }
            AppLogUtil.batchInsertAppLog(appLogInfos);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().getFormShowParameter().getCustomParams().get("coderuleid");
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    private static class MyListDataProvider
    extends ListDataProvider {
        private MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            if (rows.isEmpty()) {
                return rows;
            }
            if (!((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)"serial")) {
                return rows;
            }
            for (DynamicObject row : rows) {
                CodeRuleInfo codeRuleInfo;
                if (row.get("coderuleid") == null || !(codeRuleInfo = CodeRuleCache.reloadCodeRuleById((String)((DynamicObject)row.get("coderuleid")).getPkValue())).isFast()) continue;
                DynamicObject coderuleObj = (DynamicObject)row.get("coderuleid");
                row.set("coderuleid", (Object)CodeRuleFastUtil.getCloneAndAddFastTag(coderuleObj));
            }
            return rows;
        }
    }
}

