/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.newedit.PageCacheUtil;
import kd.bos.coderule.newedit.PageChangeEntryPlugin;
import kd.bos.coderule.newedit.PageChangePlugin;
import kd.bos.coderule.newedit.PageDataPlugin;
import kd.bos.coderule.newedit.PageShowEntryPlugin;
import kd.bos.coderule.newedit.PageShowPlugin;
import kd.bos.coderule.service.cache.CodeRuleCacheMrg;
import kd.bos.coderule.util.CodeRuleUtils;
import kd.bos.coderule.util.PermUtil;
import kd.bos.coderule.util.TreeListUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class CodeRuleNewEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final String BIZOBJECTID = "bizobjectid";
    public static final String CODERULEENABLECACHE = "codeRuleEnableCache";
    private static final String BOS_CODERULE = "bos-coderule";
    private static final String FORMNUM_CODERULE_EDIT = "bos_coderule_edit";
    private PageShowPlugin pageShowPlugin;
    private PageShowEntryPlugin pageShowEntryPlugin;
    private PageChangePlugin pageChangePlugin;
    private PageChangeEntryPlugin pageChangeEntryPlugin;
    private PageDataPlugin pageDataPlugin;

    public void initialize() {
        this.pageShowPlugin = new PageShowPlugin(this, this.getModel());
        this.pageShowEntryPlugin = new PageShowEntryPlugin(this, this.getModel());
        this.pageChangePlugin = new PageChangePlugin(this, this.getModel());
        this.pageChangeEntryPlugin = new PageChangeEntryPlugin(this, this.getModel());
        this.pageDataPlugin = new PageDataPlugin(this, this.getModel());
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"addcard", "delcard", "format", "valueatributeshow", "btnclosetips"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(BIZOBJECTID);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String id = (String)this.getView().getFormShowParameter().getCustomParam("id");
        if (StringUtils.isNotBlank((CharSequence)id)) {
            boolean isCopy;
            String isCopyStr = (String)this.getView().getFormShowParameter().getCustomParam("iscopy");
            boolean bl = isCopy = StringUtils.isNotBlank((CharSequence)isCopyStr) && isCopyStr.equals(String.valueOf(true));
            if (isCopy) {
                this.getPageCache().put("isCopy", isCopyStr);
            }
            QFilter[] qfArr = new QFilter[]{new QFilter("id", "=", (Object)id)};
            StringBuilder selectFields = new StringBuilder();
            selectFields.append("id, bizobjectid, name, splitsign, appmode, bizobjectid.number");
            if (isCopy) {
                selectFields.append(", filtercondition, conditiondesc");
            }
            selectFields.append("id, bizobjectid, name, splitsign, appmode, bizobjectid.number,ispreset");
            selectFields.append(", isserialnumber, islog, isapporg, isappcondition, isupdaterecover, ischeckcode");
            selectFields.append(", isaddview, ismatchcoderule, ismodifiable, isnonbreak, isunique, isfast");
            selectFields.append(", ruleentry.id, ruleentry.attributetype");
            selectFields.append(", ruleentry.fixval, ruleentry.format, ruleentry.attusingmode");
            selectFields.append(", ruleentry.length, ruleentry.initial, ruleentry.step");
            selectFields.append(", ruleentry.valueatribute, ruleentry.addchar, ruleentry.addstyle");
            selectFields.append(", ruleentry.cutstyle, ruleentry.issortitem, ruleentry.issplitsign, ruleentry.splitsignentry, ruleentry.isvisable");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_coderule", (String)selectFields.toString(), (QFilter[])qfArr);
            if (dynamicObject != null) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{BIZOBJECTID});
                this.getModel().setValue("ispreset", (Object)dynamicObject.getBoolean("ispreset"));
                Object bizobject = dynamicObject.get(BIZOBJECTID);
                Object ruleentry = dynamicObject.get("ruleentry");
                if (bizobject == null || ruleentry == null) {
                    this.getPageCache().put("error_tag", String.valueOf(true));
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7f16\u7801\u89c4\u5219\u6570\u636e\u5df2\u635f\u574f\uff0c\u53ef\u80fd\u662f\u4e1a\u52a1\u5bf9\u8c61\u6216\u5361\u7247\u88ab\u5220\u9664\uff0c\u8bf7\u8fd4\u56de\u5217\u8868\u5220\u9664\u6b64\u7f16\u7801\u89c4\u5219\u5e76\u91cd\u65b0\u521b\u5efa\u3002", (String)"CodeRuleNewEditPlugin_4", (String)BOS_CODERULE, (Object[])new Object[0]));
                }
            }
        }
        if (this.validateErrorTag()) {
            return;
        }
        this.pageShowPlugin.init();
    }

    private boolean validateErrorTag() {
        return String.valueOf(true).equals(this.getPageCache().get("error_tag"));
    }

    public void afterBindData(EventObject e) {
        if (this.validateErrorTag()) {
            return;
        }
        DynamicObject dynamicObject = PageCacheUtil.getDynamicObjectFromPageCache(this);
        this.pageChangePlugin.rebuildItem(dynamicObject);
    }

    public void click(EventObject evt) {
        if (this.validateErrorTag()) {
            return;
        }
        String key = ((Control)evt.getSource()).getKey();
        if ("btnclosetips".equals(key)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpaneltips"});
            return;
        }
        if (this.validateEditOperation()) {
            return;
        }
        if ("addcard".equalsIgnoreCase(key)) {
            this.pageChangeEntryPlugin.addEntry();
        } else if ("delcard".equalsIgnoreCase(key)) {
            this.pageChangeEntryPlugin.delEntry();
        } else if ("format".equalsIgnoreCase(key)) {
            this.pageShowEntryPlugin.showFormByFormat();
        } else if ("valueatributeshow".equalsIgnoreCase(key)) {
            this.pageShowEntryPlugin.showFormByValueatribute();
        }
    }

    private void openAddWindow() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        DynamicObject bizObjectDyn = (DynamicObject)this.getModel().getValue(BIZOBJECTID);
        String number = bizObjectDyn.getString("number");
        params.put("objNumber", number);
        TreeListUtil.showForm(this.getView(), FORMNUM_CODERULE_EDIT, params, null, ShowType.MainNewTabPage, OperationStatus.ADDNEW);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (this.validateErrorTag()) {
            return;
        }
        this.pageChangePlugin.changeByShowForm(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (this.validateErrorTag()) {
            return;
        }
        this.pageChangePlugin.changeByProperty(e);
    }

    public void itemClick(ItemClickEvent evt) {
        if (this.validateErrorTag()) {
            return;
        }
        String langName = RequestContext.get().getLang().name();
        DynamicObject bizobject = (DynamicObject)this.getModel().getValue(BIZOBJECTID);
        String codeRuleId = (String)this.getModel().getValue("id");
        if (this.getModel().getValue(BIZOBJECTID) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u5bf9\u8c61\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CodeRuleNewEditPlugin_0", (String)BOS_CODERULE, (Object[])new Object[0]));
            return;
        }
        String showNotifyDescription = ResManager.loadKDString((String)"\u65e0\u201c\u7f16\u7801\u89c4\u5219\u201d\u7684\u201c%s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CodeRuleNewEditPlugin_5", (String)BOS_CODERULE, (Object[])new Object[0]);
        switch (evt.getItemKey().toLowerCase()) {
            case "btn_save": {
                DynamicObjectCollection dynamicObjects;
                if (this.validateEditOperation()) {
                    return;
                }
                StringBuilder errMsg = new StringBuilder();
                if (!this.pageDataPlugin.checkData(errMsg)) {
                    this.getView().showErrorNotification(errMsg.toString());
                    return;
                }
                if (StringUtils.isNotBlank((CharSequence)codeRuleId) && (dynamicObjects = QueryServiceHelper.query((String)"bos_coderule_maxserial", (String)"id", (QFilter[])new QFilter("coderuleid", "=", (Object)codeRuleId).toArray())).size() > 0) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u89c4\u5219\u4e0b\u5df2\u6709\u201c\u6700\u5927\u53f7\u201d\u6570\u636e\uff0c \u662f\u5426\u786e\u8ba4\u4fee\u6539\u89c4\u5219\uff1f", (String)"CodeRuleNewEditPlugin_1", (String)BOS_CODERULE, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("coderule_edit", (IFormPlugin)this));
                    return;
                }
                this.pageDataPlugin.save(codeRuleId, bizobject);
                this.getView().setVisible(Boolean.TRUE, new String[]{"btn_disable", "btn_enable", "btn_org", "btn_add", "btn_copy"});
                this.getView().setEnable(Boolean.FALSE, new String[]{BIZOBJECTID});
                this.pageShowPlugin.setMoreHide();
                break;
            }
            case "btn_org": {
                this.pageShowPlugin.showFormByOrg(codeRuleId);
                break;
            }
            case "btn_condition": {
                this.pageShowPlugin.showFormCondition(codeRuleId, bizobject, langName);
                break;
            }
            case "maxserial": {
                this.pageShowPlugin.showFormMaxserial(codeRuleId);
                break;
            }
            case "intermitno": {
                this.pageShowPlugin.showFormIntermitno(codeRuleId);
                break;
            }
            case "btn_option": {
                this.pageShowPlugin.showFormOptional(codeRuleId);
                break;
            }
            case "btn_new_condiiton": {
                this.pageShowPlugin.showFormNewCondition(codeRuleId, bizobject);
                break;
            }
            case "btn_disable": {
                boolean isPreset;
                if (!PermUtil.validateForDisable(RequestContext.get().getCurrUserId())) {
                    this.getView().showErrorNotification(String.format(showNotifyDescription, ResManager.loadKDString((String)"\u7981\u7528", (String)"CodeRuleNewEditPlugin_6", (String)BOS_CODERULE, (Object[])new Object[0])));
                    break;
                }
                Map<Boolean, String> disableTipMap = this.pageDataPlugin.disable(codeRuleId);
                if (disableTipMap.containsKey(Boolean.TRUE)) {
                    if (!PermUtil.validateForUpdate(RequestContext.get().getCurrUserId())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\uff0c\u65e0\u201c\u7f16\u7801\u89c4\u5219\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u7f16\u8f91\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CodeRuleNewEditPlugin_10", (String)BOS_CODERULE, (Object[])new Object[0]));
                        break;
                    }
                    this.getView().setStatus(OperationStatus.EDIT);
                    this.getView().showSuccessNotification(disableTipMap.get(Boolean.TRUE));
                    this.getPageCache().put(CODERULEENABLECACHE, "edit");
                } else {
                    this.getView().showTipNotification(disableTipMap.get(Boolean.FALSE));
                }
                this.pageShowEntryPlugin.checkFillWithZero();
                Object preset = this.getModel().getValue("ispreset");
                boolean bl = isPreset = preset instanceof Boolean && (Boolean)preset != false;
                if (isPreset) {
                    this.getView().setStatus(OperationStatus.VIEW);
                    this.getPageCache().put(CODERULEENABLECACHE, "view");
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpaneltips"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpresettips"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexenabletips"});
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpaneltips"});
                break;
            }
            case "btn_enable": {
                boolean isPresetOnEnable;
                if (!PermUtil.validateForEnable(Long.parseLong(RequestContext.get().getUserId()))) {
                    this.getView().showErrorNotification(String.format(showNotifyDescription, ResManager.loadKDString((String)"\u542f\u7528", (String)"CodeRuleNewEditPlugin_7", (String)BOS_CODERULE, (Object[])new Object[0])));
                    break;
                }
                Map<Boolean, String> enableTipMap = this.pageDataPlugin.enable(codeRuleId);
                if (!enableTipMap.containsKey(Boolean.TRUE)) {
                    this.getView().showTipNotification(enableTipMap.get(Boolean.FALSE));
                    break;
                }
                this.getView().setStatus(OperationStatus.VIEW);
                this.getView().showSuccessNotification(enableTipMap.get(Boolean.TRUE));
                this.getPageCache().put(CODERULEENABLECACHE, "view");
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpaneltips"});
                Object presetOnEnable = this.getModel().getValue("ispreset");
                boolean bl = isPresetOnEnable = presetOnEnable instanceof Boolean && (Boolean)presetOnEnable != false;
                if (isPresetOnEnable) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpresettips"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexenabletips"});
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpresettips"});
                break;
            }
            case "btn_add": {
                if (!PermUtil.validateForSave(Long.parseLong(RequestContext.get().getUserId()))) {
                    this.getView().showErrorNotification(String.format(showNotifyDescription, ResManager.loadKDString((String)"\u65b0\u589e", (String)"CodeRuleNewEditPlugin_9", (String)BOS_CODERULE, (Object[])new Object[0])));
                    return;
                }
                this.openAddWindow();
                break;
            }
            case "btn_copy": {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("id", this.getModel().getValue("id"));
                params.put("iscopy", "true");
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "refresh");
                TreeListUtil.showForm(this.getView(), FORMNUM_CODERULE_EDIT, params, closeCallBack, ShowType.MainNewTabPage, OperationStatus.EDIT);
                break;
            }
        }
        this.clearCache(bizobject, codeRuleId);
    }

    private boolean validateEditOperation() {
        DynamicObject dynamicObject;
        boolean enable;
        DynamicObjectCollection query;
        Object codeRuleIdObj = this.getModel().getValue("id");
        if (codeRuleIdObj != null && CollectionUtils.isNotEmpty((Collection)(query = QueryServiceHelper.query((String)"bos_coderule", (String)"enable", (QFilter[])new QFilter("id", "=", (Object)((String)codeRuleIdObj)).toArray()))) && (enable = (dynamicObject = (DynamicObject)query.get(0)).getBoolean("enable"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u7528\u4e2d\u7684\u7f16\u7801\u89c4\u5219\uff0c\u4e0d\u80fd\u8fdb\u884c\u7f16\u8f91\u76f8\u5173\u64cd\u4f5c\uff0c\u8bf7\u7981\u7528\u540e\u518d\u64cd\u4f5c\u3002", (String)"CodeRuleNewEditPlugin_2", (String)BOS_CODERULE, (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void clearCache(DynamicObject bizobject, String codeRuleId) {
        DynamicObjectType type = CodeRuleUtils.getDynamicObjectType();
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)type);
        String entityId = (String)bizobject.getPkValue();
        cacheManager.removeByPrimaryKey(new Object[]{entityId});
        CodeRuleCacheMrg.clearCacheWithPrefix(CodeRuleCacheMrg.getType4BreakNumber(), codeRuleId);
        CodeRuleCacheMrg.clearCacheWithPrefix(CodeRuleCacheMrg.getType4SerialNumber(), codeRuleId);
        CodeRuleCacheMrg.clearCacheWithPrefix(CodeRuleCacheMrg.getType4MaxSerialNumber(), codeRuleId);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (this.validateErrorTag()) {
            return;
        }
        if (this.validateEditOperation()) {
            return;
        }
        if (this.getPageCache().get("close") == null && this.getModel().getDataChanged()) {
            e.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u9000\u51fa\uff1f", (String)"CodeRuleNewEditPlugin_3", (String)BOS_CODERULE, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("continue_close", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        super.confirmCallBack(messageboxclosedevent);
        String callBackId = messageboxclosedevent.getCallBackId();
        if ("continue_close".equals(callBackId) && messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("close", "");
            this.getView().close();
        } else if ("coderule_edit".equals(callBackId) && messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.pageDataPlugin.save((String)this.getModel().getValue("id"), (DynamicObject)this.getModel().getValue(BIZOBJECTID));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        QFilter modelType = new QFilter("modeltype", "in", (Object)new String[]{"BaseFormModel", "BillFormModel"});
        QFilter isTemplate = new QFilter("istemplate", "=", (Object)false);
        QFilter supportCodeRule = new QFilter("codenumber", "=", (Object)"1");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(modelType);
        qFilters.add(isTemplate);
        qFilters.add(supportCodeRule);
        listShowParameter.getListFilterParameter().setQFilters(qFilters);
    }
}

