/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.AbstractCodeRuleTreeListPlugin;
import kd.bos.coderule.adaptor.CodeRuleSigner;
import kd.bos.coderule.adaptor.CodeRuleSignerFactory;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.service.cache.CodeRuleCache;
import kd.bos.coderule.service.cache.CodeRuleCacheMrg;
import kd.bos.coderule.util.AppLogUtil;
import kd.bos.coderule.util.CodeRuleFastUtil;
import kd.bos.coderule.util.CodeRuleUtils;
import kd.bos.coderule.util.CommonUtil;
import kd.bos.coderule.util.PermUtil;
import kd.bos.coderule.util.TreeListUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.StatusConvert;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class CodeRuleTreeListPlugin
extends AbstractCodeRuleTreeListPlugin {
    private static final String FORMNUM_CODERULE_EDIT = "bos_coderule_edit";
    private static final String INTERMITNO_UTIL = "bos_intermitno_util";
    private static final String SQL_FIELD_CODERULEID = "coderuleid";
    private static final String TABLE_BOS_CODERULE_MAXSERIAL = "bos_coderule_maxserial";
    private static final String FIELD_PROPERTY_ENABLE = "enable";
    private static final String FIELD_PROPERTY_PRESET = "ispreset";
    private static final String FIELD_PROPERTY_ENABLE_PRESET = "enable,ispreset";
    private static final String BOS_CODERULE = "bos-coderule";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
        HashMap<String, Object> params = new HashMap<String, Object>();
        BillList billList = (BillList)this.getControl("billlistap");
        String id = (String)billList.getFocusRowPkId();
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)billList.getEntityType().getName(), (String)FIELD_PROPERTY_ENABLE_PRESET, (QFilter[])new QFilter("id", "=", (Object)id).toArray());
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CodeRuleTreeListPlugin_40", (String)BOS_CODERULE, (Object[])new Object[0]));
            return;
        }
        boolean enable = dynamicObject.getBoolean(FIELD_PROPERTY_ENABLE);
        boolean preset = dynamicObject.getBoolean(FIELD_PROPERTY_PRESET);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "refresh");
        params.put("id", id);
        if (enable || preset) {
            TreeListUtil.showForm(this.getView(), FORMNUM_CODERULE_EDIT, params, closeCallBack, ShowType.MainNewTabPage, OperationStatus.VIEW);
            return;
        }
        TreeListUtil.showForm(this.getView(), FORMNUM_CODERULE_EDIT, params, closeCallBack, ShowType.MainNewTabPage, OperationStatus.EDIT);
    }

    public void beforeItemClick(BeforeItemClickEvent beforeitemclickevent) {
        String itemkey = beforeitemclickevent.getItemKey();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        TreeView systeTtree = (TreeView)this.getControl("subsystemtree");
        Map map = systeTtree.getTreeState().getFocusNode();
        if (!("btn_add".equals(itemkey) || "btn_reflesh".equals(itemkey) || "btn_exit".equals(itemkey) || rows.size() != 0)) {
            if ("btn_delete".equals(itemkey) || "btn_org".equals(itemkey) || "baritem_clearcache".equals(itemkey) || "log".equals(itemkey) || "maxserial".equals(itemkey) || "intermitno".equals(itemkey) || "growup".equals(itemkey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CodeRuleTreeListPlugin_0", (String)BOS_CODERULE, (Object[])new Object[0]));
            }
            return;
        }
        if (("btn_org".equals(itemkey) || "btn_seqsegment".equals(itemkey) || "btn_enable".equals(itemkey) || "btn_copy".equals(itemkey)) && rows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u7f16\u7801\u89c4\u5219\u3002", (String)"CodeRuleTreeListPlugin_1", (String)BOS_CODERULE, (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        Object[] ids = new String[rows.size()];
        int i = 0;
        for (ListSelectedRow row : rows) {
            ids[i++] = (String)row.getPrimaryKeyValue();
        }
        String showNotifyDescription = ResManager.loadKDString((String)"\u65e0\u201c\u7f16\u7801\u89c4\u5219\u201d\u7684\u201c%s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CodeRuleNewEditPlugin_5", (String)BOS_CODERULE, (Object[])new Object[0]);
        switch (itemkey) {
            case "btn_reflesh": {
                beforeitemclickevent.setCancel(true);
                this.simulateTreeNodeClick(billList, systeTtree);
                break;
            }
            case "btn_add": {
                if (!PermUtil.validateForSave(Long.parseLong(RequestContext.get().getUserId()))) {
                    this.getView().showErrorNotification(String.format(showNotifyDescription, ResManager.loadKDString((String)"\u65b0\u589e", (String)"CodeRuleNewEditPlugin_9", (String)BOS_CODERULE, (Object[])new Object[0])));
                    break;
                }
                this.openAddWindow();
                break;
            }
            case "btn_delete": {
                if (!PermUtil.validateForDelete(Long.parseLong(RequestContext.get().getUserId()))) {
                    this.getView().showErrorNotification(String.format(showNotifyDescription, ResManager.loadKDString((String)"\u5220\u9664", (String)"CodeRuleNewEditPlugin_8", (String)BOS_CODERULE, (Object[])new Object[0])));
                    break;
                }
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%1$s\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\r\n\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"CodeRuleTreeListPlugin_30", (String)BOS_CODERULE, (Object[])new Object[0]), rows.size()), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_confirm", (IFormPlugin)this));
                break;
            }
            case "btn_enable": {
                if (!PermUtil.validateForEnable(Long.parseLong(RequestContext.get().getUserId()))) {
                    this.getView().showErrorNotification(String.format(showNotifyDescription, ResManager.loadKDString((String)"\u542f\u7528", (String)"CodeRuleNewEditPlugin_7", (String)BOS_CODERULE, (Object[])new Object[0])));
                    break;
                }
                beforeitemclickevent.setCancel(true);
                this.enable((String[])ids);
                this.simulateTreeNodeClick(billList, systeTtree);
                break;
            }
            case "btn_disable": {
                break;
            }
            case "baritem_clearcache": {
                this.clearCache((String[])ids);
                break;
            }
            case "btn_org": {
                params.put("codeRuleId", ids[0]);
                TreeListUtil.showForm(this.getView(), "bos_coderule_org", params, null, ShowType.Modal, OperationStatus.VIEW);
                break;
            }
            case "btn_seqsegment": {
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)ids[0], (String)"bos_coderule");
                DynamicObject bizobject = (DynamicObject)obj.get("bizObjectId");
                params.put("dynamicObjectType", bizobject.getString("number"));
                params.put("coderuleId", ids[0]);
                this.showSeqsegmentForm("bos_coderuleseqsegment", params, null, ShowType.Modal, (String)ids[0]);
                break;
            }
            case "btn_copy": {
                Object id = ids[0];
                params.put("id", id);
                params.put("iscopy", "true");
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "refresh");
                TreeListUtil.showForm(this.getView(), FORMNUM_CODERULE_EDIT, params, closeCallBack, ShowType.MainNewTabPage, OperationStatus.EDIT);
                break;
            }
            case "maxserial": {
                if (this.checkSelected((String[])ids)) {
                    QFilter qFilter = new QFilter(SQL_FIELD_CODERULEID, "=", ids[0]);
                    HashMap<String, Object> customParams = new HashMap<String, Object>(1);
                    customParams.put(SQL_FIELD_CODERULEID, ids[0]);
                    String unionId = this.getView().getPageId() + "maxserial" + (String)ids[0];
                    CodeRuleUtils.openBillFormListSingle((AbstractFormPlugin)this, TABLE_BOS_CODERULE_MAXSERIAL, Collections.singletonList(qFilter), unionId, customParams, ResManager.loadKDString((String)"\u6700\u5927\u53f7", (String)"CodeRuleTreeListPlugin_38", (String)BOS_CODERULE, (Object[])new Object[0]));
                    break;
                }
                beforeitemclickevent.setCancel(true);
                break;
            }
            case "intermitno": {
                if (this.checkSelected((String[])ids)) {
                    QFilter qFilter = new QFilter(SQL_FIELD_CODERULEID, "=", ids[0]);
                    HashMap<String, Object> customParams = new HashMap<String, Object>(1);
                    customParams.put(SQL_FIELD_CODERULEID, ids[0]);
                    String unionId = this.getView().getPageId() + "intermitno" + (String)ids[0];
                    CodeRuleUtils.openBillFormListSingle((AbstractFormPlugin)this, "bos_coderule_intermitno", Collections.singletonList(qFilter), unionId, customParams, ResManager.loadKDString((String)"\u65ad\u53f7", (String)"CodeRuleTreeListPlugin_39", (String)BOS_CODERULE, (Object[])new Object[0]));
                    break;
                }
                beforeitemclickevent.setCancel(true);
                break;
            }
            case "log": {
                if (this.checkSelected((String[])ids)) {
                    QFilter qFilter = new QFilter("bizobj", "=", (Object)"bos_coderule").and(new QFilter("opdescriptione", "like", (Object)("%" + String.format(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219ID:%s", (String)"CodeRuleTreeListPlugin_8", (String)BOS_CODERULE, (Object[])new Object[0]), ids[0]) + "%")));
                    CodeRuleUtils.openBillFormList((AbstractFormPlugin)this, "bos_log_operation_web", Arrays.asList(qFilter.toArray()));
                    break;
                }
                beforeitemclickevent.setCancel(true);
                break;
            }
            case "growup": {
                if (ArrayUtils.isEmpty((Object[])ids)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CodeRuleTreeListPlugin_0", (String)BOS_CODERULE, (Object[])new Object[0]));
                    beforeitemclickevent.setCancel(true);
                    break;
                }
                if (this.isFast((String[])ids)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u662f\u9ad8\u53ef\u9760\u6a21\u5f0f\uff0c\u65e0\u9700\u518d\u6b21\u53d8\u66f4\u3002", (String)"CodeRuleUpgradeTreeListPlugin_11", (String)BOS_CODERULE, (Object[])new Object[0]));
                    beforeitemclickevent.setCancel(true);
                    break;
                }
                this.growup();
                break;
            }
        }
    }

    private boolean isFast(String[] ids) {
        Map codeRuleMap = BusinessDataServiceHelper.loadFromCache((Object[])ids, (String)"bos_coderule");
        for (DynamicObject codeRule : codeRuleMap.values()) {
            if (codeRule.getBoolean("isfast")) continue;
            return false;
        }
        return true;
    }

    private void growup() {
        ListSelectedRowCollection rows = this.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            return;
        }
        String updateTips = ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u5c06\u53d8\u66f4\u4e3a\u9ad8\u53ef\u9760\u6a21\u5f0f\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u53d8\u66f4\u3002\r\n\u8bf4\u660e\uff1a\u9ad8\u53ef\u9760\u6a21\u5f0f\u662f\u727a\u7272\u4e00\u5b9a\u7684\u6027\u80fd\uff0c\u5c06\u53d1\u53f7\u8bb0\u5f55\u78c1\u76d8\uff0c\u5728\u5b58\u50a8\u8282\u70b9\u5b95\u673a\u6062\u590d\u540e\uff0c\u80fd\u8fd8\u539f\u5b95\u673a\u524d\u7684\u53d1\u53f7\u4fe1\u606f\uff0c\u4f9d\u6b21\u505a\u5230\u8fde\u7eed\u6027\u53d1\u53f7\u3002", (String)"CodeRuleUpgradeTreeListPlugin_10", (String)BOS_CODERULE, (Object[])new Object[0]);
        HashMap<Integer, String> btnNamesMaps = new HashMap<Integer, String>(2);
        btnNamesMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"CodeRuleUpgradeTreeListPlugin_2", (String)BOS_CODERULE, (Object[])new Object[0]));
        btnNamesMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u4e0b\u4e00\u6b65", (String)"CodeRuleUpgradeTreeListPlugin_3", (String)BOS_CODERULE, (Object[])new Object[0]));
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("upgrade_comfirm", (IFormPlugin)this);
        this.getView().showConfirm(updateTips, this.getModel().getChangeDesc(), MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBackListener, btnNamesMaps);
    }

    protected void simulateTreeNodeClick(BillList billList, TreeView systeTtree) {
        billList.refreshData();
    }

    private boolean checkIntermitNoDetectUtil(String[] ids) {
        ArrayList<String> strs = new ArrayList<String>();
        for (String id : ids) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bos_coderule");
            if (obj.getInt(FIELD_PROPERTY_ENABLE) != 0 && obj.getBoolean("isnonbreak")) continue;
            strs.add(obj.getString("name"));
        }
        if (strs.isEmpty()) {
            return false;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u65ad\u53f7\u8865\u507f\u201d\u4e3a\u201c\u542f\u7528\u201d\uff0c\u4e14\u201c\u4f7f\u7528\u72b6\u6001\u201d\u4e3a\u201c\u53ef\u7528\u201d\u7684\u7f16\u7801\u89c4\u5219\uff0c\u624d\u5141\u8bb8\u201c\u65ad\u53f7\u68c0\u6d4b\u201d\u3002", (String)"CodeRuleTreeListPlugin_10", (String)BOS_CODERULE, (Object[])new Object[0]));
        return true;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList billList = (BillList)this.getControl("billlistap");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", billList.getFocusRowPkId());
        if (!PermUtil.validateForUpdate(Long.parseLong(RequestContext.get().getUserId()))) {
            TreeListUtil.showForm(this.getView(), FORMNUM_CODERULE_EDIT, params, null, ShowType.MainNewTabPage, OperationStatus.VIEW);
            return;
        }
        Object primaryKeyValue = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)billList.getEntityType().getName(), (String)FIELD_PROPERTY_ENABLE_PRESET, (QFilter[])new QFilter("id", "=", (Object)primaryKeyValue.toString()).toArray());
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CodeRuleTreeListPlugin_40", (String)BOS_CODERULE, (Object[])new Object[0]));
            return;
        }
        boolean enable = ((DynamicObject)dynamicObjects.get(0)).getBoolean(FIELD_PROPERTY_ENABLE);
        boolean preset = ((DynamicObject)dynamicObjects.get(0)).getBoolean(FIELD_PROPERTY_PRESET);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "refresh");
        if (enable || preset) {
            TreeListUtil.showForm(this.getView(), FORMNUM_CODERULE_EDIT, params, closeCallBack, ShowType.MainNewTabPage, OperationStatus.VIEW);
            return;
        }
        TreeListUtil.showForm(this.getView(), FORMNUM_CODERULE_EDIT, params, closeCallBack, ShowType.MainNewTabPage, OperationStatus.EDIT);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evet) {
        String operateKey = evet.getOperateKey();
        if ("donothing".equals(operateKey)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.clearSelection();
            return;
        }
        if ("interno_check".equals(operateKey) && evet.getOperationResult().isSuccess()) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            HashMap<String, Object> params = new HashMap<String, Object>();
            Object[] ids = new String[rows.size()];
            int i = 0;
            for (ListSelectedRow row : rows) {
                ids[i++] = (String)row.getPrimaryKeyValue();
            }
            if (!this.checkIntermitNoDetectUtil((String[])ids)) {
                params.put("selectedCodeRuleIds", StringUtils.join((Object[])ids, (String)","));
                CodeRuleUtils.showForm((AbstractFormPlugin)this, INTERMITNO_UTIL, ResManager.loadKDString((String)"\u65ad\u53f7\u68c0\u6d4b", (String)"CodeRuleTreeListPlugin_11", (String)BOS_CODERULE, (Object[])new Object[0]), params, null);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)"disable", (CharSequence)operateKey)) {
            List numberAndName;
            OperationResult operationResult = evet.getOperationResult();
            List operateInfos = operationResult.getAllErrorOrValidateInfo();
            if (CollectionUtils.isEmpty((Collection)operateInfos)) {
                return;
            }
            StatusConvert source = (StatusConvert)evet.getSource();
            ListSelectedRowCollection listSelectedData = source.getListSelectedData();
            if (CollectionUtils.isEmpty((Collection)listSelectedData)) {
                return;
            }
            HashMap nameMap = new HashMap(listSelectedData.size());
            LinkedHashMap<Object, String> replaceNameMap = new LinkedHashMap<Object, String>(listSelectedData.size());
            for (ListSelectedRow selectedRow : listSelectedData) {
                numberAndName = new ArrayList<String>(2);
                numberAndName.add(selectedRow.getNumber());
                numberAndName.add(selectedRow.getName());
                nameMap.put(selectedRow.getPrimaryKeyValue(), numberAndName);
                replaceNameMap.put(selectedRow.getPrimaryKeyValue(), selectedRow.getName());
            }
            for (IOperateInfo operateInfo : operateInfos) {
                if (!(operateInfo instanceof OperateErrorInfo) || CollectionUtils.isEmpty(numberAndName = (List)nameMap.get(operateInfo.getPkValue())) || numberAndName.size() < 2) continue;
                String message = operateInfo.getMessage();
                if (StringUtils.isBlank((CharSequence)((CharSequence)numberAndName.get(0))) || StringUtils.isBlank((CharSequence)((CharSequence)numberAndName.get(1)))) continue;
                String replaceMessage = message.replace((CharSequence)numberAndName.get(0), (CharSequence)numberAndName.get(1));
                ((OperateErrorInfo)operateInfo).setMessage(replaceMessage);
            }
            operationResult.setBillNos(replaceNameMap);
        }
    }

    private void showSeqsegmentForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, String coderuleId) {
        QFilter[] qfArr;
        DynamicObject[] coderuleSeqsegment;
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (params != null) {
            param.setCustomParams(params);
        }
        if ((coderuleSeqsegment = BusinessDataServiceHelper.load((String)"bos_coderuleseqsegment", (String)"id,", (QFilter[])(qfArr = new QFilter[]{new QFilter(SQL_FIELD_CODERULEID, "=", (Object)coderuleId)}))) != null && coderuleSeqsegment.length > 0) {
            param.setPkId(coderuleSeqsegment[0].get("id"));
            param.setStatus(OperationStatus.EDIT);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    private void delete(String[] ids, boolean allDelete) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_coderule");
        DeleteServiceHelper.delete((IDataEntityType)type, (Object[])ids);
        if (allDelete) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"CodeRuleTreeListPlugin_12", (String)BOS_CODERULE, (Object[])new Object[0]));
        }
    }

    private void enable(String[] ids) {
        String codeRuleId = ids[0];
        String enable_status = "1";
        QFilter curRuleFiler = new QFilter("id", "=", (Object)codeRuleId);
        QFilter[] qFilter = new QFilter[]{curRuleFiler};
        DynamicObject[] col = BusinessDataServiceHelper.load((String)"bos_coderule", (String)"id, bizobjectid, enable,name", (QFilter[])qFilter);
        if (col == null || col.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CodeRuleTreeListPlugin_13", (String)BOS_CODERULE, (Object[])new Object[0]));
            return;
        }
        DynamicObject coderule = col[0];
        String coderuleIds = Arrays.stream(col).map(x -> x.getString("id")).collect(Collectors.joining("\u3001"));
        if (enable_status.equals(coderule.get(FIELD_PROPERTY_ENABLE))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u53ef\u7528\u72b6\u6001\u3002", (String)"CodeRuleTreeListPlugin_37", (String)BOS_CODERULE, (Object[])new Object[0]));
            AppLogUtil.insertAppLog(this.getView(), coderule, new MultiLangEnumBridge("\u542f\u7528\u89c4\u5219", "CodeRuleTreeListPlugin_15", BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u6570\u636e\u672a\u7981\u7528\uff0c\u4e0d\u80fd\u542f\u7528", "CodeRuleTreeListPlugin_16", BOS_CODERULE), coderuleIds, CommonUtil.getDynamicObjProperties(coderule, "name").toString());
            return;
        }
        DynamicObject bizobject = coderule.getDynamicObject("bizobjectid");
        String bizObjectId = bizobject.getString("id");
        String msg = CodeRuleUtils.isDuplicateCodeRule(bizObjectId, codeRuleId, null, null);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.getView().showErrorNotification(msg);
            return;
        }
        String sql = String.format("update %s set fenable = '1' where fid = ? ", "t_cr_coderule");
        try (TXHandle h = TX.required();){
            try {
                DB.update((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{codeRuleId});
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
        LocaleString msgLocale = new LocaleString(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"CodeRuleTreeListPlugin_17", (String)BOS_CODERULE, (Object[])new Object[0]));
        this.getView().showSuccessNotification(msgLocale.getLocaleValue());
        AppLogUtil.insertAppLog(this.getView(), coderule, new MultiLangEnumBridge("\u542f\u7528\u89c4\u5219", "CodeRuleTreeListPlugin_15", BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u542f\u7528\u6210\u529f", "CodeRuleTreeListPlugin_18", BOS_CODERULE), coderuleIds, CommonUtil.getDynamicObjProperties(coderule, "name").toString());
        DynamicObjectType type = CodeRuleUtils.getDynamicObjectType();
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)type);
        cacheManager.removeByPrimaryKey(new Object[]{bizObjectId});
        CodeRuleCacheMrg.clearCacheWithPrefix(CodeRuleCacheMrg.getType4BreakNumber(), codeRuleId);
        CodeRuleCacheMrg.clearCacheWithPrefix(CodeRuleCacheMrg.getType4SerialNumber(), codeRuleId);
        CodeRuleCacheMrg.clearCacheWithPrefix(CodeRuleCacheMrg.getType4MaxSerialNumber(), codeRuleId);
    }

    private void clearCache(String[] ids) {
        CodeRuleUtils.clearCache(ids);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e05\u7406\u7f16\u7801\u89c4\u5219\u7f13\u5b58\u6210\u529f\u3002", (String)"CodeRuleTreeListPlugin_19", (String)BOS_CODERULE, (Object[])new Object[0]));
    }

    private void openAddWindow() {
        TreeView systeTtree = (TreeView)this.getControl("subsystemtree");
        Map map = systeTtree.getTreeState().getFocusNode();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (null != map && (null == map.get("id") || "3".equals(String.valueOf(map.get("id")).split("_split_")[0]))) {
            String objId = String.valueOf(map.get("id")).split("_split_")[1];
            params.put("objId", objId);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "refresh");
        TreeListUtil.showForm(this.getView(), FORMNUM_CODERULE_EDIT, params, closeCallBack, ShowType.MainNewTabPage, OperationStatus.ADDNEW);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("refresh".equals(e.getActionId())) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if (callBackId.equals("delete_confirm") && mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            String[] ids = new String[rows.size()];
            int i = 0;
            for (ListSelectedRow row : rows) {
                ids[i++] = (String)row.getPrimaryKeyValue();
            }
            String selectFields = "id,bizobjectid,name,ispreset";
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)ids)};
            DynamicObjectCollection bizCol = QueryServiceHelper.query((String)"bos_coderule", (String)selectFields, (QFilter[])filters);
            if (bizCol == null || bizCol.size() == 0) {
                return;
            }
            ArrayList<String> notPresetIds = new ArrayList<String>();
            StringBuilder presetTips = new StringBuilder();
            String type = CodeRuleCacheMrg.getType4EntityCodeRules();
            String ruleNames = "";
            StringBuilder sbRuleNames = new StringBuilder();
            for (DynamicObject biz : bizCol) {
                String id = biz.getString("id");
                CodeRuleCacheMrg.clearCache(type, biz.getString("bizobjectid"));
                CodeRuleCacheMrg.clearCacheWithPrefix(CodeRuleCacheMrg.getType4BreakNumber(), id);
                CodeRuleCacheMrg.clearCacheWithPrefix(CodeRuleCacheMrg.getType4SerialNumber(), id);
                if (biz.getBoolean(FIELD_PROPERTY_PRESET)) {
                    presetTips.append(biz.getString("name")).append(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u5220\u9664\u5931\u8d25\uff1a", (String)"CodeRuleTreeListPlugin_43", (String)BOS_CODERULE, (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u9884\u7f6e\u89c4\u5219\u7981\u6b62\u5220\u9664\u3002", (String)"CodeRuleTreeListPlugin_41", (String)BOS_CODERULE, (Object[])new Object[0])).append(System.getProperty("line.separator"));
                    continue;
                }
                notPresetIds.add(id);
                if (sbRuleNames.length() > 0) {
                    sbRuleNames.append(',');
                }
                sbRuleNames.append(biz.getString("name"));
            }
            ruleNames = sbRuleNames.toString();
            boolean allDelete = true;
            if (ids.length == 1 && notPresetIds.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u89c4\u5219\u7981\u6b62\u5220\u9664\u3002", (String)"CodeRuleTreeListPlugin_41", (String)BOS_CODERULE, (Object[])new Object[0]));
                return;
            }
            if (ids.length > 1 && ids.length > notPresetIds.size()) {
                allDelete = false;
                int total = ids.length;
                int success = notPresetIds.size();
                int failed = total - success;
                String tips = String.format(ResManager.loadKDString((String)"\u5171%1s\u4e2a\u89c4\u5219\uff0c\u5220\u9664\u6210\u529f%2s\u4e2a\uff0c\u5931\u8d25%3s\u4e2a", (String)"CodeRuleTreeListPlugin_42", (String)BOS_CODERULE, (Object[])new Object[0]), total, success, failed);
                this.getView().showMessage(tips, presetTips.toString(), MessageTypes.Default);
            }
            ids = notPresetIds.toArray(new String[0]);
            QFilter codeRuleFilter = new QFilter(SQL_FIELD_CODERULEID, "in", (Object)ids);
            filters = new QFilter[]{codeRuleFilter};
            DeleteServiceHelper.delete((String)"bos_coderule_intermitno", (QFilter[])filters);
            this.deleteMaxserial(filters, ids);
            this.delete(ids, allDelete);
            OpLogAppInfo appLogInfo = new OpLogAppInfo();
            appLogInfo.setOpName("ruleCodeOp", new MultiLangEnumBridge("\u5220\u9664", "CodeRuleTreeListPlugin_26", BOS_CODERULE));
            appLogInfo.setOpDesc(new MultiLangEnumBridge("\u5220\u9664%s\u6210\u529f", "CodeRuleTreeListPlugin_36", BOS_CODERULE), new String[]{ruleNames});
            CodeRuleUtils.waitLog((AppLogInfo)appLogInfo);
            billList.clearSelection();
            billList.refresh();
        }
        if (callBackId.equals("upgrade_comfirm") && mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
            List<String> codeRuleIds = this.getUpgradeCodeRuleId();
            boolean isSuccess = true;
            try {
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u6a21\u5f0f\u5207\u6362\u4e2d", (String)"CodeRuleUpgradeConfirmPlugin_5", (String)BOS_CODERULE, (Object[])new Object[0])));
                this.upgrade(codeRuleIds);
                this.getView().hideLoading();
                this.showFormForUpgradeComplete(true, ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u5df2\u53d8\u66f4\u4e3a\u9ad8\u53ef\u9760\u6a21\u5f0f\uff0c\u8bf7\u5230\u76f8\u5e94\u4e1a\u52a1\u6a21\u5757\u4f53\u9a8c\u65b0\u7684\u7f16\u7801\u6548\u679c\u3002", (String)"CodeRuleUpgradeConfirmPlugin_6", (String)BOS_CODERULE, (Object[])new Object[0]), ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219-\u9ad8\u53ef\u9760\u53d8\u66f4\u5b8c\u6210", (String)"CodeRuleTreeListPlugin_34", (String)BOS_CODERULE, (Object[])new Object[0]));
            }
            catch (Exception e) {
                try {
                    isSuccess = false;
                    this.showFormForUpgradeComplete(false, ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u6a21\u5f0f\u5207\u6362\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u6b21\u5c1d\u8bd5\u3002", (String)"CodeRuleUpgradeConfirmPlugin_10", (String)BOS_CODERULE, (Object[])new Object[0]), ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219-\u9ad8\u53ef\u9760\u53d8\u66f4\u5931\u8d25", (String)"CodeRuleTreeListPlugin_35", (String)BOS_CODERULE, (Object[])new Object[0]));
                }
                catch (Throwable throwable) {
                    OpLogAppInfo appLogInfo = new OpLogAppInfo();
                    appLogInfo.setOpName("ruleCodeOp", new MultiLangEnumBridge("\u9ad8\u53ef\u9760\u6a21\u5f0f\u53d8\u66f4", "CodeRuleTreeListPlugin_31", BOS_CODERULE));
                    String arg = ResManager.loadKDString((String)"\u5931\u8d25", (String)"CodeRuleTreeListPlugin_32", (String)BOS_CODERULE, (Object[])new Object[0]);
                    if (isSuccess) {
                        arg = ResManager.loadKDString((String)"\u6210\u529f", (String)"CodeRuleTreeListPlugin_27", (String)BOS_CODERULE, (Object[])new Object[0]);
                    }
                    appLogInfo.setOpDesc(new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219\uff1a%s\uff0c\u9ad8\u53ef\u9760\u6a21\u5f0f\u53d8\u66f4\u3002", "CodeRuleTreeListPlugin_33", BOS_CODERULE), new String[]{StringUtils.join((Object[])codeRuleIds.toArray(), (String)",") + arg});
                    CodeRuleUtils.waitLog((AppLogInfo)appLogInfo);
                    throw throwable;
                }
                OpLogAppInfo appLogInfo = new OpLogAppInfo();
                appLogInfo.setOpName("ruleCodeOp", new MultiLangEnumBridge("\u9ad8\u53ef\u9760\u6a21\u5f0f\u53d8\u66f4", "CodeRuleTreeListPlugin_31", BOS_CODERULE));
                String arg = ResManager.loadKDString((String)"\u5931\u8d25", (String)"CodeRuleTreeListPlugin_32", (String)BOS_CODERULE, (Object[])new Object[0]);
                if (isSuccess) {
                    arg = ResManager.loadKDString((String)"\u6210\u529f", (String)"CodeRuleTreeListPlugin_27", (String)BOS_CODERULE, (Object[])new Object[0]);
                }
                appLogInfo.setOpDesc(new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219\uff1a%s\uff0c\u9ad8\u53ef\u9760\u6a21\u5f0f\u53d8\u66f4\u3002", "CodeRuleTreeListPlugin_33", BOS_CODERULE), new String[]{StringUtils.join((Object[])codeRuleIds.toArray(), (String)",") + arg});
                CodeRuleUtils.waitLog((AppLogInfo)appLogInfo);
            }
            OpLogAppInfo appLogInfo = new OpLogAppInfo();
            appLogInfo.setOpName("ruleCodeOp", new MultiLangEnumBridge("\u9ad8\u53ef\u9760\u6a21\u5f0f\u53d8\u66f4", "CodeRuleTreeListPlugin_31", BOS_CODERULE));
            String arg = ResManager.loadKDString((String)"\u5931\u8d25", (String)"CodeRuleTreeListPlugin_32", (String)BOS_CODERULE, (Object[])new Object[0]);
            if (isSuccess) {
                arg = ResManager.loadKDString((String)"\u6210\u529f", (String)"CodeRuleTreeListPlugin_27", (String)BOS_CODERULE, (Object[])new Object[0]);
            }
            appLogInfo.setOpDesc(new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219\uff1a%s\uff0c\u9ad8\u53ef\u9760\u6a21\u5f0f\u53d8\u66f4\u3002", "CodeRuleTreeListPlugin_33", BOS_CODERULE), new String[]{StringUtils.join((Object[])codeRuleIds.toArray(), (String)",") + arg});
            CodeRuleUtils.waitLog((AppLogInfo)appLogInfo);
        }
    }

    public void upgrade(List<String> codeRuleIds) {
        for (String codeRuleId : codeRuleIds) {
            CodeRuleSignerFactory.newInstanceFast().growup(codeRuleId);
        }
    }

    public void showFormForUpgradeComplete(boolean status, String msg, String caption) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bos_coderule_upgrade_ok");
        param.setCustomParam("msg_data", this.buildMsgData(status, msg));
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCaption(caption);
        param.setStatus(OperationStatus.VIEW);
        this.getView().showForm(param);
    }

    private Map<String, String> buildMsgData(boolean status, String msg) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("status", String.valueOf(status));
        map.put("msg", msg);
        return map;
    }

    private List<String> getUpgradeCodeRuleId() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        ArrayList<String> list = new ArrayList<String>(rows.size());
        for (ListSelectedRow row : rows) {
            list.add((String)row.getPrimaryKeyValue());
        }
        return list;
    }

    public void deleteMaxserial(QFilter[] filters, String[] ids) {
        if (ids.length == 0) {
            return;
        }
        for (String id : ids) {
            DynamicObject[] dynamicObjects;
            CodeRuleSigner codeRuleSigner = CodeRuleSignerFactory.newInstance(id);
            if (codeRuleSigner.isUseDB()) continue;
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)TABLE_BOS_CODERULE_MAXSERIAL, (String)"sortitemvalue", (QFilter[])new QFilter(SQL_FIELD_CODERULEID, "=", (Object)id).toArray())) {
                codeRuleSigner.clean(id, dynamicObject.getString("sortitemvalue"));
            }
        }
        DeleteServiceHelper.delete((String)TABLE_BOS_CODERULE_MAXSERIAL, (QFilter[])filters);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
    }

    private boolean checkSelected(String[] ids) {
        if (ArrayUtils.isEmpty((Object[])ids)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CodeRuleTreeListPlugin_0", (String)BOS_CODERULE, (Object[])new Object[0]));
            return false;
        }
        if (ids.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u7f16\u7801\u89c4\u5219\u3002", (String)"CodeRuleTreeListPlugin_1", (String)BOS_CODERULE, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    private static class MyListDataProvider
    extends ListDataProvider {
        private MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            if (rows.isEmpty()) {
                return rows;
            }
            List<String> codeRuleIds = rows.stream().map(row -> (String)row.getPkValue()).collect(Collectors.toList());
            String[] codeRuleIdArr = new String[codeRuleIds.size()];
            codeRuleIds.toArray(codeRuleIdArr);
            Map<String, CodeRuleInfo> codeRuleInfoMap = CodeRuleCache.reloadCodeRuleByIds(codeRuleIdArr);
            for (DynamicObject row2 : rows) {
                String coderuleid = (String)row2.getPkValue();
                CodeRuleInfo codeRuleInfo = codeRuleInfoMap.get(coderuleid);
                String name = row2.getString("name");
                if (!codeRuleInfo.isFast() || !StringUtils.isNotBlank((CharSequence)name)) continue;
                row2.set("name", (Object)(CodeRuleFastUtil.getTagName() + name));
            }
            return rows;
        }
    }
}

