/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.adaptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import kd.bos.coderule.adaptor.AbstractCodeRuleSigner;
import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.constant.CodeRuleConstant;
import kd.bos.coderule.domain.MaxserialApi;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.coderule.service.cache.CodeRuleCache;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.param.CustomParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.generator.Config;
import kd.bos.generator.ConfigFactory;
import kd.bos.generator.IDGen;
import kd.bos.generator.IDGenImpl;
import kd.bos.generator.common.GeneratorException;
import kd.bos.generator.common.Result;
import kd.bos.generator.common.ResultStatus;
import kd.bos.generator.segment.RecordSegmentSigner;
import kd.bos.generator.segment.RecordSegmentUtil;
import kd.bos.generator.segment.ReleaseTypeEnum;
import kd.bos.generator.segment.SegmentConfig;
import kd.bos.generator.segment.SegmentSigner;
import kd.bos.generator.segment.db.DBConfig;
import kd.bos.generator.segment.db.DBSigner;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class FastCodeRuleSigner
extends AbstractCodeRuleSigner
implements CodeRuleConstant {
    public static final long SEGMENTLENGTH = 1000L;
    public static final String SIGNER_ERROR = "Signer error";
    private IDGen idGen;
    private Config config;
    private String sortItem;
    private String codeRuleId;
    private boolean isDBGenerator;
    private Boolean isDefaultDBGenerator;

    public FastCodeRuleSigner() {
        String useDbGenerator = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam()).getOrDefault("SVC_CODERULE_USE_DB_GENERATOR", "true");
        this.isDBGenerator = Boolean.parseBoolean(useDbGenerator);
    }

    public FastCodeRuleSigner(boolean isDefaultDBGenerator) {
        this();
        this.isDefaultDBGenerator = isDefaultDBGenerator;
    }

    private void init(boolean isFast, String billnoKey, long initNumber, int step, long segmentLength, Supplier<Optional<Long>> getMaxNumberForInit) {
        if (this.isDBGenerator()) {
            this.initForDB(billnoKey, this.codeRuleId, this.sortItem, initNumber, step, segmentLength, getMaxNumberForInit);
            this.logger.info("[CodeRule]DB\u53d1\u53f7\u8fdb\u884c\u521d\u59cb\u5316\u3002");
            return;
        }
        this.logger.info("[CodeRule]Redis\u53d1\u53f7\u8fdb\u884c\u521d\u59cb\u5316\u3002");
        this.config = new SegmentConfig.Buidler().setKey(billnoKey).setInitNumber(initNumber).setStep(step).setSegmentLength(segmentLength).setGetMaxNumberForInit(getMaxNumberForInit).build();
        if (isFast) {
            this.idGen = new IDGenImpl(billnoKey, this.config, new RecordSegmentSigner.Buidler().setCallbackAtRelease(r -> {
                if (ReleaseTypeEnum.INIT == r) {
                    MaxserialApi.createUnique(this.codeRuleId, this.sortItem);
                }
            }).build());
            return;
        }
        this.idGen = new IDGenImpl(billnoKey, this.config, new SegmentSigner.Buidler().setCallbackAtRelease(r -> {
            if (ReleaseTypeEnum.INIT == r) {
                MaxserialApi.createUnique(this.codeRuleId, this.sortItem);
            }
        }).build());
    }

    private boolean isDBGenerator() {
        if (null != this.isDefaultDBGenerator) {
            return this.isDefaultDBGenerator;
        }
        return this.isDBGenerator;
    }

    private void initForDB(String billNoKey, String codeRuleId, String sortItem, long initNumber, int step, long segmentLength, Supplier<Optional<Long>> getMaxNumberForInit) {
        this.config = new DBConfig(codeRuleId, sortItem, initNumber, step, segmentLength, getMaxNumberForInit);
        this.idGen = new IDGenImpl(billNoKey, this.config, new DBSigner());
    }

    @Override
    protected String getBreakNumber(CodeRuleInfo codeRuleInfo, String sortItem, boolean isReadNumber) {
        return this.getBreakNumberFast(codeRuleInfo, sortItem, isReadNumber);
    }

    private String getBreakNumberFast(CodeRuleInfo codeRuleInfo, String sortItem, boolean isReadNumber) {
        Map<String, String> minBreakMap = this.getMinBreakMap(codeRuleInfo, sortItem);
        String breakId = minBreakMap.get("FID");
        String breakNumber = minBreakMap.get("FSerial");
        if (isReadNumber) {
            return breakNumber;
        }
        if (CollectionUtils.isEmpty(minBreakMap.entrySet())) {
            return "";
        }
        boolean b = this.deleteBreakId(codeRuleInfo, sortItem, breakId, breakNumber);
        return b ? breakNumber : "";
    }

    private Map<String, String> getMinBreakMap(CodeRuleInfo codeRuleInfo, String sortItem) {
        if (StringUtils.isBlank((CharSequence)sortItem)) {
            sortItem = "_split_";
        }
        Object[] params = new SqlParameter[]{new SqlParameter(":FCodeRuleID", 12, (Object)codeRuleInfo.getId()), new SqlParameter(":FSortItemValue", 12, (Object)sortItem)};
        String sql = "SELECT TOP 1 FID, FSerial FROM T_CR_IntermitNO WHERE FCodeRuleID = ? and FSortItemValue = ? order by FSerial";
        HashMap<String, String> map = new HashMap<String, String>();
        DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, rs -> {
            if (rs.next()) {
                map.put("FID", rs.getString("FID"));
                map.put("FSerial", rs.getString("FSerial"));
            }
            return null;
        });
        return map;
    }

    private boolean deleteBreakId(CodeRuleInfo codeRuleInfo, String sortItem, String breakId, String breakNumber) {
        String sql = "delete from T_CR_IntermitNO where FID = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)breakId)};
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            boolean bl = DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            return bl;
        }
        catch (Exception e) {
            this.logger.error(String.format("\u5220\u9664\u65ad\u53f7\u53d1\u751f\u5f02\u5e38\uff0c codeRuleId: %s, SerialNumber:%s, sortItemVaule: %s", codeRuleInfo.getId(), breakNumber, sortItem), (Throwable)e);
            h.markRollback();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return false;
    }

    @Override
    public long signerNumber(CodeRuleInfo codeRuleInfo, CodeRuleEntryInfo codeRuleEntry, String sortItem, boolean isReadNumber) {
        this.codeRuleId = codeRuleInfo.getId();
        this.sortItem = sortItem;
        String billNoKey = this.getBillNoKey(sortItem, this.codeRuleId);
        this.init(codeRuleInfo.isFast(), billNoKey, codeRuleEntry.getInitial() - codeRuleEntry.getStep(), (int)codeRuleEntry.getStep(), this.getSegmentLengthBySerialNumLen(codeRuleEntry.getLength()), () -> this.getMaxNumberForInit(codeRuleEntry, sortItem));
        Result result = isReadNumber ? this.idGen.read() : this.idGen.get();
        if (result.getStatus() == ResultStatus.FAIL) {
            throw new GeneratorException(SIGNER_ERROR, result.getException().getMessage(), result.getException());
        }
        long num = result.getCurseq();
        if (isReadNumber) {
            num += codeRuleEntry.getStep();
        }
        this.logger.info(String.format("[FastCodeRuleSigner][signerNumber]\u5355\u6761\u751f\u6210\u7684\u53f7:%s, \u6b65\u957f:%s, \u53ea\u8bfb\u5c5e\u6027:%s", num, codeRuleEntry.getStep(), isReadNumber));
        return num;
    }

    private long getSegmentLengthBySerialNumLen(int serialNumLen) {
        if (serialNumLen > 4) {
            return 1000L;
        }
        return (long)Math.pow(10.0, serialNumLen - 1);
    }

    public Optional<Long> getMaxNumberForInit(CodeRuleEntryInfo codeRuleEntry, String sortItem) {
        QFilter qFilter = new QFilter("codeRuleID", "=", (Object)this.codeRuleId).and(new QFilter("sortitemvalue", "=", (Object)sortItem));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_coderule_maxserial", (String)"sortitemvalue, maxserial", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)query)) {
            return Optional.empty();
        }
        if (query.size() > 1) {
            throw new GeneratorException(GeneratorException.ErrorCode.ERRCODE_INIT_MAXSERIAL_DB.getCode(), String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u53f7\u6bb5\u4fe1\u606f\u65f6\u51fa\u9519\uff0c\u6700\u5927\u53f7\u8868\u67e5\u8be2\u4e0d\u5230\u552f\u4e00\u7684\u503c\uff0c\u641c\u7d22\u6761\u4ef6: %s", (String)"FastCodeRuleSigner_1", (String)"bos-coderule", (Object[])new Object[0]), qFilter.toString()));
        }
        long maxserial = ((DynamicObject)query.get(0)).getLong("maxserial");
        if (maxserial == 0L) {
            maxserial = codeRuleEntry.getInitial() - codeRuleEntry.getStep();
        }
        return Optional.of(maxserial);
    }

    private String getBillNoKey(String sortItem, String codeRuleID) {
        String billnoKey = (codeRuleID + sortItem).intern();
        if (billnoKey.endsWith("/")) {
            billnoKey = billnoKey.replace("/", "").intern();
        }
        billnoKey = "bas/coderule/" + billnoKey;
        return billnoKey;
    }

    @Override
    public void signerNumbers(CodeRuleInfo codeRuleInfo, CodeRuleEntryInfo codeRuleEntry, String sortItem, String[] serialNumbers, int start) {
        this.codeRuleId = codeRuleInfo.getId();
        this.sortItem = sortItem;
        String billNoKey = this.getBillNoKey(sortItem, this.codeRuleId);
        this.init(codeRuleInfo.isFast(), billNoKey, codeRuleEntry.getInitial() - codeRuleEntry.getStep(), (int)codeRuleEntry.getStep(), this.getSegmentLengthBySerialNumLen(codeRuleEntry.getLength()), () -> this.getMaxNumberForInit(codeRuleEntry, sortItem));
        int reqNum = serialNumbers.length - start;
        int step = (int)codeRuleEntry.getStep();
        int maxReqSequence = step * reqNum;
        Result result = this.idGen.getBy(maxReqSequence);
        if (result.getStatus() == ResultStatus.FAIL) {
            ErrorCode errorCode = new ErrorCode(SIGNER_ERROR, result.getErrorType().toString());
            throw new KDException((Throwable)result.getException(), errorCode, new Object[0]);
        }
        long reqSequence = result.getCurseq();
        this.logger.info(String.format("[FastCodeRuleSigner][signerNumbers]\u6279\u91cf\u751f\u6210\u7684\u6700\u5927\u53f7:%s, \u4e2a\u6570:%s, \u6b65\u957f:%s", reqSequence, serialNumbers.length, step));
        for (int i = serialNumbers.length - 1; i >= start; --i) {
            serialNumbers[i] = "" + reqSequence;
            reqSequence -= (long)step;
        }
    }

    @Override
    public List<Integer> getBreakNums(CodeRuleInfo codeRuleInfo, String sortItem, int intermitNum, boolean isReadNumber) {
        return super.getBreakNums(codeRuleInfo, sortItem, intermitNum, isReadNumber);
    }

    @Override
    @Deprecated
    public boolean updateMaxNumber(String ruleId, String sortItem, long maxNumber) {
        throw new GeneratorException(GeneratorException.ErrorCode.ERRCODE_USE_OBSOLETE_METHOD.getCode(), "this is a obsolete method !");
    }

    @Override
    public boolean updateMaxNumber(CodeRuleInfo codeRuleInfo, String sortItem, long maxNumber) {
        this.codeRuleId = codeRuleInfo.getId();
        this.sortItem = sortItem;
        String billNoKey = this.getBillNoKey(sortItem, codeRuleInfo.getId());
        CodeRuleEntryInfo seqEntry = this.getCodeRuleEntityWithSerialNum(codeRuleInfo);
        if (seqEntry == null) {
            return false;
        }
        this.init(codeRuleInfo.isFast(), billNoKey, seqEntry.getInitial() - seqEntry.getStep(), (int)seqEntry.getStep(), this.getSegmentLengthBySerialNumLen(seqEntry.getLength()), () -> this.getMaxNumberForInit(seqEntry, sortItem));
        Result result = this.idGen.read();
        if (result.getStatus() == ResultStatus.FAIL) {
            throw new GeneratorException(SIGNER_ERROR, result.getException().getMessage(), result.getException());
        }
        boolean execute = this.config.updateCurseq(billNoKey, maxNumber);
        if (execute && codeRuleInfo.isFast() && !this.isDBGenerator()) {
            Config forSearch = ConfigFactory.getInstanceForSearch(billNoKey);
            long version = forSearch.getVersion(billNoKey);
            RecordSegmentUtil.insertRecordInfo(billNoKey, version, maxNumber);
        }
        this.logger.info(String.format("[FastCodeRuleSigner][updateMaxNumber]\u4fee\u6539\u6700\u5927\u53f7\u72b6\u6001:%s,\u4f20\u5165\u89c4\u5219ID:%s,\u4f20\u5165\u4f9d\u636e:%s,\u6700\u5927\u53f7:%s", execute, codeRuleInfo.getId(), sortItem, maxNumber));
        return execute;
    }

    private CodeRuleEntryInfo getCodeRuleEntityWithSerialNum(CodeRuleInfo codeRuleInfo) {
        if (codeRuleInfo != null) {
            for (CodeRuleEntryInfo codeRuleEntryInfo : codeRuleInfo.getRuleEntry()) {
                if (!CodeRuleEntryTypeEnum.TYPE_SEQ.getTypeStr().equals(codeRuleEntryInfo.getAttributeType())) continue;
                return codeRuleEntryInfo;
            }
        }
        return null;
    }

    public List<Integer> generateNums(List<Map<String, String>> maps, int intermitNum, boolean isAllFlag) {
        ArrayList<Integer> breakNums = new ArrayList<Integer>(intermitNum > 0 ? intermitNum : 8);
        if (CollectionUtils.isNotEmpty(maps)) {
            for (Map<String, String> map : maps) {
                int startseq = Integer.parseInt(map.get("fstartseq"));
                int endseq = Integer.parseInt(map.get("fendseq"));
                int i = startseq;
                while (i < endseq) {
                    if (!isAllFlag && intermitNum <= 0) {
                        return breakNums;
                    }
                    breakNums.add(i);
                    map.put("fstartseq", String.valueOf(i));
                    map.putIfAbsent("index", String.valueOf(true));
                    ++i;
                    --intermitNum;
                }
            }
        }
        return breakNums;
    }

    @Override
    public void reset(String codeRuleId, String sortItem, long initNumber) {
        String billNoKey = this.getBillNoKey(sortItem, codeRuleId);
        Config configForSearch = ConfigFactory.getInstanceForSearch(billNoKey);
        if (!configForSearch.isExist()) {
            this.logger.error("[CodeRuleSignerFast][rebuild]\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728, \u91cd\u7f6e\u9519\u8bef");
            throw new KDException(new ErrorCode(SIGNER_ERROR, ResManager.loadKDString((String)"\u53d1\u53f7\u5668rebuild\u65f6\uff0c\u672a\u627e\u5230\u76f8\u5173\u914d\u7f6e", (String)"FastCodeRuleSigner_0", (String)"bos-coderule", (Object[])new Object[0])), new Object[0]);
        }
        long segmentLength = configForSearch.getSegmentLength();
        int step = configForSearch.getStep();
        this.config = this.isDBGenerator() ? new DBConfig(codeRuleId, sortItem, initNumber, step, segmentLength) : new SegmentConfig.Buidler().setKey(billNoKey).setInitNumber(initNumber).setSegmentLength(segmentLength).setStep(step).build();
        this.config.rebuild();
    }

    @Override
    public void updateStep(String codeRuleId, String sortItem, int step) {
        String billNoKey = this.getBillNoKey(sortItem, codeRuleId);
        ConfigFactory.getInstanceForSearch(billNoKey).setStep(step);
    }

    @Override
    public void clean(String codeRuleId, String sortItem) {
        String billNoKey = this.getBillNoKey(sortItem, codeRuleId);
        ConfigFactory.getInstanceForSearch(billNoKey).clear();
        new DBConfig(codeRuleId, sortItem).clear();
    }

    @Override
    public boolean isUseDB() {
        return false;
    }

    @Override
    public void growup(String codeRuleId) {
        CodeRuleInfo codeRuleInfo = CodeRuleCache.reloadCodeRuleById(codeRuleId);
        if (codeRuleInfo == null || codeRuleInfo.isFast()) {
            return;
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])new String[]{codeRuleId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_coderule"));
        DynamicObject dynamicObject = dynamicObjects[0];
        dynamicObject.set("isfast", (Object)Character.valueOf('1'));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }
}

