/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.domain;

import java.util.Date;
import kd.bos.coderule.handler.SyncHandler;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

class Maxserial {
    private static final Log logger = LogFactory.getLog(Maxserial.class);
    private static final String LOCK_PREFIX = "CODERULE_MAXSERIAL_CREATE_";
    private String coderuleId;
    private String sortItemValue;

    public Maxserial(String coderuleId, String sortItemValue) {
        this.coderuleId = coderuleId;
        this.sortItemValue = sortItemValue;
    }

    public String getEntityId() {
        return this.coderuleId + "_" + this.sortItemValue;
    }

    public void createUnique() {
        if (this.isExist()) {
            return;
        }
        final String dLockKey = LOCK_PREFIX + this.getEntityId();
        new SyncHandler(dLockKey){

            @Override
            protected void syncProcess() {
                if (Maxserial.this.isExist()) {
                    return;
                }
                Maxserial.this.create();
            }

            @Override
            protected void beforeSyncProcess() {
                logger.info("[Maxserial#createUnique]\u5f00\u59cb\u521b\u5efa\u6700\u5927\u53f7-dLockKey:" + dLockKey);
            }

            @Override
            protected void afterSyncProcess() {
                logger.info("[Maxserial#createUnique]\u7ed3\u675f\u521b\u5efa\u6700\u5927\u53f7-dLockKey:" + dLockKey);
            }
        }.process();
    }

    private boolean isExist() {
        QFilter qFilter = new QFilter("codeRuleID", "=", (Object)this.coderuleId).and(new QFilter("sortitemvalue", "=", (Object)this.sortItemValue));
        return QueryServiceHelper.exists((String)"bos_coderule_maxserial", (QFilter[])qFilter.toArray());
    }

    private void create() {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_coderule_maxserial");
        DynamicObject dynaObj = new DynamicObject((DynamicObjectType)dt);
        dynaObj.set("codeRuleID", (Object)this.coderuleId);
        dynaObj.set("seqsegmententryid", (Object)"");
        dynaObj.set("sortitemvalue", (Object)this.sortItemValue);
        dynaObj.set("maxserial", (Object)0);
        dynaObj.set("initserial", (Object)0);
        dynaObj.set("createdate", (Object)new Date());
        dynaObj.set("creater", (Object)RequestContext.get().getUserId());
        SaveServiceHelper.save((IDataEntityType)dt, (Object[])new DynamicObject[]{dynaObj});
    }
}

