/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.handler;

import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public abstract class SyncHandler {
    private static final Log logger = LogFactory.getLog(SyncHandler.class);
    private final String dLockKey;
    private final String codeRuleName;
    private final String codeRuleId;

    public SyncHandler(String dLockKey) {
        this.dLockKey = dLockKey;
        this.codeRuleName = null;
        this.codeRuleId = null;
    }

    public SyncHandler(String dLockKey, String codeRuleName, String codeRuleId) {
        this.dLockKey = dLockKey;
        this.codeRuleName = codeRuleName;
        this.codeRuleId = codeRuleId;
    }

    public void process() {
        try (DLock dl = this.createDLock(this.dLockKey);){
            this.lock(dl);
            try {
                this.beforeSyncProcess();
                this.syncProcess();
            }
            finally {
                this.afterSyncProcess();
                dl.unlock();
            }
        }
    }

    protected void beforeSyncProcess() {
        logger.info("CodeRuleServiceImp: \u7f16\u7801\u89c4\u5219 " + this.codeRuleName + " (" + this.codeRuleId + ") \u83b7\u5f97\u9501 " + "bas/coderule/" + this.dLockKey);
    }

    protected void afterSyncProcess() {
        logger.info("CodeRuleServiceImp: \u7f16\u7801\u89c4\u5219: " + this.codeRuleName + " (" + this.codeRuleId + ") \u91ca\u653e\u9501\uff1a" + "bas/coderule/" + this.dLockKey);
    }

    protected DLock createDLock(String dLockKey) {
        return DLock.create((String)dLockKey);
    }

    protected void lock(DLock dl) {
        dl.lock();
    }

    protected abstract void syncProcess();
}

