/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.newedit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.coderule.newedit.FieldUtil;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;

public class EntryUtil {
    public static final String ENTRYENTITY = "entryentity";
    public static final String FIXVAL = "fixval";
    public static final String FORMAT = "format";
    public static final String ATTUSINGMODE = "attusingmode";
    public static final String LENGTH = "length";
    public static final String VALUEATRIBUTESHOW = "valueatributeshow";
    public static final String ADDCHAR = "addchar";
    public static final String ADDSTYLE = "addstyle";
    public static final String CUTSTYLE = "cutstyle";
    public static final String INITIAL = "initial";
    public static final String CHECKCODE = "checkcode";
    public static final String ISNONBREAK = "isnonbreak";
    private static final String IS_FILL_WITH_ZERO = "isfillwithzero";
    private static final String IS_AUTO_INCR_LENGTH = "isautoincrlength";
    public static final String SERIALBASIS = "serialbasis";
    private AbstractFormPlugin formPlugin;
    private IDataModel dataModel;

    public EntryUtil(AbstractFormPlugin formPlugin, IDataModel dataModel) {
        this.formPlugin = formPlugin;
        this.dataModel = dataModel;
    }

    public void rebuildEntryForChoseAttribute(int entryNo, String attributetype) {
        this.recoverEntry(entryNo, false);
        this.formatEntry(entryNo, attributetype);
        this.initDefaultValueFormEntry(entryNo, attributetype, false);
    }

    private void recoverEntry(int entryNo, boolean isCreateNewData) {
        CardEntry formView = (CardEntry)this.formPlugin.getControl(ENTRYENTITY);
        formView.setChildVisible(true, entryNo, new String[]{FIXVAL});
        formView.setChildVisible(true, entryNo, new String[]{FORMAT});
        formView.setChildVisible(true, entryNo, new String[]{ATTUSINGMODE});
        formView.setChildVisible(true, entryNo, new String[]{LENGTH});
        formView.setChildVisible(true, entryNo, new String[]{VALUEATRIBUTESHOW});
        formView.setChildVisible(true, entryNo, new String[]{ADDCHAR});
        formView.setChildVisible(true, entryNo, new String[]{ADDSTYLE});
        formView.setChildVisible(true, entryNo, new String[]{CUTSTYLE});
        formView.setChildVisible(true, entryNo, new String[]{"step"});
        formView.setChildVisible(true, entryNo, new String[]{INITIAL});
        formView.setChildVisible(true, entryNo, new String[]{CHECKCODE});
        formView.setChildVisible(true, entryNo, new String[]{ISNONBREAK});
        formView.setChildVisible(true, entryNo, new String[]{IS_FILL_WITH_ZERO});
        formView.setChildVisible(true, entryNo, new String[]{IS_AUTO_INCR_LENGTH});
        FieldUtil fieldUtil = new FieldUtil(this.formPlugin, this.dataModel, isCreateNewData);
        fieldUtil.setFieldValue(FIXVAL, "", entryNo);
        fieldUtil.setFieldValue(FORMAT, "", entryNo);
        fieldUtil.setFieldValue(ATTUSINGMODE, "", entryNo);
        fieldUtil.setFieldValue(LENGTH, "8", entryNo);
        fieldUtil.setFieldValue("valueatribute", "", entryNo);
        fieldUtil.setFieldValue(VALUEATRIBUTESHOW, "", entryNo);
        fieldUtil.setFieldValue(ADDCHAR, "", entryNo);
        fieldUtil.setFieldValue("step", "1", entryNo);
        fieldUtil.setFieldValue(INITIAL, "1", entryNo);
        fieldUtil.setFieldValue(ISNONBREAK, "", entryNo);
        fieldUtil.setFieldValue(IS_FILL_WITH_ZERO, "", entryNo);
        fieldUtil.setFieldValue(IS_AUTO_INCR_LENGTH, "", entryNo);
    }

    public void formatEntry(int entryNo, String attributetype) {
        CodeRuleEntryTypeEnum typeEnum = CodeRuleEntryTypeEnum.getEnums(attributetype);
        CardEntry formView = (CardEntry)this.formPlugin.getControl(ENTRYENTITY);
        switch (typeEnum) {
            case TYPE_FIX_TEXT: {
                formView.setChildVisible(false, entryNo, new String[]{FORMAT});
                formView.setChildVisible(false, entryNo, new String[]{ATTUSINGMODE});
                formView.setChildVisible(false, entryNo, new String[]{LENGTH});
                formView.setChildVisible(false, entryNo, new String[]{VALUEATRIBUTESHOW});
                formView.setChildVisible(false, entryNo, new String[]{ADDCHAR});
                formView.setChildVisible(false, entryNo, new String[]{ADDSTYLE});
                formView.setChildVisible(false, entryNo, new String[]{CUTSTYLE});
                formView.setChildVisible(false, entryNo, new String[]{"step"});
                formView.setChildVisible(false, entryNo, new String[]{INITIAL});
                formView.setChildVisible(false, entryNo, new String[]{CHECKCODE});
                formView.setChildVisible(false, entryNo, new String[]{ISNONBREAK});
                formView.setChildVisible(false, entryNo, new String[]{IS_FILL_WITH_ZERO});
                formView.setChildVisible(false, entryNo, new String[]{IS_AUTO_INCR_LENGTH});
                break;
            }
            case TYPE_SYSTEM_TIME_FIELD: {
                formView.setChildVisible(false, entryNo, new String[]{FIXVAL});
                formView.setChildVisible(false, entryNo, new String[]{ATTUSINGMODE});
                formView.setChildVisible(false, entryNo, new String[]{LENGTH});
                formView.setChildVisible(false, entryNo, new String[]{VALUEATRIBUTESHOW});
                formView.setChildVisible(false, entryNo, new String[]{ADDCHAR});
                formView.setChildVisible(false, entryNo, new String[]{ADDSTYLE});
                formView.setChildVisible(false, entryNo, new String[]{CUTSTYLE});
                formView.setChildVisible(false, entryNo, new String[]{"step"});
                formView.setChildVisible(false, entryNo, new String[]{INITIAL});
                formView.setChildVisible(false, entryNo, new String[]{CHECKCODE});
                formView.setChildVisible(false, entryNo, new String[]{ISNONBREAK});
                formView.setChildVisible(false, entryNo, new String[]{IS_FILL_WITH_ZERO});
                formView.setChildVisible(false, entryNo, new String[]{IS_AUTO_INCR_LENGTH});
                break;
            }
            case TYPE_DATE_FIELD: {
                formView.setChildVisible(false, entryNo, new String[]{FIXVAL});
                formView.setChildVisible(false, entryNo, new String[]{ATTUSINGMODE});
                formView.setChildVisible(false, entryNo, new String[]{LENGTH});
                formView.setChildVisible(false, entryNo, new String[]{ADDCHAR});
                formView.setChildVisible(false, entryNo, new String[]{ADDSTYLE});
                formView.setChildVisible(false, entryNo, new String[]{CUTSTYLE});
                formView.setChildVisible(false, entryNo, new String[]{"step"});
                formView.setChildVisible(false, entryNo, new String[]{INITIAL});
                formView.setChildVisible(false, entryNo, new String[]{CHECKCODE});
                formView.setChildVisible(false, entryNo, new String[]{ISNONBREAK});
                formView.setChildVisible(false, entryNo, new String[]{IS_FILL_WITH_ZERO});
                formView.setChildVisible(false, entryNo, new String[]{IS_AUTO_INCR_LENGTH});
                break;
            }
            case TYPE_ITEM_FIELD: 
            case TYPE_LIST_FIELD: {
                formView.setChildVisible(false, entryNo, new String[]{FIXVAL});
                formView.setChildVisible(false, entryNo, new String[]{FORMAT});
                formView.setChildVisible(false, entryNo, new String[]{"step"});
                formView.setChildVisible(false, entryNo, new String[]{INITIAL});
                formView.setChildVisible(false, entryNo, new String[]{CHECKCODE});
                formView.setChildVisible(false, entryNo, new String[]{ISNONBREAK});
                formView.setChildVisible(false, entryNo, new String[]{IS_FILL_WITH_ZERO});
                formView.setChildVisible(false, entryNo, new String[]{IS_AUTO_INCR_LENGTH});
                break;
            }
            case TYPE_RANDOM_NUMBER: {
                formView.setChildVisible(false, entryNo, new String[]{FORMAT});
                formView.setChildVisible(false, entryNo, new String[]{FIXVAL});
                formView.setChildVisible(false, entryNo, new String[]{ATTUSINGMODE});
                formView.setChildVisible(false, entryNo, new String[]{VALUEATRIBUTESHOW});
                formView.setChildVisible(false, entryNo, new String[]{ADDCHAR});
                formView.setChildVisible(false, entryNo, new String[]{ADDSTYLE});
                formView.setChildVisible(false, entryNo, new String[]{CUTSTYLE});
                formView.setChildVisible(false, entryNo, new String[]{"step"});
                formView.setChildVisible(false, entryNo, new String[]{INITIAL});
                formView.setChildVisible(false, entryNo, new String[]{CHECKCODE});
                formView.setChildVisible(false, entryNo, new String[]{ISNONBREAK});
                formView.setChildVisible(false, entryNo, new String[]{IS_FILL_WITH_ZERO});
                formView.setChildVisible(false, entryNo, new String[]{IS_AUTO_INCR_LENGTH});
                break;
            }
            case TYPE_SEQ: {
                formView.setChildVisible(false, entryNo, new String[]{FIXVAL});
                formView.setChildVisible(false, entryNo, new String[]{FORMAT});
                formView.setChildVisible(false, entryNo, new String[]{ATTUSINGMODE});
                formView.setChildVisible(false, entryNo, new String[]{VALUEATRIBUTESHOW});
                formView.setChildVisible(false, entryNo, new String[]{ADDCHAR});
                formView.setChildVisible(false, entryNo, new String[]{ADDSTYLE});
                formView.setChildVisible(false, entryNo, new String[]{CUTSTYLE});
                formView.setChildVisible(false, entryNo, new String[]{CHECKCODE});
                break;
            }
            case CHECK_CODE: {
                formView.setChildVisible(false, entryNo, new String[]{FIXVAL});
                formView.setChildVisible(false, entryNo, new String[]{FORMAT});
                formView.setChildVisible(false, entryNo, new String[]{ATTUSINGMODE});
                formView.setChildVisible(false, entryNo, new String[]{LENGTH});
                formView.setChildVisible(false, entryNo, new String[]{VALUEATRIBUTESHOW});
                formView.setChildVisible(false, entryNo, new String[]{ADDCHAR});
                formView.setChildVisible(false, entryNo, new String[]{ADDSTYLE});
                formView.setChildVisible(false, entryNo, new String[]{CUTSTYLE});
                formView.setChildVisible(false, entryNo, new String[]{"step"});
                formView.setChildVisible(false, entryNo, new String[]{INITIAL});
                formView.setChildVisible(false, entryNo, new String[]{ISNONBREAK});
                formView.setChildVisible(false, entryNo, new String[]{IS_FILL_WITH_ZERO});
                formView.setChildVisible(false, entryNo, new String[]{IS_AUTO_INCR_LENGTH});
                break;
            }
        }
        if (entryNo == 0) {
            formView.setChildVisible(false, entryNo, new String[]{"splitsignentry"});
        }
        this.formPlugin.getView().setEnable(Boolean.TRUE, entryNo, new String[]{LENGTH});
    }

    public void formatEntryFullValue(int entryNo) {
        CardEntry formView = (CardEntry)this.formPlugin.getControl(ENTRYENTITY);
        int attusingmode = Integer.parseInt(String.valueOf(this.dataModel.getValue(ATTUSINGMODE, entryNo)));
        if (attusingmode == 3) {
            formView.setChildVisible(false, entryNo, new String[]{LENGTH});
            formView.setChildVisible(false, entryNo, new String[]{ADDCHAR});
            formView.setChildVisible(false, entryNo, new String[]{ADDSTYLE});
            formView.setChildVisible(false, entryNo, new String[]{CUTSTYLE});
        } else if (attusingmode == 1 || attusingmode == 2) {
            formView.setChildVisible(false, entryNo, new String[]{ADDCHAR});
            formView.setChildVisible(false, entryNo, new String[]{ADDSTYLE});
            formView.setChildVisible(false, entryNo, new String[]{CUTSTYLE});
        } else {
            formView.setChildVisible(true, entryNo, new String[]{LENGTH});
            formView.setChildVisible(true, entryNo, new String[]{ADDCHAR});
            formView.setChildVisible(true, entryNo, new String[]{ADDSTYLE});
            formView.setChildVisible(true, entryNo, new String[]{CUTSTYLE});
        }
    }

    public void initDefaultValueFormEntry(int entryNo, String attributetype, boolean isCreateNewData) {
        FieldUtil fieldUtil = new FieldUtil(this.formPlugin, this.dataModel, isCreateNewData);
        fieldUtil.setFieldValueWithDefault(INITIAL, entryNo);
        fieldUtil.setFieldValueWithDefault(LENGTH, entryNo);
        fieldUtil.setFieldValueWithDefault("step", entryNo);
        fieldUtil.setFieldValueWithDefault(SERIALBASIS, entryNo);
        CodeRuleEntryTypeEnum typeEnum = CodeRuleEntryTypeEnum.getEnums(attributetype);
        switch (typeEnum) {
            case TYPE_FIX_TEXT: {
                break;
            }
            case TYPE_SYSTEM_TIME_FIELD: {
                break;
            }
            case TYPE_DATE_FIELD: {
                break;
            }
            case TYPE_ITEM_FIELD: 
            case TYPE_LIST_FIELD: {
                this.setAttUsingmode(CodeRuleEntryTypeEnum.TYPE_LIST_FIELD.getTypeStr(), entryNo, isCreateNewData);
                this.formatEntryFullValue(entryNo);
                break;
            }
            case TYPE_RANDOM_NUMBER: {
                fieldUtil.setFieldValue(LENGTH, "8", entryNo);
                this.formPlugin.getView().setEnable(Boolean.FALSE, entryNo, new String[]{LENGTH});
                break;
            }
            case TYPE_SEQ: {
                fieldUtil.setFieldValueWithDefault(ISNONBREAK, entryNo);
                fieldUtil.setFieldValueWithDefault(IS_FILL_WITH_ZERO, entryNo);
                fieldUtil.setFieldValueWithDefault(IS_AUTO_INCR_LENGTH, entryNo);
                break;
            }
            case CHECK_CODE: {
                break;
            }
        }
    }

    private void setAttUsingmode(String modeStr, int entryNum, boolean isCreateNewData) {
        ComboEdit propertyField = (ComboEdit)this.formPlugin.getControl(ATTUSINGMODE);
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>();
        CodeRuleEntryTypeEnum typeEnum = CodeRuleEntryTypeEnum.getEnums(modeStr);
        if (typeEnum == CodeRuleEntryTypeEnum.TYPE_LIST_FIELD || typeEnum == CodeRuleEntryTypeEnum.TYPE_ITEM_FIELD) {
            ComboItem comboItem1 = new ComboItem();
            comboItem1.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5b8c\u5168\u53d6\u503c", (String)"EntryUtil_0", (String)"bos-coderule", (Object[])new Object[0])));
            comboItem1.setValue("3");
            ComboItem comboItem2 = new ComboItem();
            comboItem2.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5c5e\u6027\u622a\u65ad", (String)"EntryUtil_1", (String)"bos-coderule", (Object[])new Object[0])));
            comboItem2.setValue("4");
            propertyItems.add(comboItem1);
            propertyItems.add(comboItem2);
            FieldUtil fieldUtil = new FieldUtil(this.formPlugin, this.dataModel, isCreateNewData);
            fieldUtil.setFieldValue(ATTUSINGMODE, "3", entryNum);
        }
        propertyField.setComboItems(propertyItems);
    }

    public void initComboEditForSplitsign(String fieldKey) {
        ComboEdit propertyField = (ComboEdit)this.formPlugin.getControl(fieldKey);
        List<String> splitKeys = Arrays.asList(ResManager.loadKDString((String)"\u7a7a", (String)"EntryUtil_2", (String)"bos-coderule", (Object[])new Object[0]), "-", "@", "#", "$", "%", "^", "&", "*", "[", "]", "_");
        List<String> splitValues = Arrays.asList("[SPECIAL_EMPTY_VALUE]", "-", "@", "#", "$", "%", "^", "&", "*", "[", "]", "_");
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(splitKeys.size());
        for (int i = 0; i < splitKeys.size(); ++i) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(splitKeys.get(i)));
            comboItem.setValue(splitValues.get(i));
            propertyItems.add(comboItem);
        }
        propertyField.setComboItems(propertyItems);
    }

    public void validateSerialBasis() {
        int rowCount = this.dataModel.getEntryRowCount(ENTRYENTITY);
        if (rowCount != 0) {
            int row;
            boolean haveSerial = false;
            for (int row2 = 0; row2 < rowCount; ++row2) {
                String attributetype = String.valueOf(this.dataModel.getValue("attributetype", row2));
                if (!CodeRuleEntryTypeEnum.TYPE_SEQ.getTypeStr().equals(attributetype)) continue;
                haveSerial = true;
                break;
            }
            CardEntry formView = (CardEntry)this.formPlugin.getControl(ENTRYENTITY);
            for (row = 0; row < rowCount; ++row) {
                formView.setChildVisible(haveSerial, row, new String[]{SERIALBASIS});
            }
            for (row = 0; row < rowCount; ++row) {
                String attributetype = String.valueOf(this.dataModel.getValue("attributetype", row));
                if (!CodeRuleEntryTypeEnum.TYPE_SEQ.getTypeStr().equals(attributetype) && !CodeRuleEntryTypeEnum.TYPE_FIX_TEXT.getTypeStr().equals(attributetype) && !CodeRuleEntryTypeEnum.CHECK_CODE.getTypeStr().equals(attributetype) && !CodeRuleEntryTypeEnum.TYPE_RANDOM_NUMBER.getTypeStr().equals(attributetype)) continue;
                formView.setChildVisible(false, row, new String[]{SERIALBASIS});
            }
        }
    }
}

