/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.newedit;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.coderule.enums.SerialBasisEnum;
import kd.bos.coderule.newedit.AttributetypeUtil;
import kd.bos.coderule.newedit.EntryUtil;
import kd.bos.coderule.newedit.FieldUtil;
import kd.bos.coderule.newedit.NumberUtil;
import kd.bos.coderule.newedit.SplitsignUtil;
import kd.bos.coderule.util.CodeRuleSerialNumUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.ID;

public class PageChangeEntryPlugin {
    public static final String ENTRYENTITY = "entryentity";
    public static final String SPLITSIGNENTRY = "splitsignentry";
    public static final String FORMAT = "format";
    private static final String ATTRIBUTE_TYPE = "attributetype";
    private AbstractFormPlugin formPlugin;
    private IDataModel dataModel;
    private AttributetypeUtil attributetypeUtil;
    private EntryUtil entryUtil;

    public PageChangeEntryPlugin(AbstractFormPlugin formPlugin, IDataModel dataModel) {
        this.formPlugin = formPlugin;
        this.dataModel = dataModel;
        this.attributetypeUtil = new AttributetypeUtil(formPlugin, dataModel);
        this.entryUtil = new EntryUtil(formPlugin, dataModel);
    }

    public void rebuildChoseByAttributetype(DynamicObject dynamicObject) {
        int rowCount = this.dataModel.getEntryRowCount(ENTRYENTITY);
        for (int row = 0; row < rowCount; ++row) {
            boolean validateByCode;
            Object attributetypeValue = this.dataModel.getValue(ATTRIBUTE_TYPE, row);
            boolean validateBySeq = !dynamicObject.getBoolean("isserialnumber") && attributetypeValue.toString().equals(CodeRuleEntryTypeEnum.TYPE_SEQ.getTypeStr());
            boolean bl = validateByCode = !dynamicObject.getBoolean("ischeckcode") && attributetypeValue.toString().equals(CodeRuleEntryTypeEnum.CHECK_CODE.getTypeStr());
            if (!validateBySeq && !validateByCode) continue;
            this.entryUtil.rebuildEntryForChoseAttribute(row, CodeRuleEntryTypeEnum.TYPE_FIX_TEXT.getTypeStr());
            new FieldUtil(this.formPlugin, this.dataModel).setFieldValue(ATTRIBUTE_TYPE, CodeRuleEntryTypeEnum.TYPE_FIX_TEXT.getTypeStr(), row);
        }
    }

    public void changeByAttributetype(PropertyChangedArgs e, String proName) {
        int row = this.dataModel.getEntryCurrentRowIndex(ENTRYENTITY);
        int rowCount = this.dataModel.getEntryRowCount(ENTRYENTITY);
        int attributetype = Integer.parseInt(String.valueOf(e.getChangeSet()[0].getNewValue()));
        CodeRuleEntryTypeEnum typeEnum = CodeRuleEntryTypeEnum.getEnums("" + attributetype);
        if (!this.validateFormChangeAttributetype(e, proName, row, rowCount, typeEnum)) {
            return;
        }
        this.specialProcessingCheckCode(e, rowCount, typeEnum);
        this.entryUtil.rebuildEntryForChoseAttribute(row, typeEnum.getTypeStr());
    }

    private boolean validateFormChangeAttributetype(PropertyChangedArgs e, String proName, int row, int rowCount, CodeRuleEntryTypeEnum typeEnum) {
        boolean b = this.attributetypeUtil.validateAttributetypes(e, proName, row, rowCount, typeEnum);
        if (!b) {
            new FieldUtil(this.formPlugin, this.dataModel).setFieldValue(proName, e.getChangeSet()[0].getOldValue().toString(), row);
        }
        return b;
    }

    private void specialProcessingCheckCode(PropertyChangedArgs e, int rowCount, CodeRuleEntryTypeEnum typeEnum) {
        if (typeEnum == CodeRuleEntryTypeEnum.CHECK_CODE) {
            for (int i = 0; i < rowCount; ++i) {
                new FieldUtil(this.formPlugin, this.dataModel).setFieldValue(SPLITSIGNENTRY, "[SPECIAL_EMPTY_VALUE]", i);
            }
        }
    }

    public void addEntry() {
        int rowCount = this.dataModel.getEntryRowCount(ENTRYENTITY);
        if (rowCount >= 20) {
            this.formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u6bb5\u6570\u91cf\u8d85\u8fc7\u4e0a\u9650\u503c\uff0c\u65e0\u6cd5\u7ee7\u7eed\u65b0\u589e\u3002", (String)"PageChangeEntryPlugin_0", (String)"bos-coderule", (Object[])new Object[0]));
            return;
        }
        if (rowCount > 0 && CodeRuleEntryTypeEnum.CHECK_CODE.getTypeStr().equalsIgnoreCase(String.valueOf(this.dataModel.getValue(ATTRIBUTE_TYPE, rowCount - 1)))) {
            this.formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6821\u9a8c\u7801\u201d\u5df2\u5728\u6700\u540e\u4e00\u6bb5\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u5728\u201c\u6821\u9a8c\u7801\u201d\u540e\u65b0\u589e\u3002", (String)"PageChangeEntryPlugin_4", (String)"bos-coderule", (Object[])new Object[0]));
            return;
        }
        int row = this.dataModel.createNewEntryRow(ENTRYENTITY);
        this.entryUtil.formatEntry(row, CodeRuleEntryTypeEnum.TYPE_FIX_TEXT.getTypeStr());
        this.dataModel.setValue(SPLITSIGNENTRY, this.dataModel.getValue("splitsign"), row);
        this.entryUtil.validateSerialBasis();
        this.rebuildCodeRuleSeq();
        this.rebuildSimCode();
    }

    public void delEntry() {
        int[] selectRows = ((EntryGrid)this.formPlugin.getView().getControl(ENTRYENTITY)).getSelectRows();
        if (selectRows.length == 0) {
            this.formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u5206\u5f55\u518d\u70b9\u51fb\u5220\u9664\u6309\u94ae\u3002", (String)"PageChangeEntryPlugin_1", (String)"bos-coderule", (Object[])new Object[0]));
            return;
        }
        this.dataModel.deleteEntryRows(ENTRYENTITY, selectRows);
        CardEntry formView = (CardEntry)this.formPlugin.getControl(ENTRYENTITY);
        formView.setChildVisible(false, 0, new String[]{SPLITSIGNENTRY});
        this.rebuildCodeRuleSeq();
        this.rebuildSimCode();
    }

    public void batchDelEntry() {
        int rowCount = this.dataModel.getEntryRowCount(ENTRYENTITY);
        if (rowCount == 0) {
            return;
        }
        int[] rows = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            rows[i] = i;
        }
        this.dataModel.deleteEntryRows(ENTRYENTITY, rows);
        CardEntry formView = (CardEntry)this.formPlugin.getControl(ENTRYENTITY);
        formView.setChildVisible(false, 0, new String[]{SPLITSIGNENTRY});
        this.dataModel.setValue("number", (Object)ID.genStringId());
        this.dataModel.setValue("name", (Object)"");
        this.dataModel.setValue("isaddview", (Object)true);
        this.dataModel.setValue("ismodifiable", (Object)false);
        this.dataModel.setValue("ischecknumber", (Object)false);
        this.dataModel.setValue("isupdaterecover", (Object)false);
        this.rebuildCodeRuleSeq();
        this.rebuildSimCode();
        this.addEntry();
    }

    public void rebuildCodeRuleSeq() {
        int rowCount = this.dataModel.getEntryRowCount(ENTRYENTITY);
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                this.dataModel.setValue("labelapnum", (Object)String.format(ResManager.loadKDString((String)"\u7f16\u7801%1$s\u6bb5", (String)"PageChangeEntryPlugin_5", (String)"bos-coderule", (Object[])new Object[0]), NumberUtil.toChinese("" + (i + 1))), i);
            }
        }
    }

    public void rebuildSimCode() {
        int rowCount = this.dataModel.getEntryRowCount(ENTRYENTITY);
        StringBuilder simCode = new StringBuilder();
        block9: for (int row = 0; row < rowCount; ++row) {
            Object serialbasisObj = this.dataModel.getValue("serialbasis", row);
            if (SerialBasisEnum.IS_BASIS_BUT_UNSHOW.getType() == Integer.parseInt(serialbasisObj.toString())) continue;
            String attributetype = String.valueOf(this.dataModel.getValue(ATTRIBUTE_TYPE, row));
            CodeRuleEntryTypeEnum typeEnum = CodeRuleEntryTypeEnum.getEnums(attributetype);
            if (row != 0) {
                String splitsignentry = this.dataModel.getValue(SPLITSIGNENTRY, row).toString().trim();
                simCode.append(SplitsignUtil.convertSpecialToEmpty(splitsignentry));
            }
            switch (typeEnum) {
                case TYPE_FIX_TEXT: {
                    simCode.append(this.dataModel.getValue("fixval", row));
                    continue block9;
                }
                case TYPE_SYSTEM_TIME_FIELD: {
                    String systemDataFormat = String.valueOf(this.dataModel.getValue(FORMAT, row));
                    SimpleDateFormat systemDataSdf = new SimpleDateFormat(systemDataFormat);
                    simCode.append(systemDataSdf.format(new Date()));
                    continue block9;
                }
                case TYPE_DATE_FIELD: {
                    String format = String.valueOf(this.dataModel.getValue(FORMAT, row));
                    SimpleDateFormat sdf = new SimpleDateFormat(format);
                    if (StringUtils.isBlank((CharSequence)this.dataModel.getValue("valueatributeshow", row).toString()) || StringUtils.isBlank((CharSequence)this.dataModel.getValue(FORMAT, row).toString())) continue block9;
                    simCode.append(sdf.format(new Date()));
                    continue block9;
                }
                case TYPE_ITEM_FIELD: 
                case TYPE_LIST_FIELD: {
                    String attrVal = String.valueOf(this.dataModel.getValue("valueatributeshow", row));
                    simCode.append(attrVal);
                    continue block9;
                }
                case TYPE_RANDOM_NUMBER: {
                    Object lengthObj = this.dataModel.getValue("length", row);
                    for (int j = 0; j < Integer.parseInt(lengthObj.toString()); ++j) {
                        simCode.append('X');
                    }
                    continue block9;
                }
                case TYPE_SEQ: {
                    int length = Integer.parseInt(String.valueOf(this.dataModel.getValue("length", row)));
                    String initial = String.valueOf(this.dataModel.getValue("initial", row));
                    if (initial.length() > length) {
                        initial = "1";
                    }
                    CodeRuleEntryInfo codeRuleEntryInfo = new CodeRuleEntryInfo();
                    codeRuleEntryInfo.setLength(length);
                    codeRuleEntryInfo.setAttributeType(attributetype);
                    codeRuleEntryInfo.setAddstyle(Boolean.TRUE);
                    codeRuleEntryInfo.setAddchar("0");
                    boolean isFillWithZero = (Boolean)this.dataModel.getValue("isfillwithzero", row);
                    boolean isAutoIncrLength = (Boolean)this.dataModel.getValue("isautoincrlength", row);
                    simCode.append(CodeRuleSerialNumUtil.addChar(codeRuleEntryInfo, initial, "", isFillWithZero, isAutoIncrLength));
                    continue block9;
                }
                case CHECK_CODE: {
                    simCode.append(this.dataModel.getValue("checkcode", row));
                    continue block9;
                }
            }
        }
        this.dataModel.setValue("example", (Object)simCode.toString());
    }
}

