/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.newedit;

import java.util.Collection;
import java.util.Map;
import kd.bos.coderule.newedit.AttributetypeUtil;
import kd.bos.coderule.newedit.EntryUtil;
import kd.bos.coderule.newedit.FieldUtil;
import kd.bos.coderule.newedit.PageCacheUtil;
import kd.bos.coderule.newedit.PageChangeEntryPlugin;
import kd.bos.coderule.util.CodeRuleSystemParam;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class PageChangePlugin {
    public static final String ISAPPCONDITION = "isappcondition";
    public static final String ISAPPORG = "isapporg";
    public static final String ISSERIALNUMBER = "isserialnumber";
    public static final String CURRENT_ROW = "currentRow";
    public static final String ENTRYENTITY = "entryentity";
    private AbstractFormPlugin formPlugin;
    private IDataModel dataModel;
    private PageChangeEntryPlugin pageChangeEntryPlugin;
    private AttributetypeUtil attributetypeUtil;
    private EntryUtil entryUtil;

    public PageChangePlugin(AbstractFormPlugin formPlugin, IDataModel dataModel) {
        this.formPlugin = formPlugin;
        this.dataModel = dataModel;
        this.pageChangeEntryPlugin = new PageChangeEntryPlugin(formPlugin, dataModel);
        this.attributetypeUtil = new AttributetypeUtil(formPlugin, dataModel);
        this.entryUtil = new EntryUtil(formPlugin, dataModel);
    }

    public void rebuildItem(DynamicObject dynamicObject) {
        boolean isShowCondition = dynamicObject.getBoolean(ISAPPCONDITION);
        if (CodeRuleSystemParam.getCustomParameter("SVC_CODERULE_IS_HIDE_CONDITION", true) && CollectionUtils.isEmpty((Collection)dynamicObject.getDynamicObjectCollection("conditionentry"))) {
            isShowCondition = false;
        }
        this.formPlugin.getView().setVisible(Boolean.valueOf(isShowCondition), new String[]{"btn_condition"});
        this.attributetypeUtil.rebuild(dynamicObject);
    }

    public void changeByShowForm(ClosedCallBackEvent e) {
        Map returnData;
        if ("selectValueatribute".equals(e.getActionId())) {
            Map returnData2 = (Map)e.getReturnData();
            if (returnData2 != null && returnData2.get(CURRENT_ROW) != null) {
                new FieldUtil(this.formPlugin, this.dataModel).setFieldValue("valueatribute", returnData2.get("valueatribute").toString(), Integer.parseInt("" + returnData2.get(CURRENT_ROW)));
                new FieldUtil(this.formPlugin, this.dataModel).setFieldValue("valueatributeshow", returnData2.get("valueatributeshow").toString(), Integer.parseInt("" + returnData2.get(CURRENT_ROW)));
            }
        } else if ("selectDateFormat".equals(e.getActionId())) {
            Map returnData3 = (Map)e.getReturnData();
            if (returnData3 != null) {
                new FieldUtil(this.formPlugin, this.dataModel).setFieldValue("format", returnData3.get("format").toString(), Integer.parseInt("" + returnData3.get(CURRENT_ROW)));
            }
        } else if ("selectOptionData".equals(e.getActionId()) && (returnData = (Map)e.getReturnData()) != null) {
            DynamicObject dynamicObject = PageCacheUtil.getDynamicObjectFromPageCache(this.formPlugin);
            dynamicObject.set(ISSERIALNUMBER, (Object)true);
            dynamicObject.set("islog", returnData.get("islog"));
            dynamicObject.set(ISAPPORG, (Object)true);
            dynamicObject.set(ISAPPCONDITION, returnData.get(ISAPPCONDITION));
            dynamicObject.set("ischeckcode", returnData.get("ischeckcode"));
            PageCacheUtil.injectDynamicObjectToPageCache(this.formPlugin, dynamicObject);
            this.rebuildItem(dynamicObject);
            this.pageChangeEntryPlugin.rebuildChoseByAttributetype(dynamicObject);
            this.entryUtil.validateSerialBasis();
        }
        this.pageChangeEntryPlugin.rebuildSimCode();
    }

    public void changeByProperty(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        if (proName.equalsIgnoreCase("attributetype")) {
            this.pageChangeEntryPlugin.changeByAttributetype(e, proName);
            this.entryUtil.validateSerialBasis();
        } else if (proName.equalsIgnoreCase("attusingmode")) {
            int row = this.dataModel.getEntryCurrentRowIndex(ENTRYENTITY);
            this.entryUtil.formatEntryFullValue(row);
        } else if (proName.equalsIgnoreCase("splitsign")) {
            int rowCount = this.dataModel.getEntryRowCount(ENTRYENTITY);
            String filedValue = e.getChangeSet()[0].getNewValue().toString();
            for (int i = 0; i < rowCount; ++i) {
                new FieldUtil(this.formPlugin, this.dataModel).setFieldValue("splitsignentry", filedValue, i);
            }
        } else if (proName.equalsIgnoreCase("fixval")) {
            int row = this.dataModel.getEntryCurrentRowIndex(ENTRYENTITY);
            String fixval = (String)this.dataModel.getValue(proName, row);
            if (fixval.contains("!")) {
                this.formPlugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u4e2d\u4e0d\u53ef\u5305\u542b\u7b26\u53f7\u201c!\u201d", (String)"PageChangePlugin_0", (String)"bos-coderule", (Object[])new Object[0]));
            }
        } else if (proName.equalsIgnoreCase("addchar")) {
            int row = this.dataModel.getEntryCurrentRowIndex(ENTRYENTITY);
            String addchar = (String)this.dataModel.getValue(proName, row);
            if (addchar.contains("!")) {
                this.formPlugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u4e2d\u4e0d\u53ef\u5305\u542b\u7b26\u53f7\u201c!\u201d", (String)"PageChangePlugin_0", (String)"bos-coderule", (Object[])new Object[0]));
            }
        } else if (proName.equalsIgnoreCase("bizobjectid")) {
            this.pageChangeEntryPlugin.batchDelEntry();
        } else if (proName.equalsIgnoreCase("useinterruption") || proName.equalsIgnoreCase("updatemaxnumber")) {
            Object newValueObj = e.getChangeSet()[0].getNewValue();
            if (StringUtils.isNotBlank((Object)newValueObj) && newValueObj.toString().contains("0")) {
                this.dataModel.setValue("ismodifiable", (Object)true);
            } else if (StringUtils.isBlank((Object)newValueObj)) {
                this.dataModel.setValue("ismatchcoderule", (Object)"0");
            }
        }
        if (!"example".equals(proName)) {
            this.pageChangeEntryPlugin.rebuildSimCode();
            this.dataModel.setDataChanged(true);
        }
    }
}

