/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.newedit;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.coderule.newedit.AttributetypeUtil;
import kd.bos.coderule.newedit.EntryUtil;
import kd.bos.coderule.newedit.PageCacheUtil;
import kd.bos.coderule.newedit.PageChangeEntryPlugin;
import kd.bos.coderule.newedit.PageShowEntryPlugin;
import kd.bos.coderule.newedit.ShowFormUtil;
import kd.bos.coderule.newedit.SplitsignUtil;
import kd.bos.coderule.util.CodeRuleFastUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class PageShowPlugin {
    private static final String BOS_CODERULE = "bos-coderule";
    public static final String SPLITSIGN = "splitsign";
    public static final String BIZOBJECTID = "bizobjectid";
    public static final String NUMBER = "number";
    public static final String ISADDVIEW = "isaddview";
    public static final String ISMATCHCODERULE = "ismatchcoderule";
    public static final String CODERULEENABLECACHE = "codeRuleEnableCache";
    public static final String NAME = "name";
    public static final String FILTERCONDITION = "filtercondition";
    public static final String CONDITIONDESC = "conditiondesc";
    private static final String IS_CHECK_NUMBER = "ischecknumber";
    private AbstractFormPlugin formPlugin;
    private IDataModel dataModel;
    private PageShowEntryPlugin pageShowEntryPlugin;
    private PageChangeEntryPlugin pageChangeEntryPlugin;
    private AttributetypeUtil attributetypeUtil;
    private ShowFormUtil showFormUtil;
    private EntryUtil entryUtil;
    private OperationStatus status;

    public PageShowPlugin(AbstractFormPlugin formPlugin, IDataModel dataModel) {
        this.formPlugin = formPlugin;
        this.dataModel = dataModel;
        this.pageShowEntryPlugin = new PageShowEntryPlugin(formPlugin, dataModel);
        this.pageChangeEntryPlugin = new PageChangeEntryPlugin(formPlugin, dataModel);
        this.attributetypeUtil = new AttributetypeUtil(formPlugin, dataModel);
        this.showFormUtil = new ShowFormUtil(formPlugin, dataModel);
        this.entryUtil = new EntryUtil(formPlugin, dataModel);
        FormShowParameter formShowParameter = formPlugin.getView().getFormShowParameter();
        String enable = formPlugin.getPageCache().get(CODERULEENABLECACHE);
        if (enable == null) {
            this.status = formShowParameter != null && formShowParameter.getStatus() != null ? formShowParameter.getStatus() : OperationStatus.VIEW;
        } else if (enable.equals("view")) {
            this.status = OperationStatus.VIEW;
        } else if (enable.equals("edit")) {
            this.status = OperationStatus.EDIT;
        }
    }

    public void init() {
        this.attributetypeUtil.init();
        String id = (String)this.formPlugin.getView().getFormShowParameter().getCustomParam("id");
        if (id == null || id.trim().length() == 0) {
            this.initPageFormNew();
            this.formPlugin.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpaneltips"});
            this.formPlugin.getView().setVisible(Boolean.FALSE, new String[]{"btn_disable", "btn_enable", "btn_org", "btn_more", "btn_add", "btn_copy"});
        } else {
            boolean enable;
            this.initPageFormUpdate(id);
            this.setMoreHide();
            if (this.formPlugin.getPageCache().get("isCopy") != null) {
                this.formPlugin.getView().setVisible(Boolean.FALSE, new String[]{"btn_disable", "btn_enable", "btn_org", "btn_more", "btn_add", "btn_copy"});
                this.dataModel.setValue("id", null);
                this.dataModel.setValue("enable", null);
                DynamicObjectCollection entryentity = this.dataModel.getEntryEntity("entryentity");
                for (DynamicObject dynamicObject : entryentity) {
                    dynamicObject.set("id", null);
                }
                this.dataModel.setValue("ispreset", (Object)0);
                this.dataModel.setValue(NUMBER, (Object)ID.genStringId());
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
                String name = StringUtils.isNotBlank((Object)this.dataModel.getValue(NAME)) && this.dataModel.getValue(NAME).toString().startsWith(CodeRuleFastUtil.getTagName()) ? this.dataModel.getValue(NAME).toString().substring(CodeRuleFastUtil.getTagName().length()) : (this.dataModel.getValue(NAME) == null ? "" : this.dataModel.getValue(NAME).toString());
                this.dataModel.setValue(NAME, (Object)(name + "_copy_" + LocalDateTime.now().format(formatter)));
            }
            boolean isPreset = this.dataModel.getValue("ispreset") instanceof Boolean && (Boolean)this.dataModel.getValue("ispreset") != false;
            boolean bl = enable = this.dataModel.getValue("enable") != null && this.dataModel.getValue("enable").equals("1");
            if (isPreset && !enable) {
                this.formPlugin.getView().setVisible(Boolean.valueOf(false), new String[]{"flexenabletips"});
            } else if (!isPreset && enable) {
                this.formPlugin.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpresettips"});
            } else if (!enable) {
                this.formPlugin.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpaneltips"});
            }
        }
        this.pageChangeEntryPlugin.rebuildSimCode();
        this.pageChangeEntryPlugin.rebuildCodeRuleSeq();
        this.entryUtil.validateSerialBasis();
    }

    public void initPageFormNew() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_coderule");
        PageCacheUtil.injectDynamicObjectToPageCache(this.formPlugin, dynamicObject);
        this.entryUtil.formatEntry(0, CodeRuleEntryTypeEnum.TYPE_FIX_TEXT.getTypeStr());
        this.entryUtil.initComboEditForSplitsign(SPLITSIGN);
        this.entryUtil.initComboEditForSplitsign("splitsignentry");
        boolean isAutoChooseObj = this.setBaseFormBizobj();
        if (isAutoChooseObj) {
            DynamicObject bizobject = this.dataModel.getDataEntity().getDynamicObject(BIZOBJECTID);
            String bizobjectString = bizobject.getString(NAME);
            this.dataModel.setValue(NAME, (Object)bizobjectString);
        }
        this.dataModel.setValue(NUMBER, (Object)ID.genStringId());
        this.dataModel.setValue(ISADDVIEW, (Object)"1");
    }

    private boolean setBaseFormBizobj() {
        String objId = (String)this.formPlugin.getView().getFormShowParameter().getCustomParam("objId");
        String number = (String)this.formPlugin.getView().getFormShowParameter().getCustomParam("objNumber");
        if (StringUtils.isBlank((CharSequence)number) && StringUtils.isNotBlank((CharSequence)objId)) {
            String sql = "select fnumber from t_meta_entitydesign where fid = '" + objId + "'";
            number = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)new ResultSetHandler<String>(){

                public String handle(ResultSet rs) throws SQLException {
                    String number = "";
                    while (rs.next()) {
                        number = rs.getString("fnumber");
                    }
                    return number;
                }
            });
        }
        if (StringUtils.isBlank((CharSequence)number)) {
            return false;
        }
        QFilter[] qfArr = new QFilter[]{new QFilter(NUMBER, "=", (Object)number)};
        DynamicObject bizObjectType = BusinessDataServiceHelper.loadSingle((String)"bos_objecttype", (String)"id", (QFilter[])qfArr);
        if (bizObjectType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"%\u641c\u7d22\u4e0d\u5230\u4e1a\u52a1\u5bf9\u8c61\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u6216\u786e\u8ba4\u4e1a\u52a1\u5bf9\u8c61\u662f\u5426\u5b58\u5728", (String)"PageShowPlugin_4", (String)BOS_CODERULE, (Object[])new Object[0]));
        }
        this.dataModel.setValue(BIZOBJECTID, bizObjectType.getPkValue());
        return true;
    }

    public void initPageFormUpdate(String id) {
        QFilter[] qfArr = new QFilter[]{new QFilter("id", "=", (Object)id)};
        StringBuilder selectFields = new StringBuilder();
        selectFields.append("id, bizobjectid, name, splitsign, appmode, bizobjectid.number,enable");
        if (this.formPlugin.getPageCache().get("isCopy") != null) {
            selectFields.append(", filtercondition, conditiondesc");
        }
        selectFields.append(", isserialnumber, islog, isapporg, isappcondition, isupdaterecover, ischeckcode");
        selectFields.append(", isaddview, ismatchcoderule, ischecknumber, ismodifiable, isnonbreak, isfillwithzero, isautoincrlength, isunique, isfast");
        selectFields.append(", ruleentry.id, ruleentry.attributetype");
        selectFields.append(", ruleentry.fixval, ruleentry.format, ruleentry.attusingmode");
        selectFields.append(", ruleentry.length, ruleentry.initial, ruleentry.step");
        selectFields.append(", ruleentry.valueatribute, ruleentry.addchar, ruleentry.addstyle");
        selectFields.append(", ruleentry.cutstyle, ruleentry.issortitem, ruleentry.issplitsign, ruleentry.splitsignentry, ruleentry.isvisable");
        selectFields.append(", conditionentry.id, conditionentry.property, conditionentry.propertyvalue");
        selectFields.append(",useinterruption,updatemaxnumber");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_coderule", (String)selectFields.toString(), (QFilter[])qfArr);
        if (dynamicObject == null) {
            return;
        }
        DynamicObjectCollection ruleentrys = dynamicObject.getDynamicObjectCollection("ruleentry");
        DynamicObject bizobject = dynamicObject.getDynamicObject(BIZOBJECTID);
        this.entryUtil.initComboEditForSplitsign(SPLITSIGN);
        this.entryUtil.initComboEditForSplitsign("splitsignentry");
        this.initMainEntity(dynamicObject);
        this.pageShowEntryPlugin.initRuleEntry(dynamicObject, ruleentrys, bizobject);
        if (this.formPlugin.getPageCache().get("isCopy") != null) {
            dynamicObject.set("ruleentry", null);
        }
        PageCacheUtil.injectDynamicObjectToPageCache(this.formPlugin, dynamicObject);
    }

    private void initMainEntity(DynamicObject dynamicObject) {
        this.dataModel.setValue("id", dynamicObject.get("id"));
        this.dataModel.setValue(BIZOBJECTID, dynamicObject.get(BIZOBJECTID));
        String splitsign = dynamicObject.getString(SPLITSIGN);
        this.dataModel.setValue(SPLITSIGN, (Object)SplitsignUtil.convertEmptyToSpecial(splitsign));
        this.dataModel.setValue("appmode", dynamicObject.get("appmode"));
        this.dataModel.setValue(NAME, (Object)dynamicObject.getString(NAME));
        boolean isfast = dynamicObject.getBoolean("isfast");
        if (isfast) {
            this.dataModel.setValue(NAME, (Object)(CodeRuleFastUtil.getTagName() + dynamicObject.getString(NAME)));
        }
        this.dataModel.setValue(NUMBER, (Object)dynamicObject.getString(NUMBER));
        this.dataModel.setValue(ISADDVIEW, (Object)dynamicObject.getString(ISADDVIEW));
        this.dataModel.setValue(ISMATCHCODERULE, (Object)dynamicObject.getString(ISMATCHCODERULE));
        this.dataModel.setValue(IS_CHECK_NUMBER, (Object)dynamicObject.getString(IS_CHECK_NUMBER));
        this.dataModel.setValue("ismodifiable", (Object)dynamicObject.getString("ismodifiable"));
        this.dataModel.setValue("isunique", (Object)dynamicObject.getString("isunique"));
        this.dataModel.setValue("enable", dynamicObject.get("enable"));
        this.dataModel.setValue("isupdaterecover", dynamicObject.get("isupdaterecover"));
        if (this.formPlugin.getPageCache().get("isCopy") != null) {
            this.formPlugin.getPageCache().put(FILTERCONDITION, dynamicObject.getString(FILTERCONDITION));
            this.formPlugin.getPageCache().put(CONDITIONDESC, dynamicObject.getString(CONDITIONDESC));
        }
        if (StringUtils.isNotBlank((CharSequence)dynamicObject.getString("useinterruption"))) {
            if (dynamicObject.getString("useinterruption").equals("-1")) {
                this.dataModel.setValue("useinterruption", (Object)"");
            } else {
                this.dataModel.setValue("useinterruption", (Object)dynamicObject.getString("useinterruption"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dynamicObject.getString("updatemaxnumber"))) {
            if (dynamicObject.getString("updatemaxnumber").equals("-1")) {
                this.dataModel.setValue("updatemaxnumber", (Object)"");
            } else {
                this.dataModel.setValue("updatemaxnumber", (Object)dynamicObject.getString("updatemaxnumber"));
            }
        }
        if (dynamicObject.getBoolean(ISMATCHCODERULE)) {
            if (dynamicObject.getString("useinterruption").equals("-1")) {
                this.dataModel.setValue("useinterruption", (Object)"0");
                this.dataModel.setValue(ISMATCHCODERULE, (Object)"0");
            } else if (!dynamicObject.getString("useinterruption").contains("0")) {
                this.dataModel.setValue("useinterruption", (Object)("0," + dynamicObject.getString("useinterruption")));
            }
            if (dynamicObject.getString("updatemaxnumber").equals("-1")) {
                this.dataModel.setValue("updatemaxnumber", (Object)"0");
                this.dataModel.setValue(ISMATCHCODERULE, (Object)"0");
            } else if (!dynamicObject.getString("updatemaxnumber").contains("0")) {
                this.dataModel.setValue("updatemaxnumber", (Object)("0," + dynamicObject.getString("updatemaxnumber")));
            }
        }
    }

    public void showFormByOrg(String codeRuleId) {
        if (codeRuleId == null || codeRuleId.trim().length() == 0) {
            this.formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u89c4\u5219\u672a\u4fdd\u5b58\u3002", (String)"PageShowPlugin_1", (String)BOS_CODERULE, (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("codeRuleId", codeRuleId);
        this.showFormUtil.showForm("bos_coderule_org", params, null, ShowType.Modal, this.status);
    }

    public void showFormCondition(String codeRuleId, DynamicObject bizobject, String langName) {
        if (codeRuleId == null || codeRuleId.trim().length() == 0) {
            this.formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u89c4\u5219\u672a\u4fdd\u5b58\u3002", (String)"PageShowPlugin_1", (String)BOS_CODERULE, (Object[])new Object[0]));
            return;
        }
        ILocaleString name = (ILocaleString)bizobject.get(NAME);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dtname", name.get((Object)langName));
        params.put("dtval", bizobject.get(1));
        params.put("coderuleid", codeRuleId);
        if (this.formPlugin.getPageCache().get("isCopy") != null) {
            params.put("isCopy", true);
            String filtercondition = this.formPlugin.getPageCache().get(FILTERCONDITION);
            String conditiondesc = this.formPlugin.getPageCache().get(CONDITIONDESC);
            params.put(FILTERCONDITION, filtercondition);
            params.put(CONDITIONDESC, conditiondesc);
        }
        this.showFormUtil.showForm("bos_coderulepropertydy", params, null, ShowType.Modal, this.status);
    }

    public void showFormNewCondition(String codeRuleId, DynamicObject bizObject) {
        if (StringUtils.isBlank((CharSequence)codeRuleId)) {
            this.formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u89c4\u5219\u672a\u4fdd\u5b58\u3002", (String)"PageShowPlugin_1", (String)BOS_CODERULE, (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("codeRuleId", codeRuleId);
        params.put("bizObjectNumber", bizObject.get(1));
        this.showFormUtil.showForm("bos_coderule_condition", params, null, ShowType.Modal, this.status);
    }

    public void showFormMaxserial() {
        String unionId = this.formPlugin.getView().getPageId() + "maxserial";
        this.showFormUtil.openBillForm("bos_coderule_maxserial", unionId, ResManager.loadKDString((String)"\u6700\u5927\u53f7\u5217\u8868", (String)"PageShowPlugin_2", (String)BOS_CODERULE, (Object[])new Object[0]));
    }

    public void showFormMaxserial(String codeRuleId) {
        IFormView view = this.formPlugin.getView();
        IFormView parentView = view.getParentView();
        String unionId = view.getPageId() + "maxserial" + codeRuleId;
        if (parentView != null) {
            unionId = parentView.getPageId() + "maxserial" + codeRuleId;
        }
        this.showFormUtil.openBillForm("bos_coderule_maxserial", unionId, ResManager.loadKDString((String)"\u6700\u5927\u53f7", (String)"CodeRuleTreeListPlugin_38", (String)BOS_CODERULE, (Object[])new Object[0]));
    }

    @Deprecated
    public void showFormIntermitno() {
        String unionId = this.formPlugin.getView().getPageId() + "intermitno";
        this.showFormUtil.openBillForm("bos_coderule_intermitno", unionId, ResManager.loadKDString((String)"\u65ad\u53f7", (String)"CodeRuleTreeListPlugin_39", (String)BOS_CODERULE, (Object[])new Object[0]));
    }

    public void showFormIntermitno(String codeRuleId) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(1);
        customParams.put("coderuleid", codeRuleId);
        IFormView view = this.formPlugin.getView();
        IFormView parentView = view.getParentView();
        String unionId = view.getPageId() + "intermitno" + codeRuleId;
        if (parentView != null) {
            unionId = parentView.getPageId() + "intermitno" + codeRuleId;
        }
        this.showFormUtil.openBillForm("bos_coderule_intermitno", unionId, ResManager.loadKDString((String)"\u65ad\u53f7", (String)"CodeRuleTreeListPlugin_39", (String)BOS_CODERULE, (Object[])new Object[0]), customParams);
    }

    public void showFormOptional(String codeRuleId) {
        DynamicObject dynamicObject = PageCacheUtil.getDynamicObjectFromPageCache(this.formPlugin);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("islog", dynamicObject.getBoolean("islog"));
        params.put("isappcondition", dynamicObject.getBoolean("isappcondition"));
        params.put("isupdaterecover", dynamicObject.getBoolean("isupdaterecover"));
        params.put("ischeckcode", dynamicObject.getBoolean("ischeckcode"));
        params.put("coderuleid", codeRuleId);
        params.put("isexistappcondition", CollectionUtils.isNotEmpty((Collection)dynamicObject.getDynamicObjectCollection("conditionentry")));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.formPlugin, "selectOptionData");
        this.showFormUtil.showForm("bos_coderule_option", params, closeCallBack, ShowType.Modal, this.status);
    }

    public void setMoreHide() {
        boolean isContainsSerialnumber = false;
        int rowCount = this.dataModel.getEntryRowCount("entryentity");
        for (int row = 0; row < rowCount; ++row) {
            Object attributetypeValue = this.dataModel.getValue("attributetype", row);
            if (!attributetypeValue.toString().equals(CodeRuleEntryTypeEnum.TYPE_SEQ.getTypeStr())) continue;
            isContainsSerialnumber = true;
            break;
        }
        this.formPlugin.getView().setVisible(Boolean.valueOf(isContainsSerialnumber), new String[]{"btn_more"});
    }
}

