/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.opplugin.pagecache;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.utils.StringUtils;

public class SerialNumberCache {
    private static final String PAGE_CACHE_KEY_SERIAL_NUMBER = "coderule_serial_number_operate_fail";
    private static final String PAGE_CACHE_KEY_IS_OPEN_BILLNO = "coderule_is_open_billno_pagecache";
    private String className;

    public SerialNumberCache(String className) {
        this.className = className;
    }

    public boolean isOpenBillNoParam(OperateOption option) {
        if (option.tryGetVariableValue(PAGE_CACHE_KEY_IS_OPEN_BILLNO, new RefObject())) {
            return Boolean.parseBoolean(option.getVariableValue(PAGE_CACHE_KEY_IS_OPEN_BILLNO));
        }
        return false;
    }

    public void saveSerialNumberToOperation(String codeRuleKey, long serialNumber, OperateOption option) {
        String serialNumberKey = this.getPageCacheKeySerialNumber(codeRuleKey);
        option.setVariableValue(serialNumberKey, String.valueOf(serialNumber));
    }

    public String getAndRemoveSerialNumber(OperateOption option, String codeRuleKey) {
        String keySerialNumber = this.getPageCacheKeySerialNumber(codeRuleKey);
        String serialNumber = null;
        if (option.tryGetVariableValue(keySerialNumber, new RefObject()) && StringUtils.isNotBlank((CharSequence)(serialNumber = option.getVariableValue(keySerialNumber)))) {
            option.removeVariable(keySerialNumber);
        }
        return serialNumber;
    }

    public String getPageCacheKeySerialNumber(String codeRuleKey) {
        return PAGE_CACHE_KEY_SERIAL_NUMBER + this.className + codeRuleKey;
    }
}

