/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.opplugin.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.api.ConditionEntryInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class DynamicObjUtil {
    public static String getNumField(MainEntityType entityType) {
        String billNoName;
        if (entityType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)(billNoName = ((BillEntityType)entityType).getBillNo()))) {
            return billNoName;
        }
        return null;
    }

    public static DynamicObject getSimpleDynamicObject(CodeRuleInfo codeRuleInfo, DynamicObject dynamicObject) {
        ArrayList<String> fieldKeys = new ArrayList<String>(8);
        DynamicObjUtil.injectFieldFromConditionEntry(fieldKeys, codeRuleInfo.getConditionEntry());
        DynamicObjUtil.injectFieldFromCodeRuleEntry(fieldKeys, codeRuleInfo.getRuleEntry());
        DynamicObjUtil.injectFieldFromFilterCondition(fieldKeys, codeRuleInfo.getEnableCondition());
        MainEntityType mainEntityType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)dynamicObject.getDataEntityType().getName(), fieldKeys);
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])new Object[]{dynamicObject.getPkValue()}, (DynamicObjectType)mainEntityType);
        if (objs == null || objs.length == 0) {
            return null;
        }
        return objs[0];
    }

    public static void injectFieldFromConditionEntry(List<String> fieldKeys, List<ConditionEntryInfo> conditionEntrys) {
        if (CollectionUtils.isNotEmpty(conditionEntrys)) {
            for (ConditionEntryInfo conditionEntry : conditionEntrys) {
                fieldKeys.add(conditionEntry.getProperty());
            }
        }
    }

    public static void injectFieldFromCodeRuleEntry(List<String> fieldKeys, List<CodeRuleEntryInfo> codeRuleEntrys) {
        if (CollectionUtils.isNotEmpty(codeRuleEntrys)) {
            for (CodeRuleEntryInfo codeRuleEntry : codeRuleEntrys) {
                if (!StringUtils.isNotBlank((CharSequence)codeRuleEntry.getValueAtribute())) continue;
                fieldKeys.add(codeRuleEntry.getValueAtribute().split("\\.")[0]);
            }
        }
    }

    public static void injectFieldFromFilterCondition(List<String> fieldKeys, String enableCondition) {
        if (StringUtils.isBlank((CharSequence)enableCondition)) {
            return;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)enableCondition, FilterCondition.class);
        if (filterCondition == null || filterCondition.getFilterRow() == null) {
            return;
        }
        for (SimpleFilterRow filterRow : filterCondition.getFilterRow()) {
            String rowFieldName = filterRow.getFieldName();
            String[] splitFieldName = StringUtils.split((String)rowFieldName, (String)".");
            fieldKeys.add(splitFieldName[0]);
        }
    }
}

