/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.opplugin.util;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkInternal;

public class OrgUtil {
    private static final Log logger = LogFactory.getLog(OrgUtil.class);

    @SdkInternal
    public static String getMainOrgId(DynamicObject obj) {
        String mainOrg = ((BillEntityType)obj.getDataEntityType()).getMainOrg();
        String orgId = null;
        if (mainOrg == null) {
            return orgId;
        }
        try {
            Object orgObj = obj.get(mainOrg);
            if (orgObj == null) {
                return orgId;
            }
            if (orgObj instanceof DynamicObject) {
                orgId = String.valueOf(((DynamicObject)orgObj).getPkValue());
            } else if (orgObj instanceof Long) {
                orgId = String.valueOf(orgObj);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return orgId;
    }

    @SdkInternal
    public static String getMainOrgId(DynamicObject obj, String mainOrg) {
        String orgId = null;
        if (StringUtils.isBlank((CharSequence)mainOrg)) {
            return orgId;
        }
        Object orgObj = obj.get(mainOrg);
        if (orgObj == null) {
            return orgId;
        }
        if (orgObj instanceof DynamicObject) {
            orgId = String.valueOf(((DynamicObject)orgObj).getPkValue());
        } else if (orgObj instanceof Long) {
            orgId = String.valueOf(orgObj);
        }
        return orgId;
    }
}

