/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.service;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.business.plugin.CodeRuleGroup;
import kd.bos.coderule.adaptor.CodeRuleSigner;
import kd.bos.coderule.adaptor.CodeRuleSignerFactory;
import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.api.CoderuleFile;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.coderule.constant.CodeRuleConstant;
import kd.bos.coderule.domain.CodeRuleSqlExportDTO;
import kd.bos.coderule.domain.GroupHandlerDataEntity;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.coderule.handler.GroupHandler;
import kd.bos.coderule.handler.SyncHandler;
import kd.bos.coderule.handler.TraceHandler;
import kd.bos.coderule.handler.TransactionHandler;
import kd.bos.coderule.service.BatchRecycleServiceImpl;
import kd.bos.coderule.service.cache.CodeRuleCache;
import kd.bos.coderule.util.AppLogUtil;
import kd.bos.coderule.util.CodeRuleInfoBuilder;
import kd.bos.coderule.util.CodeRuleInfoUtil;
import kd.bos.coderule.util.CodeRuleNumberDTO;
import kd.bos.coderule.util.CodeRuleSerialNumUtil;
import kd.bos.coderule.util.CodeRuleSystemParam;
import kd.bos.coderule.util.CodeRuleUtils;
import kd.bos.coderule.util.CommonUtil;
import kd.bos.coderule.util.GroupHandlerUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.generator.common.GeneratorException;
import kd.bos.generator.common.GeneratorWithNumException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.collections4.CollectionUtils;

@SdkPublic
public class CodeRuleServiceImp
implements ICodeRuleService,
CodeRuleConstant {
    private Function<DynamicObject, CodeRuleInfo> codeRuleInfoFun;
    private static final Log logger = LogFactory.getLog(CodeRuleServiceImp.class);
    private static final String BOS_CODERULE = "bos-coderule";
    @SdkInternal
    public static final String EXCEPTION_MESSAGE_FORMAT = "Error:%s";
    @SdkInternal
    public static final String ENTITYID_CODERULE_MAXSERIAL = "bos_coderule_maxserial";

    public CodeRuleServiceImp() {
    }

    public CodeRuleServiceImp(Function<DynamicObject, CodeRuleInfo> codeRuleInfoFun) {
        this.codeRuleInfoFun = codeRuleInfoFun;
    }

    @SdkInternal
    public Function<DynamicObject, CodeRuleInfo> getCodeRuleInfoFun() {
        return this.codeRuleInfoFun;
    }

    @SdkInternal
    public CodeRuleServiceImp singCodeRuleInfoFun(Function<DynamicObject, CodeRuleInfo> codeRuleInfoFun) {
        this.codeRuleInfoFun = codeRuleInfoFun;
        return this;
    }

    private static String getCODELENGTHERROR() {
        return ResManager.loadKDString((String)"\u201cEAN13\u6821\u9a8c\u7801\u201d\u524d\u976212\u4f4d\u5fc5\u987b\u4e3a\u6570\u5b57\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u7f16\u7801\u89c4\u5219\u3002", (String)"CodeRuleServiceImp_0", (String)BOS_CODERULE, (Object[])new Object[0]);
    }

    private static String getMessageUpdateMaxserialAtImport() {
        return ResManager.loadKDString((String)"\u5bfc\u5165\u65f6\u4fee\u6539\u6700\u5927\u53f7\u9519\u8bef", (String)"CodeRuleServiceImp_12", (String)BOS_CODERULE, (Object[])new Object[0]);
    }

    public CodeRuleInfo getCodeRuleByEntityID(String entityId) {
        DynamicObject dataInfo = null;
        return this.getCodeRuleByEntityID(entityId, dataInfo, null);
    }

    public CodeRuleInfo getCodeRuleByEntityID(String entityId, DynamicObject dataInfo, String orgID) {
        Long userOrgId = this.getUserOrgId(dataInfo, orgID);
        List<CodeRuleInfo> codeRuleList = CodeRuleCache.getAllCodeRuleByEntity(entityId);
        if (codeRuleList == null || codeRuleList.isEmpty()) {
            return null;
        }
        CodeRuleInfo codeRuleInfo = this.getUsableCodeRuleId(codeRuleList, entityId, userOrgId, dataInfo);
        if (codeRuleInfo != null) {
            codeRuleInfo.setEntityId(entityId);
            codeRuleInfo.setOrgId(userOrgId.longValue());
        }
        return codeRuleInfo;
    }

    public String getNumber(String entityId, DynamicObject dataInfo, String orgId) {
        return this.getNumber(this.getCodeRuleByEntityID(entityId, dataInfo, orgId), dataInfo);
    }

    public String readNumber(String entityId, DynamicObject dataInfo, String orgId) {
        return this.readNumber(this.getCodeRuleByEntityID(entityId, dataInfo, orgId), dataInfo);
    }

    public String getNumber(CodeRuleInfo codeRuleInfo, DynamicObject dataInfo) {
        return this.getNumber(codeRuleInfo, dataInfo, false);
    }

    public String readNumber(CodeRuleInfo codeRuleInfo, DynamicObject dataInfo) {
        return this.getNumber(codeRuleInfo, dataInfo, true);
    }

    public String getNumber(CodeRuleInfo codeRuleInfo, DynamicObject dataInfo, boolean isReadNumber) {
        return this.getNumber(codeRuleInfo, dataInfo, isReadNumber, false);
    }

    public String generateExampleSerialNumber(CodeRuleInfo codeRuleInfo, DynamicObject dataInfo) {
        return this.getNumber(codeRuleInfo, dataInfo, true, true);
    }

    private String getNumber(final CodeRuleInfo codeRuleInfo, DynamicObject dataInfo, boolean isReadNumber, boolean isGenerateExample) {
        if (codeRuleInfo == null || dataInfo == null) {
            return null;
        }
        try (TraceSpan span = Tracer.create((String)"CodeRuleServiceImp", (String)"getNumber");){
            if (codeRuleInfo != null && dataInfo != null) {
                span.addTag("codeRuleInfo.id", codeRuleInfo.getId());
                span.addTag("codeRuleInfo.getEntityId", codeRuleInfo.getEntityId());
                span.addTag("dataInfo", dataInfo.getPkValue() == null ? "" : dataInfo.getPkValue().toString());
                span.addTag("isReadNumber", String.valueOf(isReadNumber));
                logger.info(String.format("CodeRuleServiceImp.getNumber(): codeRuleInfo(%s , %s) , codeRuleInfo.getEntityId: %s , dataInfo: %s , isReadNumber: %s", codeRuleInfo.getId(), codeRuleInfo.getName(), codeRuleInfo.getEntityId(), dataInfo.getPkValue() == null ? "" : dataInfo.getPkValue().toString(), String.valueOf(isReadNumber)));
            }
            StringBuilder beforeSeqNumber = new StringBuilder();
            StringBuilder afterSeqNumber = new StringBuilder();
            StringBuilder number = beforeSeqNumber;
            final StringBuilder sortItem = new StringBuilder();
            boolean isFirst = true;
            String entryValue = "";
            CodeRuleEntryInfo seqInfo = null;
            boolean hasCheckCode = false;
            boolean seqVisableFlag = true;
            for (CodeRuleEntryInfo codeRuleEntry : codeRuleInfo.getRuleEntry()) {
                entryValue = "";
                boolean isVisable = codeRuleEntry.getVisable();
                if (isFirst) {
                    isFirst = false;
                } else if (StringUtils.isNotBlank((CharSequence)codeRuleEntry.getSplitSign()) && isVisable) {
                    number.append(codeRuleEntry.getSplitSign());
                }
                CodeRuleEntryTypeEnum enums = CodeRuleEntryTypeEnum.getEnums(codeRuleEntry.getAttributeType());
                switch (enums) {
                    case TYPE_FIX_TEXT: {
                        entryValue = codeRuleEntry.getFormat();
                        break;
                    }
                    case TYPE_SEQ: {
                        seqVisableFlag = isVisable;
                        number = afterSeqNumber;
                        seqInfo = codeRuleEntry;
                        break;
                    }
                    case TYPE_RANDOM_NUMBER: {
                        entryValue = ResManager.loadKDString((String)"\u968f\u673a\u7801", (String)"CodeRuleServiceImp_1", (String)BOS_CODERULE, (Object[])new Object[0]);
                        if (isGenerateExample) {
                            entryValue = "ABCDEFG8";
                            break;
                        }
                        if (isReadNumber) break;
                        entryValue = CodeRuleSerialNumUtil.getRandomNumber(8);
                        break;
                    }
                    case TYPE_SYSTEM_TIME_FIELD: {
                        entryValue = CodeRuleSerialNumUtil.getSystemDateEntry(codeRuleEntry);
                        break;
                    }
                    case TYPE_DATE_FIELD: {
                        entryValue = CodeRuleSerialNumUtil.getDateEntry(codeRuleEntry, dataInfo);
                        break;
                    }
                    case TYPE_ITEM_FIELD: {
                        entryValue = CodeRuleSerialNumUtil.getItemEntry(codeRuleEntry, dataInfo);
                        break;
                    }
                    case TYPE_LIST_FIELD: {
                        break;
                    }
                    case CHECK_CODE: {
                        hasCheckCode = true;
                        break;
                    }
                }
                entryValue = CodeRuleSerialNumUtil.formatString(codeRuleEntry, entryValue);
                if (StringUtils.isNotBlank((CharSequence)entryValue) && isVisable) {
                    number.append(entryValue);
                }
                if (!codeRuleEntry.getIsSortItem().booleanValue()) continue;
                sortItem.append(entryValue);
                sortItem.append("_split_");
            }
            String seqValue = "";
            if (seqInfo != null) {
                try (TXHandle h = TX.requiresNew();){
                    try {
                        String sortValueItem = sortItem.toString();
                        if (sortValueItem.endsWith("_split_")) {
                            sortValueItem = sortValueItem.substring(0, sortValueItem.lastIndexOf("_split_"));
                        }
                        seqValue = isGenerateExample ? CodeRuleSerialNumUtil.generateExampleSerialNumber(codeRuleInfo, "1") : this.getCodeRuleSigner(codeRuleInfo).getSerialNumber(codeRuleInfo, seqInfo, sortValueItem, isReadNumber);
                        logger.info(String.format("CodeRuleServiceImp.getSerialNumber:serialNum=(%s), coderuleInfo=(%s,%s), sortItem = %s, isReadNumber = %s\uff0cisGenerateExample=%s", seqValue, codeRuleInfo.getId(), codeRuleInfo.getName(), sortItem.toString(), isReadNumber, isGenerateExample));
                    }
                    catch (Exception e) {
                        h.markRollback();
                        String message = e.getMessage();
                        if (!(e instanceof GeneratorWithNumException) || !StringUtils.equals((CharSequence)GeneratorException.ErrorCode.ERRCODE_CODERULE_VALIDATE_NUMBER.getCode(), (CharSequence)((GeneratorWithNumException)e).getCode())) {
                            String errorInfo = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\uff1a%1$s\uff0c \u83b7\u53d6\u6d41\u6c34\u53f7\u65f6\u51fa\u73b0\u5f02\u5e38:%2$s", (String)"CodeRuleServiceImp_2", (String)BOS_CODERULE, (Object[])new Object[0]), codeRuleInfo.getEntityId(), message);
                            logger.error(errorInfo, (Throwable)e);
                        }
                        if (e instanceof GeneratorWithNumException) {
                            if (!isReadNumber && codeRuleInfo.getIsNonBreak().booleanValue()) {
                                new TransactionHandler(ResManager.loadKDString((String)"\u53d1\u53f7\u5668\u5f02\u5e38\u56de\u6536\u7f16\u53f7\u5931\u8d25", (String)"CodeRuleServiceImp_23", (String)BOS_CODERULE, (Object[])new Object[0])){

                                    @Override
                                    protected void transactionProcess() {
                                        String sortValueItem = sortItem.toString();
                                        if (sortValueItem.endsWith("_split_")) {
                                            sortValueItem = sortValueItem.substring(0, sortValueItem.lastIndexOf("_split_"));
                                        }
                                        CodeRuleServiceImp.this.recycleNumber(codeRuleInfo, sortValueItem, ((GeneratorWithNumException)e).getNums());
                                    }
                                };
                            }
                            throw new KDBizException((Throwable)e, new ErrorCode("ERRCODE_CODERULE_VALIDATE_NUMBER", message), new Object[0]);
                        }
                        throw new KDBizException((Throwable)e, new ErrorCode("ERRCODE_CODERULE_VALIDATE_NUMBER", message), new Object[0]);
                    }
                }
            }
            StringBuilder finalNumber = new StringBuilder();
            finalNumber = finalNumber.append((CharSequence)beforeSeqNumber);
            if (seqVisableFlag) {
                finalNumber = finalNumber.append(seqValue);
            }
            finalNumber = finalNumber.append((CharSequence)afterSeqNumber);
            if (hasCheckCode) {
                if (CommonUtil.validateNumLen(finalNumber.toString())) {
                    finalNumber.append(String.valueOf(CommonUtil.getCheckNumber(finalNumber.toString())));
                } else {
                    throw new KDBizException(new ErrorCode("ERRCODE_CODERULE_VALIDATE_NUMBER", CodeRuleConstant.getCODELENGTHERROR()), new Object[0]);
                }
            }
            String billNumber = finalNumber.toString();
            codeRuleInfo.setNumber(billNumber);
            logger.info(String.format("CodeRuleServiceImp: \u4e1a\u52a1\u5bf9\u8c61\uff1a%s , \u751f\u6210\u6700\u7ec8\u7f16\u7801: %s , isReadNumber = %s ", codeRuleInfo.getEntityId(), billNumber, String.valueOf(isReadNumber)));
            String string = billNumber;
            return string;
        }
    }

    @SdkInternal
    protected CodeRuleSigner getCodeRuleSigner(CodeRuleInfo codeRuleInfo) {
        return CodeRuleSignerFactory.newInstance(codeRuleInfo);
    }

    private static boolean validateNumLen(String string) {
        String str = "^\\d{12}$";
        Pattern p = Pattern.compile(str);
        Matcher m = p.matcher(string);
        return m.matches();
    }

    public static int getCheckNumber(String num) {
        int i;
        num = num + "0";
        int numSect1 = 1;
        int numSect2 = 2;
        int length = num.length();
        int len = 6;
        try {
            numSect1 = Integer.parseInt(num.substring(length - len, length));
            numSect2 = Integer.parseInt(num.substring(0, length - len));
        }
        catch (Exception e) {
            throw new KDBizException(new ErrorCode("ErrCode_CodeRule", CodeRuleServiceImp.getCODELENGTHERROR()), new Object[0]);
        }
        int sum1 = 0;
        int sum2 = 0;
        int dec = 10;
        for (i = 1; i <= len; ++i) {
            if (i % 2 == 0) {
                sum2 += numSect1 % dec;
            } else {
                sum1 += numSect1 % dec;
            }
            numSect1 /= dec;
        }
        for (i = 7; i <= length; ++i) {
            if (i % 2 == 0) {
                sum2 += numSect2 % dec;
            } else {
                sum1 += numSect2 % dec;
            }
            numSect2 /= dec;
        }
        int sum = sum2 * 3 + sum1;
        return (dec - sum % dec) % dec;
    }

    public CodeRuleInfo getUsableCodeRuleId(List<CodeRuleInfo> codeRuleList, String entityId, Long orgID, DynamicObject dataInfo) {
        return CodeRuleInfoUtil.getUsableCodeRuleId(codeRuleList, entityId, orgID, dataInfo);
    }

    @SdkInternal
    public Long getUserOrgId(DynamicObject dataInfo, String orgID) {
        return CodeRuleInfoUtil.getUserOrgId(dataInfo, orgID);
    }

    @SdkInternal
    public String[] getBatchNumber(String entityId, DynamicObject dataInfo, String orgID, int count) {
        if (count < 1) {
            return new String[0];
        }
        CodeRuleInfo codeRuleInfo = this.getCodeRuleByEntityID(entityId, dataInfo, orgID);
        if (codeRuleInfo == null || dataInfo == null) {
            return new String[0];
        }
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(count);
        for (int i = 0; i < count; ++i) {
            dynamicObjects.add(dataInfo);
        }
        List<String> numbers = this.getNumbers(entityId, dynamicObjects, codeRuleInfo);
        if (CollectionUtils.isEmpty(numbers)) {
            return new String[0];
        }
        return numbers.toArray(new String[numbers.size()]);
    }

    public void injectNumbers(String entityId, List<DynamicObject> dynamicObjects) {
        List<GroupHandlerDataEntity> dataEntities = GroupHandlerUtil.convertToGroupHandlerDataEntitys(dynamicObjects);
        if (CollectionUtils.isNotEmpty(dataEntities)) {
            new GroupHandler(this, entityId, dataEntities){

                @Override
                protected void groupProcess(final CodeRuleInfo codeRuleInfo, final String sortItem, final List<GroupHandlerDataEntity> dataEntities) {
                    final List<DynamicObject> dynamicObjects = GroupHandlerUtil.convertToDynamicObjects(dataEntities);
                    new TraceHandler(codeRuleInfo, dynamicObjects){

                        @Override
                        public void traceProcess() {
                            String[] numbers = CodeRuleServiceImp.this.buildBatchNumber(codeRuleInfo, sortItem, dynamicObjects);
                            for (int i = 0; i < dataEntities.size(); ++i) {
                                DynamicObject dynamicObject = ((GroupHandlerDataEntity)dataEntities.get(i)).getDynamicObject();
                                String billNo = ((BillEntityType)dynamicObject.getDataEntityType()).getBillNo();
                                dynamicObject.set(billNo, (Object)numbers[i]);
                            }
                        }
                    }.process();
                }
            }.process();
        }
    }

    public List<String> getNumbers(String entityId, List<DynamicObject> dynamicObjects) {
        return this.getNumbers(entityId, dynamicObjects, null);
    }

    public List<String> getNumbers(String entityId, List<DynamicObject> dynamicObjects, CodeRuleInfo codeRuleInfo) {
        List<GroupHandlerDataEntity> dataEntitys = GroupHandlerUtil.convertToGroupHandlerDataEntitys(dynamicObjects);
        if (CollectionUtils.isNotEmpty(dataEntitys)) {
            new GroupHandler(this, entityId, dataEntitys, codeRuleInfo){

                @Override
                protected void groupProcess(final CodeRuleInfo codeRuleInfo, final String sortItem, final List<GroupHandlerDataEntity> dataEntities) {
                    final List<DynamicObject> dynamicObjects = GroupHandlerUtil.convertToDynamicObjects(dataEntities);
                    new TraceHandler(codeRuleInfo, dynamicObjects){

                        @Override
                        public void traceProcess() {
                            String[] numbers = CodeRuleServiceImp.this.buildBatchNumber(codeRuleInfo, sortItem, dynamicObjects);
                            for (int i = 0; i < dataEntities.size(); ++i) {
                                ((GroupHandlerDataEntity)dataEntities.get(i)).setBillNo(numbers[i]);
                            }
                        }
                    }.process();
                }
            }.process();
        }
        return Optional.ofNullable(dataEntitys).map(Collection::stream).orElseGet(Stream::empty).sorted((o1, o2) -> {
            if (o1.getRowIndex() > o2.getRowIndex()) {
                return 1;
            }
            return -1;
        }).map(GroupHandlerDataEntity::getBillNo).collect(Collectors.toList());
    }

    private String[] buildBatchNumber(CodeRuleInfo codeRuleInfo, String sortItem, List<DynamicObject> dynamicObjects) {
        StringBuilder[] completeNumbers = new StringBuilder[dynamicObjects.size()];
        String[] serailNumbers = this.buildBatchNumberForSerialNumber(codeRuleInfo, dynamicObjects);
        String[] seqNumbers = this.buildBatchNumberForSeqNumber(codeRuleInfo, sortItem, dynamicObjects.size());
        this.buildCompeteFromSeqNumAndSerialNum(codeRuleInfo, dynamicObjects, completeNumbers, serailNumbers, seqNumbers);
        String[] completeNumberStrs = new String[completeNumbers.length];
        for (int i = 0; i < completeNumbers.length; ++i) {
            completeNumberStrs[i] = completeNumbers[i].toString();
        }
        return completeNumberStrs;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String[] buildBatchNumberForSerialNumber(CodeRuleInfo codeRuleInfo, List<DynamicObject> dynamicObjects) {
        StringBuilder[] serialNumbers = new StringBuilder[dynamicObjects.size()];
        int i = 0;
        while (true) {
            StringBuilder serialNumber;
            DynamicObject dataInfo;
            if (i < dynamicObjects.size()) {
                dataInfo = dynamicObjects.get(i);
                serialNumber = new StringBuilder();
            } else {
                String[] result = new String[serialNumbers.length];
                int i2 = 0;
                while (true) {
                    if (i2 >= serialNumbers.length) {
                        return result;
                    }
                    result[i2] = serialNumbers[i2].toString();
                    ++i2;
                }
            }
            block12: for (int j = 0; j < codeRuleInfo.getRuleEntry().size(); ++j) {
                CodeRuleEntryInfo codeRuleEntry = (CodeRuleEntryInfo)codeRuleInfo.getRuleEntry().get(j);
                if (j != 0 && StringUtils.isNotBlank((CharSequence)codeRuleEntry.getSplitSign()) && codeRuleEntry.getVisable()) {
                    serialNumber.append(codeRuleEntry.getSplitSign());
                }
                String entryValue = "";
                CodeRuleEntryTypeEnum enums = CodeRuleEntryTypeEnum.getEnums(codeRuleEntry.getAttributeType());
                switch (enums) {
                    case TYPE_FIX_TEXT: {
                        entryValue = codeRuleEntry.getFormat();
                        break;
                    }
                    case TYPE_RANDOM_NUMBER: {
                        entryValue = CodeRuleSerialNumUtil.getRandomNumber(8);
                        break;
                    }
                    case TYPE_SYSTEM_TIME_FIELD: {
                        entryValue = CodeRuleSerialNumUtil.getSystemDateEntry(codeRuleEntry);
                        break;
                    }
                    case TYPE_DATE_FIELD: {
                        entryValue = CodeRuleSerialNumUtil.getDateEntry(codeRuleEntry, dataInfo);
                        break;
                    }
                    case TYPE_ITEM_FIELD: {
                        entryValue = CodeRuleSerialNumUtil.getItemEntry(codeRuleEntry, dataInfo);
                        break;
                    }
                    case TYPE_SEQ: {
                        entryValue = "CODERULE_SPECIAL_SPLIT_FOR_SERIAL_NUMBER";
                        break;
                    }
                    case TYPE_LIST_FIELD: {
                        entryValue = "CODERULE_SPECIAL_SPLIT_FOR_SERIAL_NUMBER";
                        break;
                    }
                    case CHECK_CODE: {
                        continue block12;
                    }
                }
                entryValue = CodeRuleSerialNumUtil.formatString(codeRuleEntry, entryValue);
                if (StringUtils.isNotBlank((CharSequence)entryValue) && codeRuleEntry.getVisable()) {
                    serialNumber.append(entryValue);
                }
                serialNumbers[i] = serialNumber;
            }
            ++i;
        }
    }

    private String[] buildBatchNumberForSeqNumber(final CodeRuleInfo codeRuleInfo, final String sortItem, final int count) {
        final Optional<CodeRuleEntryInfo> seqInfo = codeRuleInfo.getRuleEntry().stream().filter(x -> x.getAttributeType().equals(CodeRuleEntryTypeEnum.TYPE_SEQ.getTypeStr())).findFirst();
        if (!seqInfo.isPresent()) {
            return null;
        }
        final String[] seqNumbers = new String[count];
        new TransactionHandler(ResManager.loadKDString((String)"\u6279\u91cf\u83b7\u53d6\u6d41\u6c34\u53f7\u5f02\u5e38\u3002", (String)"CodeRuleServiceImp_3", (String)BOS_CODERULE, (Object[])new Object[0])){

            @Override
            protected void transactionProcess() {
                String[] serialNumbers = CodeRuleServiceImp.this.getCodeRuleSigner(codeRuleInfo).getBatchSerialNumber(codeRuleInfo, (CodeRuleEntryInfo)seqInfo.get(), CodeRuleSerialNumUtil.fillSortItem(sortItem), count);
                int i = 0;
                while (i < count) {
                    seqNumbers[i] = "";
                    String seqNumber = CodeRuleSerialNumUtil.formatString((CodeRuleEntryInfo)seqInfo.get(), serialNumbers[i]);
                    int n = i++;
                    seqNumbers[n] = seqNumbers[n] + seqNumber;
                }
            }

            @Override
            protected void doError(final Exception e) {
                if (e instanceof GeneratorWithNumException) {
                    if (codeRuleInfo.getIsNonBreak().booleanValue()) {
                        new TransactionHandler(ResManager.loadKDString((String)"\u53d1\u53f7\u5668\u5f02\u5e38\u56de\u6536\u7f16\u53f7\u5931\u8d25", (String)"CodeRuleServiceImp_23", (String)CodeRuleServiceImp.BOS_CODERULE, (Object[])new Object[0])){

                            @Override
                            protected void transactionProcess() {
                                CodeRuleServiceImp.this.recycleNumber(codeRuleInfo, sortItem, ((GeneratorWithNumException)e).getNums());
                            }
                        };
                    }
                    throw new KDBizException((Throwable)e, new ErrorCode("ERRCODE_CODERULE_VALIDATE_NUMBER", e.getMessage()), new Object[0]);
                }
                String errorInfo = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\uff1a%1$s\uff0c \u83b7\u53d6\u6d41\u6c34\u53f7\u65f6\u51fa\u73b0\u5f02\u5e38:%2$s", (String)"CodeRuleServiceImp_2", (String)CodeRuleServiceImp.BOS_CODERULE, (Object[])new Object[0]), codeRuleInfo.getEntityId(), e.getMessage());
                logger.error(errorInfo, (Throwable)e);
                throw new KDException((Throwable)e, new ErrorCode("ERRCODE_CODERULE_VALIDATE_NUMBER", e.getMessage()), new Object[0]);
            }
        };
        return seqNumbers;
    }

    private void buildCompeteFromSeqNumAndSerialNum(CodeRuleInfo codeRuleInfo, List<DynamicObject> dynamicObjects, StringBuilder[] completeNumbers, String[] serailNumbers, String[] seqNumbers) {
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            completeNumbers[i] = new StringBuilder();
            String completeNumber = serailNumbers[i];
            if (seqNumbers != null && seqNumbers.length > i) {
                completeNumber = completeNumber.replace("CODERULE_SPECIAL_SPLIT_FOR_SERIAL_NUMBER", seqNumbers[i]);
            }
            completeNumbers[i].append(completeNumber);
        }
        Optional<CodeRuleEntryInfo> validateType = codeRuleInfo.getRuleEntry().stream().filter(x -> x.getAttributeType().equals(CodeRuleEntryTypeEnum.CHECK_CODE.getTypeStr())).findFirst();
        if (validateType.isPresent()) {
            for (StringBuilder completeNumber : completeNumbers) {
                if (!CodeRuleServiceImp.validateNumLen(completeNumber.toString())) {
                    throw new KDBizException(new ErrorCode("ERRCODE_CODERULE_VALIDATE_NUMBER", CodeRuleServiceImp.getCODELENGTHERROR()), new Object[0]);
                }
                completeNumber.append(CodeRuleServiceImp.getCheckNumber(completeNumber.toString()));
            }
        }
    }

    public boolean[] recycleBatchNumber(String entityId, DynamicObject[] dataInfo, String orgID, String[] numbers) {
        if (CodeRuleSystemParam.getMcParam("coderuleservice.recyclebatchnumber")) {
            return new BatchRecycleServiceImpl(this).recycleBatchNumber(entityId, dataInfo, orgID, numbers);
        }
        if (dataInfo == null || dataInfo.length == 0) {
            return new boolean[0];
        }
        StringBuilder sbDataInfoIds = new StringBuilder();
        for (int i = 0; i < dataInfo.length; ++i) {
            if (dataInfo[i] == null) continue;
            sbDataInfoIds.append(dataInfo[i].getPkValue());
            if (i == dataInfo.length - 1) continue;
            sbDataInfoIds.append(',');
        }
        logger.info(String.format("CodeRuleServiceImp.recycleBatchNumber(): entityId: %s, dataInfo: [%s], orgID: %s, number: %s ", entityId, sbDataInfoIds, orgID, Arrays.toString(numbers)));
        int count = numbers.length;
        boolean[] results = new boolean[count];
        for (int i = 0; i < count; ++i) {
            results[i] = this.recycleNumber(entityId, dataInfo[i], orgID, numbers[i]);
        }
        return results;
    }

    public boolean autoRecycleNumber(String ruleID) {
        return false;
    }

    public boolean recycleNumber(String entityId, DynamicObject dataInfo, String orgID, String number) {
        logger.info(String.format("CodeRuleServiceImp.recycleNumber(): entityId: %s , dataInfo: %s ,  orgID: %s , number: %s ", entityId, dataInfo != null ? dataInfo.getPkValue() : null, orgID, number));
        CodeRuleInfo codeRuleInfo = this.getCodeRuleByEntityID(entityId, dataInfo, orgID);
        return this.recycleNumber(codeRuleInfo, dataInfo, number);
    }

    public boolean recycleNumber(final CodeRuleInfo codeRuleInfo, final DynamicObject dataInfo, String number) {
        if (codeRuleInfo == null) {
            logger.info("CodeRuleServiceImp.recycleNumber(): \u65e0\u5408\u9002\u7f16\u7801\u89c4\u5219\uff0c\u4e0d\u56de\u6536\u7f16\u7801");
            return true;
        }
        if (StringUtils.isBlank((CharSequence)number)) {
            logger.info("CodeRuleServiceImp.recycleNumber(): \u4f20\u5165\u7684\u7f16\u53f7\u4e3a\u7a7a, \u4e0d\u505a\u56de\u6536\u5904\u7406");
            return true;
        }
        logger.info(String.format("CodeRuleServiceImp.recycleNumber(): codeRuleInfo(%s , %s) , codeRuleInfo.getEntityId: %s , dataInfo: %s", codeRuleInfo.getId(), codeRuleInfo.getName(), codeRuleInfo.getEntityId(), dataInfo.getPkValue() == null ? "" : dataInfo.getPkValue().toString()));
        if (!codeRuleInfo.getIsNonBreak().booleanValue()) {
            logger.info("CodeRuleServiceImp.recycleNumber(): \u5f53\u524d\u89c4\u5219\u4e0d\u662f\u201c\u4e0d\u5141\u8bb8\u65ad\u53f7\u201d\u7684\u60c5\u51b5\uff0c\u4e0d\u56de\u6536\u7f16\u7801");
            return true;
        }
        final CodeRuleNumberDTO codeRuleNumberDTO = this.getSerialNumber(codeRuleInfo, dataInfo, number);
        if ("-1".equals(codeRuleNumberDTO.getSerialNumber())) {
            logger.info("CodeRuleServiceImp.recycleNumber(): \u672a\u80fd\u627e\u5230\u6d41\u6c34\u53f7\uff0c\u4e0d\u56de\u6536\u7f16\u7801");
            return true;
        }
        CodeRuleEntryInfo codeRuleEntryInfo = this.getCodeRuleEntityWithSerialNum(codeRuleInfo);
        if (codeRuleEntryInfo == null) {
            logger.info("CodeRuleServiceImp.recycleNumber():\u89c4\u5219\u7f3a\u5c11\u6d41\u6c34\u53f7\u6bb5,\u4e0d\u7ee7\u7eed\u56de\u6536");
            return true;
        }
        final boolean[] resultArr = new boolean[1];
        new TransactionHandler(ResManager.loadKDString((String)"\u56de\u6536\u7f16\u7801\u53d1\u751f\u5f02\u5e38", (String)"CodeRuleServiceImp_4", (String)BOS_CODERULE, (Object[])new Object[0])){

            @Override
            protected void transactionProcess() {
                new SyncHandler(CodeRuleSerialNumUtil.getDLockKey(codeRuleInfo, codeRuleNumberDTO.getSortItemValue()), codeRuleInfo.getName(), codeRuleInfo.getId()){

                    @Override
                    protected void syncProcess() {
                        resultArr[0] = CodeRuleServiceImp.this.recycleNumber(codeRuleInfo, codeRuleNumberDTO, dataInfo);
                    }
                }.process();
            }
        }.process();
        String sortItemValue = CommonUtil.convertSortItem(codeRuleNumberDTO.getSortItemValue());
        if ("".equals(sortItemValue) || "_split_".equals(sortItemValue)) {
            AppLogUtil.insertAppLog(dataInfo, new MultiLangEnumBridge("\u56de\u6536\u5355\u636e", "CodeRuleServiceImp_5", BOS_CODERULE), new MultiLangEnumBridge("\u56de\u6536\u53f7:%1$s, \u5355\u636e\u7f16\u53f7:%2$s, \u72b6\u6001:%3$s", "CodeRuleServiceImp_6", BOS_CODERULE), codeRuleNumberDTO.getSerialNumber(), number, String.valueOf(resultArr[0]));
        } else {
            AppLogUtil.insertAppLog(dataInfo, new MultiLangEnumBridge("\u56de\u6536\u5355\u636e", "CodeRuleServiceImp_5", BOS_CODERULE), new MultiLangEnumBridge("\u56de\u6536\u53f7:%1$s, \u5355\u636e\u7f16\u53f7:%2$s, \u72b6\u6001:%3$s, \u4f9d\u636e:%s\u3002", "BOS_CODERULE_7", BOS_CODERULE), codeRuleNumberDTO.getSerialNumber(), number, String.valueOf(resultArr[0]), sortItemValue);
        }
        return resultArr[0];
    }

    private CodeRuleEntryInfo getCodeRuleEntityWithSerialNum(CodeRuleInfo codeRuleInfo) {
        if (codeRuleInfo != null) {
            for (CodeRuleEntryInfo codeRuleEntryInfo : codeRuleInfo.getRuleEntry()) {
                if (!CodeRuleEntryTypeEnum.TYPE_SEQ.getTypeStr().equals(codeRuleEntryInfo.getAttributeType())) continue;
                return codeRuleEntryInfo;
            }
        }
        return null;
    }

    private boolean recycleNumber(CodeRuleInfo codeRuleInfo, CodeRuleNumberDTO codeRuleNumberDTO, DynamicObject dynamicObject) {
        boolean result = false;
        String seqSegmentEntryID = "";
        result = this.saveIntermitNumber(codeRuleInfo, seqSegmentEntryID, codeRuleNumberDTO.getSortItemValue(), codeRuleNumberDTO.getSerialNumber(), dynamicObject);
        logger.info("CodeRuleServiceImp: \u56de\u6536\u7f16\u7801\u6700\u7ec8\u7ed3\u679c\uff1a" + result);
        return result;
    }

    protected Boolean saveIntermitNumber(CodeRuleInfo codeRuleInfo, String seqSegmentEntryID, String sortItemValue, String serialNumber, DynamicObject dynamicObject) {
        if (codeRuleInfo == null) {
            return Boolean.FALSE;
        }
        Boolean result = Boolean.FALSE;
        if (StringUtils.isBlank((CharSequence)sortItemValue)) {
            sortItemValue = "_split_";
        }
        Boolean checkResult = this.checkIntermitNumber(codeRuleInfo, seqSegmentEntryID, sortItemValue, serialNumber);
        logger.info(String.format("CodeRuleServiceImp.checkIntermitNumber(): codeRuleInfo.Id: %s , codeRuleInfo.name: %s , codeRuleInfo.getEntityId: %s , seqSegmentEntryID: %s , sortItemValue: %s, serialNumber:%s, checkResult: %s", codeRuleInfo.getId(), codeRuleInfo.getName(), codeRuleInfo.getEntityId(), seqSegmentEntryID, sortItemValue, serialNumber, checkResult));
        if (checkResult.booleanValue()) {
            String sortItem = CommonUtil.convertSortItem(sortItemValue);
            if (AppLogUtil.checkSortItemValue(sortItem)) {
                AppLogUtil.insertAppLog(dynamicObject, new MultiLangEnumBridge("\u4fdd\u5b58\u65ad\u53f7", "CodeRuleServiceImp_7", BOS_CODERULE), new MultiLangEnumBridge("\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u56de\u6536\u53f7:%3$s\uff0c\u56de\u6536\u5224\u5b9a:\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u65ad\u53f7\u65e0\u9700\u63d2\u5165", "CodeRuleServiceImp_24", BOS_CODERULE), codeRuleInfo.getId(), codeRuleInfo.getName(), serialNumber);
            } else {
                AppLogUtil.insertAppLog(dynamicObject, new MultiLangEnumBridge("\u4fdd\u5b58\u65ad\u53f7", "CodeRuleServiceImp_7", BOS_CODERULE), new MultiLangEnumBridge("\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u56de\u6536\u53f7:%3$s\uff0c\u56de\u6536\u5224\u5b9a:\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u65ad\u53f7\u65e0\u9700\u63d2\u5165\uff0c\u4f9d\u636e:%s\u3002", "BOS_CODERULE_8", BOS_CODERULE), codeRuleInfo.getId(), codeRuleInfo.getName(), serialNumber, sortItem);
            }
            logger.info("CodeRuleServiceImp.checkIntermitNumber():\u65ad\u53f7\u5df2\u5b58\u5728\uff01");
            return result;
        }
        result = this.insertIntermitNumber(codeRuleInfo, seqSegmentEntryID, sortItemValue, serialNumber);
        String sortItem = CommonUtil.convertSortItem(sortItemValue);
        if (AppLogUtil.checkSortItemValue(sortItem)) {
            AppLogUtil.insertAppLog(dynamicObject, new MultiLangEnumBridge("\u4fdd\u5b58\u65ad\u53f7", "CodeRuleServiceImp_7", BOS_CODERULE), new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f\uff0c\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u56de\u6536\u53f7:%3$s\uff0c\u56de\u6536\u5224\u5b9a:\u9700\u8981\u4fdd\u5b58\u6b64\u65ad\u53f7", "CodeRuleServiceImp_25", BOS_CODERULE), codeRuleInfo.getId(), codeRuleInfo.getName(), serialNumber);
        } else {
            AppLogUtil.insertAppLog(dynamicObject, new MultiLangEnumBridge("\u4fdd\u5b58\u65ad\u53f7", "CodeRuleServiceImp_7", BOS_CODERULE), new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f\uff0c\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u56de\u6536\u53f7:%3$s\uff0c\u56de\u6536\u5224\u5b9a:\u9700\u8981\u4fdd\u5b58\u6b64\u65ad\u53f7\uff0c\u4f9d\u636e:%s\u3002", "BOS_CODERULE_9", BOS_CODERULE), codeRuleInfo.getId(), codeRuleInfo.getName(), serialNumber, sortItem);
        }
        logger.info(String.format("CodeRuleServiceImp.insertIntermitNumber(): codeRuleInfo.Id: %s , codeRuleInfo.name: %s , codeRuleInfo.getEntityId: %s , seqSegmentEntryID: %s , sortItemValue: %s, serialNumber:%s, result: %s", codeRuleInfo.getId(), codeRuleInfo.getName(), codeRuleInfo.getEntityId(), seqSegmentEntryID, sortItemValue, serialNumber, result));
        return result;
    }

    private Boolean insertIntermitNumber(CodeRuleInfo codeRuleInfo, String seqSegmentEntryID, String sortItemValue, String serialNumber) {
        Long intermitNumber = Long.valueOf(serialNumber);
        DynamicObject dObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_coderule_intermitno");
        dObj.set("codeRuleID", (Object)codeRuleInfo.getId());
        dObj.set("seqSegmentEntryID", (Object)seqSegmentEntryID);
        dObj.set("sortitemvalue", (Object)sortItemValue);
        dObj.set("serial", (Object)intermitNumber);
        dObj.set("createdate", (Object)new Date());
        dObj.set("creater", (Object)RequestContext.get().getUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObj});
        return Boolean.TRUE;
    }

    protected Boolean checkIntermitNumber(CodeRuleInfo codeRuleInfo, String seqSegmentEntryID, String sortItemValue, String serialNumber) {
        QFilter[] qfArr = new QFilter[]{new QFilter("codeRuleID", "=", (Object)codeRuleInfo.getId()), new QFilter("seqSegmentEntryID", "=", (Object)seqSegmentEntryID), new QFilter("sortitemvalue", "=", (Object)sortItemValue), new QFilter("serial", "=", (Object)Long.valueOf(serialNumber))};
        return QueryServiceHelper.exists((String)"bos_coderule_intermitno", (QFilter[])qfArr);
    }

    protected CodeRuleNumberDTO getSerialNumber(CodeRuleInfo codeRuleInfo, DynamicObject dataInfo, String number) {
        return CodeRuleSerialNumUtil.getSerialNumberWithoutSplitSign(codeRuleInfo, dataInfo, number);
    }

    public boolean isExist(String entityId, DynamicObject dataInfo, String orgID) {
        CodeRuleInfo codeRuleInfo = this.getCodeRuleByEntityID(entityId, dataInfo, orgID);
        return codeRuleInfo != null;
    }

    public boolean isAddView(String entityId, DynamicObject dataInfo, String orgID) {
        CodeRuleInfo codeRuleInfo = this.getCodeRuleByEntityID(entityId, dataInfo, orgID);
        if (codeRuleInfo == null) {
            return false;
        }
        return codeRuleInfo.getIsAddView();
    }

    public boolean isModifiable(String entityId, DynamicObject dataInfo, String orgID) {
        CodeRuleInfo codeRuleInfo = this.getCodeRuleByEntityID(entityId, dataInfo, orgID);
        if (codeRuleInfo == null) {
            return true;
        }
        return codeRuleInfo.getIsModifiable();
    }

    public boolean isUseIntermitNumber(String entityId, DynamicObject dataInfo, String orgID) {
        CodeRuleInfo codeRuleInfo = this.getCodeRuleByEntityID(entityId, dataInfo, orgID);
        if (codeRuleInfo == null) {
            return false;
        }
        return codeRuleInfo.getIsNonBreak();
    }

    public CodeRuleInfo getCodeRule(String entityId, DynamicObject dataInfo, String orgID) {
        CodeRuleInfo codeRuleInfo = this.getCodeRuleByEntityID(entityId, dataInfo, orgID);
        return codeRuleInfo;
    }

    public List<CodeRuleInfo> getAllCodeRuleByEntity(String entityID) {
        List<CodeRuleInfo> codeRuleList = CodeRuleCache.getAllCodeRuleByEntity(entityID);
        return codeRuleList;
    }

    public String getSortItem(CodeRuleInfo codeRuleInfo, DynamicObject dataInfo) {
        StringBuilder number = new StringBuilder();
        StringBuilder sortItem = new StringBuilder();
        boolean isFirst = true;
        String entryValue = "";
        for (CodeRuleEntryInfo codeRuleEntry : codeRuleInfo.getRuleEntry()) {
            entryValue = "";
            boolean isVisable = codeRuleEntry.getVisable();
            if (isFirst) {
                isFirst = false;
            } else if (StringUtils.isNotBlank((CharSequence)codeRuleEntry.getSplitSign()) && isVisable) {
                number.append(codeRuleEntry.getSplitSign());
            }
            CodeRuleEntryTypeEnum enums = CodeRuleEntryTypeEnum.getEnums(codeRuleEntry.getAttributeType());
            switch (enums) {
                case TYPE_FIX_TEXT: {
                    entryValue = codeRuleEntry.getFormat();
                    break;
                }
                case TYPE_SEQ: {
                    String serialNumber = "0";
                    entryValue = CodeRuleSerialNumUtil.addChar(codeRuleEntry, serialNumber, codeRuleInfo.getName(), codeRuleInfo.isFillWithZero(), codeRuleInfo.isAutoIncrLength());
                    break;
                }
                case TYPE_RANDOM_NUMBER: {
                    entryValue = CodeRuleSerialNumUtil.getRandomNumber(8);
                    break;
                }
                case TYPE_SYSTEM_TIME_FIELD: {
                    entryValue = CodeRuleSerialNumUtil.getSystemDateEntry(codeRuleEntry);
                    break;
                }
                case TYPE_DATE_FIELD: {
                    entryValue = CodeRuleSerialNumUtil.getDateEntry(codeRuleEntry, dataInfo);
                    break;
                }
                case TYPE_ITEM_FIELD: {
                    entryValue = CodeRuleSerialNumUtil.getItemEntry(codeRuleEntry, dataInfo);
                    break;
                }
                case CHECK_CODE: {
                    if (CommonUtil.validateNumLen(number.toString())) {
                        entryValue = String.valueOf(CommonUtil.getCheckNumber(number.toString()));
                        break;
                    }
                    return ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u5bf9\uff0c\u4e0d\u80fd\u751f\u6210\u6821\u9a8c\u7801", (String)"CodeRuleServiceImp_11", (String)BOS_CODERULE, (Object[])new Object[0]);
                }
            }
            entryValue = CodeRuleSerialNumUtil.formatString(codeRuleEntry, entryValue);
            if (StringUtils.isNotBlank((CharSequence)entryValue) && isVisable) {
                number.append(entryValue);
            }
            if (!codeRuleEntry.getIsSortItem().booleanValue()) continue;
            sortItem.append(entryValue);
            sortItem.append("_split_");
        }
        String sortValueItem = sortItem.toString();
        if (sortValueItem.endsWith("_split_")) {
            sortValueItem = sortValueItem.substring(0, sortValueItem.lastIndexOf("_split_"));
        }
        return sortValueItem;
    }

    public List<CoderuleFile> exportCodeRuleByEntityID(List<String> entityIDList) {
        if (CollectionUtils.isEmpty(entityIDList)) {
            return new ArrayList<CoderuleFile>(1);
        }
        StringBuilder codeRuleSqlBuild = new StringBuilder();
        codeRuleSqlBuild.append("select ").append("FID, FNUMBER, FBIZOBJECTID, FSPLITSIGN, FCTRLMODE, FAPPMODE, FEXAMPLE, FEXAMPLELENGTH, FENABLE, FSTATUS, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME, FMASTERID, FISUPDATERECOVER, FISNONBREAK, FISCHECKCODE, FISAPPCONDITION, FISAPPORG, FISLOG, FISSERIALNUMBER, FISUNIQUE, FISMODIFIABLE, FISADDVIEW, FFILTERCONDITION, FCONDITIONDESC, FISFAST, FISCHECKNUMBER ,FISFILLWITHZERO, FISAUTOINCRLENGTH ").append("from t_cr_coderule ").append("where fenable = '1' ").append("and fbizobjectid in(");
        for (String entityId : entityIDList) {
            codeRuleSqlBuild.append('\'').append(entityId).append('\'').append(',');
        }
        codeRuleSqlBuild.deleteCharAt(codeRuleSqlBuild.length() - 1);
        codeRuleSqlBuild.append(')');
        HashMap<String, CodeRuleSqlExportDTO> codeRuleSqlsMap = new HashMap<String, CodeRuleSqlExportDTO>(entityIDList.size());
        DB.query((DBRoute)DBRoute.basedata, (String)codeRuleSqlBuild.toString(), rs -> {
            try {
                while (rs.next()) {
                    ArrayList<String> codeRuleSqls = new ArrayList<String>();
                    String codeRuleId = rs.getString("fid");
                    String entityId = rs.getString("fbizobjectid");
                    this.appendSqlByEntity(codeRuleSqls, rs, "t_cr_coderule");
                    codeRuleSqlsMap.put(codeRuleId, new CodeRuleSqlExportDTO(codeRuleSqls, codeRuleId, entityId));
                }
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(EXCEPTION_MESSAGE_FORMAT, e.getMessage())});
            }
            return null;
        });
        return this.buildCoderuleFiles(codeRuleSqlsMap);
    }

    @SdkInternal
    protected CoderuleFile exportCodeRuleSql(String entityId, final String codeRuleId, final List<String> codeRuleList) {
        CoderuleFile coderuleFile = new CoderuleFile();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String curDateFormat = sdf.format(new Date());
        String randomWord = kd.bos.util.StringUtils.randomWord((int)4);
        coderuleFile.setFileName(entityId + "_" + randomWord + "_" + curDateFormat);
        Object[] params = new SqlParameter[1];
        String codeRuleLSql = "select FPKID, FID, FLOCALEID, FNAME from t_cr_coderule_l where fid = ?";
        params = new SqlParameter[]{new SqlParameter(":fbizobjectid", 12, (Object)codeRuleId)};
        DB.query((DBRoute)DBRoute.basedata, (String)codeRuleLSql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) {
                try {
                    int num = 0;
                    while (rs.next()) {
                        if (num == 0 && StringUtils.isNotBlank((CharSequence)rs.getString("FID"))) {
                            String codeRuleLDelStr = "DELETE from t_cr_coderule_l where fid = '" + codeRuleId + "';";
                            codeRuleList.add(codeRuleLDelStr);
                            ++num;
                        }
                        CodeRuleServiceImp.this.appendSqlByEntity(codeRuleList, rs, "t_cr_coderule_l");
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(CodeRuleServiceImp.EXCEPTION_MESSAGE_FORMAT, e.getMessage())});
                }
                return null;
            }
        });
        String codeRuleEntrySql = "select FENTRYID, FID, FSEQ, FATTRIBUTETYPE, FATTUSINGMODE, FVALUEATRIBUTE, FFORMAT, FSETTINGVALUE, FLENGTH, FINITIAL, FSTEP, FADDCHAR, FISSPLITSIGN, FADDSTYLE, FCUTSTYLE, FISSORTITEM, FSPLITSIGN, FISVISABLE from t_cr_coderuleentry where fid = ? ";
        params = new SqlParameter[]{new SqlParameter(":fid", 12, (Object)codeRuleId)};
        DB.query((DBRoute)DBRoute.basedata, (String)codeRuleEntrySql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) {
                try {
                    int num = 0;
                    while (rs.next()) {
                        if (num == 0 && StringUtils.isNotBlank((CharSequence)rs.getString("FID"))) {
                            String codeRuleLDelStr = "DELETE from t_cr_coderuleentry where fid = '" + codeRuleId + "';";
                            codeRuleList.add(codeRuleLDelStr);
                            ++num;
                        }
                        CodeRuleServiceImp.this.appendSqlByEntity(codeRuleList, rs, "t_cr_coderuleentry");
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(CodeRuleServiceImp.EXCEPTION_MESSAGE_FORMAT, e.getMessage())});
                }
                return null;
            }
        });
        String appConditionSql = "select FENTRYID, FID, FSEQ, FPROPERTY, FPROPERTYVALUE from t_cr_appcondition where fid = ?";
        params = new SqlParameter[]{new SqlParameter(":fid", 12, (Object)codeRuleId)};
        DB.query((DBRoute)DBRoute.basedata, (String)appConditionSql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) {
                try {
                    int num = 0;
                    while (rs.next()) {
                        if (num == 0 && StringUtils.isNotBlank((CharSequence)rs.getString("FID"))) {
                            String codeRuleLDelStr = "DELETE from t_cr_appcondition where fid = '" + codeRuleId + "';";
                            codeRuleList.add(codeRuleLDelStr);
                            ++num;
                        }
                        CodeRuleServiceImp.this.appendSqlByEntity(codeRuleList, rs, "t_cr_appcondition");
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(CodeRuleServiceImp.EXCEPTION_MESSAGE_FORMAT, e.getMessage())});
                }
                return null;
            }
        });
        String appCondProSql = "select FID,FBIZOBJECTID,FNUMBER from t_cr_appcondpro WHERE fid in(select FPROPERTY from t_cr_appcondition where fid = ?)";
        params = new SqlParameter[]{new SqlParameter(":fid", 12, (Object)codeRuleId)};
        DB.query((DBRoute)DBRoute.basedata, (String)appCondProSql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) {
                try {
                    int num = 0;
                    while (rs.next()) {
                        if (num == 0 && StringUtils.isNotBlank((CharSequence)rs.getString("FID"))) {
                            String codeRuleLDelStr = "DELETE from t_cr_appcondpro WHERE fid ='" + rs.getString("FID") + "';";
                            codeRuleList.add(codeRuleLDelStr);
                            ++num;
                        }
                        CodeRuleServiceImp.this.appendSqlByEntity(codeRuleList, rs, "t_cr_appcondpro");
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(CodeRuleServiceImp.EXCEPTION_MESSAGE_FORMAT, e.getMessage())});
                }
                return null;
            }
        });
        String appCondproLSql = "select FPKID, FID, FLOCALEID, FNAME, FDESCRIPTION from t_cr_appcondpro_l WHERE fid in(select FPROPERTY from t_cr_appcondition where fid = ?)";
        params = new SqlParameter[]{new SqlParameter(":fid", 12, (Object)codeRuleId)};
        DB.query((DBRoute)DBRoute.basedata, (String)appCondproLSql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) {
                try {
                    int num = 0;
                    while (rs.next()) {
                        if (num == 0 && StringUtils.isNotBlank((CharSequence)rs.getString("FID"))) {
                            String codeRuleLDelStr = "DELETE from t_cr_appcondpro_l WHERE fid = '" + rs.getString("FID") + "';";
                            codeRuleList.add(codeRuleLDelStr);
                            ++num;
                        }
                        CodeRuleServiceImp.this.appendSqlByEntity(codeRuleList, rs, "t_cr_appcondpro_l");
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(CodeRuleServiceImp.EXCEPTION_MESSAGE_FORMAT, e.getMessage())});
                }
                return null;
            }
        });
        String appCondProValueSql = "select FID, FAPPCONDPROID, FVALUE from t_cr_appcondprovalue WHERE fid in(select FPropertyValue from t_cr_appcondition where fid = ?)";
        params = new SqlParameter[]{new SqlParameter(":fid", 12, (Object)codeRuleId)};
        DB.query((DBRoute)DBRoute.basedata, (String)appCondProValueSql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) {
                try {
                    int num = 0;
                    while (rs.next()) {
                        if (num == 0 && StringUtils.isNotBlank((CharSequence)rs.getString("FID"))) {
                            String codeRuleLDelStr = "DELETE from t_cr_appcondprovalue WHERE fid ='" + rs.getString("FID") + "';";
                            codeRuleList.add(codeRuleLDelStr);
                            ++num;
                        }
                        CodeRuleServiceImp.this.appendSqlByEntity(codeRuleList, rs, "t_cr_appcondprovalue");
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(CodeRuleServiceImp.EXCEPTION_MESSAGE_FORMAT, e.getMessage())});
                }
                return null;
            }
        });
        String appCondProValueLSql = "select FPKID, FID, FLOCALEID, FNAME, FDESCRIPTION from t_cr_appcondprovalue_l WHERE fid in(select FPropertyValue from t_cr_appcondition where fid = ?)";
        params = new SqlParameter[]{new SqlParameter(":fid", 12, (Object)codeRuleId)};
        DB.query((DBRoute)DBRoute.basedata, (String)appCondProValueLSql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) {
                try {
                    int num = 0;
                    while (rs.next()) {
                        if (num == 0 && StringUtils.isNotBlank((CharSequence)rs.getString("FID"))) {
                            String codeRuleLDelStr = "DELETE from t_cr_appcondprovalue_l WHERE fid ='" + rs.getString("FID") + "';";
                            codeRuleList.add(codeRuleLDelStr);
                            ++num;
                        }
                        CodeRuleServiceImp.this.appendSqlByEntity(codeRuleList, rs, "t_cr_appcondprovalue_l");
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(CodeRuleServiceImp.EXCEPTION_MESSAGE_FORMAT, e.getMessage())});
                }
                return null;
            }
        });
        coderuleFile.setFileContent(codeRuleList);
        return coderuleFile;
    }

    protected List<String> appendSqlByEntity(List<String> entityStrs, ResultSet rs, String tableStr) throws SQLException {
        StringBuilder entityInsStr = new StringBuilder();
        String entityDelStr = "";
        StringBuilder entityLInsStr = new StringBuilder();
        if ("t_cr_coderule".equals(tableStr)) {
            String codeRuleID = rs.getString("fid");
            entityDelStr = " DELETE from t_cr_coderule where fid = '" + codeRuleID + "';";
            entityStrs.add(entityDelStr);
            entityInsStr.append(" INSERT INTO t_cr_coderule(FID, FNUMBER, FBIZOBJECTID, FSPLITSIGN, FCTRLMODE, FAPPMODE, FEXAMPLE, FEXAMPLELENGTH, FENABLE, FSTATUS, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME, FMASTERID, FISUPDATERECOVER, FISNONBREAK, FISCHECKCODE, FISAPPCONDITION, FISAPPORG, FISLOG, FISSERIALNUMBER, FISUNIQUE, FISMODIFIABLE, FISADDVIEW, FFILTERCONDITION, FCONDITIONDESC, FISFAST, FISCHECKNUMBER, FISFILLWITHZERO, FISAUTOINCRLENGTH) VALUES ( '");
            entityInsStr.append(this.emptyStrToSpaceStr(codeRuleID)).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FNUMBER"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FBIZOBJECTID"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FSPLITSIGN"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FCTRLMODE"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FAPPMODE"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FEXAMPLE"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FEXAMPLELENGTH"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FENABLE"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FSTATUS"))).append("', ");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FCREATORID"))).append(',');
            String SQL_FIELD_FCREATETIME = "FCREATETIME";
            if (StringUtils.isNotBlank((CharSequence)rs.getString(SQL_FIELD_FCREATETIME))) {
                entityInsStr.append("{ts'").append(rs.getString(SQL_FIELD_FCREATETIME).split("\\.")[0]).append("'},");
            } else {
                entityInsStr.append("null,");
            }
            entityInsStr.append(rs.getString("FMODIFIERID")).append(',');
            String SQL_FIELD_FMODIFYTIME = "FMODIFYTIME";
            if (StringUtils.isNotBlank((CharSequence)rs.getString(SQL_FIELD_FMODIFYTIME))) {
                entityInsStr.append("{ts'").append(rs.getString(SQL_FIELD_FMODIFYTIME).split("\\.")[0]).append("'},'");
            } else {
                entityInsStr.append("null,'");
            }
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FMASTERID"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FISUPDATERECOVER"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FISNONBREAK"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FISCHECKCODE"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FISAPPCONDITION"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FISAPPORG"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FISLOG"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FISSERIALNUMBER"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FISUNIQUE"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FISMODIFIABLE"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FISADDVIEW"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FFILTERCONDITION"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FCONDITIONDESC"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FISFAST"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FISCHECKNUMBER"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FISFILLWITHZERO"))).append("','");
            entityInsStr.append(this.emptyStrToSpaceStr(rs.getString("FISAUTOINCRLENGTH"))).append("');");
            entityStrs.add(entityInsStr.toString());
        } else {
            String SQL_FIELD_FPKID = "FPKID";
            String SQL_FIELD_FLOCALEID = "FLOCALEID";
            String SQL_FIELD_FNAME = "FNAME";
            if ("t_cr_coderule_l".equals(tableStr)) {
                String codeRuleID = rs.getString("fid");
                entityLInsStr.append("INSERT INTO t_cr_coderule_l(FPKID, FID, FLOCALEID, FNAME) VALUES ('").append(this.emptyStrToSpaceStr(rs.getString(SQL_FIELD_FPKID))).append("','").append(this.emptyStrToSpaceStr(codeRuleID)).append("','").append(this.emptyStrToSpaceStr(rs.getString(SQL_FIELD_FLOCALEID))).append("','").append(this.emptyStrToSpaceStr(rs.getString(SQL_FIELD_FNAME))).append("');");
                entityStrs.add(entityLInsStr.toString());
            } else if ("t_cr_coderuleentry".equals(tableStr)) {
                String codeRuleID = rs.getString("fid");
                entityLInsStr.append("INSERT INTO t_cr_coderuleentry(FENTRYID, FID, FSEQ, FATTRIBUTETYPE, FATTUSINGMODE, FVALUEATRIBUTE, FFORMAT, FSETTINGVALUE, FLENGTH, FINITIAL, FSTEP, FADDCHAR, FISSPLITSIGN, FADDSTYLE, FCUTSTYLE, FISSORTITEM, FSPLITSIGN, FISVISABLE) VALUES ('").append(this.emptyStrToSpaceStr(rs.getString("FENTRYID"))).append("','").append(this.emptyStrToSpaceStr(codeRuleID)).append("',").append(this.emptyStrToSpaceStr(rs.getString("FSEQ"))).append(",'").append(this.emptyStrToSpaceStr(rs.getString("FATTRIBUTETYPE"))).append("','").append(this.emptyStrToSpaceStr(rs.getString("FATTUSINGMODE"))).append("','").append(this.emptyStrToSpaceStr(rs.getString("FVALUEATRIBUTE"))).append("','").append(this.emptyStrToSpaceStr(rs.getString("FFORMAT"))).append("','").append(this.emptyStrToSpaceStr(rs.getString("FSETTINGVALUE"))).append("',").append(this.emptyStrToSpaceStr(rs.getString("FLENGTH"))).append(',').append(this.emptyStrToSpaceStr(rs.getString("FINITIAL"))).append(',').append(this.emptyStrToSpaceStr(rs.getString("FSTEP"))).append(",'").append(this.emptyStrToSpaceStr(rs.getString("FADDCHAR"))).append("','").append(this.emptyStrToSpaceStr(rs.getString("FISSPLITSIGN"))).append("','").append(this.emptyStrToSpaceStr(rs.getString("FADDSTYLE"))).append("','").append(this.emptyStrToSpaceStr(rs.getString("FCUTSTYLE"))).append("','").append(this.emptyStrToSpaceStr(rs.getString("FISSORTITEM"))).append("','").append(this.emptyStrToSpaceStr(rs.getString("FSPLITSIGN"))).append("','").append(this.emptyStrToSpaceStr(rs.getString("FISVISABLE"))).append("');");
                entityStrs.add(entityLInsStr.toString());
            } else if ("t_cr_appcondition".equals(tableStr)) {
                String codeRuleID = rs.getString("fid");
                entityLInsStr.append("INSERT INTO t_cr_appcondition(FENTRYID, FID, FSEQ, FPROPERTY, FPROPERTYVALUE) VALUES ('").append(this.emptyStrToSpaceStr(rs.getString("FENTRYID"))).append("','").append(this.emptyStrToSpaceStr(codeRuleID)).append("',").append(this.emptyStrToSpaceStr(rs.getString("FSEQ"))).append(",'").append(this.emptyStrToSpaceStr(rs.getString("FPROPERTY"))).append("','").append(this.emptyStrToSpaceStr(rs.getString("FPROPERTYVALUE"))).append("');");
                entityStrs.add(entityLInsStr.toString());
            } else if ("t_cr_appcondpro".equals(tableStr)) {
                entityLInsStr.append("INSERT INTO t_cr_appcondpro(FID,FBIZOBJECTID,FNUMBER) VALUES ('").append(this.emptyStrToSpaceStr(rs.getString("FID"))).append("','").append(this.emptyStrToSpaceStr(rs.getString("FBIZOBJECTID"))).append("','").append(this.emptyStrToSpaceStr(rs.getString("FNUMBER"))).append("');");
                entityStrs.add(entityLInsStr.toString());
            } else if ("t_cr_appcondpro_l".equals(tableStr)) {
                entityLInsStr.append("INSERT INTO t_cr_appcondpro_l(FPKID, FID, FLOCALEID, FNAME, FDESCRIPTION) VALUES ('").append(this.emptyStrToSpaceStr(rs.getString(SQL_FIELD_FPKID))).append("','").append(this.emptyStrToSpaceStr(rs.getString("FID"))).append("','").append(this.emptyStrToSpaceStr(rs.getString(SQL_FIELD_FLOCALEID))).append("','").append(this.emptyStrToSpaceStr(rs.getString(SQL_FIELD_FNAME))).append("','").append(this.emptyStrToSpaceStr(rs.getString("FDESCRIPTION"))).append("');");
                entityStrs.add(entityLInsStr.toString());
            } else if ("t_cr_appcondprovalue".equals(tableStr)) {
                entityLInsStr.append("INSERT INTO t_cr_appcondprovalue(FID, FAPPCONDPROID, FVALUE) VALUES ('").append(this.emptyStrToSpaceStr(rs.getString("FID"))).append("','").append(this.emptyStrToSpaceStr(rs.getString("FAPPCONDPROID"))).append("','").append(this.emptyStrToSpaceStr(rs.getString("FVALUE"))).append("');");
                entityStrs.add(entityLInsStr.toString());
            } else if ("t_cr_appcondprovalue_l".equals(tableStr)) {
                entityLInsStr.append("INSERT INTO t_cr_appcondprovalue_l(FPKID, FID, FLOCALEID, FNAME, FDESCRIPTION) VALUES ('").append(this.emptyStrToSpaceStr(rs.getString(SQL_FIELD_FPKID))).append("','").append(this.emptyStrToSpaceStr(rs.getString("FID"))).append("','").append(this.emptyStrToSpaceStr(rs.getString(SQL_FIELD_FLOCALEID))).append("','").append(this.emptyStrToSpaceStr(rs.getString(SQL_FIELD_FNAME))).append("','").append(this.emptyStrToSpaceStr(rs.getString("FDESCRIPTION"))).append("');");
                entityStrs.add(entityLInsStr.toString());
            }
        }
        return entityStrs;
    }

    private String emptyStrToSpaceStr(String str) {
        if (str == null || str.equals("")) {
            str = " ";
        }
        return str;
    }

    private List<String> getEntityIDByAppId(List<String> appIDList) {
        HashSet<String> entityIDSet = new HashSet<String>();
        String[] modeltypes = new String[]{"BillFormModel", "BaseFormModel"};
        for (String appID : appIDList) {
            DynamicObject[] entitys = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("bizappid", "=", (Object)appID), new QFilter("modeltype", "in", (Object)modeltypes)});
            if (null == entitys || entitys.length <= 0) continue;
            for (DynamicObject entity : entitys) {
                String number = entity.getString("number");
                if (!StringUtils.isNotBlank((CharSequence)number)) continue;
                entityIDSet.add(entity.getString("number"));
            }
        }
        return new ArrayList<String>(entityIDSet);
    }

    @SdkInternal
    @Deprecated
    public List<CodeRuleInfo> getAllCodeRuleByAppId(String appID) {
        ArrayList<String> appIDList = new ArrayList<String>();
        appIDList.add(appID);
        return this.getAllCodeRuleByAppId(appIDList);
    }

    public List<CodeRuleInfo> getAllCodeRuleByAppId(List<String> appIds) {
        List<String> entityIDList = this.getEntityIDByAppId(appIds);
        ArrayList<CodeRuleInfo> codeRuleList = new ArrayList<CodeRuleInfo>();
        for (String entityID : entityIDList) {
            List<CodeRuleInfo> codeRules = this.getAllCodeRuleByEntity(entityID);
            codeRuleList.addAll(codeRules);
        }
        return codeRuleList;
    }

    public List<CoderuleFile> exportCodeRuleByAppID(List<String> appIDList) {
        List<String> entityIDList = this.getEntityIDByAppId(appIDList);
        return this.exportCodeRuleByEntityID(entityIDList);
    }

    public List<CoderuleFile> exportCodeRuleByCoderuleID(List<String> coderuleIDList) {
        if (CollectionUtils.isEmpty(coderuleIDList)) {
            return new ArrayList<CoderuleFile>(1);
        }
        StringBuilder codeRuleSqlBuild = new StringBuilder();
        codeRuleSqlBuild.append("select ").append("FID, FNUMBER, FBIZOBJECTID, FSPLITSIGN, FCTRLMODE, FAPPMODE, FEXAMPLE, FEXAMPLELENGTH, FENABLE, FSTATUS, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME, FMASTERID, FISUPDATERECOVER, FISNONBREAK, FISCHECKCODE, FISAPPCONDITION, FISAPPORG, FISLOG, FISSERIALNUMBER, FISUNIQUE, FISMODIFIABLE, FISADDVIEW, FFILTERCONDITION, FCONDITIONDESC, FISFAST, FISCHECKNUMBER ,FISFILLWITHZERO, FISAUTOINCRLENGTH ").append("from t_cr_coderule ").append("where fenable = '1' ").append("and fid in(");
        for (String codeRuleId : coderuleIDList) {
            codeRuleSqlBuild.append('\'').append(codeRuleId).append('\'').append(',');
        }
        codeRuleSqlBuild.deleteCharAt(codeRuleSqlBuild.length() - 1);
        codeRuleSqlBuild.append(')');
        HashMap<String, CodeRuleSqlExportDTO> codeRuleSqlsMap = new HashMap<String, CodeRuleSqlExportDTO>(coderuleIDList.size());
        DB.query((DBRoute)DBRoute.basedata, (String)codeRuleSqlBuild.toString(), rs -> {
            try {
                while (rs.next()) {
                    ArrayList<String> codeRuleSqls = new ArrayList<String>();
                    String codeRuleId = rs.getString("fid");
                    String entityId = rs.getString("fbizobjectid");
                    this.appendSqlByEntity(codeRuleSqls, rs, "t_cr_coderule");
                    codeRuleSqlsMap.put(codeRuleId, new CodeRuleSqlExportDTO(codeRuleSqls, codeRuleId, entityId));
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(EXCEPTION_MESSAGE_FORMAT, e.getMessage())});
            }
            return null;
        });
        return this.buildCoderuleFiles(codeRuleSqlsMap);
    }

    private List<CoderuleFile> buildCoderuleFiles(Map<String, CodeRuleSqlExportDTO> codeRuleSqlsMap) {
        ArrayList<CoderuleFile> coderuleFiles = new ArrayList<CoderuleFile>(codeRuleSqlsMap.size());
        for (Map.Entry<String, CodeRuleSqlExportDTO> entry : codeRuleSqlsMap.entrySet()) {
            CodeRuleSqlExportDTO codeRuleSqlExportDTO = entry.getValue();
            CoderuleFile coderuleFile = this.exportCodeRuleSql(codeRuleSqlExportDTO.getEntityId(), codeRuleSqlExportDTO.getCodeRuleId(), codeRuleSqlExportDTO.getCodeRuleSqls());
            coderuleFiles.add(coderuleFile);
        }
        return coderuleFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteBreakNumbers(String entityID, Map<String, Object> dataInfo, Long orgID, List<String> numbers) {
        logger.info(String.format("CodeRuleServiceImp.deleteBreakNumbers(): entityID: %s , orgID: %s , numbers: %s ", entityID, orgID, numbers));
        String seqSegmentEntryID = "";
        String sortItemValue = "";
        BillEntityType entityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityID);
        DynamicObject dataObj = (DynamicObject)entityType.createInstance();
        for (Map.Entry<String, Object> entry : dataInfo.entrySet()) {
            dataObj.set(entry.getKey(), entry.getValue());
        }
        CodeRuleInfo codeRuleInfo = this.getCodeRule(entityID, dataObj, orgID.toString());
        if (codeRuleInfo == null) {
            return false;
        }
        sortItemValue = this.getSortItem(codeRuleInfo, dataObj);
        String key = (codeRuleInfo.getId() + seqSegmentEntryID + sortItemValue).intern();
        boolean result = false;
        List<Object> ids = new ArrayList();
        ArrayList<Object> intermitIds = new ArrayList<Object>();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_coderule_intermitno");
        String dLockKey = key;
        if (dLockKey.endsWith("/")) {
            dLockKey = dLockKey.replace("/", "").intern();
        }
        try (DLock dl = DLock.create((String)("bas/coderule/" + dLockKey));){
            dl.lock();
            boolean isRemoveCache = false;
            try {
                String breakNumberQueue = CodeRuleCache.getBreakNumberQueue(codeRuleInfo, seqSegmentEntryID, sortItemValue);
                if (StringUtils.isBlank((CharSequence)breakNumberQueue) || "DATA_LOADED".equals(breakNumberQueue)) {
                    isRemoveCache = true;
                }
                for (String number : numbers) {
                    CodeRuleNumberDTO codeRuleNumberDTO = this.getSerialNumber(codeRuleInfo, dataObj, number);
                    if ("-1".equals(codeRuleNumberDTO.getSerialNumber())) {
                        boolean bl = true;
                        return bl;
                    }
                    ids = this.queryIntermitNumber(codeRuleInfo, seqSegmentEntryID, sortItemValue, codeRuleNumberDTO.getSerialNumber());
                    if (ids != null && !ids.isEmpty()) {
                        intermitIds.addAll(ids);
                    }
                    breakNumberQueue = this.buildBreakNumberQueue(isRemoveCache, breakNumberQueue, codeRuleNumberDTO);
                }
                try (TXHandle h = TX.requiresNew();){
                    try {
                        if (CollectionUtils.isNotEmpty(intermitIds)) {
                            DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])intermitIds.toArray(new Object[0]));
                            result = true;
                        }
                        CodeRuleCache.updateeBreakNumberCache(key, breakNumberQueue);
                    }
                    catch (Exception e) {
                        h.markRollback();
                    }
                }
            }
            finally {
                dl.unlock();
            }
        }
        return result;
    }

    @SdkInternal
    protected String buildBreakNumberQueue(boolean isRemoveCache, String breakNumberQueue, CodeRuleNumberDTO codeRuleNumberDTO) {
        if (!isRemoveCache) {
            long breakNumber = Long.parseLong(codeRuleNumberDTO.getSerialNumber());
            if (breakNumberQueue.equals("" + breakNumber)) {
                breakNumberQueue = "";
            } else if (breakNumberQueue.startsWith(breakNumber + ",")) {
                breakNumberQueue = breakNumberQueue.substring((breakNumber + ",").length());
            } else if (breakNumberQueue.endsWith("," + breakNumber)) {
                breakNumberQueue = breakNumberQueue.substring(0, breakNumberQueue.length() - (breakNumber + ",").length());
            } else if (breakNumberQueue.indexOf("," + breakNumber + ",") > 0) {
                breakNumberQueue = breakNumberQueue.replace("," + breakNumber + ",", ",");
            }
        }
        return breakNumberQueue;
    }

    protected List<String> queryIntermitNumber(CodeRuleInfo codeRuleInfo, String seqSegmentEntryID, String sortItemValue, String serialNumber) {
        DynamicObject[] intermits;
        ArrayList<String> ids = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)sortItemValue)) {
            sortItemValue = "_split_";
        }
        if (null != (intermits = BusinessDataServiceHelper.load((String)"bos_coderule_intermitno", (String)"id", (QFilter[])new QFilter[]{new QFilter("codeRuleID", "=", (Object)codeRuleInfo.getId()), new QFilter("sortitemvalue", "=", (Object)sortItemValue), new QFilter("serial", "=", (Object)Long.valueOf(serialNumber))})) && intermits.length > 0) {
            for (DynamicObject intermit : intermits) {
                String id = intermit.getString("id");
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                ids.add(id);
            }
        }
        return ids;
    }

    public boolean checkNumber(String entityID, DynamicObject dataInfo, Long orgID, String number) {
        boolean isMatch = false;
        CodeRuleInfo codeRuleInfo = this.getCodeRuleByEntityID(entityID, dataInfo, orgID == null ? null : orgID.toString());
        if (codeRuleInfo == null) {
            return isMatch;
        }
        CodeRuleNumberDTO codeRuleNumberDTO = this.getSerialNumber(codeRuleInfo, dataInfo, number);
        if ("-1".equals(codeRuleNumberDTO.getSerialNumber())) {
            return isMatch;
        }
        isMatch = true;
        return isMatch;
    }

    public boolean checkNumber(DynamicObject dataInfo, String number, CodeRuleInfo codeRuleInfo) {
        boolean isMatch = false;
        if (codeRuleInfo == null) {
            return isMatch;
        }
        if (StringUtils.isBlank((CharSequence)number)) {
            return isMatch;
        }
        CodeRuleNumberDTO codeRuleNumberDTO = this.getSerialNumber(codeRuleInfo, dataInfo, number);
        if ("-1".equals(codeRuleNumberDTO.getSerialNumber())) {
            return isMatch;
        }
        isMatch = true;
        return isMatch;
    }

    @SdkInternal
    public Map<DynamicObject, CodeRuleGroup> collectionUpdateMaximum(List<DynamicObject> updateDynamicObjs, final String billNoFldKey) {
        if (CollectionUtils.isEmpty(updateDynamicObjs)) {
            return null;
        }
        final HashMap<DynamicObject, CodeRuleGroup> codeRuleGroupMap = new HashMap<DynamicObject, CodeRuleGroup>(updateDynamicObjs.size());
        String entityName = updateDynamicObjs.get(0).getDataEntityType().getName();
        List<GroupHandlerDataEntity> dataEntitys = GroupHandlerUtil.convertToGroupHandlerDataEntitys(updateDynamicObjs);
        new GroupHandler(this, entityName, dataEntitys){

            @Override
            protected void groupProcess(CodeRuleInfo codeRuleInfo, String sortItem, List<GroupHandlerDataEntity> dataEntities) {
                List<DynamicObject> dynamicObjects = GroupHandlerUtil.convertToDynamicObjects(dataEntities);
                CodeRuleServiceImp.this.recordMaximum(dynamicObjects, codeRuleInfo, sortItem, billNoFldKey, codeRuleGroupMap);
            }
        }.process();
        return codeRuleGroupMap;
    }

    private void recordMaximum(List<DynamicObject> dynamicObjects, CodeRuleInfo codeRuleInfo, String sortItem, String billNoFldKey, Map<DynamicObject, CodeRuleGroup> codeRuleGroupMap) {
        CodeRuleEntryInfo codeRuleEntryInfo = this.getCodeRuleEntityWithSerialNum(codeRuleInfo);
        if (codeRuleEntryInfo == null) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            CodeRuleNumberDTO codeRuleNumberDTO = CodeRuleSerialNumUtil.getSerialNumberWithoutSplitSign(codeRuleInfo, dynamicObject, dynamicObject.getString(billNoFldKey));
            if ("-1".equals(codeRuleNumberDTO.getSerialNumber())) continue;
            String serialNumber = codeRuleNumberDTO.getSerialNumber();
            codeRuleGroupMap.put(dynamicObject, new CodeRuleGroup(codeRuleInfo, sortItem, Integer.parseInt(serialNumber)));
        }
    }

    @SdkInternal
    public void updateMaximum(List<CodeRuleGroup> codeRuleGroupList) {
        if (CollectionUtils.isEmpty(codeRuleGroupList)) {
            return;
        }
        HashMap<String, CodeRuleGroup> codeRuleGroupMap = new HashMap<String, CodeRuleGroup>();
        for (CodeRuleGroup codeRuleGroup : codeRuleGroupList) {
            String sorItem = codeRuleGroup.getCodeRuleInfo().getId() + codeRuleGroup.getSortItem();
            CodeRuleGroup ruleGroup = (CodeRuleGroup)codeRuleGroupMap.get(sorItem);
            if (ruleGroup == null) {
                codeRuleGroupMap.put(sorItem, codeRuleGroup);
                continue;
            }
            if (codeRuleGroup.getMaximum() <= ruleGroup.getMaximum()) continue;
            codeRuleGroupMap.put(sorItem, codeRuleGroup);
        }
        for (CodeRuleGroup value : codeRuleGroupMap.values()) {
            this.updateNumber(value.getCodeRuleInfo(), value.getSortItem(), value.getMaximum());
        }
    }

    public void updateMaxserialNumbers(List<DynamicObject> unGenerateDynamicObjs, final String billNoFldKey) {
        if (CollectionUtils.isEmpty(unGenerateDynamicObjs)) {
            return;
        }
        String billnoStrs = unGenerateDynamicObjs.stream().map(dynamicObject -> dynamicObject.get(billNoFldKey)).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(","));
        logger.info("[CodeRuleService]\u8fdb\u5165\u4fee\u6539\u6700\u5927\u53f7\u573a\u666f,\u7f16\u53f7:[" + billnoStrs + "]");
        String entityName = unGenerateDynamicObjs.get(0).getDataEntityType().getName();
        List<GroupHandlerDataEntity> dataEntitys = GroupHandlerUtil.convertToGroupHandlerDataEntitys(unGenerateDynamicObjs);
        new GroupHandler(this, entityName, dataEntitys){

            @Override
            protected void groupProcess(final CodeRuleInfo codeRuleInfo, final String sortItem, List<GroupHandlerDataEntity> dataEntities) {
                final List<DynamicObject> dynamicObjects = GroupHandlerUtil.convertToDynamicObjects(dataEntities);
                new TraceHandler(codeRuleInfo, dynamicObjects){

                    @Override
                    public void traceProcess() {
                        logger.info("[CodeRuleService]\u5206\u7ec4\u8fdb\u5165\u6700\u5927\u53f7\u4fee\u6539\u573a\u666f,\u7f16\u7801\u89c4\u5219:" + codeRuleInfo.getId() + ",\u4f9d\u636e:" + sortItem);
                        CodeRuleServiceImp.this.updateMaxserialNumbersBySortitem(dynamicObjects, codeRuleInfo, sortItem, billNoFldKey);
                    }
                }.process();
            }
        }.process();
    }

    public void updateMaxserialNumbersBySortitem(List<DynamicObject> dynamicObjects, CodeRuleInfo codeRuleInfo, String sortItem, String billNoFldKey) {
        CodeRuleEntryInfo codeRuleEntryInfo = this.getCodeRuleEntityWithSerialNum(codeRuleInfo);
        if (codeRuleEntryInfo == null) {
            return;
        }
        int maxNumber = Integer.MIN_VALUE;
        for (DynamicObject dynamicObject : dynamicObjects) {
            CodeRuleNumberDTO codeRuleNumberDTO = CodeRuleSerialNumUtil.getSerialNumberWithoutSplitSign(codeRuleInfo, dynamicObject, dynamicObject.getString(billNoFldKey));
            if ("-1".equals(codeRuleNumberDTO.getSerialNumber())) continue;
            String serialNumber = codeRuleNumberDTO.getSerialNumber();
            maxNumber = Math.max(maxNumber, Integer.parseInt(serialNumber));
        }
        if (maxNumber != Integer.MIN_VALUE) {
            this.updateNumber(codeRuleInfo, sortItem, maxNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternal
    public void updateMaxserialNumbersOnDistributeLock(CodeRuleInfo codeRuleInfo, String sortItem, int maxNumber, QFilter qFilter) {
        String codeRuleID = codeRuleInfo.getId();
        String codeRuleName = codeRuleInfo.getName();
        String seqSegmentEntryID = "";
        String dLockKey = (codeRuleID + seqSegmentEntryID + sortItem).intern();
        if (dLockKey.endsWith("/")) {
            dLockKey = dLockKey.replace("/", "").intern();
        }
        String key = (codeRuleID + seqSegmentEntryID + sortItem).intern();
        try (DLock dl = DLock.create((String)("bas/coderule/" + dLockKey));){
            try {
                dl.lock();
                this.checkAndUpdateMaxserial(codeRuleInfo, sortItem, maxNumber, qFilter, key);
            }
            finally {
                logger.info("CodeRuleServiceImp: \u7f16\u7801\u89c4\u5219: " + codeRuleName + " (" + codeRuleID + ") \u91ca\u653e\u9501\uff1a" + "bas/coderule/" + dLockKey);
                dl.unlock();
            }
        }
    }

    @SdkInternal
    public void checkAndUpdateMaxserial(final CodeRuleInfo codeRuleInfo, final String sortItem, int maxNumber, QFilter qFilter, final String cacheKey) {
        final DynamicObject[] load = BusinessDataServiceHelper.load((String)ENTITYID_CODERULE_MAXSERIAL, (String)"id, maxserial", (QFilter[])qFilter.toArray());
        if (load == null || load.length <= 0) {
            final int finalMaxNumber = maxNumber;
            new TransactionHandler(CodeRuleServiceImp.getMessageUpdateMaxserialAtImport()){

                @Override
                protected void transactionProcess() {
                    CodeRuleCache.updateMaxSerialNumber(cacheKey, String.valueOf(finalMaxNumber));
                    DynamicObject dynaObj = CodeRuleInfoBuilder.buildCodeRuleMaxSerial(codeRuleInfo.getId(), sortItem, finalMaxNumber);
                    SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)CodeRuleServiceImp.ENTITYID_CODERULE_MAXSERIAL), (Object[])new DynamicObject[]{dynaObj});
                    logger.info("[CodeRuleService]\u65b0\u589e\u7f16\u7801\u89c4\u5219\u6700\u5927\u53f7, \u503c\u4e3a:" + finalMaxNumber);
                    String newValue = String.valueOf(finalMaxNumber);
                    if (AppLogUtil.checkSortItemValue(sortItem)) {
                        AppLogUtil.insertAppLog(dynaObj, new MultiLangEnumBridge("\u5bfc\u5165\u65b0\u589e\u6700\u5927\u53f7\u8868", "CodeRuleServiceImp_13", CodeRuleServiceImp.BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u53f7\u7801:%s\u3002", "AppLogUtil_1", CodeRuleServiceImp.BOS_CODERULE), codeRuleInfo.getId(), codeRuleInfo.getName(), newValue);
                    } else {
                        AppLogUtil.insertAppLog(dynaObj, new MultiLangEnumBridge("\u5bfc\u5165\u65b0\u589e\u6700\u5927\u53f7\u8868", "CodeRuleServiceImp_13", CodeRuleServiceImp.BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u4f9d\u636e:%1$s\uff0c\u53f7\u7801:%2$s\u3002", "AppLogUtil_1", CodeRuleServiceImp.BOS_CODERULE), codeRuleInfo.getId(), codeRuleInfo.getName(), CommonUtil.convertSortItem(sortItem), newValue);
                    }
                }
            }.process();
            return;
        }
        final DynamicObject dynamicObject = load[0];
        final int oldMaxserial = dynamicObject.getInt("maxserial");
        if (maxNumber > oldMaxserial) {
            final int finalMaxNumber = maxNumber;
            new TransactionHandler(CodeRuleServiceImp.getMessageUpdateMaxserialAtImport()){

                @Override
                protected void transactionProcess() {
                    CodeRuleCache.updateMaxSerialNumber(cacheKey, String.valueOf(finalMaxNumber));
                    dynamicObject.set("maxserial", (Object)finalMaxNumber);
                    SaveServiceHelper.save((DynamicObject[])load);
                    logger.info("[CodeRuleService]\u4fee\u6539\u7f16\u7801\u89c4\u5219\u6700\u5927\u53f7, \u503c\u53d8\u66f4\u4e3a:" + finalMaxNumber);
                    String oldValue = String.valueOf(oldMaxserial);
                    String newValue = String.valueOf(finalMaxNumber);
                    if (AppLogUtil.checkSortItemValue(sortItem)) {
                        AppLogUtil.insertAppLog(dynamicObject, new MultiLangEnumBridge("\u5bfc\u5165\u6539\u53d8\u6700\u5927\u53f7\u8868", "CodeRuleMaxSerialEditPlugin_5", CodeRuleServiceImp.BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u4fee\u6539\u524d\u53f7\u7801:%3$s\uff0c\u4fee\u6539\u540e\u53f7\u7801:%4$s\u3002", "AppLogUtil_1", CodeRuleServiceImp.BOS_CODERULE), codeRuleInfo.getId(), codeRuleInfo.getName(), oldValue, newValue);
                    } else {
                        AppLogUtil.insertAppLog(dynamicObject, new MultiLangEnumBridge("\u5bfc\u5165\u6539\u53d8\u6700\u5927\u53f7\u8868", "CodeRuleMaxSerialEditPlugin_5", CodeRuleServiceImp.BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u4f9d\u636e\uff1a%3$s\uff0c\u4fee\u6539\u524d\u53f7\u7801\uff1a%4$s\uff0c\u4fee\u6539\u540e\u53f7\u7801%5$s\u3002", "AppLogUtil_1", CodeRuleServiceImp.BOS_CODERULE), codeRuleInfo.getId(), codeRuleInfo.getName(), CommonUtil.convertSortItem(sortItem), oldValue, newValue);
                    }
                }
            }.process();
        }
    }

    @SdkInternal
    protected void updateMaxserialOnFast(final CodeRuleSigner codeRuleSigner, final CodeRuleInfo codeRuleInfo, CodeRuleEntryInfo codeRuleEntryInfo, final String sortItem, int maxNumber, QFilter qFilter) {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)ENTITYID_CODERULE_MAXSERIAL, (String)"id, maxserial", (QFilter[])qFilter.toArray());
        if (load == null || load.length <= 0) {
            final int finalMaxNumber = maxNumber;
            new TransactionHandler(CodeRuleServiceImp.getMessageUpdateMaxserialAtImport()){

                @Override
                protected void transactionProcess() {
                    codeRuleSigner.reset(codeRuleInfo.getId(), sortItem, finalMaxNumber);
                    DynamicObject dynaObj = CodeRuleInfoBuilder.buildCodeRuleMaxSerial(codeRuleInfo.getId(), sortItem, 0);
                    SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)CodeRuleServiceImp.ENTITYID_CODERULE_MAXSERIAL), (Object[])new DynamicObject[]{dynaObj});
                    logger.info("[CodeRuleService]\u65b0\u7f16\u7801\u89c4\u5219\u6700\u5927\u53f7, \u503c\u4e3a:" + finalMaxNumber);
                    String newValue = String.valueOf(finalMaxNumber);
                    if (AppLogUtil.checkSortItemValue(sortItem)) {
                        AppLogUtil.insertAppLog(dynaObj, new MultiLangEnumBridge("\u5bfc\u5165\u65b0\u589e\u6700\u5927\u53f7\u8868", "CodeRuleServiceImp_13", CodeRuleServiceImp.BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u53f7\u7801:%s\u3002", "AppLogUtil_1", CodeRuleServiceImp.BOS_CODERULE), codeRuleInfo.getId(), codeRuleInfo.getName(), newValue);
                    } else {
                        AppLogUtil.insertAppLog(dynaObj, new MultiLangEnumBridge("\u5bfc\u5165\u65b0\u589e\u6700\u5927\u53f7\u8868", "CodeRuleServiceImp_13", CodeRuleServiceImp.BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u4f9d\u636e:%1$s\uff0c\u53f7\u7801:%2$s\u3002", "AppLogUtil_1", CodeRuleServiceImp.BOS_CODERULE), codeRuleInfo.getId(), codeRuleInfo.getName(), CommonUtil.convertSortItem(sortItem), newValue);
                    }
                }
            }.process();
            return;
        }
        final DynamicObject dynamicObject = load[0];
        final long maxserial = codeRuleSigner.signerNumber(codeRuleInfo, codeRuleEntryInfo, sortItem, true);
        if ((long)maxNumber > maxserial) {
            final int finalMaxNumber = maxNumber;
            new TransactionHandler(CodeRuleServiceImp.getMessageUpdateMaxserialAtImport()){

                @Override
                protected void transactionProcess() {
                    codeRuleSigner.reset(codeRuleInfo.getId(), sortItem, finalMaxNumber);
                    logger.info("[CodeRuleService][\u9ad8\u6027\u80fd]\u4fee\u6539\u7f16\u7801\u89c4\u5219\u6700\u5927\u53f7, \u503c\u53d8\u66f4\u4e3a:" + finalMaxNumber);
                    String oldValue = String.valueOf(maxserial);
                    String newValue = String.valueOf(finalMaxNumber);
                    if (AppLogUtil.checkSortItemValue(sortItem)) {
                        AppLogUtil.insertAppLog(dynamicObject, new MultiLangEnumBridge("\u5bfc\u5165\u6539\u53d8\u6700\u5927\u53f7\u8868", "CodeRuleMaxSerialEditPlugin_5", CodeRuleServiceImp.BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u4fee\u6539\u524d\u53f7\u7801:%3$s\uff0c\u4fee\u6539\u540e\u53f7\u7801:%4$s\u3002", "AppLogUtil_1", CodeRuleServiceImp.BOS_CODERULE), codeRuleInfo.getId(), codeRuleInfo.getName(), oldValue, newValue);
                    } else {
                        AppLogUtil.insertAppLog(dynamicObject, new MultiLangEnumBridge("\u5bfc\u5165\u6539\u53d8\u6700\u5927\u53f7\u8868", "CodeRuleMaxSerialEditPlugin_5", CodeRuleServiceImp.BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u4f9d\u636e\uff1a%3$s\uff0c\u4fee\u6539\u524d\u53f7\u7801\uff1a%4$s\uff0c\u4fee\u6539\u540e\u53f7\u7801%5$s\u3002", "AppLogUtil_1", CodeRuleServiceImp.BOS_CODERULE), codeRuleInfo.getId(), codeRuleInfo.getName(), CommonUtil.convertSortItem(sortItem), oldValue, newValue);
                    }
                }
            }.process();
        }
    }

    public List<Integer> readIntermitNumber(CodeRuleInfo coderule, String sortItemValue, int intermitNum) {
        return this.getCodeRuleSigner(coderule).getBreakNums(coderule, sortItemValue, intermitNum, true);
    }

    public List<Integer> consumeIntermitNumber(CodeRuleInfo coderule, String sortItemValue, int intermitNum) {
        return this.getCodeRuleSigner(coderule).getBreakNums(coderule, sortItemValue, intermitNum, false);
    }

    public boolean[] recycleNumber(CodeRuleInfo coderule, String sortItemValue, int[] intermits) {
        if (StringUtils.isBlank((CharSequence)sortItemValue)) {
            sortItemValue = "_split_";
        }
        QFilter[] qfArr = new QFilter[]{new QFilter("codeRuleID", "=", (Object)coderule.getId()), new QFilter("sortitemvalue", "=", (Object)sortItemValue), new QFilter("serial", "in", (Object)intermits)};
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_coderule_intermitno", (String)"serial", (QFilter[])qfArr);
        if (!query.isEmpty()) {
            throw new KDBizException(new ErrorCode("CODERULE_ERROR", String.format(ResManager.loadKDString((String)"\u65ad\u53f7\u8868\u4e2d\u5df2\u5b58\u5728\u65ad\u53f7: %s", (String)"CodeRuleServiceImp_18", (String)BOS_CODERULE, (Object[])new Object[0]), query.stream().map(q -> q.getString("serial")).collect(Collectors.joining(",")))), new Object[0]);
        }
        int count = intermits.length;
        boolean[] results = new boolean[count];
        for (int i = 0; i < count; ++i) {
            results[i] = this.insertIntermitNumber(coderule, "", sortItemValue, String.valueOf(intermits[i]));
        }
        return results;
    }

    public boolean updateNumber(CodeRuleInfo coderule, String sortItemValue, int maxserial) {
        return this.getCodeRuleSigner(coderule).updateMaxNumber(coderule, sortItemValue, (long)maxserial);
    }

    public void cacheBlankNumberFields(String pageId, DynamicObject dataInfo) {
        CodeRuleUtils.cacheBlankNumberFields(pageId, dataInfo);
    }

    public void convertFieldToOperateOption(String pageId, OperateOption operateOption) {
        CodeRuleUtils.convertPageCacheToOperateOption(pageId, operateOption);
    }

    @SdkInternal
    public void consumptionIntermitnos(List<CodeRuleGroup> codeRuleGroupList) {
        if (CollectionUtils.isEmpty(codeRuleGroupList)) {
            return;
        }
        DynamicObject[] intermitnos = this.getIntermitnos(codeRuleGroupList);
        ArrayList<String> intermitnoIdList = new ArrayList<String>();
        ArrayList<CodeRuleGroup> consumptionDataList = new ArrayList<CodeRuleGroup>();
        StringBuilder logMessage = new StringBuilder("CodeRuleServiceImp delete broken numbers:");
        block0: for (CodeRuleGroup codeRuleGroup : codeRuleGroupList) {
            for (DynamicObject intermitno : intermitnos) {
                if (!this.isNeedConsumeBroken(intermitno, codeRuleGroup)) continue;
                intermitnoIdList.add(intermitno.getString("id"));
                consumptionDataList.add(codeRuleGroup);
                logMessage.append("brokenId\uff1a").append(intermitno.getString("id")).append("\uff0c");
                logMessage.append("codeRuleId\uff1a").append(intermitno.getString("coderuleid.id")).append("\uff0c");
                logMessage.append("codeRule sortItem\uff1a").append(intermitno.getString("sortitemvalue")).append("\uff0c");
                logMessage.append("brokenNumber\uff1a").append(intermitno.getString("serial")).append("\uff1b\n");
                continue block0;
            }
        }
        logger.info(logMessage.toString());
        boolean isDelSuccess = this.deleteIntermitnoById(intermitnoIdList);
        if (!isDelSuccess) {
            logger.info("CodeRuleServiceImp Failed to delete the broken number.");
        }
        codeRuleGroupList.removeAll(consumptionDataList);
    }

    private boolean isNeedConsumeBroken(DynamicObject broken, CodeRuleGroup codeRuleGroup) {
        CodeRuleInfo codeRuleInfo = codeRuleGroup.getCodeRuleInfo();
        String codeRuleId = broken.getString("coderuleid.id");
        String sortItem = broken.getString("sortitemvalue");
        int serial = broken.getInt("serial");
        String groupSortItem = codeRuleGroup.getSortItem();
        return codeRuleInfo.getIsNonBreak() != false && StringUtils.equals((CharSequence)codeRuleId, (CharSequence)codeRuleInfo.getId()) && (StringUtils.equals((CharSequence)sortItem, (CharSequence)groupSortItem) || StringUtils.isBlank((CharSequence)groupSortItem) && StringUtils.equals((CharSequence)sortItem, (CharSequence)"_split_")) && serial == codeRuleGroup.getMaximum();
    }

    private DynamicObject[] getIntermitnos(List<CodeRuleGroup> codeRuleGroupList) {
        HashSet<String> codeRuleIds = new HashSet<String>(4);
        HashSet<String> sortItems = new HashSet<String>(4);
        for (CodeRuleGroup codeRuleGroup : codeRuleGroupList) {
            CodeRuleInfo codeRuleInfo = codeRuleGroup.getCodeRuleInfo();
            if (Boolean.FALSE.equals(codeRuleInfo.getIsNonBreak())) continue;
            codeRuleIds.add(codeRuleInfo.getId());
            String sortItem = codeRuleGroup.getSortItem();
            if (StringUtils.isBlank((CharSequence)sortItem)) {
                sortItem = "_split_";
            }
            sortItems.add(sortItem);
        }
        QFilter filter = new QFilter("coderuleid", "in", codeRuleIds).and(new QFilter("sortitemvalue", "in", sortItems));
        return BusinessDataServiceHelper.load((String)"bos_coderule_intermitno", (String)"id,coderuleid,sortitemvalue,serial", (QFilter[])new QFilter[]{filter});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean deleteIntermitnoById(List<String> intermitnoIdList) {
        block14: {
            boolean bl;
            TXHandle h;
            block15: {
                String sql = "delete from T_CR_IntermitNO where FID = ?";
                ArrayList<Object[]> deleteParamsList = new ArrayList<Object[]>(intermitnoIdList.size());
                for (String fid : intermitnoIdList) {
                    Object[] params = new Object[]{fid};
                    deleteParamsList.add(params);
                }
                h = TX.requiresNew();
                Throwable throwable = null;
                try {
                    int[] delResult = DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, deleteParamsList);
                    String delResultStr = Arrays.toString(delResult);
                    logger.info("\u5220\u9664\u65ad\u53f7\u7684\u7ed3\u679c\u662f\uff1a" + delResultStr);
                    if (delResultStr.isEmpty() || delResultStr.contains("0")) break block14;
                    bl = true;
                    if (h == null) return bl;
                    if (throwable == null) break block15;
                }
                catch (Exception e) {
                    logger.error("deleteBrokenById#\u5220\u9664\u65ad\u53f7\u53d1\u751f\u5f02\u5e38\uff0c\u8981\u5220\u9664\u7684\u65ad\u53f7\u96c6\u5408\u4e3a\uff1a" + intermitnoIdList);
                    h.markRollback();
                    return false;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                try {
                    h.close();
                    return bl;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                    return bl;
                }
            }
            h.close();
            return bl;
        }
        return false;
    }

    @SdkInternal
    public void testJUnit() {
    }
}

