/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.service.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.service.cache.CodeRuleCacheMrg;
import kd.bos.coderule.util.CodeRuleInfoBuilder;
import kd.bos.coderule.util.Util;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CodeRuleCache {
    public static final String ENTITYID_CODERULE = "bos_coderule";

    public static List<CodeRuleInfo> getAllCodeRuleByEntity(String entityID) {
        ArrayList<CodeRuleInfo> codeRuleList = new ArrayList();
        codeRuleList = CodeRuleCache.reloadAllCodeRuleByEntity(entityID);
        return codeRuleList;
    }

    private static String getSelectFields() {
        return "id, splitsign, appmode, isupdaterecover,orgentry.id, orgentry.orgid, isaddview, ismatchcoderule, ischecknumber, isfillwithzero, isautoincrlength, ismodifiable, isnonbreak, isunique, isfast, filtercondition, orgentry.isincludesuborg, conditionentry.id, conditionentry.property, conditionentry.propertyvalue, ruleentry.id, ruleentry.seq,ruleentry.attributeType,ruleentry.valueAtribute,ruleentry.attusingmode,ruleentry.length,ruleentry.cutstyle,ruleentry.format,ruleentry.addchar,ruleentry.addstyle,ruleentry.initial,ruleentry.step,ruleentry.isSortItem,ruleentry.issplit,sign,ruleentry.issplitsign,ruleentry.splitsignentry,ruleentry.isvisable,name,useinterruption,updatemaxnumber";
    }

    private static List<CodeRuleInfo> reloadAllCodeRuleByEntity(String entityID) {
        String selectFields = CodeRuleCache.getSelectFields();
        QFilter entityFiler = new QFilter("bizobjectid", "=", (Object)entityID);
        QFilter enableFiler = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        QFilter[] filters = new QFilter[]{entityFiler, enableFiler};
        Map codeRuleCollection = BusinessDataServiceHelper.loadFromCache((String)ENTITYID_CODERULE, (String)selectFields, (QFilter[])filters);
        ArrayList<CodeRuleInfo> codeRuleList = null;
        if (codeRuleCollection == null || codeRuleCollection.size() == 0) {
            return new ArrayList<CodeRuleInfo>();
        }
        codeRuleList = new ArrayList<CodeRuleInfo>(codeRuleCollection.size());
        for (DynamicObject codeRule : codeRuleCollection.values()) {
            codeRuleList.add(CodeRuleInfoBuilder.buildCodeRuleInfo(codeRule));
        }
        return codeRuleList;
    }

    public static CodeRuleInfo reloadCodeRuleById(String id) {
        Iterator iterator;
        String selectFields = CodeRuleCache.getSelectFields();
        QFilter entityFiler = new QFilter("id", "=", (Object)id);
        Map codeRuleCollection = BusinessDataServiceHelper.loadFromCache((String)ENTITYID_CODERULE, (String)selectFields, (QFilter[])entityFiler.toArray());
        CodeRuleInfo codeRuleInfo = null;
        if (codeRuleCollection != null && codeRuleCollection.size() > 0 && (iterator = codeRuleCollection.values().iterator()).hasNext()) {
            codeRuleInfo = CodeRuleInfoBuilder.buildCodeRuleInfo((DynamicObject)iterator.next());
        }
        return codeRuleInfo;
    }

    public static Map<String, CodeRuleInfo> reloadCodeRuleByIds(String[] ids) {
        String selectFields = CodeRuleCache.getSelectFields();
        QFilter entityFiler = new QFilter("id", "in", (Object)ids);
        Map codeRuleCollection = BusinessDataServiceHelper.loadFromCache((String)ENTITYID_CODERULE, (String)selectFields, (QFilter[])entityFiler.toArray());
        HashMap<String, CodeRuleInfo> codeRuleInfoMap = new HashMap<String, CodeRuleInfo>(codeRuleCollection.size());
        if (codeRuleCollection.size() > 0) {
            for (DynamicObject codeRule : codeRuleCollection.values()) {
                CodeRuleInfo codeRuleInfo = CodeRuleInfoBuilder.buildCodeRuleInfo(codeRule);
                codeRuleInfoMap.put(codeRuleInfo.getId(), codeRuleInfo);
            }
        }
        return codeRuleInfoMap;
    }

    public static String getBreakNumberQueue(CodeRuleInfo codeRuleInfo, String seqSegmentEntryID, String sortItem) {
        String breakNumberQueue = CodeRuleCache.loadBreakNumberCache(codeRuleInfo, seqSegmentEntryID, sortItem);
        return breakNumberQueue;
    }

    private static String loadBreakNumberCache(CodeRuleInfo codeRuleInfo, String seqSegmentEntryID, String sortItem) {
        String key;
        String breakNumberQueue = null;
        String type = CodeRuleCacheMrg.getType4BreakNumber();
        breakNumberQueue = CodeRuleCacheMrg.getCache(type, key = codeRuleInfo.getId() + seqSegmentEntryID + sortItem);
        if (!CodeRuleCacheMrg.isLoaded(breakNumberQueue)) {
            breakNumberQueue = CodeRuleCache.reloadBreakNumber(codeRuleInfo, seqSegmentEntryID, sortItem);
        }
        return breakNumberQueue;
    }

    private static String reloadBreakNumber(CodeRuleInfo codeRuleInfo, String seqSegmentEntryID, String sortItem) {
        String breakNumberQueue = null;
        if (StringUtils.isBlank((CharSequence)sortItem)) {
            sortItem = "_split_";
        }
        String sql = "select FSERIAL from T_cr_IntermitNo where FCODERULEID = ? and FSEQSEGMENTENTRYID = ? and FSORTITEMVALUE = ? order by FSERIAL";
        Object[] params = new SqlParameter[]{new SqlParameter(":FCODERULEID", 12, (Object)codeRuleInfo.getId()), new SqlParameter(":FSEQSEGMENTENTRYID", 12, (Object)seqSegmentEntryID), new SqlParameter(":FSORTITEMVALUE", 12, (Object)sortItem)};
        List breakNumberList = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) {
                ArrayList<String> list = new ArrayList<String>();
                try {
                    while (rs.next()) {
                        list.add(rs.getString("FSERIAL"));
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                }
                return list;
            }
        });
        String type = CodeRuleCacheMrg.getType4BreakNumber();
        String key = codeRuleInfo.getId() + seqSegmentEntryID + sortItem;
        if (breakNumberList.size() > 0) {
            CodeRuleCacheMrg.putCache(type, key, Util.list2Str(breakNumberList));
        } else {
            CodeRuleCacheMrg.putLoaded(type, key);
        }
        return breakNumberQueue;
    }

    public static String getSerialNumberQueue(String key) {
        String serialNumberQueue = CodeRuleCache.loadSerialNumberCache(key);
        return serialNumberQueue;
    }

    private static String loadSerialNumberCache(String key) {
        String serialNumberQueue = null;
        String type = CodeRuleCacheMrg.getType4SerialNumber();
        serialNumberQueue = CodeRuleCacheMrg.getCache(type, key);
        if (CodeRuleCacheMrg.isLoaded(serialNumberQueue) && CodeRuleCacheMrg.isData(serialNumberQueue)) {
            return serialNumberQueue;
        }
        return null;
    }

    public static void updateeBreakNumberCache(String key, String breakNumberQueue) {
        String type = CodeRuleCacheMrg.getType4BreakNumber();
        if (StringUtils.isBlank((CharSequence)breakNumberQueue)) {
            CodeRuleCacheMrg.putLoaded(type, key);
        } else {
            CodeRuleCacheMrg.putCache(type, key, breakNumberQueue);
        }
    }

    public static void updateSerialNumberCache(String key, String serialNumberQueue) {
        String type = CodeRuleCacheMrg.getType4SerialNumber();
        if (StringUtils.isBlank((CharSequence)serialNumberQueue)) {
            CodeRuleCacheMrg.putLoaded(type, key);
        } else {
            CodeRuleCacheMrg.putCache(type, key, serialNumberQueue);
        }
    }

    public static String getMaxSerialNumber(String key) {
        String type = CodeRuleCacheMrg.getType4MaxSerialNumber();
        String maxSerialNumber = CodeRuleCacheMrg.getCache(type, key);
        if (CodeRuleCacheMrg.isLoaded(maxSerialNumber) && CodeRuleCacheMrg.isData(maxSerialNumber)) {
            return maxSerialNumber;
        }
        return maxSerialNumber;
    }

    public static void updateMaxSerialNumber(String key, String maxSerialNumber) {
        String type = CodeRuleCacheMrg.getType4MaxSerialNumber();
        if (StringUtils.isBlank((CharSequence)maxSerialNumber)) {
            CodeRuleCacheMrg.putLoaded(type, key);
        } else {
            CodeRuleCacheMrg.putCache(type, key, maxSerialNumber);
        }
    }
}

