/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.upgrade;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.adaptor.CodeRuleSignerFactory;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class CodeRuleUpgradeConfirmPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object listdata = formShowParameter.getCustomParam("coderule_listdata");
        if (listdata instanceof List) {
            List listdataObj = (List)listdata;
            boolean haveUpgradeData = false;
            for (Object dataObj : listdataObj) {
                if (!(dataObj instanceof Map)) continue;
                Map mapData = (Map)dataObj;
                String coderuleName = (String)mapData.get("coderule_name");
                String bizobjectName = (String)mapData.get("bizobject_name");
                String enable = (String)mapData.get("enable");
                String nonbreak = (String)mapData.get("nonbreak");
                String isSerialnumber = (String)mapData.get("is_serialnumber");
                String upgradeStatus = (String)mapData.get("upgrade_status");
                String fastStatus = (String)mapData.get("fast_status");
                int entryentity = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("coderule_name", (Object)coderuleName, entryentity);
                this.getModel().setValue("bizobject_name", (Object)bizobjectName, entryentity);
                this.getModel().setValue("enable", (Object)enable, entryentity);
                this.getModel().setValue("nonbreak", (Object)nonbreak, entryentity);
                this.getModel().setValue("is_serialnumber", (Object)isSerialnumber, entryentity);
                this.getModel().setValue("upgrade_status", (Object)upgradeStatus, entryentity);
                this.getModel().setValue("fast_status", (Object)fastStatus, entryentity);
                String isUpgrade = (String)mapData.get("isUpgrade");
                if (!String.valueOf(true).equals(isUpgrade)) continue;
                haveUpgradeData = true;
            }
            this.getPageCache().put("haveUpgradeData", String.valueOf(haveUpgradeData));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if ("nextstep".equals(operate.getOperateKey())) {
            String haveUpgradeData = this.getPageCache().get("haveUpgradeData");
            if (!String.valueOf(true).equals(haveUpgradeData)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5217\u8868\u4e2d\u6ca1\u6709\u53ef\u5347\u7ea7\u7684\u7f16\u7801\u89c4\u5219\u3002", (String)"CodeRuleUpgradeConfirmPlugin_0", (String)"bos-coderule", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String updateTips = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u5347\u7ea7\u6682\u65f6\u4e0d\u53ef\u56de\u9000\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5347\u7ea7\u3002\u201c%1$s\u201d\u7f16\u7801\u89c4\u5219\u5347\u7ea7\u8fc7\u7a0b\u4e2d\u76f8\u5e94\u7684\u7f16\u7801\u670d\u52a1\u4f1a\u77ed\u6682\u4e0d\u53ef\u7528\uff0c\u5347\u7ea7\u5b8c\u6210\u5c31\u4f1a\u6062\u590d\u3002", (String)"CodeRuleUpgradeConfirmPlugin_8", (String)"bos-coderule", (Object[])new Object[0]), "\\r\\n\\r\\n");
            HashMap<Integer, String> btnNamesMaps = new HashMap<Integer, String>(2);
            btnNamesMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"CodeRuleUpgradeConfirmPlugin_3", (String)"bos-coderule", (Object[])new Object[0]));
            btnNamesMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u4e0b\u4e00\u6b65", (String)"CodeRuleUpgradeConfirmPlugin_4", (String)"bos-coderule", (Object[])new Object[0]));
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("nextstep_comfirm", (IFormPlugin)this);
            this.getView().showConfirm(updateTips, this.getModel().getChangeDesc(), MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBackListener, btnNamesMaps);
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if (callBackId.equals("nextstep_comfirm") && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            try {
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u5347\u7ea7\u4e2d", (String)"CodeRuleUpgradeConfirmPlugin_9", (String)"bos-coderule", (Object[])new Object[0])));
                this.upgrade();
                this.getView().hideLoading();
                this.showFormForUpgradeComplete(true, ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u5df2\u53d8\u66f4\u4e3a\u9ad8\u53ef\u9760\u6a21\u5f0f\uff0c\u8bf7\u5230\u76f8\u5e94\u4e1a\u52a1\u6a21\u5757\u4f53\u9a8c\u65b0\u7684\u7f16\u7801\u6548\u679c\u3002", (String)"CodeRuleUpgradeConfirmPlugin_6", (String)"bos-coderule", (Object[])new Object[0]));
            }
            catch (Exception e) {
                this.showFormForUpgradeComplete(false, ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u5347\u7ea7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u6b21\u5c1d\u8bd5\u3002", (String)"CodeRuleUpgradeConfirmPlugin_7", (String)"bos-coderule", (Object[])new Object[0]));
            }
        }
    }

    public void upgrade() {
        List<String> codeRuleIds = this.getUpgradeCodeRuleId();
        for (String codeRuleId : codeRuleIds) {
            CodeRuleSignerFactory.newInstanceFast().growup(codeRuleId);
        }
    }

    public void showFormForUpgradeComplete(boolean status, String msg) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bos_coderule_upgrade_ok");
        param.setCustomParam("msg_data", this.buildMsgData(status, msg));
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setStatus(OperationStatus.VIEW);
        this.getView().showForm(param);
    }

    private Map<String, String> buildMsgData(boolean status, String msg) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("status", String.valueOf(status));
        map.put("msg", msg);
        return map;
    }

    private List<String> getUpgradeCodeRuleId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object listdata = formShowParameter.getCustomParam("coderule_listdata");
        if (listdata instanceof List) {
            List listdataObj = (List)listdata;
            ArrayList<String> list = new ArrayList<String>(listdataObj.size());
            for (Object dataObj : listdataObj) {
                if (!(dataObj instanceof Map)) continue;
                Map mapData = (Map)dataObj;
                String coderuleId = (String)mapData.get("coderule_id");
                String isupgradeStr = (String)mapData.get("isupgrade");
                if (!String.valueOf(true).equals(isupgradeStr)) continue;
                list.add(coderuleId);
            }
            return list;
        }
        return new ArrayList<String>(1);
    }
}

