/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.upgrade;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.AbstractCodeRuleTreeListPlugin;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.coderule.util.TreeListUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CodeRuleUpgradeTreeListPlugin
extends AbstractCodeRuleTreeListPlugin {
    private static final String FORMNUM_CODERULE_EDIT = "bos_coderule_edit";

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter("isfast", "=", (Object)Character.valueOf('0')));
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String itemkey = e.getItemKey();
        if ("upgrade".equals(itemkey)) {
            // empty if block
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if (callBackId.equals("upgrade_comfirm") && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            FormShowParameter param = new FormShowParameter();
            param.setFormId("bos_coderule_upgrade_conf");
            param.setCustomParam("coderule_listdata", this.buildConfirmListData());
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setStatus(OperationStatus.VIEW);
            this.getView().showForm(param);
        }
    }

    private List<Map<String, String>> buildConfirmListData() {
        ListSelectedRowCollection rows = this.getSelectedRows();
        DynamicObject[] coderules = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_coderule"));
        ArrayList<Map<String, String>> maps = new ArrayList<Map<String, String>>();
        for (DynamicObject coderule : coderules) {
            boolean isFast;
            String codeRuleName = coderule.getString("name");
            Object bizobjectid = coderule.get("bizobjectid");
            if (bizobjectid == null) continue;
            String bizObjectName = ((DynamicObject)bizobjectid).getString("name");
            boolean enable = coderule.getBoolean("enable");
            String enableStr = enable ? ResManager.loadKDString((String)"\u53ef\u7528", (String)"CodeRuleUpgradeTreeListPlugin_4", (String)"bos-coderule", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528", (String)"CodeRuleUpgradeTreeListPlugin_5", (String)"bos-coderule", (Object[])new Object[0]);
            boolean isNonBreak = false;
            boolean isSerialNumber = false;
            DynamicObjectCollection ruleentry = coderule.getDynamicObjectCollection("ruleentry");
            for (DynamicObject dynamicObject : ruleentry) {
                String attributetype = dynamicObject.getString("attributetype");
                if (!CodeRuleEntryTypeEnum.TYPE_SEQ.getTypeStr().equals(attributetype)) continue;
                isSerialNumber = true;
                isNonBreak = coderule.getBoolean("isnonbreak");
                break;
            }
            String fastStatus = (isFast = coderule.getBoolean("isfast")) ? ResManager.loadKDString((String)"\u662f", (String)"CodeRuleUpgradeTreeListPlugin_6", (String)"bos-coderule", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"CodeRuleUpgradeTreeListPlugin_7", (String)"bos-coderule", (Object[])new Object[0]);
            String isNonBreakStr = isNonBreak ? ResManager.loadKDString((String)"\u5df2\u5f00\u542f", (String)"CodeRuleUpgradeTreeListPlugin_8", (String)"bos-coderule", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u672a\u5f00\u542f", (String)"CodeRuleUpgradeTreeListPlugin_9", (String)"bos-coderule", (Object[])new Object[0]);
            String isSerialNumberStr = isSerialNumber ? ResManager.loadKDString((String)"\u662f", (String)"CodeRuleUpgradeTreeListPlugin_6", (String)"bos-coderule", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"CodeRuleUpgradeTreeListPlugin_7", (String)"bos-coderule", (Object[])new Object[0]);
            boolean isUpgrade = isSerialNumber && !isFast;
            String upgradeStatus = isUpgrade ? ResManager.loadKDString((String)"\u662f", (String)"CodeRuleUpgradeTreeListPlugin_6", (String)"bos-coderule", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"CodeRuleUpgradeTreeListPlugin_7", (String)"bos-coderule", (Object[])new Object[0]);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("coderule_id", coderule.getPkValue().toString());
            map.put("isupgrade", String.valueOf(isUpgrade));
            map.put("coderule_name", codeRuleName);
            map.put("bizobject_name", bizObjectName);
            map.put("enable", enableStr);
            map.put("nonbreak", isNonBreakStr);
            map.put("is_serialnumber", isSerialNumberStr);
            map.put("isUpgrade", String.valueOf(isUpgrade));
            map.put("upgrade_status", upgradeStatus);
            map.put("fast_status", fastStatus);
            maps.add(map);
        }
        return maps;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList billList = (BillList)this.getControl("billlistap");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", billList.getFocusRowPkId());
        TreeListUtil.showForm(this.getView(), FORMNUM_CODERULE_EDIT, params, null, ShowType.MainNewTabPage, OperationStatus.VIEW);
    }
}

