/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.util;

import java.util.List;
import kd.bos.coderule.util.CommonUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import org.apache.commons.collections4.CollectionUtils;

public class AppLogUtil {
    private static ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final String BOS_CODERULE = "bos-coderule";
    private static final String OPNAME_FORMAT = ResManager.loadKDString((String)"%s", (String)"AppLogUtil_0", (String)"bos-coderule", (Object[])new Object[0]);

    public static AppLogInfo buildAppLog(String bizObjID, String opName, String opDesc) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setBizAppID(BizAppServiceHelp.getAppIdByFormNum((String)bizObjID));
        appLogInfo.setBizObjID(bizObjID);
        return appLogInfo;
    }

    public static AppLogInfo buildAppLog(DynamicObject dynamicObject, String codeRuleId, String codeRuleName, String opName, String opDesc) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        String bizObjID = dynamicObject.getDataEntityType().getName();
        appLogInfo.setBizObjID(bizObjID);
        appLogInfo.setBizAppID(BizAppServiceHelp.getAppIdByFormNum((String)bizObjID));
        return appLogInfo;
    }

    public static AppLogInfo buildAppLog(IFormView view, DynamicObject dynamicObject) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        String bizObjID = dynamicObject.getDataEntityType().getName();
        appLogInfo.setBizObjID(bizObjID);
        appLogInfo.setBizAppID(AppLogUtil.getBizAppId(view, bizObjID));
        return appLogInfo;
    }

    @Deprecated
    public static AppLogInfo buildAppLog(DynamicObject dynamicObject, String codeRuleId, String codeRuleName, String opName, String opDesc, boolean isSuccess) {
        AppLogInfo appLogInfo = AppLogUtil.buildAppLog(dynamicObject, codeRuleId, codeRuleName, opName, opDesc);
        appLogInfo.setOpName(String.format(OPNAME_FORMAT, opName));
        String desc = AppLogUtil.removeComma(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c%3$s", (String)"AppLogUtil_1", (String)BOS_CODERULE, (Object[])new Object[0]), codeRuleId, codeRuleName, opDesc));
        String descResult = AppLogUtil.getOpDesc(desc, isSuccess);
        appLogInfo.setOpDescription(AppLogUtil.limitLength(descResult));
        return appLogInfo;
    }

    @Deprecated
    public static AppLogInfo buildAppLog(IFormView view, DynamicObject dynamicObject, String codeRuleId, String codeRuleName, String opName, String opDesc, boolean isSuccess) {
        AppLogInfo appLogInfo = AppLogUtil.buildAppLog(view, dynamicObject);
        appLogInfo.setOpName(String.format(OPNAME_FORMAT, opName));
        String desc = AppLogUtil.removeComma(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c%3$s", (String)"AppLogUtil_1", (String)BOS_CODERULE, (Object[])new Object[0]), codeRuleId, codeRuleName, opDesc));
        String descResult = AppLogUtil.getOpDesc(desc, isSuccess);
        appLogInfo.setOpDescription(AppLogUtil.limitLength(descResult));
        return appLogInfo;
    }

    public static OpLogAppInfo buildAppLog(IFormView view, DynamicObject dynamicObject, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescBridge, boolean isSuccess, String ... opDescArgs) {
        OpLogAppInfo appLogInfo = (OpLogAppInfo)AppLogUtil.buildAppLog(view, dynamicObject);
        appLogInfo.setOpName("brokenNumberDeleted", opNameBridge);
        appLogInfo.setStatus(isSuccess ? "1" : "0");
        appLogInfo.setOpDesc(opDescBridge, opDescArgs);
        return appLogInfo;
    }

    private static String getBizAppId(IFormView view, String entityNumber) {
        String appId = null;
        String appNumber = view.getFormShowParameter().getAppId();
        if (StringUtils.isBlank((CharSequence)appNumber)) {
            return BizAppServiceHelp.getAppIdByFormNum((String)entityNumber);
        }
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
        if (null != appInfo) {
            appId = appInfo.getId();
        }
        if (StringUtils.isEmpty(appId)) {
            String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity);
            AbstractMetadata abstractMetadata = MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            appId = abstractMetadata.getBizappId();
        }
        return appId;
    }

    public static void batchInsertAppLog(List<AppLogInfo> appLogInfos) {
        if (CollectionUtils.isEmpty(appLogInfos)) {
            return;
        }
        service.addBatchLog(appLogInfos);
    }

    @Deprecated
    public static void insertAppLog(DynamicObject dynamicObject, String codeRuleId, String codeRuleName, String opName, String opDesc, boolean isSuccess) {
        AppLogInfo appLogInfo = AppLogUtil.buildAppLog(dynamicObject, codeRuleId, codeRuleName, opName, opDesc);
        appLogInfo.setOpName(String.format(OPNAME_FORMAT, opName));
        String desc = AppLogUtil.removeComma(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c%3$s", (String)"AppLogUtil_1", (String)BOS_CODERULE, (Object[])new Object[0]), codeRuleId, codeRuleName, opDesc));
        String descResult = AppLogUtil.getOpDesc(desc, isSuccess);
        appLogInfo.setOpDescription(AppLogUtil.limitLength(descResult));
        service.addLog(appLogInfo);
    }

    @Deprecated
    public static void insertAppLog(IFormView view, DynamicObject dynamicObject, String codeRuleId, String codeRuleName, String opName, String opDesc, boolean isSuccess) {
        AppLogInfo appLogInfo = AppLogUtil.buildAppLog(view, dynamicObject);
        appLogInfo.setOpName(String.format(OPNAME_FORMAT, opName));
        String desc = AppLogUtil.removeComma(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c%3$s", (String)"AppLogUtil_1", (String)BOS_CODERULE, (Object[])new Object[0]), codeRuleId, codeRuleName, opDesc));
        String descResult = AppLogUtil.getOpDesc(desc, isSuccess);
        appLogInfo.setOpDescription(AppLogUtil.limitLength(descResult));
        service.addLog(appLogInfo);
    }

    public static void insertAppLog(IFormView view, DynamicObject dynamicObject, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescBridge, boolean isSuccess, String ... opDescArgs) {
        OpLogAppInfo appLogInfo = (OpLogAppInfo)AppLogUtil.buildAppLog(view, dynamicObject);
        appLogInfo.setOpName("ruleOp", opNameBridge);
        appLogInfo.setStatus(isSuccess ? "1" : "0");
        if (opDescBridge != null) {
            appLogInfo.setOpDesc(opDescBridge, opDescArgs);
        }
        service.addLog((AppLogInfo)appLogInfo);
    }

    private static MultiLangEnumBridge getOpDesc(boolean isSuccess) {
        if (isSuccess) {
            return new MultiLangEnumBridge("\u64cd\u4f5c\u6210\u529f\uff0c%s", "AppLogUtil_6", BOS_CODERULE);
        }
        return new MultiLangEnumBridge("\u64cd\u4f5c\u5931\u8d25\uff0c%s", "AppLogUtil_7", BOS_CODERULE);
    }

    @Deprecated
    private static String getOpDesc(String desc, boolean isSuccess) {
        if (isSuccess) {
            return String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff0c%s", (String)"AppLogUtil_6", (String)BOS_CODERULE, (Object[])new Object[0]), desc);
        }
        return String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c%s", (String)"AppLogUtil_7", (String)BOS_CODERULE, (Object[])new Object[0]), desc);
    }

    @Deprecated
    public static void insertAppLog(DynamicObject dynamicObject, String codeRuleId, String codeRuleName, String opName, String opDesc) {
        AppLogInfo appLogInfo = AppLogUtil.buildAppLog(dynamicObject, codeRuleId, codeRuleName, opName, opDesc);
        appLogInfo.setOpName(String.format(OPNAME_FORMAT, opName));
        String desc = AppLogUtil.removeComma(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c%3$s", (String)"AppLogUtil_1", (String)BOS_CODERULE, (Object[])new Object[0]), codeRuleId, codeRuleName, opDesc));
        appLogInfo.setOpDescription(AppLogUtil.limitLength(desc));
        service.addLog(appLogInfo);
    }

    public static void insertAppLog(DynamicObject dynamicObject, MultiLangEnumBridge opName, MultiLangEnumBridge opDesc, String ... opDeseArgs) {
        OpLogAppInfo appLogInfo = (OpLogAppInfo)AppLogUtil.buildAppLog(dynamicObject, "", "", "", "");
        appLogInfo.setOpName("ruleOp", opName);
        appLogInfo.setOpDesc(opDesc, opDeseArgs);
        service.addLog((AppLogInfo)appLogInfo);
    }

    @Deprecated
    public static void insertAppLog(IFormView view, DynamicObject dynamicObject, String codeRuleId, String codeRuleName, String opName, String opDesc) {
        AppLogInfo appLogInfo = AppLogUtil.buildAppLog(view, dynamicObject);
        appLogInfo.setOpName(String.format(OPNAME_FORMAT, opName));
        String desc = AppLogUtil.removeComma(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c%3$s", (String)"AppLogUtil_1", (String)BOS_CODERULE, (Object[])new Object[0]), codeRuleId, codeRuleName, opDesc));
        appLogInfo.setOpDescription(AppLogUtil.limitLength(desc));
        service.addLog(appLogInfo);
    }

    public static void insertAppLog(IFormView view, DynamicObject dynamicObject, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescBridge, String ... opDescArgs) {
        OpLogAppInfo appLogInfo = (OpLogAppInfo)AppLogUtil.buildAppLog(view, dynamicObject);
        appLogInfo.setOpName("ruleOp", opNameBridge);
        if (opDescBridge != null) {
            appLogInfo.setOpDesc(opDescBridge, opDescArgs);
        }
        service.addLog((AppLogInfo)appLogInfo);
    }

    public static String getBizObjId(DynamicObject dynamicObject) {
        return "bos_coderule";
    }

    @Deprecated
    public static void insertAppLog(DynamicObject dynamicObject, String opName, String opDesc) {
        String bizObjID = AppLogUtil.getBizObjId(dynamicObject);
        AppLogUtil.insertAppLog(bizObjID, opName, opDesc);
    }

    public static void insertAppLog(DynamicObject dynamicObject, MultiLangEnumBridge opName, MultiLangEnumBridge opDesc, String opDescArgs) {
        String bizObjID = AppLogUtil.getBizObjId(dynamicObject);
        OpLogAppInfo appLogInfo = (OpLogAppInfo)AppLogUtil.buildAppLog(bizObjID, "", "");
        appLogInfo.setOpName("ruleOp", opName);
        appLogInfo.setOpDesc(opDesc, new String[]{opDescArgs});
        service.addLog((AppLogInfo)appLogInfo);
    }

    @Deprecated
    public static void insertAppLog(String bizObjID, String opName, String opDesc) {
        AppLogInfo appLogInfo = AppLogUtil.buildAppLog(bizObjID, opName, opDesc);
        appLogInfo.setOpName(String.format(OPNAME_FORMAT, opName));
        appLogInfo.setOpDescription(AppLogUtil.limitLength(String.format("%s", opDesc)));
        service.addLog(appLogInfo);
    }

    private static String limitLength(String desc) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)desc) && desc.length() > 250) {
            desc = desc.substring(0, 250);
        }
        return desc;
    }

    private static String removeComma(String desc) {
        if (desc.endsWith(", ")) {
            desc = desc.substring(0, desc.length() - 2);
        }
        return desc;
    }

    @Deprecated
    public static String noDisplayEmptySortItem(String sortItemValue, String serial) {
        if (AppLogUtil.checkSortItemValue(sortItemValue)) {
            return String.format(ResManager.loadKDString((String)"\u53f7\u7801:%s", (String)"AppLogUtil_2", (String)BOS_CODERULE, (Object[])new Object[0]), serial);
        }
        return String.format(ResManager.loadKDString((String)"\u4f9d\u636e:%1$s\uff0c\u53f7\u7801:%2$s", (String)"AppLogUtil_3", (String)BOS_CODERULE, (Object[])new Object[0]), CommonUtil.convertSortItem(sortItemValue), serial);
    }

    @Deprecated
    public static String noDisplayEmptySortItem(String sortItemValue, String oldValue, String newValue) {
        if (AppLogUtil.checkSortItemValue(sortItemValue)) {
            return String.format(ResManager.loadKDString((String)"\u4fee\u6539\u524d\u53f7\u7801:%1$s\uff0c\u4fee\u6539\u540e\u53f7\u7801:%2$s", (String)"AppLogUtil_4", (String)BOS_CODERULE, (Object[])new Object[0]), oldValue, newValue);
        }
        return String.format(ResManager.loadKDString((String)"\u4f9d\u636e\uff1a%1$s\uff0c\u4fee\u6539\u524d\u53f7\u7801\uff1a%2$s\uff0c\u4fee\u6539\u540e\u53f7\u7801%3$s\u3002", (String)"AppLogUtil_5", (String)BOS_CODERULE, (Object[])new Object[0]), CommonUtil.convertSortItem(sortItemValue), oldValue, newValue);
    }

    public static boolean checkSortItemValue(String sortItemValue) {
        return sortItemValue == null || "".equals(sortItemValue) || "_split_".equals(sortItemValue);
    }
}

